/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SearcherWarmer;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;

public final class SearcherManager {
    private volatile IndexSearcher currentSearcher;
    private final ExecutorService es;
    private final SearcherWarmer warmer;
    private final Semaphore reopenLock = new Semaphore(1);

    public SearcherManager(IndexWriter writer, boolean applyAllDeletes, final SearcherWarmer warmer, final ExecutorService es) throws IOException {
        this.es = es;
        this.warmer = warmer;
        this.currentSearcher = new IndexSearcher(IndexReader.open(writer, applyAllDeletes));
        if (warmer != null) {
            writer.getConfig().setMergedSegmentWarmer(new IndexWriter.IndexReaderWarmer(){

                public void warm(IndexReader reader) throws IOException {
                    warmer.warm(new IndexSearcher(reader, es));
                }
            });
        }
    }

    public SearcherManager(Directory dir, SearcherWarmer warmer, ExecutorService es) throws IOException {
        this.es = es;
        this.warmer = warmer;
        this.currentSearcher = new IndexSearcher(IndexReader.open(dir, true), es);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean maybeReopen() throws IOException {
        this.ensureOpen();
        if (!this.reopenLock.tryAcquire()) {
            return false;
        }
        try {
            block8: {
                IndexReader newReader = IndexReader.openIfChanged(this.currentSearcher.getIndexReader());
                if (newReader != null) {
                    IndexSearcher newSearcher = new IndexSearcher(newReader, this.es);
                    boolean success = false;
                    try {
                        if (this.warmer != null) {
                            this.warmer.warm(newSearcher);
                        }
                        this.swapSearcher(newSearcher);
                        success = true;
                        Object var5_5 = null;
                        if (success) break block8;
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        if (!success) {
                            this.release(newSearcher);
                        }
                        throw throwable;
                    }
                    this.release(newSearcher);
                }
            }
            boolean bl = true;
            Object var7_8 = null;
            this.reopenLock.release();
            return bl;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.reopenLock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSearcherCurrent() throws CorruptIndexException, IOException {
        boolean bl;
        IndexSearcher searcher = this.acquire();
        try {
            bl = searcher.getIndexReader().isCurrent();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.release(searcher);
            throw throwable;
        }
        this.release(searcher);
        return bl;
    }

    public void release(IndexSearcher searcher) throws IOException {
        assert (searcher != null);
        searcher.getIndexReader().decRef();
    }

    public synchronized void close() throws IOException {
        if (this.currentSearcher != null) {
            this.swapSearcher(null);
        }
    }

    public IndexSearcher acquire() {
        IndexSearcher searcher;
        do {
            if ((searcher = this.currentSearcher) != null) continue;
            throw new AlreadyClosedException("this SearcherManager is closed");
        } while (!searcher.getIndexReader().tryIncRef());
        return searcher;
    }

    private void ensureOpen() {
        if (this.currentSearcher == null) {
            throw new AlreadyClosedException("this SearcherManager is closed");
        }
    }

    private synchronized void swapSearcher(IndexSearcher newSearcher) throws IOException {
        this.ensureOpen();
        IndexSearcher oldSearcher = this.currentSearcher;
        this.currentSearcher = newSearcher;
        this.release(oldSearcher);
    }
}

