/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.TimeUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.FileUtils;

@Deprecated
public abstract class GraphDatabaseSetting<T>
implements Setting {
    @Deprecated
    public static final String TRUE = "true";
    @Deprecated
    public static final String FALSE = "false";
    @Deprecated
    public static final String ANY = ".+";
    @Deprecated
    public static final String SIZE = "\\d+[kmgKMG]";
    @Deprecated
    public static final String DURATION = "\\d+(ms|s|m)";
    private final String name;
    private final String validationMessage;

    protected GraphDatabaseSetting(String name, String validationMessage) {
        this.name = name;
        this.validationMessage = validationMessage;
    }

    @Override
    public String name() {
        return this.name;
    }

    public String validationMessage() {
        return this.validationMessage;
    }

    @Override
    public void validate(String value) throws IllegalArgumentException {
        this.validate(Locale.getDefault(), value);
    }

    public abstract void validate(Locale var1, String var2);

    public abstract T valueOf(String var1, Config var2);

    protected String getMessage(Locale locale, String defaultMessage) {
        if (locale.getLanguage().equals(Locale.ENGLISH.getLanguage())) {
            return defaultMessage;
        }
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(this.getClass().getName());
            return bundle.getString(this.name());
        }
        catch (Exception e) {
            return defaultMessage;
        }
    }

    @Deprecated
    protected IllegalArgumentException illegalValue(Locale locale, String ... args) {
        return this.illegalValue(locale, "<unknown>", (Object[])args);
    }

    protected IllegalArgumentException illegalValue(Locale locale, String value, Object[] args) throws IllegalArgumentException {
        return this.illegalValue(locale, value, this.validationMessage, args);
    }

    protected IllegalArgumentException illegalValue(Locale locale, String value, String rawMessage, Object[] args) throws IllegalArgumentException {
        String message = this.getMessage(locale, rawMessage);
        String errorMessage = new Formatter(locale).format(message, args).toString();
        String settingNameMessage = this.getMessage(locale, "Invalid value %s for config property '%s': ");
        String settingMessage = new Formatter(locale).format(settingNameMessage, value == null ? "[null]" : "'" + value + "'", this.name()).toString();
        return new IllegalArgumentException(settingMessage + errorMessage);
    }

    public static boolean osIsWindows() {
        String nameOs = System.getProperty("os.name");
        return nameOs.startsWith("Windows");
    }

    public static boolean osIsMacOS() {
        String nameOs = System.getProperty("os.name");
        return nameOs.equalsIgnoreCase("Mac OS X");
    }

    @Deprecated
    public static class URISetting
    extends GraphDatabaseSetting<URI> {
        private boolean normalize;

        public URISetting(String name) {
            this(name, false);
        }

        public URISetting(String name, boolean normalize) {
            super(name, "Value given does not validate as a proper URI.");
            this.normalize = normalize;
        }

        @Override
        public void validate(Locale locale, String value) {
            if (value == null) {
                throw this.illegalValue(locale, null, (Object[])new String[0]);
            }
            try {
                new URI(value).normalize();
            }
            catch (URISyntaxException e) {
                throw this.illegalValue(locale, value, (Object[])new String[0]);
            }
        }

        @Override
        public URI valueOf(String rawValue, Config config) {
            URI uri = null;
            try {
                String resultStr;
                uri = new URI(rawValue);
                if (this.normalize && (resultStr = uri.normalize().toString()).endsWith("/")) {
                    uri = new URI(resultStr.substring(0, resultStr.length() - 1));
                }
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Unable to get URI value from config, see nested exception", e);
            }
            return uri;
        }
    }

    @Deprecated
    public static class ListSetting<T>
    extends GraphDatabaseSetting<List<T>> {
        private GraphDatabaseSetting<T> itemSetting;
        private String separator;

        public ListSetting(String name, GraphDatabaseSetting<T> itemSetting) {
            this(name, itemSetting, ",");
        }

        public ListSetting(String name, GraphDatabaseSetting<T> itemSetting, String separator) {
            super(name, "%s is not a valid list, must be '" + separator + "' separated list of values.");
            this.itemSetting = itemSetting;
            this.separator = separator;
        }

        @Override
        public void validate(Locale locale, String value) {
            if (value == null) {
                throw this.illegalValue(locale, value, (Object[])new String[0]);
            }
            if (value.length() == 0) {
                return;
            }
            for (String item : value.split(this.separator)) {
                this.itemSetting.validate(item);
            }
        }

        @Override
        public List<T> valueOf(String rawValue, Config config) {
            ArrayList<T> list = new ArrayList<T>();
            if (rawValue.length() > 0) {
                for (String item : rawValue.split(this.separator)) {
                    list.add(this.itemSetting.valueOf(item, config));
                }
            }
            return list;
        }
    }

    @Deprecated
    public static class IntegerRangeNumberOfBytesSetting
    extends GraphDatabaseSetting<Integer> {
        private final GraphDatabaseSetting<Long> fullRange;
        private final int atLeast;

        public IntegerRangeNumberOfBytesSetting(String name) {
            this(name, 0);
        }

        public IntegerRangeNumberOfBytesSetting(String name, int atLeast) {
            super(name, "");
            this.atLeast = atLeast;
            this.fullRange = new NumberOfBytesSetting(name);
        }

        @Override
        public void validate(Locale locale, String value) {
            this.fullRange.validate(locale, value);
            Long bytes = this.fullRange.valueOf(value, null);
            if (bytes > Integer.MAX_VALUE) {
                throw this.illegalValue(locale, value, "Size too big, keep withing interger range (2^32-1)", "" + bytes);
            }
            int result = bytes.intValue();
            if (result < this.atLeast) {
                throw this.illegalValue(locale, value, "Size too low, must be at least " + this.atLeast);
            }
        }

        @Override
        public Integer valueOf(String rawValue, Config config) {
            return this.fullRange.valueOf(rawValue, config).intValue();
        }
    }

    @Deprecated
    public static class NumberOfBytesSetting
    extends GraphDatabaseSetting<Long> {
        private final Pattern sizeRegex = Pattern.compile("\\d+ *[kmgKMG]?");

        public NumberOfBytesSetting(String name) {
            super(name, "%s is not a valid size, must be e.g. 10, 5K, 1M, 11G");
        }

        @Override
        public void validate(Locale locale, String value) {
            if (value == null) {
                throw this.illegalValue(locale, value, (Object[])new String[0]);
            }
            if (!this.sizeRegex.matcher(value).matches()) {
                throw this.illegalValue(locale, value, (Object[])new String[0]);
            }
        }

        @Override
        public Long valueOf(String rawValue, Config config) {
            String mem = rawValue.toLowerCase();
            long multiplier = 1L;
            if (mem.endsWith("k")) {
                multiplier = 1024L;
                mem = mem.substring(0, mem.length() - 1);
            } else if (mem.endsWith("m")) {
                multiplier = 0x100000L;
                mem = mem.substring(0, mem.length() - 1);
            } else if (mem.endsWith("g")) {
                multiplier = 0x40000000L;
                mem = mem.substring(0, mem.length() - 1);
            }
            return Long.parseLong(mem.trim()) * multiplier;
        }
    }

    @Deprecated
    public static class DirectorySetting
    extends AbstractPathSetting {
        public DirectorySetting(String name) {
            super(name, null, false, false);
        }

        public DirectorySetting(String name, boolean makeCanonical, boolean fixIncorrectPathSeparators) {
            super(name, null, makeCanonical, fixIncorrectPathSeparators);
        }

        public DirectorySetting(String name, DirectorySetting relativeTo, boolean makeCanonical, boolean fixIncorrectPathSeparators) {
            super(name, relativeTo, makeCanonical, fixIncorrectPathSeparators);
        }

        @Override
        public void validate(Locale locale, String value) {
            if (value == null) {
                throw this.illegalValue(locale, value, (Object[])new String[0]);
            }
            File dir = new File(value);
            if (dir.exists() && !dir.isDirectory()) {
                throw this.illegalValue(locale, value, (Object[])new String[0]);
            }
        }
    }

    @Deprecated
    public static class FileSetting
    extends AbstractPathSetting {
        public FileSetting(String name) {
            super(name, null, false, false);
        }

        public FileSetting(String name, boolean makeCanonical, boolean fixIncorrectPathSeparators) {
            super(name, null, makeCanonical, fixIncorrectPathSeparators);
        }

        public FileSetting(String name, DirectorySetting relativeTo, boolean makeCanonical, boolean fixIncorrectPathSeparators) {
            super(name, relativeTo, makeCanonical, fixIncorrectPathSeparators);
        }

        @Override
        public void validate(Locale locale, String value) {
            if (value == null) {
                throw this.illegalValue(locale, value, (Object[])new String[0]);
            }
            File file = new File(value);
            if (file.exists() && !file.isFile()) {
                throw this.illegalValue(locale, value, (Object[])new String[0]);
            }
        }
    }

    @Deprecated
    public static class AbstractPathSetting
    extends StringSetting {
        private DirectorySetting relativeTo;
        private boolean makeCanonical;
        private boolean fixIncorrectPathSeparators;

        public AbstractPathSetting(String name) {
            this(name, null, false, false);
        }

        public AbstractPathSetting(String name, boolean makeCanonical, boolean fixIncorrectPathSeparators) {
            this(name, null, makeCanonical, fixIncorrectPathSeparators);
        }

        public AbstractPathSetting(String name, DirectorySetting relativeTo, boolean makeCanonical, boolean fixIncorrectPathSeparators) {
            super(name, ".*", "Must be a valid file path.");
            this.relativeTo = relativeTo;
            this.makeCanonical = makeCanonical;
            this.fixIncorrectPathSeparators = fixIncorrectPathSeparators;
        }

        @Override
        public void validate(Locale locale, String value) {
            if (value == null) {
                throw this.illegalValue(locale, value, (Object[])new String[0]);
            }
        }

        @Override
        public String valueOf(String rawValue, Config config) {
            File path;
            if (this.fixIncorrectPathSeparators) {
                rawValue = FileUtils.fixSeparatorsInPath(rawValue);
            }
            if (!(path = new File(rawValue)).isAbsolute() && this.relativeTo != null) {
                File baseDir = new File(config.get(this.relativeTo));
                path = new File(baseDir, rawValue);
            }
            if (this.makeCanonical) {
                try {
                    return path.getCanonicalPath();
                }
                catch (IOException e) {
                    if (path.isAbsolute()) {
                        return path.getAbsolutePath();
                    }
                    throw new IllegalArgumentException(this.name() + ": unable to resolve canonical path for " + rawValue + ".", e);
                }
            }
            if (path.isAbsolute()) {
                return path.getAbsolutePath();
            }
            return rawValue;
        }
    }

    @Deprecated
    public static class BooleanSetting
    extends BaseOptionsSetting<Boolean> {
        public BooleanSetting(String name) {
            super(name, GraphDatabaseSetting.TRUE, GraphDatabaseSetting.FALSE);
        }

        @Override
        public Boolean valueOf(String rawValue, Config config) {
            return Boolean.parseBoolean(rawValue);
        }
    }

    @Deprecated
    public static class EnumerableSetting<ET extends Enum<ET>>
    extends BaseOptionsSetting<ET> {
        private final Class<ET> backingEnum;

        private static String[] enumSetToStringArray(EnumSet<?> enums) {
            String[] stringValues = new String[enums.size()];
            int i = 0;
            for (Enum v : enums) {
                stringValues[i++] = v.name().toLowerCase();
            }
            return stringValues;
        }

        public EnumerableSetting(String name, Class<ET> theEnum) {
            super(name, EnumerableSetting.enumSetToStringArray(EnumSet.allOf(theEnum)));
            this.backingEnum = theEnum;
        }

        @Override
        public ET valueOf(String rawValue, Config config) {
            return Enum.valueOf(this.backingEnum, rawValue);
        }
    }

    @Deprecated
    public static class OptionsSetting
    extends BaseOptionsSetting<String> {
        protected OptionsSetting(String name, String ... options) {
            super(name, options);
        }

        @Override
        public String valueOf(String rawValue, Config config) {
            return rawValue;
        }
    }

    @Deprecated
    public static abstract class BaseOptionsSetting<ST>
    extends GraphDatabaseSetting<ST> {
        String[] options;

        protected BaseOptionsSetting(String name, String ... options) {
            super(name, "Invalid option. Valid options are:%s");
            this.options = options;
        }

        @Override
        public void validate(Locale locale, String value) throws IllegalArgumentException {
            for (String option : this.options()) {
                if (!option.equalsIgnoreCase(value)) continue;
                return;
            }
            throw this.illegalValue(locale, value, (Object[])new String[]{Arrays.asList(this.options()).toString()});
        }

        public String[] options() {
            return this.options;
        }
    }

    @Deprecated
    public static class TimeSpanSetting
    extends GraphDatabaseSetting<Long> {
        private final Pattern timeSpanRegex = Pattern.compile("\\d+(ms|s|m)");

        public TimeSpanSetting(String name) {
            super(name, "Must be a valid time span");
        }

        @Override
        public void validate(Locale locale, String value) throws IllegalArgumentException {
            if (value == null) {
                throw this.illegalValue(locale, value, (Object[])new String[0]);
            }
            if (!this.timeSpanRegex.matcher(value).matches()) {
                throw this.illegalValue(locale, value, (Object[])new String[0]);
            }
        }

        @Override
        public Long valueOf(String rawValue, Config config) {
            return TimeUtil.parseTimeMillis(rawValue);
        }
    }

    @Deprecated
    public static class PortSetting
    extends IntegerSetting {
        public PortSetting(String name) {
            super(name, "Must be a valid port number", 1, 65535);
        }
    }

    @Deprecated
    public static class DoubleSetting
    extends NumberSetting<Double> {
        public DoubleSetting(String name, String formatMessage) {
            super(name, formatMessage);
        }

        public DoubleSetting(String name, String formatMessage, Double min, Double max) {
            super(name, formatMessage, min, max);
        }

        @Override
        public void validate(Locale locale, String value) {
            double val;
            if (value == null) {
                throw this.illegalValue(locale, value, (Object[])new String[0]);
            }
            try {
                val = Double.parseDouble(value);
            }
            catch (Exception e) {
                throw this.illegalValue(locale, value, (Object[])new String[0]);
            }
            this.rangeCheck(locale, Double.valueOf(val));
        }

        @Override
        public Double valueOf(String rawValue, Config config) {
            return Double.valueOf(rawValue);
        }
    }

    @Deprecated
    public static class FloatSetting
    extends NumberSetting<Float> {
        public FloatSetting(String name, String formatMessage) {
            super(name, formatMessage);
        }

        public FloatSetting(String name, String formatMessage, Float min, Float max) {
            super(name, formatMessage, min, max);
        }

        @Override
        public void validate(Locale locale, String value) {
            float val;
            if (value == null) {
                throw this.illegalValue(locale, value, (Object[])new String[0]);
            }
            try {
                val = Float.parseFloat(value);
            }
            catch (Exception e) {
                throw this.illegalValue(locale, value, (Object[])new String[0]);
            }
            this.rangeCheck(locale, Float.valueOf(val));
        }

        @Override
        public Float valueOf(String rawValue, Config config) {
            return Float.valueOf(rawValue);
        }
    }

    @Deprecated
    public static class LongSetting
    extends NumberSetting<Long> {
        public LongSetting(String name, String formatMessage) {
            super(name, formatMessage);
        }

        public LongSetting(String name, String formatMessage, Long min, Long max) {
            super(name, formatMessage, min, max);
        }

        @Override
        public void validate(Locale locale, String value) {
            long val;
            if (value == null) {
                throw this.illegalValue(locale, value, (Object[])new String[0]);
            }
            try {
                val = Long.parseLong(value);
            }
            catch (Exception e) {
                throw this.illegalValue(locale, value, (Object[])new String[0]);
            }
            this.rangeCheck(locale, Long.valueOf(val));
        }

        @Override
        public Long valueOf(String rawValue, Config config) {
            return Long.valueOf(rawValue);
        }
    }

    @Deprecated
    public static class IntegerSetting
    extends NumberSetting<Integer> {
        public IntegerSetting(String name, String formatMessage) {
            super(name, formatMessage);
        }

        public IntegerSetting(String name, String formatMessage, Integer min, Integer max) {
            super(name, formatMessage, min, max);
        }

        @Override
        public void validate(Locale locale, String value) {
            int val;
            if (value == null) {
                throw this.illegalValue(locale, value, (Object[])new String[0]);
            }
            try {
                val = Integer.parseInt(value);
            }
            catch (Exception e) {
                throw this.illegalValue(locale, value, (Object[])new String[0]);
            }
            this.rangeCheck(locale, Integer.valueOf(val));
        }

        @Override
        public Integer valueOf(String rawValue, Config config) {
            return Integer.valueOf(rawValue);
        }
    }

    @Deprecated
    public static abstract class NumberSetting<T extends Number>
    extends GraphDatabaseSetting<T> {
        protected T min;
        protected T max;

        protected NumberSetting(String name, String validationMessage) {
            super(name, validationMessage);
        }

        protected NumberSetting(String name, String validationMessage, T min, T max) {
            super(name, validationMessage);
            this.min = min;
            this.max = max;
        }

        protected void rangeCheck(Locale locale, Comparable value) {
            if (this.min != null && value.compareTo(this.min) < 0) {
                throw this.illegalValue(locale, value + "", "Minimum allowed value is: %s", (Object[])new String[]{this.min + ""});
            }
            if (this.max != null && value.compareTo(this.max) > 0) {
                throw this.illegalValue(locale, value + "", "Maximum allowed value is: %s", (Object[])new String[]{this.max + ""});
            }
        }

        @Deprecated
        protected void rangeCheck(Comparable value) {
            this.rangeCheck(Locale.getDefault(), value);
        }

        public T getMin() {
            return this.min;
        }

        public T getMax() {
            return this.max;
        }
    }

    @Deprecated
    public static class StringSetting
    extends GraphDatabaseSetting<String> {
        private Pattern regex;

        public StringSetting() {
            this("", GraphDatabaseSetting.ANY, "Must be a non-empty string.");
        }

        public StringSetting(String name, String regex, String formatMessage) {
            super(name, formatMessage);
            this.regex = Pattern.compile(regex);
        }

        @Override
        public void validate(Locale locale, String value) {
            if (value == null) {
                throw this.illegalValue(locale, value, (Object[])new String[0]);
            }
            if (!this.regex.matcher(value).matches()) {
                throw this.illegalValue(locale, value, (Object[])new String[0]);
            }
        }

        @Override
        public String valueOf(String rawValue, Config config) {
            return rawValue;
        }
    }

    public static interface DefaultValue {
        public String getDefaultValue();
    }
}

