/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.traversal;

import java.util.Arrays;
import java.util.HashSet;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluator;

public abstract class Evaluators {
    private static final Evaluator ALL = new Evaluator(){

        @Override
        public Evaluation evaluate(Path path) {
            return Evaluation.INCLUDE_AND_CONTINUE;
        }
    };
    private static final Evaluator ALL_BUT_START_POSITION = new Evaluator(){

        @Override
        public Evaluation evaluate(Path path) {
            return path.length() == 0 ? Evaluation.EXCLUDE_AND_CONTINUE : Evaluation.INCLUDE_AND_CONTINUE;
        }
    };

    public static Evaluator all() {
        return ALL;
    }

    public static Evaluator excludeStartPosition() {
        return ALL_BUT_START_POSITION;
    }

    public static Evaluator toDepth(final int depth) {
        return new Evaluator(){

            @Override
            public Evaluation evaluate(Path path) {
                int pathLength = path.length();
                return Evaluation.of(pathLength <= depth, pathLength < depth);
            }
        };
    }

    public static Evaluator fromDepth(final int depth) {
        return new Evaluator(){

            @Override
            public Evaluation evaluate(Path path) {
                return path.length() >= depth ? Evaluation.INCLUDE_AND_CONTINUE : Evaluation.EXCLUDE_AND_CONTINUE;
            }
        };
    }

    public static Evaluator atDepth(final int depth) {
        return new Evaluator(){

            @Override
            public Evaluation evaluate(Path path) {
                return path.length() == depth ? Evaluation.INCLUDE_AND_PRUNE : Evaluation.EXCLUDE_AND_CONTINUE;
            }
        };
    }

    public static Evaluator includingDepths(final int minDepth, final int maxDepth) {
        return new Evaluator(){

            @Override
            public Evaluation evaluate(Path path) {
                int length = path.length();
                return Evaluation.of(length >= minDepth && length <= maxDepth, length < maxDepth);
            }
        };
    }

    public static Evaluator lastRelationshipTypeIs(final Evaluation evaluationIfMatch, final Evaluation evaluationIfNoMatch, final RelationshipType type, RelationshipType ... orAnyOfTheseTypes) {
        if (orAnyOfTheseTypes.length == 0) {
            return new Evaluator(){

                @Override
                public Evaluation evaluate(Path path) {
                    Relationship rel = path.lastRelationship();
                    if (rel == null) {
                        return evaluationIfNoMatch;
                    }
                    return rel.isType(type) ? evaluationIfMatch : evaluationIfNoMatch;
                }
            };
        }
        final HashSet<String> expectedTypes = new HashSet<String>();
        expectedTypes.add(type.name());
        for (RelationshipType otherType : orAnyOfTheseTypes) {
            expectedTypes.add(otherType.name());
        }
        return new Evaluator(){

            @Override
            public Evaluation evaluate(Path path) {
                Relationship lastRelationship = path.lastRelationship();
                if (lastRelationship == null) {
                    return evaluationIfNoMatch;
                }
                return expectedTypes.contains(lastRelationship.getType().name()) ? evaluationIfMatch : evaluationIfNoMatch;
            }
        };
    }

    public static Evaluator returnWhereLastRelationshipTypeIs(RelationshipType type, RelationshipType ... orAnyOfTheseTypes) {
        return Evaluators.includeWhereLastRelationshipTypeIs(type, orAnyOfTheseTypes);
    }

    public static Evaluator includeWhereLastRelationshipTypeIs(RelationshipType type, RelationshipType ... orAnyOfTheseTypes) {
        return Evaluators.lastRelationshipTypeIs(Evaluation.INCLUDE_AND_CONTINUE, Evaluation.EXCLUDE_AND_CONTINUE, type, orAnyOfTheseTypes);
    }

    public static Evaluator pruneWhereLastRelationshipTypeIs(RelationshipType type, RelationshipType ... orAnyOfTheseTypes) {
        return Evaluators.lastRelationshipTypeIs(Evaluation.INCLUDE_AND_PRUNE, Evaluation.EXCLUDE_AND_CONTINUE, type, orAnyOfTheseTypes);
    }

    public static Evaluator endNodeIs(final Evaluation evaluationIfMatch, final Evaluation evaluationIfNoMatch, Node ... possibleEndNodes) {
        if (possibleEndNodes.length == 1) {
            final Node target = possibleEndNodes[0];
            return new Evaluator(){

                @Override
                public Evaluation evaluate(Path path) {
                    return target.equals(path.endNode()) ? evaluationIfMatch : evaluationIfNoMatch;
                }
            };
        }
        final HashSet<Node> endNodes = new HashSet<Node>(Arrays.asList(possibleEndNodes));
        return new Evaluator(){

            @Override
            public Evaluation evaluate(Path path) {
                return endNodes.contains(path.endNode()) ? evaluationIfMatch : evaluationIfNoMatch;
            }
        };
    }

    public static Evaluator returnWhereEndNodeIs(Node ... nodes) {
        return Evaluators.includeWhereEndNodeIs(nodes);
    }

    public static Evaluator includeWhereEndNodeIs(Node ... nodes) {
        return Evaluators.endNodeIs(Evaluation.INCLUDE_AND_CONTINUE, Evaluation.EXCLUDE_AND_CONTINUE, nodes);
    }

    public static Evaluator pruneWhereEndNodeIs(Node ... nodes) {
        return Evaluators.endNodeIs(Evaluation.INCLUDE_AND_PRUNE, Evaluation.EXCLUDE_AND_CONTINUE, nodes);
    }

    public static Evaluator includeIfContainsAll(final Node ... nodes) {
        if (nodes.length == 1) {
            return new Evaluator(){

                @Override
                public Evaluation evaluate(Path path) {
                    for (Node node : path.reverseNodes()) {
                        if (!node.equals(nodes[0])) continue;
                        return Evaluation.INCLUDE_AND_CONTINUE;
                    }
                    return Evaluation.EXCLUDE_AND_CONTINUE;
                }
            };
        }
        final HashSet<Node> fullSet = new HashSet<Node>(Arrays.asList(nodes));
        return new Evaluator(){

            @Override
            public Evaluation evaluate(Path path) {
                HashSet set = new HashSet(fullSet);
                for (Node node : path.reverseNodes()) {
                    if (!set.remove(node) || !set.isEmpty()) continue;
                    return Evaluation.INCLUDE_AND_CONTINUE;
                }
                return Evaluation.EXCLUDE_AND_CONTINUE;
            }
        };
    }

    public static Evaluator includeIfAcceptedByAny(final Evaluator ... evaluators) {
        return new Evaluator(){

            @Override
            public Evaluation evaluate(Path path) {
                for (Evaluator evaluator : evaluators) {
                    if (!evaluator.evaluate(path).includes()) continue;
                    return Evaluation.INCLUDE_AND_CONTINUE;
                }
                return Evaluation.EXCLUDE_AND_CONTINUE;
            }
        };
    }
}

