/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.util.Collection;
import java.util.Iterator;
import org.neo4j.index.impl.lucene.AbstractIndexHits;

class ConstantScoreIterator<T>
extends AbstractIndexHits<T> {
    private final Iterator<T> items;
    private final int size;
    private final float score;

    ConstantScoreIterator(Collection<T> items, float score) {
        this.items = items.iterator();
        this.score = score;
        this.size = items.size();
    }

    @Override
    public float currentScore() {
        return this.score;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    protected T fetchNextOrNull() {
        return this.items.hasNext() ? (T)this.items.next() : null;
    }
}

