/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.TimeZone;
import org.neo4j.helpers.Pair;
import org.neo4j.index.impl.lucene.LuceneCommand;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommandFactory;

public class DumpLogicalLog
extends org.neo4j.kernel.impl.util.DumpLogicalLog {
    public static void main(String[] args) throws IOException {
        Pair<Iterable<String>, TimeZone> config = DumpLogicalLog.parseConfig(args);
        for (String file : config.first()) {
            int dumped = new DumpLogicalLog().dump(file, config.other());
            if (dumped != 0 || !DumpLogicalLog.isAGraphDatabaseDirectory(file)) continue;
            new DumpLogicalLog().dump(new File(file, "index").getAbsolutePath(), config.other());
        }
    }

    @Override
    protected XaCommandFactory instantiateCommandFactory() {
        return new CommandFactory();
    }

    @Override
    protected String getLogPrefix() {
        return "lucene.log";
    }

    private static class CommandFactory
    extends XaCommandFactory {
        private CommandFactory() {
        }

        @Override
        public XaCommand readCommand(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
            return LuceneCommand.readCommand(byteChannel, buffer, null);
        }
    }
}

