/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.helpers.Pair;
import org.neo4j.index.impl.lucene.IndexIdentifier;
import org.neo4j.index.impl.lucene.IndexType;
import org.neo4j.kernel.impl.index.IndexStore;

class IndexTypeCache {
    private final Map<IndexIdentifier, Pair<Integer, IndexType>> cache = Collections.synchronizedMap(new HashMap());
    private final IndexStore indexStore;

    IndexTypeCache(IndexStore indexStore) {
        this.indexStore = indexStore;
    }

    IndexType getIndexType(IndexIdentifier identifier, boolean recovery) {
        Pair<Integer, IndexType> type = this.cache.get(identifier);
        Map<String, String> config = this.indexStore.get(identifier.entityType.getType(), identifier.indexName);
        if (type != null && ((Object)config).hashCode() == type.first().intValue()) {
            return type.other();
        }
        if (config == null) {
            if (recovery) {
                return null;
            }
            throw new IllegalArgumentException("Unknown index " + identifier);
        }
        type = Pair.of(((Object)config).hashCode(), IndexType.getIndexType(identifier, config));
        this.cache.put(identifier, type);
        return type.other();
    }

    void invalidate(IndexIdentifier identifier) {
        this.cache.remove(identifier);
    }
}

