/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

import java.util.Map;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.index.lucene.QueryContext;
import org.neo4j.index.lucene.TimelineIndex;
import org.neo4j.index.lucene.ValueContext;

public class LuceneTimeline<T extends PropertyContainer>
implements TimelineIndex<T> {
    private static final String FIELD = "timestamp";
    private final Index<T> index;

    public LuceneTimeline(GraphDatabaseService db, Index<T> index) {
        this.assertIsLuceneIndex(db, index);
        this.index = index;
    }

    private void assertIsLuceneIndex(GraphDatabaseService db, Index<T> index) {
        Map<String, String> config = db.index().getConfiguration(index);
        if (!config.get("provider").equals("lucene")) {
            throw new IllegalArgumentException(index + " isn't a Lucene index");
        }
    }

    private T getSingle(boolean reversed) {
        IndexHits hits = this.index.query(this.sort(this.everythingQuery().top(1), reversed));
        return (T)((PropertyContainer)hits.getSingle());
    }

    private QueryContext everythingQuery() {
        return new QueryContext(NumericRangeQuery.newLongRange(FIELD, 0L, Long.MAX_VALUE, true, true));
    }

    private QueryContext rangeQuery(Long startTimestampOrNull, Long endTimestampOrNull) {
        long start = startTimestampOrNull != null ? startTimestampOrNull : -9223372036854775807L;
        long end = endTimestampOrNull != null ? endTimestampOrNull : Long.MAX_VALUE;
        return new QueryContext(NumericRangeQuery.newLongRange(FIELD, start, end, true, true));
    }

    private QueryContext sort(QueryContext query, boolean reversed) {
        return query.sort(new Sort(new SortField(FIELD, 6, reversed)));
    }

    @Override
    public T getLast() {
        return this.getSingle(true);
    }

    @Override
    public T getFirst() {
        return this.getSingle(false);
    }

    @Override
    public void remove(T entity, long timestamp) {
        this.index.remove(entity, FIELD, timestamp);
    }

    @Override
    public void add(T entity, long timestamp) {
        this.index.add(entity, FIELD, ValueContext.numeric(timestamp));
    }

    @Override
    public IndexHits<T> getBetween(Long startTimestampOrNull, Long endTimestampOrNull) {
        return this.getBetween(startTimestampOrNull, endTimestampOrNull, false);
    }

    @Override
    public IndexHits<T> getBetween(Long startTimestampOrNull, Long endTimestampOrNull, boolean reversed) {
        return this.index.query(this.sort(this.rangeQuery(startTimestampOrNull, endTimestampOrNull), reversed));
    }
}

