/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.traversal.BranchSelector;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.graphdb.traversal.TraversalContext;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.AbstractSelectorOrderer;

public class LevelSelectorOrderer
extends AbstractSelectorOrderer<Pair<AtomicInteger, TraversalBranch[]>> {
    private final boolean stopDescentOnResult;
    private final TotalDepth totalDepth = new TotalDepth();
    private final int maxDepth;

    public LevelSelectorOrderer(BranchSelector startSelector, BranchSelector endSelector, boolean stopDescentOnResult, int maxDepth) {
        super(startSelector, endSelector);
        this.stopDescentOnResult = stopDescentOnResult;
        this.maxDepth = maxDepth;
    }

    @Override
    protected Pair<AtomicInteger, TraversalBranch[]> initialState() {
        return Pair.of(new AtomicInteger(), new TraversalBranch[]{null});
    }

    @Override
    public TraversalBranch next(TraversalContext metadata) {
        TraversalBranch branch = this.nextBranchFromCurrentSelector(metadata, false);
        Pair state = (Pair)this.getStateForCurrentSelector();
        AtomicInteger previousDepth = (AtomicInteger)state.first();
        if (branch != null && branch.length() == previousDepth.get()) {
            return branch;
        }
        if (branch != null) {
            this.totalDepth.set(this.currentSide(), branch.length());
        }
        if (this.stopDescentOnResult && metadata.getNumberOfPathsReturned() > 0 || this.totalDepth.get() > this.maxDepth + 1) {
            this.nextSelector();
            return null;
        }
        if (branch != null) {
            previousDepth.set(branch.length());
            ((TraversalBranch[])state.other())[0] = branch;
        }
        BranchSelector otherSelector = this.nextSelector();
        Pair otherState = (Pair)this.getStateForCurrentSelector();
        TraversalBranch otherBranch = ((TraversalBranch[])otherState.other())[0];
        if (otherBranch != null) {
            ((TraversalBranch[])otherState.other())[0] = null;
            return otherBranch;
        }
        otherBranch = otherSelector.next(metadata);
        return otherBranch != null ? otherBranch : branch;
    }

    private static class TotalDepth {
        private int out;
        private int in;

        private TotalDepth() {
        }

        void set(Direction side, int depth) {
            switch (side) {
                case OUTGOING: {
                    this.out = depth;
                    break;
                }
                case INCOMING: {
                    this.in = depth;
                }
            }
        }

        int get() {
            return this.out + this.in;
        }
    }
}

