/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Traverser;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.traversal.OldTraverserWrapper;

public class NodeProxy
implements Node {
    private final NodeLookup nodeLookup;
    private final long nodeId;

    NodeProxy(long nodeId, NodeLookup nodeLookup) {
        this.nodeId = nodeId;
        this.nodeLookup = nodeLookup;
    }

    @Override
    public long getId() {
        return this.nodeId;
    }

    @Override
    public GraphDatabaseService getGraphDatabase() {
        return this.nodeLookup.getGraphDatabase();
    }

    @Override
    public void delete() {
        this.nodeLookup.lookup(this.nodeId, LockType.WRITE).delete(this.nodeLookup.getNodeManager(), this);
    }

    @Override
    public Iterable<Relationship> getRelationships() {
        return this.nodeLookup.lookup(this.nodeId).getRelationships(this.nodeLookup.getNodeManager());
    }

    @Override
    public boolean hasRelationship() {
        return this.nodeLookup.lookup(this.nodeId).hasRelationship(this.nodeLookup.getNodeManager());
    }

    @Override
    public Iterable<Relationship> getRelationships(Direction dir) {
        return this.nodeLookup.lookup(this.nodeId).getRelationships(this.nodeLookup.getNodeManager(), dir);
    }

    @Override
    public boolean hasRelationship(Direction dir) {
        return this.nodeLookup.lookup(this.nodeId).hasRelationship(this.nodeLookup.getNodeManager(), dir);
    }

    @Override
    public Iterable<Relationship> getRelationships(RelationshipType ... types) {
        return this.nodeLookup.lookup(this.nodeId).getRelationships(this.nodeLookup.getNodeManager(), types);
    }

    @Override
    public Iterable<Relationship> getRelationships(Direction direction, RelationshipType ... types) {
        return this.nodeLookup.lookup(this.nodeId).getRelationships(this.nodeLookup.getNodeManager(), direction, types);
    }

    @Override
    public boolean hasRelationship(RelationshipType ... types) {
        return this.nodeLookup.lookup(this.nodeId).hasRelationship(this.nodeLookup.getNodeManager(), types);
    }

    @Override
    public boolean hasRelationship(Direction direction, RelationshipType ... types) {
        return this.nodeLookup.lookup(this.nodeId).hasRelationship(this.nodeLookup.getNodeManager(), direction, types);
    }

    @Override
    public Iterable<Relationship> getRelationships(RelationshipType type, Direction dir) {
        return this.nodeLookup.lookup(this.nodeId).getRelationships(this.nodeLookup.getNodeManager(), type, dir);
    }

    @Override
    public boolean hasRelationship(RelationshipType type, Direction dir) {
        return this.nodeLookup.lookup(this.nodeId).hasRelationship(this.nodeLookup.getNodeManager(), type, dir);
    }

    @Override
    public Relationship getSingleRelationship(RelationshipType type, Direction dir) {
        return this.nodeLookup.lookup(this.nodeId).getSingleRelationship(this.nodeLookup.getNodeManager(), type, dir);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.nodeLookup.lookup(this.nodeId, LockType.WRITE).setProperty(this.nodeLookup.getNodeManager(), this, key, value);
    }

    @Override
    public Object removeProperty(String key) throws NotFoundException {
        return this.nodeLookup.lookup(this.nodeId, LockType.WRITE).removeProperty(this.nodeLookup.getNodeManager(), this, key);
    }

    @Override
    public Object getProperty(String key, Object defaultValue) {
        return this.nodeLookup.lookup(this.nodeId).getProperty(this.nodeLookup.getNodeManager(), key, defaultValue);
    }

    @Override
    public Iterable<Object> getPropertyValues() {
        return this.nodeLookup.lookup(this.nodeId).getPropertyValues(this.nodeLookup.getNodeManager());
    }

    @Override
    public Iterable<String> getPropertyKeys() {
        return this.nodeLookup.lookup(this.nodeId).getPropertyKeys(this.nodeLookup.getNodeManager());
    }

    @Override
    public Object getProperty(String key) throws NotFoundException {
        return this.nodeLookup.lookup(this.nodeId).getProperty(this.nodeLookup.getNodeManager(), key);
    }

    @Override
    public boolean hasProperty(String key) {
        return this.nodeLookup.lookup(this.nodeId).hasProperty(this.nodeLookup.getNodeManager(), key);
    }

    public int compareTo(Object node) {
        long theirId;
        Node n = (Node)node;
        long ourId = this.getId();
        if (ourId < (theirId = n.getId())) {
            return -1;
        }
        if (ourId > theirId) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Node)) {
            return false;
        }
        return this.getId() == ((Node)o).getId();
    }

    public int hashCode() {
        return (int)(this.nodeId >>> 32 ^ this.nodeId);
    }

    public String toString() {
        return "Node[" + this.getId() + "]";
    }

    @Override
    public Relationship createRelationshipTo(Node otherNode, RelationshipType type) {
        return this.nodeLookup.lookup(this.nodeId, LockType.WRITE).createRelationshipTo(this.nodeLookup.getNodeManager(), this, otherNode, type);
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType relationshipType, Direction direction) {
        return OldTraverserWrapper.traverse(this, traversalOrder, stopEvaluator, returnableEvaluator, new Object[]{relationshipType, direction});
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType firstRelationshipType, Direction firstDirection, RelationshipType secondRelationshipType, Direction secondDirection) {
        return OldTraverserWrapper.traverse(this, traversalOrder, stopEvaluator, returnableEvaluator, new Object[]{firstRelationshipType, firstDirection, secondRelationshipType, secondDirection});
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, Object ... relationshipTypesAndDirections) {
        return OldTraverserWrapper.traverse(this, traversalOrder, stopEvaluator, returnableEvaluator, relationshipTypesAndDirections);
    }

    public static interface NodeLookup {
        public NodeImpl lookup(long var1);

        public GraphDatabaseService getGraphDatabase();

        public NodeManager getNodeManager();

        public NodeImpl lookup(long var1, LockType var3);
    }
}

