/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.transaction.LockType;

public class RelationshipProxy
implements Relationship {
    private final long relId;
    private final RelationshipLookups relationshipLookups;

    RelationshipProxy(long relId, RelationshipLookups relationshipLookups) {
        this.relId = relId;
        this.relationshipLookups = relationshipLookups;
    }

    @Override
    public long getId() {
        return this.relId;
    }

    @Override
    public GraphDatabaseService getGraphDatabase() {
        return this.relationshipLookups.getGraphDatabaseService();
    }

    @Override
    public void delete() {
        this.relationshipLookups.lookupRelationship(this.relId, LockType.WRITE).delete(this.relationshipLookups.getNodeManager(), this);
    }

    @Override
    public Node[] getNodes() {
        RelationshipImpl relationship = this.relationshipLookups.lookupRelationship(this.relId);
        return new Node[]{this.relationshipLookups.newNodeProxy(relationship.getStartNodeId()), this.relationshipLookups.newNodeProxy(relationship.getEndNodeId())};
    }

    @Override
    public Node getOtherNode(Node node) {
        RelationshipImpl relationship = this.relationshipLookups.lookupRelationship(this.relId);
        if (relationship.getStartNodeId() == node.getId()) {
            return this.relationshipLookups.newNodeProxy(relationship.getEndNodeId());
        }
        if (relationship.getEndNodeId() == node.getId()) {
            return this.relationshipLookups.newNodeProxy(relationship.getStartNodeId());
        }
        throw new NotFoundException("Node[" + node.getId() + "] not connected to this relationship[" + this.getId() + "]");
    }

    @Override
    public Node getStartNode() {
        return this.relationshipLookups.newNodeProxy(this.relationshipLookups.lookupRelationship(this.relId).getStartNodeId());
    }

    @Override
    public Node getEndNode() {
        return this.relationshipLookups.newNodeProxy(this.relationshipLookups.lookupRelationship(this.relId).getEndNodeId());
    }

    @Override
    public RelationshipType getType() {
        return this.relationshipLookups.getNodeManager().getRelationshipTypeById(this.relationshipLookups.lookupRelationship(this.relId).getTypeId());
    }

    @Override
    public Iterable<String> getPropertyKeys() {
        return this.relationshipLookups.lookupRelationship(this.relId).getPropertyKeys(this.relationshipLookups.getNodeManager());
    }

    @Override
    public Iterable<Object> getPropertyValues() {
        return this.relationshipLookups.lookupRelationship(this.relId).getPropertyValues(this.relationshipLookups.getNodeManager());
    }

    @Override
    public Object getProperty(String key) {
        return this.relationshipLookups.lookupRelationship(this.relId).getProperty(this.relationshipLookups.getNodeManager(), key);
    }

    @Override
    public Object getProperty(String key, Object defaultValue) {
        return this.relationshipLookups.lookupRelationship(this.relId).getProperty(this.relationshipLookups.getNodeManager(), key, defaultValue);
    }

    @Override
    public boolean hasProperty(String key) {
        return this.relationshipLookups.lookupRelationship(this.relId).hasProperty(this.relationshipLookups.getNodeManager(), key);
    }

    @Override
    public void setProperty(String key, Object property) {
        this.relationshipLookups.lookupRelationship(this.relId, LockType.WRITE).setProperty(this.relationshipLookups.getNodeManager(), this, key, property);
    }

    @Override
    public Object removeProperty(String key) {
        return this.relationshipLookups.lookupRelationship(this.relId, LockType.WRITE).removeProperty(this.relationshipLookups.getNodeManager(), this, key);
    }

    @Override
    public boolean isType(RelationshipType type) {
        return this.relationshipLookups.getNodeManager().getRelationshipTypeById(this.relationshipLookups.lookupRelationship(this.relId).getTypeId()).name().equals(type.name());
    }

    public int compareTo(Object rel) {
        long theirId;
        Relationship r = (Relationship)rel;
        long ourId = this.getId();
        if (ourId < (theirId = r.getId())) {
            return -1;
        }
        if (ourId > theirId) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Relationship)) {
            return false;
        }
        return this.getId() == ((Relationship)o).getId();
    }

    public int hashCode() {
        return (int)(this.relId >>> 32 ^ this.relId);
    }

    public String toString() {
        return "Relationship[" + this.getId() + "]";
    }

    public static interface RelationshipLookups {
        public Node lookupNode(long var1);

        public Node newNodeProxy(long var1);

        public RelationshipImpl lookupRelationship(long var1);

        public GraphDatabaseService getGraphDatabaseService();

        public NodeManager getNodeManager();

        public RelationshipImpl lookupRelationship(long var1, LockType var3);
    }
}

