/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.neo4j.kernel.impl.storemigration.StoreFiles;

public class LogFiles {
    public static void move(File fromDirectory, File toDirectory) throws IOException {
        assert (fromDirectory.isDirectory());
        assert (toDirectory.isDirectory());
        for (String logFile : fromDirectory.list(new LogicalLogFilenameFilter())) {
            StoreFiles.moveFile(logFile, fromDirectory, toDirectory);
        }
    }

    private static final class LogicalLogFilenameFilter
    implements FilenameFilter {
        private static final String[] logFilenamePatterns = new String[]{"active_tx_log", "nioneo_logical\\.log.*", "tm_tx_log\\..*"};

        private LogicalLogFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            for (String pattern : logFilenamePatterns) {
                if (!name.matches(pattern)) continue;
                return true;
            }
            return false;
        }
    }
}

