/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.LinkedList;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeRecord;

public class LegacyRelationshipTypeStoreReader {
    public static final String FROM_VERSION = "RelationshipTypeStore v0.9.9";
    private String fileName;

    public LegacyRelationshipTypeStoreReader(String fileName) {
        this.fileName = fileName;
    }

    public Iterable<RelationshipTypeRecord> readRelationshipTypes() throws IOException {
        FileChannel fileChannel = new RandomAccessFile(this.fileName, "r").getChannel();
        int recordLength = 5;
        int endHeaderSize = UTF8.encode(FROM_VERSION).length;
        long recordCount = (fileChannel.size() - (long)endHeaderSize) / (long)recordLength;
        LinkedList<RelationshipTypeRecord> records = new LinkedList<RelationshipTypeRecord>();
        ByteBuffer buffer = ByteBuffer.allocateDirect(recordLength);
        int id = 0;
        while ((long)id <= recordCount) {
            boolean inUse;
            buffer.position(0);
            fileChannel.read(buffer);
            buffer.flip();
            long inUseByte = buffer.get();
            boolean bl = inUse = inUseByte == (long)Record.IN_USE.byteValue();
            if (inUse) {
                RelationshipTypeRecord record = new RelationshipTypeRecord(id);
                record.setInUse(inUse);
                record.setNameId(buffer.getInt());
                records.add(record);
            }
            ++id;
        }
        fileChannel.close();
        return records;
    }
}

