/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.Transaction;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.transaction.IllegalResourceException;
import org.neo4j.kernel.impl.transaction.LockNotFoundException;
import org.neo4j.kernel.impl.transaction.RWLock;
import org.neo4j.kernel.impl.transaction.RagManager;
import org.neo4j.kernel.info.LockInfo;
import org.neo4j.kernel.info.LockingTransaction;
import org.neo4j.kernel.info.WaitingThread;

public class LockManager {
    private final Map<Object, RWLock> resourceLockMap = new HashMap<Object, RWLock>();
    private final RagManager ragManager;

    public LockManager(RagManager ragManager) {
        this.ragManager = ragManager;
    }

    public long getDetectedDeadlockCount() {
        return this.ragManager.getDeadlockCount();
    }

    public void getReadLock(Object resource) throws DeadlockDetectedException, IllegalResourceException {
        this.getReadLock(resource, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getReadLock(Object resource, Transaction tx) throws DeadlockDetectedException, IllegalResourceException {
        if (resource == null) {
            throw new IllegalResourceException("Null parameter");
        }
        RWLock lock = null;
        Map<Object, RWLock> map = this.resourceLockMap;
        synchronized (map) {
            lock = this.resourceLockMap.get(resource);
            if (lock == null) {
                lock = new RWLock(resource, this.ragManager);
                this.resourceLockMap.put(resource, lock);
            }
            lock.mark();
        }
        lock.acquireReadLock(tx);
    }

    public void getWriteLock(Object resource) throws DeadlockDetectedException, IllegalResourceException {
        this.getWriteLock(resource, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getWriteLock(Object resource, Transaction tx) throws DeadlockDetectedException, IllegalResourceException {
        if (resource == null) {
            throw new IllegalResourceException("Null parameter");
        }
        RWLock lock = null;
        Map<Object, RWLock> map = this.resourceLockMap;
        synchronized (map) {
            lock = this.resourceLockMap.get(resource);
            if (lock == null) {
                lock = new RWLock(resource, this.ragManager);
                this.resourceLockMap.put(resource, lock);
            }
            lock.mark();
        }
        lock.acquireWriteLock(tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseReadLock(Object resource, Transaction tx) throws LockNotFoundException, IllegalResourceException {
        if (resource == null) {
            throw new IllegalResourceException("Null parameter");
        }
        RWLock lock = null;
        Map<Object, RWLock> map = this.resourceLockMap;
        synchronized (map) {
            lock = this.resourceLockMap.get(resource);
            if (lock == null) {
                throw new LockNotFoundException("Lock not found for: " + resource);
            }
            if (!lock.isMarked() && lock.getReadCount() == 1 && lock.getWriteCount() == 0 && lock.getWaitingThreadsCount() == 0) {
                this.resourceLockMap.remove(resource);
            }
            lock.releaseReadLock(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseWriteLock(Object resource, Transaction tx) throws LockNotFoundException, IllegalResourceException {
        if (resource == null) {
            throw new IllegalResourceException("Null parameter");
        }
        RWLock lock = null;
        Map<Object, RWLock> map = this.resourceLockMap;
        synchronized (map) {
            lock = this.resourceLockMap.get(resource);
            if (lock == null) {
                throw new LockNotFoundException("Lock not found for: " + resource);
            }
            if (!lock.isMarked() && lock.getReadCount() == 0 && lock.getWriteCount() == 1 && lock.getWaitingThreadsCount() == 0) {
                this.resourceLockMap.remove(resource);
            }
            lock.releaseWriteLock(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpLocksOnResource(Object resource) {
        RWLock lock = null;
        Map<Object, RWLock> map = this.resourceLockMap;
        synchronized (map) {
            if (!this.resourceLockMap.containsKey(resource)) {
                System.out.println("No locks on " + resource);
                return;
            }
            lock = this.resourceLockMap.get(resource);
        }
        lock.dumpStack();
    }

    public List<LockInfo> getAllLocks() {
        return this.eachLock(new ListAppendingVisitor()).result;
    }

    public List<LockInfo> getAwaitedLocks(long minWaitTime) {
        return this.eachAwaitedLock(new ListAppendingVisitor(), minWaitTime).result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V extends Visitor<LockInfo>> V eachLock(V visitor) {
        Map<Object, RWLock> map = this.resourceLockMap;
        synchronized (map) {
            for (RWLock lock : this.resourceLockMap.values()) {
                if (visitor.visit((LockInfo)lock.info())) break;
            }
        }
        return visitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V extends Visitor<LockInfo>> V eachAwaitedLock(V visitor, long minWaitTime) {
        long waitStart = System.currentTimeMillis() - minWaitTime;
        Map<Object, RWLock> map = this.resourceLockMap;
        synchronized (map) {
            for (RWLock lock : this.resourceLockMap.values()) {
                if (lock.acceptVisitorIfWaitedSinceBefore(visitor, waitStart)) break;
            }
        }
        return visitor;
    }

    public void dumpRagStack() {
        this.ragManager.dumpStack();
    }

    public void dumpAllLocks() {
        DumpVisitor dump = new DumpVisitor();
        this.eachLock(dump);
        dump.done();
    }

    private static class DumpVisitor
    implements Visitor<LockInfo> {
        int emptyLockCount = 0;

        private DumpVisitor() {
        }

        @Override
        public boolean visit(LockInfo lock) {
            if (lock.getWriteCount() > 0 || lock.getReadCount() > 0) {
                this.dumpStack(lock);
            } else {
                if (lock.getWaitingThreadsCount() > 0) {
                    this.dumpStack(lock);
                }
                ++this.emptyLockCount;
            }
            return false;
        }

        private void dumpStack(LockInfo lock) {
            System.out.println("Total lock count: readCount=" + lock.getReadCount() + " writeCount=" + lock.getWriteCount() + " for " + lock.getResourceType().toString(lock.getResourceId()));
            System.out.println("Waiting list:");
            StringBuilder waitlist = new StringBuilder();
            String sep = "";
            for (WaitingThread we : lock.getWaitingThreads()) {
                waitlist.append(sep).append("[tid=").append(we.getThreadId()).append("(").append(we.getReadCount()).append("r,").append(we.getWriteCount()).append("w ),").append(we.isWaitingOnWriteLock() ? "Write" : "Read").append("Lock]");
                sep = ", ";
            }
            System.out.println(waitlist);
            for (LockingTransaction tle : lock.getLockingTransactions()) {
                System.out.println("" + tle.getTransaction() + "(" + tle.getReadCount() + "r," + tle.getWriteCount() + "w)");
            }
        }

        void done() {
            if (this.emptyLockCount > 0) {
                System.out.println("There are " + this.emptyLockCount + " empty locks");
            } else {
                System.out.println("There are no empty locks");
            }
        }
    }

    private static class ListAppendingVisitor
    implements Visitor<LockInfo> {
        private final List<LockInfo> result = new ArrayList<LockInfo>();

        private ListAppendingVisitor() {
        }

        @Override
        public boolean visit(LockInfo element) {
            this.result.add(element);
            return false;
        }
    }
}

