/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.core.ReadOnlyDbException;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.ReadOnlyTransactionImpl;
import org.neo4j.kernel.impl.transaction.TransactionImpl;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaResource;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class ReadOnlyTxManager
extends AbstractTransactionManager
implements Lifecycle {
    private static Logger log = Logger.getLogger(ReadOnlyTxManager.class.getName());
    private ArrayMap<Thread, ReadOnlyTransactionImpl> txThreadMap;
    private int eventIdentifierCounter = 0;
    private XaDataSourceManager xaDsManager = null;

    public ReadOnlyTxManager(XaDataSourceManager xaDsManagerToUse) {
        this.xaDsManager = xaDsManagerToUse;
    }

    synchronized int getNextEventIdentifier() {
        return this.eventIdentifierCounter++;
    }

    @Override
    public void init() {
        this.txThreadMap = new ArrayMap(5, true, true);
    }

    @Override
    public void start() throws Throwable {
    }

    @Override
    public void stop() {
    }

    @Override
    public void shutdown() throws Throwable {
    }

    @Override
    public void begin() throws NotSupportedException {
        Thread thread = Thread.currentThread();
        ReadOnlyTransactionImpl tx = this.txThreadMap.get(thread);
        if (tx != null) {
            throw new NotSupportedException("Nested transactions not supported");
        }
        tx = new ReadOnlyTransactionImpl(this);
        this.txThreadMap.put(thread, tx);
    }

    @Override
    public void commit() throws RollbackException, HeuristicMixedException, IllegalStateException {
        Thread thread = Thread.currentThread();
        ReadOnlyTransactionImpl tx = this.txThreadMap.get(thread);
        if (tx == null) {
            throw new IllegalStateException("Not in transaction");
        }
        if (tx.getStatus() != 0 && tx.getStatus() != 1) {
            throw new IllegalStateException("Tx status is: " + this.getTxStatusAsString(tx.getStatus()));
        }
        tx.doBeforeCompletion();
        if (tx.getStatus() == 0) {
            this.commit(thread, tx);
        } else if (tx.getStatus() == 1) {
            this.rollbackCommit(thread, tx);
        } else {
            throw new IllegalStateException("Tx status is: " + this.getTxStatusAsString(tx.getStatus()));
        }
    }

    private void commit(Thread thread, ReadOnlyTransactionImpl tx) {
        if (tx.getResourceCount() != 0) {
            throw new ReadOnlyDbException();
        }
        tx.setStatus(3);
        tx.doAfterCompletion();
        this.txThreadMap.remove(thread);
        tx.setStatus(6);
    }

    private void rollbackCommit(Thread thread, ReadOnlyTransactionImpl tx) throws HeuristicMixedException, RollbackException {
        try {
            tx.doRollback();
        }
        catch (XAException e) {
            log.log(Level.SEVERE, "Unable to rollback marked transaction. Some resources may be commited others not. Neo4j kernel should be SHUTDOWN for resource maintance and transaction recovery ---->", e);
            throw Exceptions.withCause(new HeuristicMixedException("Unable to rollback  ---> error code for rollback: " + e.errorCode), e);
        }
        tx.doAfterCompletion();
        this.txThreadMap.remove(thread);
        tx.setStatus(6);
        throw new RollbackException("Failed to commit, transaction rolledback");
    }

    @Override
    public void rollback() throws IllegalStateException, SystemException {
        Thread thread = Thread.currentThread();
        ReadOnlyTransactionImpl tx = this.txThreadMap.get(thread);
        if (tx == null) {
            throw new IllegalStateException("Not in transaction");
        }
        if (tx.getStatus() == 0 || tx.getStatus() == 1 || tx.getStatus() == 7) {
            tx.doBeforeCompletion();
            try {
                tx.doRollback();
            }
            catch (XAException e) {
                log.log(Level.SEVERE, "Unable to rollback marked or active transaction. Some resources may be commited others not. Neo4j kernel should be SHUTDOWN for resource maintance and transaction recovery ---->", e);
                throw Exceptions.withCause(new SystemException("Unable to rollback  ---> error code for rollback: " + e.errorCode), e);
            }
        } else {
            throw new IllegalStateException("Tx status is: " + this.getTxStatusAsString(tx.getStatus()));
        }
        tx.doAfterCompletion();
        this.txThreadMap.remove(thread);
        tx.setStatus(6);
    }

    @Override
    public int getStatus() {
        Thread thread = Thread.currentThread();
        ReadOnlyTransactionImpl tx = this.txThreadMap.get(thread);
        if (tx != null) {
            return tx.getStatus();
        }
        return 6;
    }

    @Override
    public Transaction getTransaction() {
        return this.txThreadMap.get(Thread.currentThread());
    }

    @Override
    public void resume(Transaction tx) throws IllegalStateException {
        ReadOnlyTransactionImpl txImpl;
        Thread thread = Thread.currentThread();
        if (this.txThreadMap.get(thread) != null) {
            throw new IllegalStateException("Transaction already associated");
        }
        if (tx != null && (txImpl = (ReadOnlyTransactionImpl)tx).getStatus() != 6) {
            txImpl.markAsActive();
            this.txThreadMap.put(thread, txImpl);
        }
    }

    @Override
    public Transaction suspend() {
        ReadOnlyTransactionImpl tx = this.txThreadMap.remove(Thread.currentThread());
        if (tx != null) {
            tx.markAsSuspended();
        }
        return tx;
    }

    @Override
    public void setRollbackOnly() throws IllegalStateException {
        Thread thread = Thread.currentThread();
        ReadOnlyTransactionImpl tx = this.txThreadMap.get(thread);
        if (tx == null) {
            throw new IllegalStateException("Not in transaction");
        }
        tx.setRollbackOnly();
    }

    @Override
    public void setTransactionTimeout(int seconds) {
    }

    byte[] getBranchId(XAResource xaRes) {
        byte[] branchId;
        if (xaRes instanceof XaResource && (branchId = ((XaResource)xaRes).getBranchId()) != null) {
            return branchId;
        }
        return this.xaDsManager.getBranchId(xaRes);
    }

    String getTxStatusAsString(int status) {
        switch (status) {
            case 0: {
                return "STATUS_ACTIVE";
            }
            case 6: {
                return "STATUS_NO_TRANSACTION";
            }
            case 7: {
                return "STATUS_PREPARING";
            }
            case 2: {
                return "STATUS_PREPARED";
            }
            case 8: {
                return "STATUS_COMMITING";
            }
            case 3: {
                return "STATUS_COMMITED";
            }
            case 9: {
                return "STATUS_ROLLING_BACK";
            }
            case 4: {
                return "STATUS_ROLLEDBACK";
            }
            case 5: {
                return "STATUS_UNKNOWN";
            }
            case 1: {
                return "STATUS_MARKED_ROLLBACK";
            }
        }
        return "STATUS_UNKNOWN(" + status + ")";
    }

    public synchronized void dumpTransactions() {
        Iterator<ReadOnlyTransactionImpl> itr = this.txThreadMap.values().iterator();
        if (!itr.hasNext()) {
            System.out.println("No uncompleted transactions");
            return;
        }
        System.out.println("Uncompleted transactions found: ");
        while (itr.hasNext()) {
            System.out.println(itr.next());
        }
    }

    public int getEventIdentifier() {
        TransactionImpl tx = (TransactionImpl)this.getTransaction();
        if (tx != null) {
            return tx.getEventIdentifier();
        }
        return -1;
    }
}

