/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.util.List;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Service;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptor;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;

public abstract class TransactionInterceptorProvider
extends Service {
    public TransactionInterceptorProvider(String name) {
        super(name, new String[0]);
    }

    public abstract String name();

    public abstract TransactionInterceptor create(XaDataSource var1, Object var2, DependencyResolver var3);

    public abstract TransactionInterceptor create(TransactionInterceptor var1, XaDataSource var2, Object var3, DependencyResolver var4);

    public static TransactionInterceptor resolveChain(List<Pair<TransactionInterceptorProvider, Object>> providers, XaDataSource ds, DependencyResolver dependencyResolver) {
        TransactionInterceptor first = null;
        for (Pair<TransactionInterceptorProvider, Object> providerAndConfig : providers) {
            TransactionInterceptorProvider provider = providerAndConfig.first();
            Object config = providerAndConfig.other();
            if (first == null) {
                first = provider.create(ds, config, dependencyResolver);
                continue;
            }
            TransactionInterceptor temp = provider.create(first, ds, config, dependencyResolver);
            if (temp == null) continue;
            first = temp;
        }
        return first;
    }
}

