/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.traversal.InitialStateFactory;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.graphdb.traversal.TraversalContext;
import org.neo4j.kernel.impl.traversal.TraversalBranchImpl;
import org.neo4j.kernel.impl.traversal.TraversalBranchWithState;

class StartNodeTraversalBranch
extends TraversalBranchWithState {
    private final InitialStateFactory initialState;

    StartNodeTraversalBranch(TraversalContext context, TraversalBranch parent, Node source, InitialStateFactory initialState) {
        super(context, parent, source);
        this.initialState = initialState;
        context.isUniqueFirst(this);
    }

    @Override
    public TraversalBranch next(PathExpander expander, TraversalContext metadata) {
        if (!this.hasExpandedRelationships()) {
            this.expandRelationships(expander);
            return this;
        }
        return super.next(expander, metadata);
    }

    @Override
    protected TraversalBranch newNextBranch(Node node, Relationship relationship) {
        return this.initialState != InitialStateFactory.NO_STATE ? new TraversalBranchWithState(this, 1, node, relationship) : new TraversalBranchImpl(this, 1, node, relationship);
    }

    @Override
    protected Object retrieveStateFromParent() {
        return this.initialState.initialState(this);
    }
}

