/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.lucene.ValueContext;
import org.neo4j.rest.graphdb.BatchTransaction;
import org.neo4j.rest.graphdb.ExecutingRestRequest;
import org.neo4j.rest.graphdb.RequestResult;
import org.neo4j.rest.graphdb.RestAPI;
import org.neo4j.rest.graphdb.RestRequest;
import org.neo4j.rest.graphdb.RestResultException;
import org.neo4j.rest.graphdb.batch.BatchCallback;
import org.neo4j.rest.graphdb.batch.BatchRestAPI;
import org.neo4j.rest.graphdb.converter.RelationshipIterableConverter;
import org.neo4j.rest.graphdb.converter.RestEntityExtractor;
import org.neo4j.rest.graphdb.converter.RestIndexHitsConverter;
import org.neo4j.rest.graphdb.entity.RestEntity;
import org.neo4j.rest.graphdb.entity.RestNode;
import org.neo4j.rest.graphdb.entity.RestRelationship;
import org.neo4j.rest.graphdb.index.IndexInfo;
import org.neo4j.rest.graphdb.index.RestIndex;
import org.neo4j.rest.graphdb.index.RestIndexManager;
import org.neo4j.rest.graphdb.index.RetrievedIndexInfo;
import org.neo4j.rest.graphdb.index.SimpleIndexHits;
import org.neo4j.rest.graphdb.query.RestGremlinQueryResult;
import org.neo4j.rest.graphdb.query.RestQueryResult;
import org.neo4j.rest.graphdb.services.PluginInvocation;
import org.neo4j.rest.graphdb.services.RequestType;
import org.neo4j.rest.graphdb.services.RestInvocationHandler;
import org.neo4j.rest.graphdb.services.ServiceInvocation;
import org.neo4j.rest.graphdb.traversal.RestTraversal;
import org.neo4j.rest.graphdb.traversal.RestTraverser;
import org.neo4j.rest.graphdb.util.JsonHelper;
import org.neo4j.rest.graphdb.util.QueryResult;
import org.neo4j.rest.graphdb.util.ResultConverter;

public class ExecutingRestAPI
implements RestAPI {
    protected RestRequest restRequest;
    private long propertyRefetchTimeInMillis = 1000L;
    protected final RestAPI facade;
    private static final String FULLPATH = "fullpath";

    protected ExecutingRestAPI(String uri, RestAPI facade) {
        this.facade = facade;
        this.restRequest = this.createRestRequest(uri, null, null);
    }

    protected ExecutingRestAPI(String uri, String user, String password, RestAPI facade) {
        this.facade = facade;
        this.restRequest = this.createRestRequest(uri, user, password);
    }

    protected RestRequest createRestRequest(String uri, String user, String password) {
        return new ExecutingRestRequest(uri, user, password);
    }

    @Override
    public RestIndexManager index() {
        return new RestIndexManager(this.facade);
    }

    @Override
    public RestNode getNodeById(long id) {
        RequestResult response = this.restRequest.get("node/" + id);
        if (response.statusIs(Response.Status.NOT_FOUND)) {
            throw new NotFoundException("" + id);
        }
        return new RestNode(response.toMap(), this.facade);
    }

    @Override
    public RestRelationship getRelationshipById(long id) {
        RequestResult requestResult = this.restRequest.get("relationship/" + id);
        if (requestResult.statusIs(Response.Status.NOT_FOUND)) {
            throw new NotFoundException("" + id);
        }
        return new RestRelationship(requestResult.toMap(), this.facade);
    }

    @Override
    public RestNode createNode(Map<String, Object> props) {
        RequestResult requestResult = this.restRequest.post("node", props);
        return this.createRestNode(requestResult);
    }

    @Override
    public RestNode createRestNode(RequestResult requestResult) {
        if (requestResult.statusOtherThan(Response.Status.CREATED)) {
            int status = requestResult.getStatus();
            throw new RuntimeException("" + status);
        }
        String location = requestResult.getLocation();
        return new RestNode(location, this.facade);
    }

    @Override
    public RestRelationship createRelationship(Node startNode, Node endNode, RelationshipType type, Map<String, Object> props) {
        RestNode end = (RestNode)endNode;
        Map<String, Object> data = MapUtil.map("to", end.getUri(), "type", type.name());
        if (props != null && props.size() > 0) {
            data.put("data", props);
        }
        RestNode start = (RestNode)startNode;
        RequestResult requestResult = this.getRestRequest().with(start.getUri()).post("relationships", data);
        return this.createRestRelationship(requestResult, startNode);
    }

    @Override
    public RestRelationship createRestRelationship(RequestResult requestResult, PropertyContainer element) {
        if (requestResult.statusOtherThan(Response.Status.CREATED)) {
            int status = requestResult.getStatus();
            throw new RuntimeException("Error creating relationship " + status + " " + requestResult.getText());
        }
        String location = requestResult.getLocation();
        return new RestRelationship(location, this.facade);
    }

    @Override
    public <T extends PropertyContainer> RestIndex<T> getIndex(String indexName) {
        RestIndexManager index = this.index();
        if (index.existsForNodes(indexName)) {
            return index.forNodes(indexName);
        }
        if (index.existsForRelationships(indexName)) {
            return (RestIndex)((Object)index.forRelationships(indexName));
        }
        throw new IllegalArgumentException("Index " + indexName + " does not yet exist");
    }

    @Override
    public void createIndex(String type, String indexName, Map<String, String> config) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("name", indexName);
        data.put("config", config);
        this.restRequest.post("index/" + type, data);
    }

    @Override
    public <T extends PropertyContainer> RestIndex<T> createIndex(Class<T> type, String indexName, Map<String, String> config) {
        if (Node.class.isAssignableFrom(type)) {
            return this.index().forNodes(indexName, (Map)config);
        }
        if (Relationship.class.isAssignableFrom(type)) {
            return (RestIndex)((Object)this.index().forRelationships(indexName, config));
        }
        throw new IllegalArgumentException("Required Node or Relationship types to create index, got " + type);
    }

    @Override
    public RequestResult execute(RequestType requestType, String uri, Object params) {
        return requestType.makeRequest(uri, params, this.getRestRequest());
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isAutoIndexingEnabled(Class<? extends PropertyContainer> clazz) {
        RequestResult response = this.getRestRequest().get(this.buildPathAutoIndexerStatus(clazz));
        if (response.statusIs(Response.Status.OK)) {
            return Boolean.parseBoolean(response.getText());
        }
        throw new IllegalStateException("received " + response);
    }

    @Override
    public void setAutoIndexingEnabled(Class<? extends PropertyContainer> clazz, boolean enabled) {
        RequestResult response = this.getRestRequest().put(this.buildPathAutoIndexerStatus(clazz), enabled);
        if (response.statusOtherThan(Response.Status.NO_CONTENT)) {
            throw new IllegalStateException("received " + response);
        }
    }

    @Override
    public Set<String> getAutoIndexedProperties(Class forClass) {
        RequestResult response = this.getRestRequest().get(this.buildPathAutoIndexerProperties(forClass).toString());
        Collection autoIndexedProperties = (Collection)JsonHelper.readJson(response.getText());
        return new HashSet<String>(autoIndexedProperties);
    }

    @Override
    public void startAutoIndexingProperty(Class forClass, String s) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(s.getBytes("UTF-8"));
            RequestResult response = this.getRestRequest().post(this.buildPathAutoIndexerProperties(forClass).toString(), stream);
            if (response.statusOtherThan(Response.Status.NO_CONTENT)) {
                throw new IllegalStateException("received " + response);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void stopAutoIndexingProperty(Class forClass, String s) {
        RequestResult response = this.getRestRequest().delete(this.buildPathAutoIndexerProperties(forClass).append("/").append(s).toString());
        if (response.statusOtherThan(Response.Status.NO_CONTENT)) {
            throw new IllegalStateException("received " + response);
        }
    }

    private String buildPathAutoIndexerStatus(Class<? extends PropertyContainer> clazz) {
        return this.buildPathAutoIndexerBase(clazz).append("/status").toString();
    }

    private StringBuilder buildPathAutoIndexerProperties(Class<? extends PropertyContainer> clazz) {
        return this.buildPathAutoIndexerBase(clazz).append("/properties");
    }

    private StringBuilder buildPathAutoIndexerBase(Class<? extends PropertyContainer> clazz) {
        return new StringBuilder().append("index/auto/").append(clazz.getSimpleName().toLowerCase());
    }

    public RestRequest getRestRequest() {
        BatchRestAPI restAPI = this.current();
        return restAPI == null ? this.restRequest : restAPI.getRestRequest();
    }

    private BatchRestAPI current() {
        return BatchTransaction.getRestApi();
    }

    @Override
    public TraversalDescription createTraversalDescription() {
        return new RestTraversal();
    }

    @Override
    public Node getReferenceNode() {
        Map<?, ?> map = this.restRequest.get("").toMap();
        String referenceNodeUri = (String)map.get("reference_node");
        if (referenceNodeUri == null) {
            throw new NotFoundException("Reference node not available");
        }
        RequestResult response = this.restRequest.get(referenceNodeUri);
        if (response.statusIs(Response.Status.NOT_FOUND)) {
            throw new NotFoundException("Reference node not available");
        }
        return new RestNode(response.toMap(), this.facade);
    }

    public long getPropertyRefetchTimeInMillis() {
        return this.propertyRefetchTimeInMillis;
    }

    @Override
    public String getBaseUri() {
        return this.restRequest.getUri();
    }

    public void setPropertyRefetchTimeInMillis(long propertyRefetchTimeInMillis) {
        this.propertyRefetchTimeInMillis = propertyRefetchTimeInMillis;
    }

    @Override
    public <T> T executeBatch(BatchCallback<T> batchCallback) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BatchTransaction beginTx() {
        throw new UnsupportedOperationException();
    }

    public Iterable<Relationship> wrapRelationships(RequestResult requestResult) {
        return (Iterable)new RelationshipIterableConverter(this.facade).convertFromRepresentation(requestResult);
    }

    @Override
    public RestEntityExtractor createExtractor() {
        return new RestEntityExtractor(this.facade);
    }

    @Override
    public <S extends PropertyContainer> IndexHits<S> queryIndex(String indexPath, Class<S> entityType) {
        RequestResult response = this.restRequest.get(indexPath);
        if (response.statusIs(Response.Status.OK)) {
            return new RestIndexHitsConverter<S>(this.facade, entityType).convertFromRepresentation(response);
        }
        return new SimpleIndexHits<S>(Collections.<Object>emptyList(), 0, entityType, this.facade);
    }

    @Override
    public void deleteEntity(RestEntity entity) {
        this.getRestRequest().with(entity.getUri()).delete("");
    }

    @Override
    public IndexInfo indexInfo(String indexType) {
        RequestResult response = this.restRequest.get("index/" + indexType);
        return new RetrievedIndexInfo(response);
    }

    @Override
    public void setPropertyOnEntity(RestEntity entity, String key, Object value) {
        this.getRestRequest().with(entity.getUri()).put("properties/" + key, value);
        entity.invalidatePropertyData();
    }

    @Override
    public Map<String, Object> getPropertiesFromEntity(RestEntity entity) {
        RequestResult response = this.getRestRequest().with(entity.getUri()).get("properties");
        boolean ok = response.statusIs(Response.Status.OK);
        Map<Object, Object> properties = ok ? response.toMap() : Collections.emptyMap();
        return properties;
    }

    private void deleteIndex(String indexPath) {
        this.getRestRequest().delete(indexPath);
    }

    @Override
    public void delete(RestIndex index) {
        this.deleteIndex(index.indexPath(null, null));
    }

    @Override
    public <T extends PropertyContainer> void removeFromIndex(RestIndex index, T entity, String key, Object value) {
        this.deleteIndex(this.indexPath(index.indexPath(key, value), entity));
    }

    protected <T extends PropertyContainer> String indexPath(String indexPath, T restEntity) {
        return indexPath + "/" + ((RestEntity)restEntity).getId();
    }

    @Override
    public <T extends PropertyContainer> void removeFromIndex(RestIndex index, T entity, String key) {
        this.deleteIndex(this.indexPath(index.indexPath(key, null), entity));
    }

    @Override
    public <T extends PropertyContainer> void removeFromIndex(RestIndex index, T entity) {
        this.deleteIndex(this.indexPath(index.indexPath(null, null), entity));
    }

    @Override
    public <T extends PropertyContainer> void addToIndex(T entity, RestIndex index, String key, Object value) {
        RestEntity restEntity = (RestEntity)entity;
        String uri = restEntity.getUri();
        if (value instanceof ValueContext) {
            value = ((ValueContext)value).getCorrectValue();
        }
        Map<String, Object> data = MapUtil.map("key", key, "value", value, "uri", uri);
        RequestResult result = this.getRestRequest().post(index.indexPath(), data);
        if (result.statusOtherThan(Response.Status.CREATED)) {
            throw new RuntimeException(String.format("Error adding element %d %s %s to index %s", restEntity.getId(), key, value, index.getIndexName()));
        }
    }

    @Override
    public <T extends PropertyContainer> T putIfAbsent(T entity, RestIndex index, String key, Object value) {
        RestEntity restEntity = (RestEntity)entity;
        String uri = restEntity.getUri();
        if (value instanceof ValueContext) {
            value = ((ValueContext)value).getCorrectValue();
        }
        Map<String, Object> data = MapUtil.map("key", key, "value", value, "uri", uri);
        RequestResult result = this.getRestRequest().post(index.uniqueIndexPath(), data);
        if (result.statusIs(Response.Status.CREATED)) {
            if (index.getEntityType().equals(Node.class)) {
                return (T)this.createRestNode(result);
            }
            if (index.getEntityType().equals(Relationship.class)) {
                return (T)this.createRestRelationship(result, restEntity);
            }
        }
        if (result.statusIs(Response.Status.OK)) {
            return (T)((PropertyContainer)this.createExtractor().convertFromRepresentation(result));
        }
        throw new RuntimeException(String.format("Error adding element %d %s %s to index %s", restEntity.getId(), key, value, index.getIndexName()));
    }

    @Override
    public Map<?, ?> getData(RestEntity entity) {
        return this.getRestRequest().get(entity.getUri()).toMap();
    }

    @Override
    public boolean hasToUpdate(long lastUpdate) {
        return this.timeElapsed(lastUpdate, this.getPropertyRefetchTimeInMillis());
    }

    @Override
    public void removeProperty(RestEntity entity, String key) {
        this.restRequest.with(entity.getUri()).delete("properties/" + key);
        entity.invalidatePropertyData();
    }

    private boolean timeElapsed(long since, long isItGreaterThanThis) {
        return System.currentTimeMillis() - since > isItGreaterThanThis;
    }

    @Override
    public RestNode getOrCreateNode(RestIndex<Node> index, String key, Object value, Map<String, Object> properties) {
        if (index == null || key == null || value == null) {
            throw new IllegalArgumentException("Unique index " + index + " key " + key + " value must not be null");
        }
        Map<String, Object> data = MapUtil.map("key", key, "value", value, "properties", properties);
        RequestResult result = this.getRestRequest().post(index.uniqueIndexPath(), data);
        if (result.statusIs(Response.Status.CREATED) || result.statusIs(Response.Status.OK)) {
            return (RestNode)this.createExtractor().convertFromRepresentation(result);
        }
        throw new RuntimeException(String.format("Error retrieving or creating node for key %s and value %s with index %s", key, value, index.getIndexName()));
    }

    @Override
    public RestRelationship getOrCreateRelationship(RestIndex<Relationship> index, String key, Object value, RestNode start, RestNode end, String type, Map<String, Object> properties) {
        if (index == null || key == null || value == null) {
            throw new IllegalArgumentException("Unique index " + index + " key " + key + " value must not be null");
        }
        if (start == null || end == null || type == null) {
            throw new IllegalArgumentException("Neither start, end nore type must be null");
        }
        Map<String, Object> data = MapUtil.map("key", key, "value", value, "properties", properties, "start", start.getUri(), "end", end.getUri(), "type", type);
        RequestResult result = this.getRestRequest().post(index.uniqueIndexPath(), data);
        if (result.statusIs(Response.Status.CREATED) || result.statusIs(Response.Status.OK)) {
            return (RestRelationship)this.createExtractor().convertFromRepresentation(result);
        }
        throw new RuntimeException(String.format("Error retrieving or creating relationship for key %s and value %s with index %s", key, value, index.getIndexName()));
    }

    @Override
    public <T> T getPlugin(Class<T> type) {
        return RestInvocationHandler.getInvocationProxy(type, this.facade, new PluginInvocation(this.facade, type));
    }

    @Override
    public <T> T getService(Class<T> type, String baseUri) {
        return RestInvocationHandler.getInvocationProxy(type, this.facade, new ServiceInvocation(this.facade, type, baseUri));
    }

    @Override
    public Map<?, ?> query(String statement, Map<String, Object> params) {
        params = params == null ? Collections.emptyMap() : params;
        RequestResult requestResult = this.getRestRequest().post("cypher", MapUtil.map("query", statement, "params", params));
        return this.getRestRequest().toMap(requestResult);
    }

    @Override
    public Iterable<Relationship> getRelationships(RestNode restNode, String path) {
        return this.wrapRelationships(this.getRestRequest().with(restNode.getUri()).get(path));
    }

    @Override
    public RestTraverser traverse(RestNode restNode, Map<String, Object> description) {
        RequestResult result = this.getRestRequest().with(restNode.getUri()).post("traverse/fullpath", description);
        if (result.statusOtherThan(Response.Status.OK)) {
            throw new RuntimeException(String.format("Error executing traversal: %d %s", result.getStatus(), description));
        }
        Object col = result.toEntity();
        if (!(col instanceof Collection)) {
            throw new RuntimeException(String.format("Unexpected traversal result, %s instead of collection", col != null ? col.getClass() : null));
        }
        return new RestTraverser((Collection)col, restNode.getRestApi());
    }

    @Override
    public QueryResult<Map<String, Object>> query(String statement, Map<String, Object> params, ResultConverter resultConverter) {
        Map<?, ?> resultMap = this.query(statement, params);
        if (RestResultException.isExceptionResult(resultMap)) {
            throw new RestResultException(resultMap);
        }
        return new RestQueryResult(resultMap, this.facade, resultConverter);
    }

    @Override
    public QueryResult<Object> run(String statement, Map<String, Object> params, ResultConverter resultConverter) {
        Map<String, Object> data = MapUtil.map("script", statement, "params", params);
        RequestResult requestResult = this.getRestRequest().get("ext/GremlinPlugin/graphdb/execute_script", data);
        Object result = requestResult.toEntity();
        if (requestResult.getStatus() == 500) {
            return this.handleError(result);
        }
        return new RestGremlinQueryResult<Object>(result, this.facade, resultConverter);
    }

    private QueryResult<Object> handleError(Object result) {
        Map mapResult;
        if (result instanceof Map && RestResultException.isExceptionResult(mapResult = (Map)result)) {
            throw new RestResultException(mapResult);
        }
        throw new RestResultException(Collections.singletonMap("exception", result.toString()));
    }

    public RequestResult batch(Collection<Map<String, Object>> batchRequestData) {
        return this.restRequest.post("batch", batchRequestData);
    }
}

