/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.rest.graphdb.RestGraphDatabase;

public class GraphDatabaseFactory {
    public static GraphDatabaseService databaseFor(String url) {
        return GraphDatabaseFactory.databaseFor(url, null, null);
    }

    public static GraphDatabaseService databaseFor(String url, String username, String password) {
        File file;
        if (url.startsWith("http://") || url.startsWith("https://")) {
            return new RestGraphDatabase(url, username, password);
        }
        String path = url;
        if (url.startsWith("file:")) {
            path = GraphDatabaseFactory.toURI(url).getPath();
        }
        if (!(file = new File(path)).isDirectory()) {
            file = file.getParentFile();
        }
        return new EmbeddedGraphDatabase(file.getAbsolutePath());
    }

    private static URI toURI(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Error using URI " + uri, e);
        }
    }
}

