/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb;

import com.sun.jersey.api.client.ClientResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.neo4j.rest.graphdb.batch.RestOperations;
import org.neo4j.rest.graphdb.util.JsonHelper;
import org.neo4j.rest.graphdb.util.StreamJsonHelper;

public class RequestResult {
    private final int status;
    private final String location;
    private ClientResponse response;
    private String string;
    private Object entity;
    private InputStream stream;
    private long batchId;
    private boolean batchResult = false;

    RequestResult(int status, String location, String string) {
        this.status = status;
        this.location = location;
        this.string = string;
        this.stream = null;
    }

    RequestResult(int status, String location, InputStream stream, ClientResponse response) {
        this.status = status;
        this.location = location;
        this.response = response;
        this.entity = null;
        this.stream = stream;
    }

    RequestResult(long batchId) {
        this(0, null, "");
        this.batchResult = true;
        this.batchId = batchId;
    }

    public static RequestResult batchResult(RestOperations.RestOperation restOperation) {
        return new RequestResult(restOperation.getBatchId());
    }

    public static RequestResult extractFrom(ClientResponse clientResponse) {
        int status = clientResponse.getStatus();
        URI location = clientResponse.getLocation();
        if (status == Response.Status.NO_CONTENT.getStatusCode()) {
            clientResponse.close();
            return new RequestResult(status, RequestResult.uriString(location), null, clientResponse);
        }
        RequestResult result = new RequestResult(status, RequestResult.uriString(location), clientResponse.getEntity(String.class));
        clientResponse.close();
        return result;
    }

    private static String uriString(URI location) {
        return location == null ? null : location.toString();
    }

    public int getStatus() {
        return this.status;
    }

    public String getLocation() {
        return this.location;
    }

    public Object toEntity() {
        if (this.entity != null) {
            return this.entity;
        }
        if (this.stream != null) {
            this.entity = StreamJsonHelper.jsonToSingleValue(this.stream);
            this.closeStream();
        } else {
            this.entity = JsonHelper.jsonToSingleValue(this.string);
        }
        return this.entity;
    }

    public Map<?, ?> toMap() {
        return (Map)this.toEntity();
    }

    public boolean statusIs(Response.StatusType status) {
        return this.getStatus() == status.getStatusCode();
    }

    public boolean statusOtherThan(Response.StatusType status) {
        return !this.statusIs(status);
    }

    public long getBatchId() {
        return this.batchId;
    }

    public boolean isBatchResult() {
        return this.batchResult;
    }

    public static RequestResult extractFrom(Map<String, Object> batchResult) {
        return new RequestResult(200, (String)batchResult.get("location"), JsonHelper.createJsonFrom(batchResult.get("body")));
    }

    public String getText() {
        if (this.string == null && this.stream != null) {
            this.string = JsonHelper.readString(this.stream);
            this.closeStream();
        }
        return this.string;
    }

    private void closeStream() {
        if (this.stream != null) {
            this.readFully(this.stream);
        }
        this.stream = null;
        if (this.response != null) {
            this.response.close();
            this.response = null;
        }
    }

    private void readFully(InputStream stream) {
        try {
            while (stream.read() != -1) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

