/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb;

import java.util.Map;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.rest.graphdb.AbstractRemoteDatabase;
import org.neo4j.rest.graphdb.BatchTransactionManager;
import org.neo4j.rest.graphdb.RestAPI;
import org.neo4j.rest.graphdb.RestAPIFacade;
import org.neo4j.rest.graphdb.index.RestIndexManager;
import org.neo4j.rest.graphdb.query.RestCypherQueryEngine;
import org.neo4j.rest.graphdb.util.ResultConverter;

public class RestGraphDatabase
extends AbstractRemoteDatabase {
    private RestAPI restAPI;
    private final RestCypherQueryEngine cypherQueryEngine;

    public RestGraphDatabase(RestAPI api) {
        this.restAPI = api;
        this.cypherQueryEngine = new RestCypherQueryEngine(this.restAPI);
    }

    public RestGraphDatabase(String uri) {
        this(new RestAPIFacade(uri));
    }

    public RestGraphDatabase(String uri, String user, String password) {
        this(new RestAPIFacade(uri, user, password));
    }

    public RestAPI getRestAPI() {
        return this.restAPI;
    }

    @Override
    public RestIndexManager index() {
        return this.restAPI.index();
    }

    @Override
    public Node createNode() {
        return this.restAPI.createNode(null);
    }

    @Override
    public Node getNodeById(long id) {
        return this.restAPI.getNodeById(id);
    }

    @Override
    public Node getReferenceNode() {
        return this.restAPI.getReferenceNode();
    }

    @Override
    public Iterable<Node> getAllNodes() {
        return this.cypherQueryEngine.query("start n=node(*) return n", null).to(Node.class);
    }

    @Override
    public Iterable<RelationshipType> getRelationshipTypes() {
        return this.cypherQueryEngine.query("start n=node(*) match n-[r]->() return distinct type(r) as rel_type", null).to(RelationshipType.class, new ResultConverter<Map<String, Object>, RelationshipType>(){

            @Override
            public RelationshipType convert(Map<String, Object> row, Class<RelationshipType> type) {
                return DynamicRelationshipType.withName((String)row.get("rel_type"));
            }
        });
    }

    @Override
    public Relationship getRelationshipById(long id) {
        return this.restAPI.getRelationshipById(id);
    }

    @Override
    public String getStoreDir() {
        return this.restAPI.getBaseUri();
    }

    @Override
    public TransactionManager getTxManager() {
        return new BatchTransactionManager(this.restAPI);
    }

    @Override
    public Transaction beginTx() {
        return this.restAPI.beginTx();
    }

    @Override
    public void shutdown() {
        this.restAPI.close();
    }
}

