/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.batch;

import java.util.Iterator;
import org.neo4j.rest.graphdb.RequestResult;
import org.neo4j.rest.graphdb.RestAPI;
import org.neo4j.rest.graphdb.UpdatableRestResult;

public class BatchIterable<T>
implements Iterable<T>,
UpdatableRestResult<Iterable<T>> {
    private final long batchId;
    private Iterable<T> data;

    public BatchIterable(RequestResult requestResult) {
        this.batchId = requestResult.getBatchId();
    }

    @Override
    public void updateFrom(Iterable<T> newValue, RestAPI restApi) {
        this.data = newValue;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.data == null) {
            throw new IllegalStateException("Rest Batch Request has not been executed, results only available after successful execution.");
        }
        return this.data.iterator();
    }
}

