/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.batch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.lucene.ValueContext;
import org.neo4j.rest.graphdb.ExecutingRestAPI;
import org.neo4j.rest.graphdb.ExecutingRestRequest;
import org.neo4j.rest.graphdb.RequestResult;
import org.neo4j.rest.graphdb.RestAPIFacade;
import org.neo4j.rest.graphdb.RestRequest;
import org.neo4j.rest.graphdb.RestResultException;
import org.neo4j.rest.graphdb.batch.BatchIterable;
import org.neo4j.rest.graphdb.batch.RecordingRestRequest;
import org.neo4j.rest.graphdb.batch.RestOperations;
import org.neo4j.rest.graphdb.converter.RelationshipIterableConverter;
import org.neo4j.rest.graphdb.converter.RestEntityExtractor;
import org.neo4j.rest.graphdb.converter.RestEntityPropertyRefresher;
import org.neo4j.rest.graphdb.converter.RestIndexHitsConverter;
import org.neo4j.rest.graphdb.entity.RestEntity;
import org.neo4j.rest.graphdb.entity.RestNode;
import org.neo4j.rest.graphdb.entity.RestRelationship;
import org.neo4j.rest.graphdb.index.IndexInfo;
import org.neo4j.rest.graphdb.index.RestIndex;
import org.neo4j.rest.graphdb.index.SimpleIndexHits;

public class BatchRestAPI
extends ExecutingRestAPI {
    private final ExecutingRestAPI executingRestApi;

    public BatchRestAPI(String baseUri, RestAPIFacade facade) {
        super(baseUri, facade);
        this.executingRestApi = facade.getDirect();
        this.restRequest = new RecordingRestRequest(new RestOperations(), baseUri);
    }

    @Override
    public RestRequest getRestRequest() {
        return this.restRequest;
    }

    @Override
    protected RestRequest createRestRequest(String uri, String user, String password) {
        ExecutingRestRequest executingRestRequest = new ExecutingRestRequest(uri, user, password);
        return new RecordingRestRequest(new RestOperations(), executingRestRequest.getUri());
    }

    @Override
    public RestNode createRestNode(RequestResult requestResult) {
        long batchId = requestResult.getBatchId();
        RestNode node = new RestNode("{" + batchId + "}", this.facade);
        this.getRecordingRequest().getOperations().addToRestOperation(batchId, node, new RestEntityExtractor(this.facade));
        return node;
    }

    @Override
    public RestRelationship createRestRelationship(RequestResult requestResult, PropertyContainer element) {
        long batchId = requestResult.getBatchId();
        RestRelationship relationship = new RestRelationship("{" + batchId + "}", this.facade);
        this.getRecordingRequest().getOperations().addToRestOperation(batchId, relationship, new RestEntityExtractor(this.facade));
        return relationship;
    }

    private RecordingRestRequest getRecordingRequest() {
        return (RecordingRestRequest)this.restRequest;
    }

    public RestOperations getRecordedOperations() {
        return this.getRecordingRequest().getOperations();
    }

    public void stop() {
        this.getRecordingRequest().stop();
    }

    @Override
    public Iterable<Relationship> wrapRelationships(RequestResult requestResult) {
        long batchId = requestResult.getBatchId();
        BatchIterable<Relationship> result = new BatchIterable<Relationship>(requestResult);
        this.getRecordingRequest().getOperations().addToRestOperation(batchId, result, new RelationshipIterableConverter(this.facade));
        return result;
    }

    @Override
    public <S extends PropertyContainer> IndexHits<S> queryIndex(String indexPath, Class<S> entityType) {
        RequestResult response = this.restRequest.get(indexPath);
        long batchId = response.getBatchId();
        SimpleIndexHits<S> result = new SimpleIndexHits<S>(batchId, entityType, this.facade);
        this.getRecordingRequest().getOperations().addToRestOperation(batchId, result, new RestIndexHitsConverter<S>(this.facade, entityType));
        return result;
    }

    @Override
    public void setPropertyOnEntity(RestEntity entity, String key, Object value) {
        RequestResult response = this.getRestRequest().with(entity.getUri()).put("properties/" + key, value);
        long batchId = response.getBatchId();
        this.getRecordingRequest().getOperations().addToRestOperation(batchId, entity, new RestEntityPropertyRefresher(entity));
    }

    @Override
    public <T extends PropertyContainer> void addToIndex(T entity, RestIndex index, String key, Object value) {
        RestEntity restEntity = (RestEntity)entity;
        String uri = restEntity.getUri();
        if (value instanceof ValueContext) {
            value = ((ValueContext)value).getCorrectValue();
        }
        Map<String, Object> data = MapUtil.map("key", key, "value", value, "uri", uri);
        this.restRequest.post(index.indexPath(), data);
    }

    public void executeBatchRequest() {
        this.stop();
        RestOperations operations = this.getRecordedOperations();
        RequestResult response = this.executingRestApi.batch(this.createBatchRequestData(operations));
        Map<Long, Object> mappedObjects = this.convertRequestResultToEntities(operations, response);
        this.updateRestOperations(operations, mappedObjects);
    }

    protected void updateRestOperations(RestOperations operations, Map<Long, Object> mappedObjects) {
        for (RestOperations.RestOperation operation : operations.getRecordedRequests().values()) {
            operation.updateEntity(mappedObjects.get(operation.getBatchId()), this.executingRestApi);
        }
    }

    @Override
    protected <T extends PropertyContainer> String indexPath(String indexPath, T entity) {
        RestEntity restEntity = (RestEntity)entity;
        if (this.isNewEntity(restEntity)) {
            throw new UnsupportedOperationException("Cannot delete newly created entities from index " + entity);
        }
        return super.indexPath(indexPath, restEntity);
    }

    private boolean isNewEntity(RestEntity restEntity) {
        return restEntity.getUri().startsWith("{");
    }

    protected Map<Long, Object> convertRequestResultToEntities(RestOperations operations, RequestResult response) {
        Object result = response.toEntity();
        if (RestResultException.isExceptionResult(result)) {
            throw new RestResultException(result);
        }
        Collection responseCollection = (Collection)result;
        HashMap<Long, Object> mappedObjects = new HashMap<Long, Object>(responseCollection.size());
        for (Map entry : responseCollection) {
            if (RestResultException.isExceptionResult(entry)) {
                throw new RestResultException(entry);
            }
            Long batchId = this.getBatchId(entry);
            RequestResult subResult = RequestResult.extractFrom(entry);
            RestOperations.RestOperation restOperation = operations.getOperation(batchId);
            if (restOperation.getEntity() == null) continue;
            Object entity = restOperation.getResultConverter().convertFromRepresentation(subResult);
            mappedObjects.put(batchId, entity);
        }
        return mappedObjects;
    }

    private Long getBatchId(Map<String, Object> entry) {
        return ((Number)entry.get("id")).longValue();
    }

    protected Collection<Map<String, Object>> createBatchRequestData(RestOperations operations) {
        ArrayList<Map<String, Object>> batch = new ArrayList<Map<String, Object>>();
        String baseUri = this.executingRestApi.getBaseUri();
        for (RestOperations.RestOperation operation : operations.getRecordedRequests().values()) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("method", (Object)operation.getMethod());
            if (operation.isSameUri(baseUri)) {
                params.put("to", operation.getUri());
            } else {
                params.put("to", this.createOperationUri(operation));
            }
            if (operation.getData() != null) {
                params.put("body", operation.getData());
            }
            params.put("id", operation.getBatchId());
            batch.add(params);
        }
        return batch;
    }

    private String createOperationUri(RestOperations.RestOperation operation) {
        String uri = operation.getBaseUri();
        String suffix = operation.getUri();
        if (suffix.startsWith("/")) {
            return uri + suffix;
        }
        return uri + "/" + suffix;
    }

    private static class BatchIndexInfo
    implements IndexInfo {
        private BatchIndexInfo() {
        }

        @Override
        public boolean checkConfig(String indexName, Map<String, String> config) {
            return true;
        }

        @Override
        public String[] indexNames() {
            return new String[0];
        }

        @Override
        public boolean exists(String indexName) {
            return true;
        }

        @Override
        public Map<String, String> getConfig(String name) {
            return null;
        }
    }
}

