/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.batch;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.neo4j.rest.graphdb.RequestResult;
import org.neo4j.rest.graphdb.RestRequest;
import org.neo4j.rest.graphdb.batch.RestOperations;

public class RecordingRestRequest
implements RestRequest {
    private final String baseUri;
    private MediaType contentType;
    private MediaType acceptHeader;
    private RestOperations operations;
    private boolean stop;

    public RestOperations getOperations() {
        return this.operations;
    }

    public RecordingRestRequest(String baseUri) {
        this(baseUri, MediaType.APPLICATION_JSON_TYPE, MediaType.APPLICATION_JSON_TYPE);
    }

    public RecordingRestRequest(RestOperations operations, String baseUri) {
        this(baseUri);
        this.operations = operations;
    }

    public RecordingRestRequest(String baseUri, MediaType contentType, MediaType acceptHeader) {
        this.baseUri = this.uriWithoutSlash(baseUri);
        this.contentType = contentType;
        this.acceptHeader = acceptHeader;
    }

    @Override
    public RequestResult get(String path, Object data) {
        return this.record(RestOperations.RestOperation.Methods.GET, path, data, this.getBaseUri());
    }

    @Override
    public RequestResult delete(String path) {
        return this.record(RestOperations.RestOperation.Methods.DELETE, path, null, this.getBaseUri());
    }

    @Override
    public RequestResult post(String path, Object data) {
        return this.record(RestOperations.RestOperation.Methods.POST, path, data, this.getBaseUri());
    }

    @Override
    public RequestResult put(String path, Object data) {
        return this.record(RestOperations.RestOperation.Methods.PUT, path, data, this.getBaseUri());
    }

    @Override
    public RestRequest with(String uri) {
        return new RecordingRestRequest(this.operations, uri);
    }

    @Override
    public String getUri() {
        return this.getBaseUri();
    }

    @Override
    public RequestResult get(String path) {
        return this.record(RestOperations.RestOperation.Methods.GET, path, null, this.getBaseUri());
    }

    public RequestResult record(RestOperations.RestOperation.Methods method, String path, Object data, String baseUri) {
        if (this.stop) {
            throw new IllegalStateException("BatchRequest already executed");
        }
        return this.operations.record(method, path, data, baseUri);
    }

    private String uriWithoutSlash(String uri) {
        String uriString = uri;
        return uriString.endsWith("/") ? uriString.substring(0, uriString.length() - 1) : uri;
    }

    public static String encode(Object value) {
        if (value == null) {
            return "";
        }
        try {
            return URLEncoder.encode(value.toString(), "utf-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<Long, RestOperations.RestOperation> getRecordedRequests() {
        return this.operations.getRecordedRequests();
    }

    public void stop() {
        this.stop = true;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    @Override
    public Map<?, ?> toMap(RequestResult requestResult) {
        return requestResult.toMap();
    }
}

