/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.converter;

import java.util.Map;
import org.neo4j.rest.graphdb.RequestResult;
import org.neo4j.rest.graphdb.RestAPI;
import org.neo4j.rest.graphdb.converter.RestResultConverter;
import org.neo4j.rest.graphdb.entity.RestEntity;
import org.neo4j.rest.graphdb.entity.RestNode;
import org.neo4j.rest.graphdb.entity.RestRelationship;

public class RestEntityExtractor
implements RestResultConverter {
    private final RestAPI restApi;

    public RestEntityExtractor(RestAPI restApi) {
        this.restApi = restApi;
    }

    @Override
    public Object convertFromRepresentation(RequestResult requestResult) {
        return this.convertFromRepresentation(requestResult.toMap());
    }

    public Object convertFromRepresentation(Object value) {
        RestEntity restEntity;
        if (value instanceof Map && (restEntity = this.createRestEntity((Map)value)) != null) {
            return restEntity;
        }
        return value;
    }

    RestEntity createRestEntity(Map data) {
        String uri = (String)data.get("self");
        if (uri == null || uri.isEmpty()) {
            return null;
        }
        if (uri.contains("/node/")) {
            return new RestNode(data, this.restApi);
        }
        if (uri.contains("/relationship/")) {
            return new RestRelationship(data, this.restApi);
        }
        return null;
    }

    public boolean canHandle(Object value) {
        String uri;
        return value instanceof Map && (uri = (String)((Map)value).get("self")) != null && (uri.contains("/node/") || uri.contains("/relationship/"));
    }
}

