/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.entity;

import java.net.URI;
import java.util.Collection;
import java.util.Map;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.rest.graphdb.PropertiesMap;
import org.neo4j.rest.graphdb.RestAPI;
import org.neo4j.rest.graphdb.RestGraphDatabase;
import org.neo4j.rest.graphdb.UpdatableRestResult;
import org.neo4j.rest.graphdb.util.ArrayConverter;

public class RestEntity
implements PropertyContainer,
UpdatableRestResult<RestEntity> {
    private Map<?, ?> structuralData;
    private Map<String, Object> propertyData;
    private long lastTimeFetchedPropertyData;
    protected RestAPI restApi;
    private final ArrayConverter arrayConverter = new ArrayConverter();
    private String uri;

    public RestEntity(URI uri, RestAPI restApi) {
        this(uri.toString(), restApi);
    }

    public RestEntity(String uri, RestAPI restApi) {
        this.uri = uri;
        this.restApi = restApi;
    }

    public RestEntity(Map<?, ?> data, RestAPI restApi) {
        this.structuralData = data;
        this.restApi = restApi;
        this.propertyData = (Map)data.get("data");
        this.lastTimeFetchedPropertyData = System.currentTimeMillis();
        this.uri = (String)data.get("self");
    }

    public String getUri() {
        return this.uri;
    }

    @Override
    public void updateFrom(RestEntity updateEntity, RestAPI restApi) {
        if (this == updateEntity) {
            this.lastTimeFetchedPropertyData = 0L;
        }
        this.uri = updateEntity.getUri();
        this.structuralData = updateEntity.getStructuralData();
        this.propertyData = updateEntity.getPropertyData();
        this.lastTimeFetchedPropertyData = System.currentTimeMillis();
    }

    Map<?, ?> getStructuralData() {
        if (this.structuralData == null) {
            this.structuralData = this.restApi.getData(this);
        }
        return this.structuralData;
    }

    Map<String, Object> getPropertyData() {
        if (this.hasToUpdateProperties()) {
            this.propertyData = this.restApi.getPropertiesFromEntity(this);
            this.lastTimeFetchedPropertyData = System.currentTimeMillis();
        }
        return this.propertyData;
    }

    private boolean hasToUpdateProperties() {
        if (this.propertyData == null) {
            return true;
        }
        return this.restApi.hasToUpdate(this.lastTimeFetchedPropertyData);
    }

    @Override
    public Object getProperty(String key) {
        Object value = this.getPropertyValue(key);
        if (value == null) {
            throw new NotFoundException("'" + key + "' on " + this);
        }
        return value;
    }

    private Object getPropertyValue(String key) {
        Map<String, Object> properties = this.getPropertyData();
        Object value = properties.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            Collection col = (Collection)value;
            if (col.isEmpty()) {
                return new String[0];
            }
            Object result = this.arrayConverter.toArray(col);
            if (result == null) {
                throw new IllegalStateException("Could not determine type of property " + key);
            }
            properties.put(key, result);
            return result;
        }
        return PropertiesMap.assertSupportedPropertyValue(value);
    }

    @Override
    public Object getProperty(String key, Object defaultValue) {
        Object value = this.getPropertyValue(key);
        return value != null ? value : defaultValue;
    }

    @Override
    public Iterable<String> getPropertyKeys() {
        return new IterableWrapper(this.getPropertyData().keySet()){

            protected String underlyingObjectToObject(Object key) {
                return key.toString();
            }
        };
    }

    @Override
    public Iterable<Object> getPropertyValues() {
        return this.getPropertyData().values();
    }

    @Override
    public boolean hasProperty(String key) {
        return this.getPropertyData().containsKey(key);
    }

    @Override
    public Object removeProperty(String key) {
        Object value = this.getProperty(key, null);
        this.restApi.removeProperty(this, key);
        return value;
    }

    @Override
    public void setProperty(String key, Object value) {
        this.restApi.setPropertyOnEntity(this, key, value);
    }

    public void invalidatePropertyData() {
        this.propertyData = null;
    }

    static long getEntityId(String uri) {
        return Long.parseLong(uri.substring(uri.lastIndexOf(47) + 1));
    }

    public long getId() {
        return RestEntity.getEntityId(this.getUri());
    }

    public void delete() {
        this.restApi.deleteEntity(this);
    }

    public int hashCode() {
        return (int)this.getId();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return this.getClass().equals(o.getClass()) && this.getId() == ((RestEntity)o).getId();
    }

    @Override
    public RestGraphDatabase getGraphDatabase() {
        return new RestGraphDatabase(this.restApi);
    }

    public String toString() {
        return this.getUri();
    }

    public RestAPI getRestApi() {
        return this.restApi;
    }

    public void setLastTimeFetchedPropertyData(long lastTimeFetchedPropertyData) {
        this.lastTimeFetchedPropertyData = lastTimeFetchedPropertyData;
    }
}

