/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.entity;

import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Traverser;
import org.neo4j.helpers.collection.CombiningIterable;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.rest.graphdb.RestAPI;
import org.neo4j.rest.graphdb.entity.RestEntity;
import org.neo4j.rest.graphdb.traversal.RestDirection;

public class RestNode
extends RestEntity
implements Node {
    public RestNode(URI uri, RestAPI restApi) {
        super(uri, restApi);
    }

    public RestNode(String uri, RestAPI restApi) {
        super(uri, restApi);
    }

    public RestNode(Map<?, ?> data, RestAPI restApi) {
        super(data, restApi);
    }

    @Override
    public Relationship createRelationshipTo(Node toNode, RelationshipType type) {
        return this.restApi.createRelationship(this, toNode, type, null);
    }

    @Override
    public Iterable<Relationship> getRelationships() {
        return this.restApi.getRelationships(this, "relationships/all");
    }

    @Override
    public Iterable<Relationship> getRelationships(RelationshipType ... types) {
        String path = this.getStructuralData().get("all_relationships") + "/";
        int counter = 0;
        for (RelationshipType type : types) {
            if (counter++ > 0) {
                path = path + "&";
            }
            path = path + type.name();
        }
        return this.restApi.getRelationships(this, path);
    }

    @Override
    public Iterable<Relationship> getRelationships(Direction direction) {
        return this.restApi.getRelationships(this, "relationships/" + RestDirection.from((Direction)direction).shortName);
    }

    @Override
    public Iterable<Relationship> getRelationships(RelationshipType type, Direction direction) {
        String relationshipsKey = RestDirection.from((Direction)direction).longName + "_relationships";
        Object relationship = this.getStructuralData().get(relationshipsKey);
        return this.restApi.getRelationships(this, relationship + "/" + type.name());
    }

    @Override
    public Relationship getSingleRelationship(RelationshipType type, Direction direction) {
        return IteratorUtil.singleOrNull(this.getRelationships(type, direction));
    }

    @Override
    public boolean hasRelationship() {
        return this.getRelationships().iterator().hasNext();
    }

    @Override
    public boolean hasRelationship(RelationshipType ... types) {
        return this.getRelationships(types).iterator().hasNext();
    }

    @Override
    public boolean hasRelationship(Direction direction) {
        return this.getRelationships(direction).iterator().hasNext();
    }

    @Override
    public boolean hasRelationship(RelationshipType type, Direction direction) {
        return this.getRelationships(type, direction).iterator().hasNext();
    }

    @Override
    public Traverser traverse(Traverser.Order order, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, Object ... rels) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Traverser traverse(Traverser.Order order, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType type, Direction direction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Traverser traverse(Traverser.Order order, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType type, Direction direction, RelationshipType secondType, Direction secondDirection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<Relationship> getRelationships(final Direction direction, RelationshipType ... types) {
        return new CombiningIterable<Relationship>(new IterableWrapper<Iterable<Relationship>, RelationshipType>(Arrays.asList(types)){

            @Override
            protected Iterable<Relationship> underlyingObjectToObject(RelationshipType relationshipType) {
                return RestNode.this.getRelationships(relationshipType, direction);
            }
        });
    }

    @Override
    public boolean hasRelationship(Direction direction, RelationshipType ... types) {
        for (RelationshipType relationshipType : types) {
            if (!this.hasRelationship(relationshipType, direction)) continue;
            return true;
        }
        return false;
    }
}

