/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.entity;

import java.net.URI;
import java.util.Map;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.rest.graphdb.RestAPI;
import org.neo4j.rest.graphdb.entity.RestEntity;
import org.neo4j.rest.graphdb.entity.RestNode;

public class RestRelationship
extends RestEntity
implements Relationship {
    RestRelationship(URI uri, RestAPI restApi) {
        super(uri, restApi);
    }

    public RestRelationship(String uri, RestAPI restApi) {
        super(uri, restApi);
    }

    public RestRelationship(Map<?, ?> data, RestAPI restApi) {
        super(data, restApi);
    }

    @Override
    public Node getEndNode() {
        return this.node((String)this.getStructuralData().get("end"));
    }

    @Override
    public Node[] getNodes() {
        return new Node[]{this.node((String)this.getStructuralData().get("start")), this.node((String)this.getStructuralData().get("end"))};
    }

    @Override
    public Node getOtherNode(Node node) {
        long nodeId = node.getId();
        String startNodeUri = (String)this.getStructuralData().get("start");
        String endNodeUri = (String)this.getStructuralData().get("end");
        if (RestRelationship.getEntityId(startNodeUri) == nodeId) {
            return this.node(endNodeUri);
        }
        if (RestRelationship.getEntityId(endNodeUri) == nodeId) {
            return this.node(startNodeUri);
        }
        throw new NotFoundException(node + " isn't one of start/end for " + this);
    }

    private RestNode node(String uri) {
        return new RestNode(uri, this.getRestApi());
    }

    @Override
    public Node getStartNode() {
        return this.node((String)this.getStructuralData().get("start"));
    }

    @Override
    public RelationshipType getType() {
        return DynamicRelationshipType.withName((String)this.getStructuralData().get("type"));
    }

    @Override
    public boolean isType(RelationshipType type) {
        return type.name().equals(this.getStructuralData().get("type"));
    }

    public RestRelationship create(RestNode startNode, RestNode endNode, RelationshipType type, Map<String, Object> props) {
        return this.restApi.createRelationship(startNode, endNode, type, props);
    }
}

