/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.index;

import java.util.Set;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.index.AutoIndexer;
import org.neo4j.graphdb.index.ReadableIndex;
import org.neo4j.rest.graphdb.RestAPI;

public class RestAutoIndexer<T extends PropertyContainer>
implements AutoIndexer<T> {
    protected final RestAPI restApi;
    protected final Class forClass;
    protected final ReadableIndex<T> autoIndex;

    public RestAutoIndexer(RestAPI restApi, Class forClass, ReadableIndex<T> autoIndex) {
        this.restApi = restApi;
        this.forClass = forClass;
        this.autoIndex = autoIndex;
    }

    @Override
    public void setEnabled(boolean b) {
        this.restApi.setAutoIndexingEnabled(this.forClass, b);
    }

    @Override
    public boolean isEnabled() {
        return this.restApi.isAutoIndexingEnabled(this.forClass);
    }

    @Override
    public ReadableIndex<T> getAutoIndex() {
        return this.autoIndex;
    }

    @Override
    public void startAutoIndexingProperty(String s) {
        this.restApi.startAutoIndexingProperty(this.forClass, s);
    }

    @Override
    public void stopAutoIndexingProperty(String s) {
        this.restApi.stopAutoIndexingProperty(this.forClass, s);
    }

    @Override
    public Set<String> getAutoIndexedProperties() {
        return this.restApi.getAutoIndexedProperties(this.forClass);
    }
}

