/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.index;

import com.sun.jersey.api.client.ClientResponse;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.neo4j.rest.graphdb.RequestResult;
import org.neo4j.rest.graphdb.index.IndexInfo;

public class RetrievedIndexInfo
implements IndexInfo {
    private Map<String, ?> indexInfo;

    public RetrievedIndexInfo(RequestResult response) {
        this.indexInfo = response.statusIs(ClientResponse.Status.NO_CONTENT) ? Collections.emptyMap() : response.toMap();
    }

    @Override
    public boolean checkConfig(String indexName, Map<String, String> config) {
        Map existingConfig = (Map)this.indexInfo.get(indexName);
        if (config == null) {
            return existingConfig != null;
        }
        if (existingConfig == null) {
            return false;
        }
        if (existingConfig.entrySet().containsAll(config.entrySet())) {
            return true;
        }
        throw new IllegalArgumentException("Index with the same name but different config exists!");
    }

    @Override
    public String[] indexNames() {
        Set<String> keys = this.indexInfo.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    @Override
    public boolean exists(String indexName) {
        return this.indexInfo.containsKey(indexName);
    }

    @Override
    public Map<String, String> getConfig(String name) {
        return (Map)this.indexInfo.get(name);
    }
}

