/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.index;

import java.util.Collection;
import java.util.Iterator;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.rest.graphdb.RestAPI;
import org.neo4j.rest.graphdb.UpdatableRestResult;
import org.neo4j.rest.graphdb.converter.RestEntityExtractor;

public class SimpleIndexHits<T extends PropertyContainer>
implements IndexHits<T>,
UpdatableRestResult<SimpleIndexHits<T>> {
    private Collection<Object> hits;
    private Class<T> entityType;
    private int size;
    private Iterator<Object> iterator;
    private RestEntityExtractor entityExtractor;

    public SimpleIndexHits(long batchId, Class<T> entityType, RestAPI restApi) {
        this.entityType = entityType;
        this.entityExtractor = restApi.createExtractor();
    }

    public SimpleIndexHits(Collection<Object> hits, int size, Class<T> entityType, RestAPI restApi) {
        this.hits = hits;
        this.entityType = entityType;
        this.iterator = this.hits.iterator();
        this.size = size;
        this.entityExtractor = restApi.createExtractor();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void close() {
    }

    @Override
    public T getSingle() {
        Iterator<Object> it = this.hits.iterator();
        return it.hasNext() ? (T)this.transform(it.next()) : null;
    }

    @Override
    public float currentScore() {
        return 0.0f;
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        Object value = this.iterator.next();
        return this.transform(value);
    }

    private T transform(Object value) {
        return (T)((PropertyContainer)this.entityExtractor.convertFromRepresentation(value));
    }

    @Override
    public void remove() {
    }

    @Override
    public void updateFrom(SimpleIndexHits<T> newValue, RestAPI restApi) {
        this.hits = newValue.hits;
        this.iterator = this.hits.iterator();
        this.size = newValue.size;
        this.entityExtractor = restApi.createExtractor();
    }
}

