/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.services;

import java.lang.reflect.Method;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import org.neo4j.rest.graphdb.RequestResult;
import org.neo4j.rest.graphdb.RestRequest;

public enum RequestType {
    PUT{

        @Override
        public RequestResult makeRequest(String uri, Object requestParams, RestRequest restRequest) {
            return restRequest.put(uri, requestParams);
        }
    }
    ,
    POST{

        @Override
        public RequestResult makeRequest(String uri, Object requestParams, RestRequest restRequest) {
            return restRequest.post(uri, requestParams);
        }
    }
    ,
    GET{

        @Override
        public RequestResult makeRequest(String uri, Object requestParams, RestRequest restRequest) {
            return restRequest.get(uri);
        }
    }
    ,
    DELETE{

        @Override
        public RequestResult makeRequest(String uri, Object requestParams, RestRequest restRequest) {
            return restRequest.delete(uri);
        }
    };


    public static RequestType determineRequestType(Method method) {
        if (method.isAnnotationPresent(GET.class)) {
            return GET;
        }
        if (method.isAnnotationPresent(POST.class)) {
            return POST;
        }
        if (method.isAnnotationPresent(PUT.class)) {
            return PUT;
        }
        if (method.isAnnotationPresent(DELETE.class)) {
            return DELETE;
        }
        throw new IllegalArgumentException("missing Annotation for the request type, e.g. @GET");
    }

    public abstract RequestResult makeRequest(String var1, Object var2, RestRequest var3);
}

