/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.services;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.neo4j.rest.graphdb.RequestResult;
import org.neo4j.rest.graphdb.RestAPI;
import org.neo4j.rest.graphdb.converter.ResultTypeConverter;
import org.neo4j.rest.graphdb.converter.TypeInformation;
import org.neo4j.rest.graphdb.services.RemoteInvocationStrategy;

public class RestInvocationHandler
implements InvocationHandler {
    private final Class<?> type;
    private RestAPI restAPI;
    private RemoteInvocationStrategy invocationStrategy;
    private ResultTypeConverter resultTypeConverter;

    public RestInvocationHandler(Class<?> type, RestAPI restAPI, RemoteInvocationStrategy invocationStrategy) {
        this.type = type;
        this.restAPI = restAPI;
        this.resultTypeConverter = new ResultTypeConverter(this.restAPI);
        this.invocationStrategy = invocationStrategy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (!this.type.isAssignableFrom(method.getDeclaringClass())) {
            System.out.println("method = " + method);
            return method.invoke((Object)this, args);
        }
        RequestResult requestResult = this.invocationStrategy.invoke(method, args);
        int status = requestResult.getStatus();
        if (status != 200) {
            throw new RuntimeException(requestResult.getText());
        }
        Object obj = requestResult.toEntity();
        TypeInformation typeInfo = new TypeInformation(method.getGenericReturnType());
        return this.resultTypeConverter.convertToResultType(obj, typeInfo);
    }

    public static <T> T getInvocationProxy(Class<T> type, RestAPI restAPI, RemoteInvocationStrategy invocationStrategy) {
        return (T)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)new RestInvocationHandler(type, restAPI, invocationStrategy));
    }
}

