/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.services;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.neo4j.rest.graphdb.RequestResult;
import org.neo4j.rest.graphdb.RestAPI;
import org.neo4j.rest.graphdb.services.RemoteInvocationStrategy;
import org.neo4j.rest.graphdb.services.RequestType;

public class ServiceInvocation
implements RemoteInvocationStrategy {
    private RestAPI restAPI;
    private String baseUri;
    private Class<?> targetClass;

    public ServiceInvocation(RestAPI restAPI, Class<?> targetClass, String baseUri) {
        this.restAPI = restAPI;
        this.targetClass = targetClass;
        this.baseUri = baseUri;
    }

    @Override
    public RequestResult invoke(Method method, Object[] args) {
        RequestType requestType = RequestType.determineRequestType(method);
        String uri = this.createUri(method, args);
        Map<String, Object> params = this.getRequestParams(method, args);
        return this.restAPI.execute(requestType, uri, params);
    }

    private String getClassIdentifier() {
        String identifier = this.targetClass.isAnnotationPresent(Path.class) ? this.targetClass.getAnnotation(Path.class).value() : "/" + this.targetClass.getSimpleName();
        return identifier;
    }

    private String getMethodPathIdentifier(Method method) {
        if (method.isAnnotationPresent(Path.class)) {
            return method.getAnnotation(Path.class).value();
        }
        throw new IllegalArgumentException("missing @Path annotation on method " + method.getName());
    }

    private String createUri(Method method, Object[] args) {
        String uri = this.baseUri;
        uri = uri + this.getClassIdentifier();
        uri = uri + this.getMethodPathIdentifier(method);
        uri = this.replaceMethodPathWithActualValue(method, uri, args);
        return uri;
    }

    private String replaceMethodPathWithActualValue(Method method, String uri, Object[] args) {
        String newUri = uri;
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            for (Annotation annotation : parameterAnnotations[i]) {
                if (!(annotation instanceof PathParam)) continue;
                PathParam pathParam = (PathParam)annotation;
                newUri = uri.replace("{" + pathParam.value() + "}", args[i].toString());
            }
        }
        return newUri;
    }

    private Map<String, Object> getRequestParams(Method method, Object[] args) {
        HashMap<String, Object> requestParams = new HashMap<String, Object>(args.length);
        Class<?>[] paramTypes = method.getParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < paramTypes.length; ++i) {
            for (Annotation annotation : parameterAnnotations[i]) {
                if (!(annotation instanceof PathParam)) continue;
                PathParam pathParam = (PathParam)annotation;
                requestParams.put(pathParam.value(), args[i]);
            }
        }
        return requestParams;
    }
}

