/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.traversal;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.RelationshipExpander;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.traversal.BranchOrderingPolicy;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.InitialStateFactory;
import org.neo4j.graphdb.traversal.PruneEvaluator;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.helpers.Predicate;
import org.neo4j.kernel.Uniqueness;
import org.neo4j.rest.graphdb.entity.RestNode;
import org.neo4j.rest.graphdb.traversal.RestDirection;
import org.neo4j.rest.graphdb.traversal.RestTraversalDescription;

public class RestTraversal
implements RestTraversalDescription {
    private final Map<String, Object> description = new HashMap<String, Object>();

    public String toString() {
        return this.description.toString();
    }

    @Override
    public RestTraversalDescription uniqueness(UniquenessFactory uniquenessFactory) {
        return this.uniqueness(uniquenessFactory, null);
    }

    @Override
    public RestTraversalDescription uniqueness(UniquenessFactory uniquenessFactory, Object value) {
        String uniqueness = this.restify(uniquenessFactory);
        this.add("uniqueness", value == null ? uniqueness : this.toMap("name", uniqueness, "value", value));
        return null;
    }

    private String restify(UniquenessFactory uniquenessFactory) {
        if (uniquenessFactory instanceof Uniqueness) {
            return ((Uniqueness)uniquenessFactory).name().toLowerCase().replace("_", " ");
        }
        throw new UnsupportedOperationException("Only values of " + Uniqueness.class + " are supported");
    }

    @Override
    public RestTraversalDescription prune(PruneEvaluator pruneEvaluator) {
        if (pruneEvaluator == PruneEvaluator.NONE) {
            return this.add("prune_evaluator", this.toMap("language", "builtin", "name", "none"));
        }
        Integer maxDepth = this.getMaxDepthValueOrNull(pruneEvaluator);
        if (maxDepth != null) {
            return this.maxDepth(maxDepth);
        }
        throw new UnsupportedOperationException("Only max depth supported");
    }

    private Integer getMaxDepthValueOrNull(PruneEvaluator pruneEvaluator) {
        try {
            Field depthField = pruneEvaluator.getClass().getDeclaredField("val$depth");
            depthField.setAccessible(true);
            return (Integer)depthField.get(pruneEvaluator);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public RestTraversalDescription filter(Predicate<Path> pathPredicate) {
        if (pathPredicate == Evaluators.all()) {
            return this.add("return_filter", this.toMap("language", "builtin", "name", "all"));
        }
        if (pathPredicate == Evaluators.excludeStartPosition()) {
            return this.add("return_filter", this.toMap("language", "builtin", "name", "all_but_start_node"));
        }
        throw new UnsupportedOperationException("Only builtin paths supported");
    }

    @Override
    public RestTraversalDescription evaluator(Evaluator evaluator) {
        if (evaluator == Evaluators.all()) {
            return this.add("return_filter", this.toMap("language", "builtin", "name", "all"));
        }
        if (evaluator == Evaluators.excludeStartPosition()) {
            return this.add("return_filter", this.toMap("language", "builtin", "name", "all_but_start_node"));
        }
        throw new UnsupportedOperationException("Only builtin paths supported");
    }

    @Override
    public RestTraversalDescription prune(RestTraversalDescription.ScriptLanguage language, String code) {
        return this.add("prune_evaluator", this.toMap("language", language.name().toLowerCase(), "body", code));
    }

    @Override
    public RestTraversalDescription filter(RestTraversalDescription.ScriptLanguage language, String code) {
        return this.add("return_filter", this.toMap("language", language.name().toLowerCase(), "body", code));
    }

    @Override
    public RestTraversalDescription maxDepth(int depth) {
        return this.add("max_depth", depth);
    }

    @Override
    public RestTraversalDescription order(BranchOrderingPolicy branchOrderingPolicy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RestTraversalDescription depthFirst() {
        return this.add("order", "depth_first");
    }

    @Override
    public RestTraversalDescription breadthFirst() {
        return this.add("order", "breadth_first");
    }

    private RestTraversalDescription add(String key, Object value) {
        this.description.put(key, value);
        return this;
    }

    @Override
    public RestTraversalDescription relationships(RelationshipType relationshipType) {
        return this.relationships(relationshipType, null);
    }

    @Override
    public RestTraversalDescription relationships(RelationshipType relationshipType, Direction direction) {
        if (!this.description.containsKey("relationships")) {
            this.description.put("relationships", new HashSet());
        }
        Set relationships = (Set)this.description.get("relationships");
        relationships.add(this.toMap("type", relationshipType.name(), "direction", this.directionString(direction)));
        return this;
    }

    private Map<String, Object> toMap(Object ... params) {
        if (params.length % 2 != 0) {
            throw new IllegalArgumentException("toMap needs an even number of arguments, but was " + Arrays.toString(params));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = 0; i < params.length; i += 2) {
            if (params[i + 1] == null) continue;
            result.put(params[i].toString(), params[i + 1].toString());
        }
        return result;
    }

    private String directionString(Direction direction) {
        return RestDirection.from((Direction)direction).shortName;
    }

    @Override
    public RestTraversalDescription expand(RelationshipExpander relationshipExpander) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Traverser traverse(Node node) {
        RestNode restNode = (RestNode)node;
        return restNode.getRestApi().traverse(restNode, this.description);
    }

    public static RestTraversalDescription description() {
        return new RestTraversal();
    }

    public Map<String, Object> getPostData() {
        return this.description;
    }

    @Override
    public TraversalDescription expand(PathExpander<?> expander) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <STATE> TraversalDescription expand(PathExpander<STATE> expander, InitialStateFactory<STATE> initialState) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TraversalDescription sort(Comparator<? super Path> comparator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TraversalDescription reverse() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Traverser traverse(Node ... startNode) {
        throw new UnsupportedOperationException();
    }
}

