/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.traversal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.IteratorUtil;

public class SimplePath
implements Path {
    Iterable<Relationship> relationships;
    Iterable<Node> nodes;
    private final Relationship lastRelationship;
    private int length;
    private Node startNode;
    private Node endNode;

    public SimplePath(Node startNode, Node endNode, Relationship lastRelationship, int length, Iterable<Node> nodes, Iterable<Relationship> relationships) {
        this.startNode = startNode;
        this.endNode = endNode;
        this.lastRelationship = lastRelationship;
        this.length = length;
        this.nodes = nodes;
        this.relationships = relationships;
    }

    @Override
    public Node startNode() {
        return this.startNode;
    }

    @Override
    public Node endNode() {
        return this.endNode;
    }

    @Override
    public Relationship lastRelationship() {
        return this.lastRelationship;
    }

    @Override
    public Iterable<Relationship> relationships() {
        return this.relationships;
    }

    @Override
    public Iterable<Node> nodes() {
        return this.nodes;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public Iterator<PropertyContainer> iterator() {
        return new Iterator<PropertyContainer>(){
            Iterator<? extends PropertyContainer> current;
            Iterator<? extends PropertyContainer> next;
            {
                this.current = SimplePath.this.nodes().iterator();
                this.next = SimplePath.this.relationships().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.current.hasNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PropertyContainer next() {
                try {
                    PropertyContainer propertyContainer = this.current.next();
                    return propertyContainer;
                }
                finally {
                    Iterator<? extends PropertyContainer> temp = this.current;
                    this.current = this.next;
                    this.next = temp;
                }
            }

            @Override
            public void remove() {
                this.next.remove();
            }
        };
    }

    @Override
    public Iterable<Relationship> reverseRelationships() {
        List reverseRels = IteratorUtil.addToCollection(this.relationships, new ArrayList());
        Collections.reverse(reverseRels);
        return reverseRels;
    }

    @Override
    public Iterable<Node> reverseNodes() {
        List reverseNodes = IteratorUtil.addToCollection(this.nodes, new ArrayList());
        Collections.reverse(reverseNodes);
        return reverseNodes;
    }
}

