/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.neo4j.rest.graphdb.util.JsonHelper;
import org.pingles.org.codehaus.jackson.JsonGenerator;
import org.pingles.org.codehaus.jackson.map.ObjectMapper;

public class StreamJsonHelper {
    static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static Map<String, Object> jsonToMap(InputStream stream) {
        return (Map)StreamJsonHelper.readJson(stream);
    }

    public static List<Map<String, Object>> jsonToListOfRelationshipRepresentations(InputStream stream) {
        return (List)StreamJsonHelper.readJson(stream);
    }

    public static Object readJson(InputStream stream) {
        try {
            Object object = OBJECT_MAPPER.readValue(stream, Object.class);
            return object;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading input '" + JsonHelper.readString(stream) + "' as JSON ", e);
        }
        finally {
            if (stream != null) {
                StreamJsonHelper.close(stream);
            }
        }
    }

    private static void close(InputStream stream) {
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Object jsonToSingleValue(InputStream stream) {
        Object jsonObject = StreamJsonHelper.readJson(stream);
        return jsonObject;
    }

    public static void writeJsonTo(Object data, OutputStream stream) {
        try {
            JsonGenerator generator = OBJECT_MAPPER.getJsonFactory().createJsonGenerator(stream);
            OBJECT_MAPPER.writeValue(generator, data);
            stream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

