/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.net.URI;
import java.util.Arrays;
import java.util.Iterator;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.server.rest.repr.ExtensionInjector;
import org.neo4j.server.rest.repr.ListSerializer;
import org.neo4j.server.rest.repr.ListWriter;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ValueRepresentation;

public final class ListRepresentation
extends Representation {
    private final Iterable<? extends Representation> content;

    public ListRepresentation(String type, Iterable<? extends Representation> content) {
        super(type);
        this.content = content;
    }

    public ListRepresentation(RepresentationType type, Iterable<? extends Representation> content) {
        super(type);
        this.content = content;
    }

    @Override
    String serialize(RepresentationFormat format, URI baseUri, ExtensionInjector extensions) {
        ListWriter writer = format.serializeList(this.type);
        this.serialize(new ListSerializer(writer, baseUri, extensions));
        writer.done();
        return format.complete(writer);
    }

    void serialize(ListSerializer serializer) {
        for (Representation representation : this.content) {
            representation.addTo(serializer);
        }
    }

    @Override
    void addTo(ListSerializer serializer) {
        serializer.addList(this);
    }

    @Override
    void putTo(MappingSerializer serializer, String key) {
        serializer.putList(key, this);
    }

    public static ListRepresentation strings(String ... values) {
        return ListRepresentation.string(Arrays.asList(values));
    }

    public static ListRepresentation string(Iterable<String> values) {
        return new ListRepresentation(RepresentationType.STRING, (Iterable<? extends Representation>)new IterableWrapper<Representation, String>(values){

            @Override
            protected Representation underlyingObjectToObject(String value) {
                return ValueRepresentation.string(value);
            }
        });
    }

    public static ListRepresentation relationshipTypes(Iterable<RelationshipType> types) {
        return new ListRepresentation(RepresentationType.RELATIONSHIP_TYPE, (Iterable<? extends Representation>)new IterableWrapper<Representation, RelationshipType>(types){

            @Override
            protected Representation underlyingObjectToObject(RelationshipType value) {
                return ValueRepresentation.relationshipType(value);
            }
        });
    }

    public static ListRepresentation numbers(final long ... values) {
        return new ListRepresentation(RepresentationType.LONG, (Iterable<? extends Representation>)new Iterable<ValueRepresentation>(){

            @Override
            public Iterator<ValueRepresentation> iterator() {
                return new PrefetchingIterator<ValueRepresentation>(){
                    int pos = 0;

                    @Override
                    protected ValueRepresentation fetchNextOrNull() {
                        if (this.pos >= values.length) {
                            return null;
                        }
                        return ValueRepresentation.number(values[this.pos++]);
                    }
                };
            }
        });
    }

    public static ListRepresentation numbers(final double[] values) {
        return new ListRepresentation(RepresentationType.DOUBLE, (Iterable<? extends Representation>)new Iterable<ValueRepresentation>(){

            @Override
            public Iterator<ValueRepresentation> iterator() {
                return new PrefetchingIterator<ValueRepresentation>(){
                    int pos = 0;

                    @Override
                    protected ValueRepresentation fetchNextOrNull() {
                        if (this.pos >= values.length) {
                            return null;
                        }
                        return ValueRepresentation.number(values[this.pos++]);
                    }
                };
            }
        });
    }
}

