/*
 * Decompiled with CFR 0.152.
 */
package org.pingles.cascading.neo4j.hadoop;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.util.Progressable;
import org.pingles.cascading.neo4j.hadoop.Neo4jRecordWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Neo4jOutputFormat<K, V>
implements OutputFormat<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Neo4jOutputFormat.class);
    public static final String REST_CONN_STRING_CONFIG_PROPERTY = "org.pingles.neo4j.connection.string";
    private static final String DEFAULT_BATCH_SIZE = "10";
    public static final String BATCH_SIZE_PROPERTY_NAME = "org.pingles.neo4j.batch_size";

    public static void setNeo4jConnectionString(JobConf conf, String restConnectionString) {
        conf.set(REST_CONN_STRING_CONFIG_PROPERTY, restConnectionString);
    }

    public RecordWriter<K, V> getRecordWriter(FileSystem fileSystem, JobConf jobConf, String s, Progressable progress) throws IOException {
        this.setNeo4jJavaClientSystemProperties(jobConf);
        String restConnectionString = jobConf.get(REST_CONN_STRING_CONFIG_PROPERTY);
        LOGGER.info("Creating RecordWriter, connecting to {}", (Object)restConnectionString);
        int batchSize = Integer.valueOf(jobConf.get(BATCH_SIZE_PROPERTY_NAME, DEFAULT_BATCH_SIZE));
        return new Neo4jRecordWriter(restConnectionString, batchSize);
    }

    private void setNeo4jJavaClientSystemProperties(JobConf jobConf) {
        this.setSystemPropertyFromJobConf(jobConf, "org.neo4j.rest.batch_transaction");
        this.setSystemPropertyFromJobConf(jobConf, "org.neo4j.rest.read_timeout");
        this.setSystemPropertyFromJobConf(jobConf, "org.neo4j.rest.connect_timeout");
        this.setSystemPropertyFromJobConf(jobConf, "org.neo4j.rest.stream");
        this.setSystemPropertyFromJobConf(jobConf, "org.neo4j.rest.logging_filter");
    }

    public void checkOutputSpecs(FileSystem fileSystem, JobConf entries) throws IOException {
    }

    private void setSystemPropertyFromJobConf(JobConf jobConf, String propertyName) {
        String propertyValue = jobConf.get(propertyName);
        if (propertyValue != null) {
            System.setProperty(propertyName, propertyValue);
        }
    }
}

