/*
 * Decompiled with CFR 0.152.
 */
package org.pingles.cascading.neo4j.hadoop;

import cascading.flow.FlowProcess;
import cascading.flow.hadoop.HadoopFlowProcess;
import cascading.tap.Tap;
import cascading.tap.TapException;
import cascading.tuple.TupleEntrySchemeCollector;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Neo4jTapCollector
extends TupleEntrySchemeCollector
implements OutputCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(Neo4jTapCollector.class);
    private final Reporter reporter = Reporter.NULL;
    private final FlowProcess<JobConf> flowProcess;
    private final Tap<JobConf, RecordReader, OutputCollector> tap;
    private final JobConf config;
    private RecordWriter writer;

    public Neo4jTapCollector(FlowProcess<JobConf> flowProcess, Tap<JobConf, RecordReader, OutputCollector> tap) {
        super(flowProcess, tap.getScheme());
        this.flowProcess = flowProcess;
        this.tap = tap;
        this.config = new JobConf((Configuration)flowProcess.getConfigCopy());
    }

    protected void prepare() {
        try {
            this.initialise();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        super.prepare();
    }

    private void initialise() throws IOException {
        this.tap.sinkConfInit(this.flowProcess, (Object)this.config);
        OutputFormat format = this.config.getOutputFormat();
        LOGGER.info("Output format class is {}", (Object)format.getClass().toString());
        this.writer = format.getRecordWriter(null, this.config, this.tap.getIdentifier(), (Progressable)this.reporter);
        this.sinkCall.setOutput((Object)this);
    }

    public void close() {
        try {
            this.writer.close(this.reporter);
        }
        catch (IOException e) {
            LOGGER.error("Error closing writer.", (Throwable)e);
            throw new TapException((Throwable)e);
        }
        finally {
            super.close();
        }
    }

    public void collect(Object writableComparable, Object writable) throws IOException {
        HadoopFlowProcess hadoopProcess = (HadoopFlowProcess)this.flowProcess;
        hadoopProcess.getReporter().progress();
        this.writer.write(writableComparable, writable);
    }
}

