/*
 * Decompiled with CFR 0.152.
 */
package org.pingles.cascading.neo4j.hadoop;

import cascading.flow.FlowProcess;
import cascading.scheme.Scheme;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.io.IOException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.pingles.cascading.neo4j.IndexSpec;
import org.pingles.cascading.neo4j.hadoop.Neo4jOutputFormat;
import org.pingles.cascading.neo4j.hadoop.NodeTuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeScheme
extends Scheme<JobConf, RecordReader, OutputCollector, Object[], Object[]> {
    private IndexSpec indexSpec;

    public NodeScheme(Fields sourceFields) {
        this(sourceFields, null);
    }

    public NodeScheme(Fields sourceFields, IndexSpec indexSpec) {
        super(sourceFields);
        if (indexSpec != null) {
            this.indexSpec = indexSpec;
        }
    }

    public void sourceConfInit(FlowProcess<JobConf> flowProcess, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf conf) {
        throw new UnsupportedOperationException();
    }

    public boolean source(FlowProcess flowProcess, SourceCall sourceCall) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void sinkConfInit(FlowProcess<JobConf> flowProcess, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf conf) {
        conf.setOutputKeyClass(Tuple.class);
        conf.setOutputValueClass(Tuple.class);
        conf.setOutputFormat(Neo4jOutputFormat.class);
    }

    public void sink(FlowProcess flowProcess, SinkCall sinkCall) throws IOException {
        OutputCollector collector = (OutputCollector)sinkCall.getOutput();
        TupleEntry tuple = sinkCall.getOutgoingEntry();
        NodeTuple node = this.indexSpec != null ? new NodeTuple(this.getSourceFields(), tuple, this.indexSpec) : new NodeTuple(this.getSourceFields(), tuple);
        collector.collect((Object)Tuple.NULL, (Object)node);
        flowProcess.increment("org.pingles.cascading.Neo4j", "Nodes Created", 1L);
    }
}

