/*
 * Decompiled with CFR 0.152.
 */
package org.pingles.cascading.neo4j.hadoop;

import cascading.tuple.Fields;
import cascading.tuple.TupleEntry;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.index.Index;
import org.pingles.cascading.neo4j.IndexSpec;
import org.pingles.cascading.neo4j.hadoop.Neo4jTuple;
import org.pingles.cascading.neo4j.hadoop.Neo4jWritable;

public class NodeTuple
extends Neo4jTuple
implements Neo4jWritable {
    private final TupleEntry tupleEntry;
    private IndexSpec indexSpec;
    private Fields sinkFields;

    public NodeTuple(Fields sinkFields, TupleEntry tupleEntry) {
        this(sinkFields, tupleEntry, null);
    }

    public NodeTuple(Fields sinkFields, TupleEntry tupleEntry, IndexSpec indexSpec) {
        this.tupleEntry = tupleEntry;
        this.indexSpec = indexSpec;
        this.sinkFields = sinkFields;
    }

    public void store(GraphDatabaseService service) {
        Node node = service.createNode();
        Fields fields = this.sinkFields;
        for (int idx = 0; idx < fields.size(); ++idx) {
            String fieldName = (String)((Object)fields.get(idx));
            Object fieldValue = this.tupleEntry.getTuple().getObject(idx);
            if (fieldValue == null) continue;
            node.setProperty(NodeTuple.cleanPropertyName(fieldName), fieldValue);
        }
        if (this.indexSpec != null) {
            Index<Node> index = service.index().forNodes(this.indexSpec.getNodeTypeName());
            Fields indexProperties = this.indexSpec.getIndexProperties();
            for (Comparable propName : indexProperties) {
                index.add(node, NodeTuple.cleanPropertyName(propName.toString()), this.tupleEntry.getObject(propName));
            }
        }
    }
}

