/*
 * Decompiled with CFR 0.152.
 */
package org.pingles.cascading.neo4j.local;

import cascading.flow.FlowProcess;
import cascading.scheme.ConcreteCall;
import cascading.scheme.Scheme;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntry;
import java.io.IOException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.rest.graphdb.RestGraphDatabase;
import org.pingles.cascading.neo4j.IndexSpec;

public class NodeScheme
extends Scheme {
    private GraphDatabaseService service;
    private IndexSpec indexSpec;
    private Index<Node> index;

    public NodeScheme(GraphDatabaseService service) {
        this.service = service;
    }

    public NodeScheme(String restService) {
        this.service = new RestGraphDatabase(restService);
    }

    public NodeScheme(GraphDatabaseService service, IndexSpec indexSpec) {
        this.service = service;
        this.indexSpec = indexSpec;
        this.index = service.index().forNodes(indexSpec.getNodeTypeName());
    }

    public NodeScheme(String restService, IndexSpec indexSpec) {
        this.service = new RestGraphDatabase(restService);
        this.indexSpec = indexSpec;
        this.index = this.service.index().forNodes(indexSpec.getNodeTypeName());
    }

    public void sourceConfInit(FlowProcess flowProcess, Tap tap, Object o) {
    }

    public void sinkConfInit(FlowProcess flowProcess, Tap tap, Object o) {
    }

    public boolean source(FlowProcess flowProcess, SourceCall sourceCall) throws IOException {
        Object key = sourceCall.getContext();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sink(FlowProcess flowProcess, SinkCall sinkCall) throws IOException {
        ConcreteCall call = (ConcreteCall)sinkCall;
        TupleEntry outgoingEntry = call.getOutgoingEntry();
        Transaction transaction = this.service.beginTx();
        try {
            Node node = this.service.createNode();
            Fields fields = outgoingEntry.getFields();
            for (int idx = 0; idx < fields.size(); ++idx) {
                String fieldName = (String)((Object)fields.get(idx));
                Object fieldValue = outgoingEntry.getTuple().getObject(idx);
                if (fieldValue == null) continue;
                node.setProperty(fieldName, fieldValue);
            }
            if (this.index != null) {
                Fields indexProperties = this.indexSpec.getIndexProperties();
                for (Comparable propName : indexProperties) {
                    this.index.add(node, propName.toString(), outgoingEntry.getObject(propName));
                }
            }
            transaction.success();
        }
        finally {
            transaction.finish();
        }
    }
}

