(ns goldly.sci.bindings
  (:require
   [clojure.core]
   [clojure.string :as str]
   [taoensso.timbre :refer [trace debug debugf info infof error]]
   [fipp.clojure]
   [webly.date :refer [now-str]]
   [webly.writer :refer [write-target write-status]]))

; config management

(defonce goldly-namespaces (atom []))
(defonce goldly-bindings (atom {}))

(defonce goldly-ns-bindings (atom {}))

(defmacro add-cljs-namespace [n]
  `(swap! goldly-namespaces conj '~n))

(defmacro add-cljs-bindings [b]
  `(swap! goldly-bindings merge '~b))

(defmacro add-cljs-ns-bindings [n b]
  `(swap! goldly-ns-bindings assoc '~n '~b))

;In fact {:bindings ...} is just shorthand for {:namespaces {'user ...}} .

; generate forms

(defmacro generate-require [namespaces]
  `(concat (list :require) ~namespaces))

(defn make-forms []
  (let [bindings @goldly-bindings
        ns-bindings @goldly-ns-bindings
        namespaces @goldly-namespaces
        nsl '(ns goldly-bindings-generated)
        r (generate-require namespaces)
        rl (list r)
        nslr (concat nsl rl)]
    [nslr ; (concat nsl (generate-require))
     (list 'def 'bindings-generated bindings)
     (list 'def 'ns-generated ns-bindings)]))

; write forms to cljs 

(defn form->str [f]
  (with-out-str
    (fipp.clojure/pprint f {:width 60})))

(defn write-forms [forms]
  (let [filename "src/goldly_bindings_generated.cljs"
        comment (str "; generated by goldly on " (now-str) "\r\n")
        s-forms (-> (map form->str forms)
                    (str/join))
        s (str comment s-forms)]
    (spit filename s)))

;; all together

(defn generate-bindings []
  (info "goldly is generating bindings.. ")
  ;      "namespaces: " @goldly-namespaces "bindings: " @goldly-bindings)
  #_(write-status "sci-cljs-bindings" {:namespaces @goldly-namespaces
                                       :bindings @goldly-bindings
                                       :ns-bindings @goldly-ns-bindings})
  (write-target "sci-cljs-bindings" {:namespaces @goldly-namespaces
                                     :bindings @goldly-bindings
                                     :ns-bindings @goldly-ns-bindings})

  (let [forms (make-forms)]
    (write-forms forms)))

(comment

  ;config management  
  (add-cljs-namespace [clojure.walk :as walk])
  (add-cljs-namespace [goldly.sci.bindings-goldly])
  (add-cljs-namespace [goldly.code.core])

  (add-cljs-bindings {'sin sin
                      'println println})

  ; generate forms

  (def static-forms
    ['(ns goldly.sci.bindings-generated
        (:require
         [clojure.walk :as walk]
         [goldly.sci.bindings-goldly :refer [sin]]))
     '(def bindings-generated
        {'sin sin
         'println println})])

  (make-forms)

  ; all together
  (generate-bindings)
  ;
  )