;; gorilla-repl.fileformat = 2

;; @@ [meta]
{:tags "cljs,test", :name "cljs demos", :tagline "explore what clojurescript can do"}

;; @@

;; **
;;; # Clojurescript Experiments
;; **

;; @@ [cljs]
; only the last value gets returned - so only one cookie
(fortune.core/cookie)
(fortune.core/cookie)
;; @@
;; =>
;;; ["^ ","~:type","~:html","~:content",["~:span",["^ ","~:class","clj-string"],"\"Be on the alert to recognize your prime at whatever time of your life it may occur.\""],"~:value","\"Be on the alert to recognize your prime at whatever time of your life it may occur.\""]
;; <=

;; @@ [cljs]
(def x "bongo")
;; @@
;; =>
;;; ["^ ","~:type","~:html","~:content",["~:span",["^ ","~:class","clj-unknown"],"#'cljs.user/x"],"~:value","#'cljs.user/x"]
;; <=

;; @@ [cljs]
x
;; @@
;; =>
;;; ["^ ","~:type","~:html","~:content",["~:span",["^ ","~:class","clj-string"],"\"bongo\""],"~:value","\"bongo\""]
;; <=

;; @@ [cljs]

(defn add-vatican [a b] "adds 2 numbers, but also withholds obulus to the vatican"
  (- (+ a b) 1))
;; @@
;; =>
;;; ["^ ","~:type","~:html","~:content",["~:span",["^ ","~:class","clj-unknown"],"#'cljs.user/add-vatican"],"~:value","#'cljs.user/add-vatican"]
;; <=

;; @@ [cljs]
(add-vatican 10 5)
;; @@
;; =>
;;; ["^ ","~:type","~:html","~:content",["~:span",["^ ","~:class","clj-long"],"14"],"~:value","14"]
;; <=

;; @@ [cljs]
; what happens if we forget one of the parameters?
(add-vatican 10)
;; @@
;; =>
;;; ["^ ","~:type","~:html","~:content",["~:span",["^ ","~:class","clj-long"],"##NaN"],"~:value","##NaN"]
;; <=

;; @@ [cljs]
; doc test
; KLIPSE has docstring defined, for SHADOW we have to adapt it still....
(with-out-str (doc map))
;; @@

;; @@ [cljs]
; produce an eval error:
(g kkj)
;; @@

;; @@ [cljs]
; not sure if we need namespaces in a cljs repl
; if namespaces get changed then this effects the processing of prior segments.  
(ns bongo.trott)
;; @@
;; =>
;;; ["^ ","~:type","~:html","~:content",["~:span",["^ ","~:class","clj-nil"],"nil"],"~:value","nil"]
;; <=

;; @@ [cljs]
(map inc (map inc [7 8 9]))
;; @@
;; =>
;;; ["^ ","~:type","~:list-like","~:open",["~:span",["^ ","~:class","clj-lazy-seq"],"("],"~:close",["^3",["^ ","^4","clj-lazy-seq"],")"],"~:separator",["^3"," "],"~:items",["~#list",[["^ ","^0","~:html","~:content",["^3",["^ ","^4","clj-long"],"9"],"~:value","9"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"10"],"^;","10"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"11"],"^;","11"]]],"^;","(9 10 11)"]
;; <=

;; @@ [cljs]
; self hosted clojurescrip in klipse can access host namespaces
; in shadow we cannot access host namespaces
(ns simple.core
  (:require [reagent.core :as reagent]
            [re-frame.core :as rf]))
(rf/dispatch [:click-count] "done")

;; @@

;; @@ [cljs]
; infinite seq
(def fib-seq-seq
  ((fn fib [a b]
     (lazy-seq (cons a (fib b (+ a b)))))
   0 1))
(take 1000 fib-seq-seq)
;; @@
;; =>
;;; ["^ ","~:type","~:list-like","~:open",["~:span",["^ ","~:class","clj-lazy-seq"],"("],"~:close",["^3",["^ ","^4","clj-lazy-seq"],")"],"~:separator",["^3"," "],"~:items",["~#list",[["^ ","^0","~:html","~:content",["^3",["^ ","^4","clj-long"],"0"],"~:value","0"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1"],"^;","1"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1"],"^;","1"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2"],"^;","2"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3"],"^;","3"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5"],"^;","5"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8"],"^;","8"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"13"],"^;","13"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"21"],"^;","21"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"34"],"^;","34"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"55"],"^;","55"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"89"],"^;","89"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"144"],"^;","144"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"233"],"^;","233"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"377"],"^;","377"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"610"],"^;","610"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"987"],"^;","987"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1597"],"^;","1597"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2584"],"^;","2584"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4181"],"^;","4181"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6765"],"^;","6765"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"10946"],"^;","10946"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"17711"],"^;","17711"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"28657"],"^;","28657"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"46368"],"^;","46368"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"75025"],"^;","75025"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"121393"],"^;","121393"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"196418"],"^;","196418"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"317811"],"^;","317811"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"514229"],"^;","514229"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"832040"],"^;","832040"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1346269"],"^;","1346269"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2178309"],"^;","2178309"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3524578"],"^;","3524578"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5702887"],"^;","5702887"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9227465"],"^;","9227465"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"14930352"],"^;","14930352"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"24157817"],"^;","24157817"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"39088169"],"^;","39088169"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"63245986"],"^;","63245986"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"102334155"],"^;","102334155"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"165580141"],"^;","165580141"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"267914296"],"^;","267914296"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"433494437"],"^;","433494437"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"701408733"],"^;","701408733"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1134903170"],"^;","1134903170"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1836311903"],"^;","1836311903"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2971215073"],"^;","2971215073"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4807526976"],"^;","4807526976"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7778742049"],"^;","7778742049"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"12586269025"],"^;","12586269025"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"20365011074"],"^;","20365011074"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"32951280099"],"^;","32951280099"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"53316291173"],"^;","53316291173"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"86267571272"],"^;","86267571272"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"139583862445"],"^;","139583862445"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"225851433717"],"^;","225851433717"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"365435296162"],"^;","365435296162"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"591286729879"],"^;","591286729879"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"956722026041"],"^;","956722026041"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1548008755920"],"^;","1548008755920"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2504730781961"],"^;","2504730781961"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4052739537881"],"^;","4052739537881"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6557470319842"],"^;","6557470319842"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"10610209857723"],"^;","10610209857723"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"17167680177565"],"^;","17167680177565"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"27777890035288"],"^;","27777890035288"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"44945570212853"],"^;","44945570212853"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"72723460248141"],"^;","72723460248141"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"117669030460994"],"^;","117669030460994"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"190392490709135"],"^;","190392490709135"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"308061521170129"],"^;","308061521170129"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"498454011879264"],"^;","498454011879264"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"806515533049393"],"^;","806515533049393"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1304969544928657"],"^;","1304969544928657"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2111485077978050"],"^;","2111485077978050"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3416454622906707"],"^;","3416454622906707"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5527939700884757"],"^;","5527939700884757"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8944394323791464"],"^;","8944394323791464"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"14472334024676220"],"^;","14472334024676220"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"23416728348467684"],"^;","23416728348467684"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"37889062373143900"],"^;","37889062373143900"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"61305790721611580"],"^;","61305790721611580"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"99194853094755490"],"^;","99194853094755490"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"160500643816367070"],"^;","160500643816367070"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"259695496911122560"],"^;","259695496911122560"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"420196140727489660"],"^;","420196140727489660"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"679891637638612200"],"^;","679891637638612200"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1100087778366101900"],"^;","1100087778366101900"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1779979416004714000"],"^;","1779979416004714000"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2880067194370816000"],"^;","2880067194370816000"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4660046610375530000"],"^;","4660046610375530000"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7540113804746346000"],"^;","7540113804746346000"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"12200160415121877000"],"^;","12200160415121877000"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"19740274219868226000"],"^;","19740274219868226000"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"31940434634990100000"],"^;","31940434634990100000"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"51680708854858330000"],"^;","51680708854858330000"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"83621143489848430000"],"^;","83621143489848430000"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"135301852344706760000"],"^;","135301852344706760000"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"218922995834555200000"],"^;","218922995834555200000"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"354224848179262000000"],"^;","354224848179262000000"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"573147844013817200000"],"^;","573147844013817200000"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"927372692193079200000"],"^;","927372692193079200000"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.5005205362068963e+21"],"^;","1.5005205362068963e+21"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.4278932283999755e+21"],"^;","2.4278932283999755e+21"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.9284137646068717e+21"],"^;","3.9284137646068717e+21"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.356306993006848e+21"],"^;","6.356306993006848e+21"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.028472075761372e+22"],"^;","1.028472075761372e+22"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.6641027750620568e+22"],"^;","1.6641027750620568e+22"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.6925748508234288e+22"],"^;","2.6925748508234288e+22"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.356677625885486e+22"],"^;","4.356677625885486e+22"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.049252476708914e+22"],"^;","7.049252476708914e+22"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.14059301025944e+23"],"^;","1.14059301025944e+23"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.8455182579303315e+23"],"^;","1.8455182579303315e+23"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.9861112681897715e+23"],"^;","2.9861112681897715e+23"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.831629526120103e+23"],"^;","4.831629526120103e+23"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.817740794309875e+23"],"^;","7.817740794309875e+23"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.2649370320429978e+24"],"^;","1.2649370320429978e+24"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.0467111114739851e+24"],"^;","2.0467111114739851e+24"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.3116481435169827e+24"],"^;","3.3116481435169827e+24"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.358359254990968e+24"],"^;","5.358359254990968e+24"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.670007398507951e+24"],"^;","8.670007398507951e+24"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.402836665349892e+25"],"^;","1.402836665349892e+25"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.269837405200687e+25"],"^;","2.269837405200687e+25"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.6726740705505786e+25"],"^;","3.6726740705505786e+25"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.942511475751265e+25"],"^;","5.942511475751265e+25"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.615185546301844e+25"],"^;","9.615185546301844e+25"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.555769702205311e+26"],"^;","1.555769702205311e+26"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.5172882568354952e+26"],"^;","2.5172882568354952e+26"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.0730579590408064e+26"],"^;","4.0730579590408064e+26"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.590346215876301e+26"],"^;","6.590346215876301e+26"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.0663404174917107e+27"],"^;","1.0663404174917107e+27"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.7253750390793408e+27"],"^;","1.7253750390793408e+27"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.791715456571052e+27"],"^;","2.791715456571052e+27"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.5170904956503927e+27"],"^;","4.5170904956503927e+27"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.308805952221445e+27"],"^;","7.308805952221445e+27"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.1825896447871837e+28"],"^;","1.1825896447871837e+28"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.9134702400093282e+28"],"^;","1.9134702400093282e+28"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.096059884796512e+28"],"^;","3.096059884796512e+28"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.009530124805841e+28"],"^;","5.009530124805841e+28"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.105590009602353e+28"],"^;","8.105590009602353e+28"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.3115120134408193e+29"],"^;","1.3115120134408193e+29"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.1220710144010545e+29"],"^;","2.1220710144010545e+29"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.4335830278418734e+29"],"^;","3.4335830278418734e+29"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.5556540422429276e+29"],"^;","5.5556540422429276e+29"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.989237070084801e+29"],"^;","8.989237070084801e+29"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.454489111232773e+30"],"^;","1.454489111232773e+30"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.353412818241253e+30"],"^;","2.353412818241253e+30"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.807901929474026e+30"],"^;","3.807901929474026e+30"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.161314747715279e+30"],"^;","6.161314747715279e+30"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.969216677189305e+30"],"^;","9.969216677189305e+30"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.6130531424904583e+31"],"^;","1.6130531424904583e+31"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.6099748102093888e+31"],"^;","2.6099748102093888e+31"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.223027952699847e+31"],"^;","4.223027952699847e+31"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.8330027629092365e+31"],"^;","6.8330027629092365e+31"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.1056030715609085e+32"],"^;","1.1056030715609085e+32"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.788903347851832e+32"],"^;","1.788903347851832e+32"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.8945064194127406e+32"],"^;","2.8945064194127406e+32"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.683409767264573e+32"],"^;","4.683409767264573e+32"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.577916186677313e+32"],"^;","7.577916186677313e+32"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.2261325953941887e+33"],"^;","1.2261325953941887e+33"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.98392421406192e+33"],"^;","1.98392421406192e+33"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.2100568094561087e+33"],"^;","3.2100568094561087e+33"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.193981023518028e+33"],"^;","5.193981023518028e+33"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.404037832974137e+33"],"^;","8.404037832974137e+33"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.3598018856492165e+34"],"^;","1.3598018856492165e+34"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.20020566894663e+34"],"^;","2.20020566894663e+34"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.5600075545958467e+34"],"^;","3.5600075545958467e+34"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.760213223542477e+34"],"^;","5.760213223542477e+34"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.320220778138323e+34"],"^;","9.320220778138323e+34"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.50804340016808e+35"],"^;","1.50804340016808e+35"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.4400654779819122e+35"],"^;","2.4400654779819122e+35"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.9481088781499925e+35"],"^;","3.9481088781499925e+35"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.388174356131905e+35"],"^;","6.388174356131905e+35"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.0336283234281898e+36"],"^;","1.0336283234281898e+36"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.6724457590413803e+36"],"^;","1.6724457590413803e+36"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.70607408246957e+36"],"^;","2.70607408246957e+36"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.37851984151095e+36"],"^;","4.37851984151095e+36"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.08459392398052e+36"],"^;","7.08459392398052e+36"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.146311376549147e+37"],"^;","1.146311376549147e+37"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.854770768947199e+37"],"^;","1.854770768947199e+37"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.001082145496346e+37"],"^;","3.001082145496346e+37"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.855852914443544e+37"],"^;","4.855852914443544e+37"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.85693505993989e+37"],"^;","7.85693505993989e+37"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.2712787974383434e+38"],"^;","1.2712787974383434e+38"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.0569723034323324e+38"],"^;","2.0569723034323324e+38"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.328251100870676e+38"],"^;","3.328251100870676e+38"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.385223404303009e+38"],"^;","5.385223404303009e+38"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.713474505173684e+38"],"^;","8.713474505173684e+38"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.409869790947669e+39"],"^;","1.409869790947669e+39"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.2812172414650375e+39"],"^;","2.2812172414650375e+39"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.691087032412707e+39"],"^;","3.691087032412707e+39"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.972304273877745e+39"],"^;","5.972304273877745e+39"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.663391306290452e+39"],"^;","9.663391306290452e+39"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.5635695580168196e+40"],"^;","1.5635695580168196e+40"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.529908688645865e+40"],"^;","2.529908688645865e+40"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.0934782466626846e+40"],"^;","4.0934782466626846e+40"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.623386935308549e+40"],"^;","6.623386935308549e+40"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.0716865181971233e+41"],"^;","1.0716865181971233e+41"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.7340252117279783e+41"],"^;","1.7340252117279783e+41"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.8057117299251016e+41"],"^;","2.8057117299251016e+41"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.53973694165308e+41"],"^;","4.53973694165308e+41"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.34544867157818e+41"],"^;","7.34544867157818e+41"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.188518561323126e+42"],"^;","1.188518561323126e+42"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.923063428480944e+42"],"^;","1.923063428480944e+42"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.11158198980407e+42"],"^;","3.11158198980407e+42"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.034645418285014e+42"],"^;","5.034645418285014e+42"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.146227408089083e+42"],"^;","8.146227408089083e+42"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.3180872826374099e+43"],"^;","1.3180872826374099e+43"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.1327100234463182e+43"],"^;","2.1327100234463182e+43"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.450797306083728e+43"],"^;","3.450797306083728e+43"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.583507329530046e+43"],"^;","5.583507329530046e+43"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.034304635613775e+43"],"^;","9.034304635613775e+43"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.4617811965143821e+44"],"^;","1.4617811965143821e+44"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.3652116600757594e+44"],"^;","2.3652116600757594e+44"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.826992856590142e+44"],"^;","3.826992856590142e+44"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.192204516665901e+44"],"^;","6.192204516665901e+44"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.0019197373256042e+45"],"^;","1.0019197373256042e+45"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.6211401889921942e+45"],"^;","1.6211401889921942e+45"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.6230599263177984e+45"],"^;","2.6230599263177984e+45"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.2442001153099927e+45"],"^;","4.2442001153099927e+45"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.86726004162779e+45"],"^;","6.86726004162779e+45"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.1111460156937784e+46"],"^;","1.1111460156937784e+46"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.7978720198565574e+46"],"^;","1.7978720198565574e+46"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.9090180355503355e+46"],"^;","2.9090180355503355e+46"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.706890055406893e+46"],"^;","4.706890055406893e+46"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.615908090957229e+46"],"^;","7.615908090957229e+46"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.2322798146364122e+47"],"^;","1.2322798146364122e+47"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.993870623732135e+47"],"^;","1.993870623732135e+47"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.2261504383685474e+47"],"^;","3.2261504383685474e+47"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.2200210621006825e+47"],"^;","5.2200210621006825e+47"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.44617150046923e+47"],"^;","8.44617150046923e+47"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.3666192562569911e+48"],"^;","1.3666192562569911e+48"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.2112364063039142e+48"],"^;","2.2112364063039142e+48"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.577855662560905e+48"],"^;","3.577855662560905e+48"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.7890920688648195e+48"],"^;","5.7890920688648195e+48"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.366947731425724e+48"],"^;","9.366947731425724e+48"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.5156039800290544e+49"],"^;","1.5156039800290544e+49"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.452298753171627e+49"],"^;","2.452298753171627e+49"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.967902733200681e+49"],"^;","3.967902733200681e+49"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.420201486372308e+49"],"^;","6.420201486372308e+49"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.0388104219572989e+50"],"^;","1.0388104219572989e+50"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.6808305705945297e+50"],"^;","1.6808305705945297e+50"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.7196409925518287e+50"],"^;","2.7196409925518287e+50"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.400471563146358e+50"],"^;","4.400471563146358e+50"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.120112555698187e+50"],"^;","7.120112555698187e+50"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.1520584118844544e+51"],"^;","1.1520584118844544e+51"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.864069667454273e+51"],"^;","1.864069667454273e+51"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.016128079338727e+51"],"^;","3.016128079338727e+51"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.880197746793e+51"],"^;","4.880197746793e+51"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.896325826131728e+51"],"^;","7.896325826131728e+51"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.2776523572924728e+52"],"^;","1.2776523572924728e+52"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.0672849399056455e+52"],"^;","2.0672849399056455e+52"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.344937297198118e+52"],"^;","3.344937297198118e+52"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.412222237103764e+52"],"^;","5.412222237103764e+52"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.757159534301882e+52"],"^;","8.757159534301882e+52"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.4169381771405647e+53"],"^;","1.4169381771405647e+53"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.2926541305707528e+53"],"^;","2.2926541305707528e+53"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.7095923077113174e+53"],"^;","3.7095923077113174e+53"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.002246438282071e+53"],"^;","6.002246438282071e+53"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.711838745993388e+53"],"^;","9.711838745993388e+53"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.571408518427546e+54"],"^;","1.571408518427546e+54"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.5425923930268848e+54"],"^;","2.5425923930268848e+54"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.114000911454431e+54"],"^;","4.114000911454431e+54"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.656593304481316e+54"],"^;","6.656593304481316e+54"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.0770594215935747e+55"],"^;","1.0770594215935747e+55"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.7427187520417062e+55"],"^;","1.7427187520417062e+55"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.819778173635281e+55"],"^;","2.819778173635281e+55"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.562496925676987e+55"],"^;","4.562496925676987e+55"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.382275099312268e+55"],"^;","7.382275099312268e+55"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.1944772024989255e+56"],"^;","1.1944772024989255e+56"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.9327047124301523e+56"],"^;","1.9327047124301523e+56"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.1271819149290778e+56"],"^;","3.1271819149290778e+56"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.05988662735923e+56"],"^;","5.05988662735923e+56"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.187068542288308e+56"],"^;","8.187068542288308e+56"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.3246955169647538e+57"],"^;","1.3246955169647538e+57"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.1434023711935847e+57"],"^;","2.1434023711935847e+57"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.4680978881583385e+57"],"^;","3.4680978881583385e+57"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.611500259351923e+57"],"^;","5.611500259351923e+57"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.07959814751026e+57"],"^;","9.07959814751026e+57"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.4691098406862182e+58"],"^;","1.4691098406862182e+58"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.3770696554372443e+58"],"^;","2.3770696554372443e+58"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.846179496123462e+58"],"^;","3.846179496123462e+58"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.223249151560707e+58"],"^;","6.223249151560707e+58"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.0069428647684168e+59"],"^;","1.0069428647684168e+59"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.6292677799244873e+59"],"^;","1.6292677799244873e+59"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.636210644692904e+59"],"^;","2.636210644692904e+59"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.265478424617391e+59"],"^;","4.265478424617391e+59"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.901689069310295e+59"],"^;","6.901689069310295e+59"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.1167167493927686e+60"],"^;","1.1167167493927686e+60"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.806885656323798e+60"],"^;","1.806885656323798e+60"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.923602405716567e+60"],"^;","2.923602405716567e+60"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.7304880620403654e+60"],"^;","4.7304880620403654e+60"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.654090467756932e+60"],"^;","7.654090467756932e+60"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.2384578529797298e+61"],"^;","1.2384578529797298e+61"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.003866899755423e+61"],"^;","2.003866899755423e+61"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.242324752735153e+61"],"^;","3.242324752735153e+61"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.246191652490576e+61"],"^;","5.246191652490576e+61"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.488516405225729e+61"],"^;","8.488516405225729e+61"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.3734708057716305e+62"],"^;","1.3734708057716305e+62"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.2223224462942035e+62"],"^;","2.2223224462942035e+62"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.5957932520658337e+62"],"^;","3.5957932520658337e+62"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.818115698360037e+62"],"^;","5.818115698360037e+62"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.41390895042587e+62"],"^;","9.41390895042587e+62"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.5232024648785907e+63"],"^;","1.5232024648785907e+63"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.4645933599211777e+63"],"^;","2.4645933599211777e+63"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.987795824799768e+63"],"^;","3.987795824799768e+63"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.452389184720946e+63"],"^;","6.452389184720946e+63"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.0440185009520713e+64"],"^;","1.0440185009520713e+64"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.6892574194241658e+64"],"^;","1.6892574194241658e+64"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.733275920376237e+64"],"^;","2.733275920376237e+64"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.422533339800403e+64"],"^;","4.422533339800403e+64"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.15580926017664e+64"],"^;","7.15580926017664e+64"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.1578342599977044e+65"],"^;","1.1578342599977044e+65"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.8734151860153683e+65"],"^;","1.8734151860153683e+65"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.0312494460130726e+65"],"^;","3.0312494460130726e+65"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.90466463202844e+65"],"^;","4.90466463202844e+65"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.9359140780415135e+65"],"^;","7.9359140780415135e+65"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.2840578710069954e+66"],"^;","1.2840578710069954e+66"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.0776492788111467e+66"],"^;","2.0776492788111467e+66"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.361707149818142e+66"],"^;","3.361707149818142e+66"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.439356428629289e+66"],"^;","5.439356428629289e+66"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.801063578447432e+66"],"^;","8.801063578447432e+66"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.424042000707672e+67"],"^;","1.424042000707672e+67"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.3041483585524152e+67"],"^;","2.3041483585524152e+67"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.728190359260087e+67"],"^;","3.728190359260087e+67"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.032338717812503e+67"],"^;","6.032338717812503e+67"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.760529077072589e+67"],"^;","9.760529077072589e+67"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.579286779488509e+68"],"^;","1.579286779488509e+68"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.555339687195768e+68"],"^;","2.555339687195768e+68"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.134626466684277e+68"],"^;","4.134626466684277e+68"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.689966153880045e+68"],"^;","6.689966153880045e+68"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.0824592620564322e+69"],"^;","1.0824592620564322e+69"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.751455877444437e+69"],"^;","1.751455877444437e+69"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.833915139500869e+69"],"^;","2.833915139500869e+69"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.5853710169453055e+69"],"^;","4.5853710169453055e+69"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.419286156446174e+69"],"^;","7.419286156446174e+69"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.200465717339148e+70"],"^;","1.200465717339148e+70"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.9423943329837654e+70"],"^;","1.9423943329837654e+70"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.1428600503229136e+70"],"^;","3.1428600503229136e+70"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.085254383306679e+70"],"^;","5.085254383306679e+70"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.228114433629592e+70"],"^;","8.228114433629592e+70"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.331336881693627e+71"],"^;","1.331336881693627e+71"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.1541483250565862e+71"],"^;","2.1541483250565862e+71"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.485485206750213e+71"],"^;","3.485485206750213e+71"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.6396335318068e+71"],"^;","5.6396335318068e+71"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.125118738557013e+71"],"^;","9.125118738557013e+71"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.4764752270363813e+72"],"^;","1.4764752270363813e+72"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.3889871008920825e+72"],"^;","2.3889871008920825e+72"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.865462327928464e+72"],"^;","3.865462327928464e+72"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.254449428820547e+72"],"^;","6.254449428820547e+72"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.0119911756749011e+73"],"^;","1.0119911756749011e+73"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.637436118556956e+73"],"^;","1.637436118556956e+73"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.649427294231857e+73"],"^;","2.649427294231857e+73"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.2868634127888125e+73"],"^;","4.2868634127888125e+73"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.93629070702067e+73"],"^;","6.93629070702067e+73"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.1223154119809483e+74"],"^;","1.1223154119809483e+74"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.8159444826830153e+74"],"^;","1.8159444826830153e+74"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.9382598946639633e+74"],"^;","2.9382598946639633e+74"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.754204377346978e+74"],"^;","4.754204377346978e+74"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.692464272010942e+74"],"^;","7.692464272010942e+74"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.244666864935792e+75"],"^;","1.244666864935792e+75"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.013913292136886e+75"],"^;","2.013913292136886e+75"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.258580157072678e+75"],"^;","3.258580157072678e+75"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.272493449209564e+75"],"^;","5.272493449209564e+75"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.531073606282242e+75"],"^;","8.531073606282242e+75"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.3803567055491806e+76"],"^;","1.3803567055491806e+76"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.2334640661774048e+76"],"^;","2.2334640661774048e+76"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.613820771726585e+76"],"^;","3.613820771726585e+76"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.84728483790399e+76"],"^;","5.84728483790399e+76"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.461105609630574e+76"],"^;","9.461105609630574e+76"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.5308390447534564e+77"],"^;","1.5308390447534564e+77"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.476949605716514e+77"],"^;","2.476949605716514e+77"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.0077886504699705e+77"],"^;","4.0077886504699705e+77"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.484738256186484e+77"],"^;","6.484738256186484e+77"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.0492526906656455e+78"],"^;","1.0492526906656455e+78"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.697726516284294e+78"],"^;","1.697726516284294e+78"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.7469792069499394e+78"],"^;","2.7469792069499394e+78"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.444705723234234e+78"],"^;","4.444705723234234e+78"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.191684930184173e+78"],"^;","7.191684930184173e+78"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.1636390653418406e+79"],"^;","1.1636390653418406e+79"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.882807558360258e+79"],"^;","1.882807558360258e+79"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.046446623702099e+79"],"^;","3.046446623702099e+79"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.9292541820623566e+79"],"^;","4.9292541820623566e+79"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.975700805764455e+79"],"^;","7.975700805764455e+79"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.290495498782681e+80"],"^;","1.290495498782681e+80"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.0880655793591266e+80"],"^;","2.0880655793591266e+80"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.3785610781418077e+80"],"^;","3.3785610781418077e+80"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.466626657500934e+80"],"^;","5.466626657500934e+80"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.845187735642742e+80"],"^;","8.845187735642742e+80"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.4311814393143676e+81"],"^;","1.4311814393143676e+81"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.315700212878642e+81"],"^;","2.315700212878642e+81"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.7468816521930098e+81"],"^;","3.7468816521930098e+81"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.062581865071651e+81"],"^;","6.062581865071651e+81"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.809463517264662e+81"],"^;","9.809463517264662e+81"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.5872045382336313e+82"],"^;","1.5872045382336313e+82"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.5681508899600975e+82"],"^;","2.5681508899600975e+82"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.155355428193729e+82"],"^;","4.155355428193729e+82"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.723506318153826e+82"],"^;","6.723506318153826e+82"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.0878861746347554e+83"],"^;","1.0878861746347554e+83"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.760236806450138e+83"],"^;","1.760236806450138e+83"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.848122981084893e+83"],"^;","2.848122981084893e+83"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.608359787535031e+83"],"^;","4.608359787535031e+83"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.456482768619924e+83"],"^;","7.456482768619924e+83"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.2064842556154955e+84"],"^;","1.2064842556154955e+84"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.952132532477488e+84"],"^;","1.952132532477488e+84"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.1586167880929834e+84"],"^;","3.1586167880929834e+84"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.110749320570471e+84"],"^;","5.110749320570471e+84"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.269366108663455e+84"],"^;","8.269366108663455e+84"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.3380115429233926e+85"],"^;","1.3380115429233926e+85"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.164948153789738e+85"],"^;","2.164948153789738e+85"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.5029596967131306e+85"],"^;","3.5029596967131306e+85"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.667907850502869e+85"],"^;","5.667907850502869e+85"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.170867547216e+85"],"^;","9.170867547216e+85"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.483877539771887e+86"],"^;","1.483877539771887e+86"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.400964294493487e+86"],"^;","2.400964294493487e+86"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.884841834265374e+86"],"^;","3.884841834265374e+86"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.285806128758862e+86"],"^;","6.285806128758862e+86"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.0170647963024235e+87"],"^;","1.0170647963024235e+87"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.6456454091783097e+87"],"^;","1.6456454091783097e+87"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.662710205480733e+87"],"^;","2.662710205480733e+87"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.308355614659043e+87"],"^;","4.308355614659043e+87"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.971065820139776e+87"],"^;","6.971065820139776e+87"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.127942143479882e+88"],"^;","1.127942143479882e+88"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.8250487254938595e+88"],"^;","1.8250487254938595e+88"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.9529908689737415e+88"],"^;","2.9529908689737415e+88"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.7780395944676006e+88"],"^;","4.7780395944676006e+88"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.731030463441342e+88"],"^;","7.731030463441342e+88"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.2509070057908943e+89"],"^;","1.2509070057908943e+89"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.0240100521350286e+89"],"^;","2.0240100521350286e+89"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.274917057925923e+89"],"^;","3.274917057925923e+89"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.298927110060952e+89"],"^;","5.298927110060952e+89"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.573844167986874e+89"],"^;","8.573844167986874e+89"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.3872771278047826e+90"],"^;","1.3872771278047826e+90"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.24466154460347e+90"],"^;","2.24466154460347e+90"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.631938672408253e+90"],"^;","3.631938672408253e+90"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.876600217011723e+90"],"^;","5.876600217011723e+90"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.508538889419975e+90"],"^;","9.508538889419975e+90"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.5385139106431697e+91"],"^;","1.5385139106431697e+91"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.489367799585167e+91"],"^;","2.489367799585167e+91"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.0278817102283365e+91"],"^;","4.0278817102283365e+91"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.5172495098135036e+91"],"^;","6.5172495098135036e+91"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.054513122004184e+92"],"^;","1.054513122004184e+92"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.7062380729855341e+92"],"^;","1.7062380729855341e+92"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.760751194989718e+92"],"^;","2.760751194989718e+92"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.466989267975252e+92"],"^;","4.466989267975252e+92"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.22774046296497e+92"],"^;","7.22774046296497e+92"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.1694729730940222e+93"],"^;","1.1694729730940222e+93"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.8922470193905192e+93"],"^;","1.8922470193905192e+93"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.0617199924845414e+93"],"^;","3.0617199924845414e+93"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.95396701187506e+93"],"^;","4.95396701187506e+93"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.015687004359602e+93"],"^;","8.015687004359602e+93"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.2969654016234662e+94"],"^;","1.2969654016234662e+94"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.0985341020594266e+94"],"^;","2.0985341020594266e+94"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.395499503682893e+94"],"^;","3.395499503682893e+94"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.4940336057423194e+94"],"^;","5.4940336057423194e+94"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.889533109425212e+94"],"^;","8.889533109425212e+94"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.438356671516753e+95"],"^;","1.438356671516753e+95"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.327309982459274e+95"],"^;","2.327309982459274e+95"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.765666653976027e+95"],"^;","3.765666653976027e+95"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.092976636435301e+95"],"^;","6.092976636435301e+95"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.858643290411328e+95"],"^;","9.858643290411328e+95"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.5951619926846628e+96"],"^;","1.5951619926846628e+96"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.5810263217257956e+96"],"^;","2.5810263217257956e+96"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.1761883144104584e+96"],"^;","4.1761883144104584e+96"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.7572146361362535e+96"],"^;","6.7572146361362535e+96"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.0933402950546712e+97"],"^;","1.0933402950546712e+97"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.7690617586682965e+97"],"^;","1.7690617586682965e+97"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.8624020537229677e+97"],"^;","2.8624020537229677e+97"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.631463812391264e+97"],"^;","4.631463812391264e+97"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.493865866114232e+97"],"^;","7.493865866114232e+97"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.2125329678505497e+98"],"^;","1.2125329678505497e+98"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.961919554461973e+98"],"^;","1.961919554461973e+98"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.1744525223125226e+98"],"^;","3.1744525223125226e+98"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.1363720767744955e+98"],"^;","5.1363720767744955e+98"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.310824599087018e+98"],"^;","8.310824599087018e+98"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.3447196675861514e+99"],"^;","1.3447196675861514e+99"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.175802127494853e+99"],"^;","2.175802127494853e+99"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.520521795081005e+99"],"^;","3.520521795081005e+99"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.696323922575858e+99"],"^;","5.696323922575858e+99"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.216845717656862e+99"],"^;","9.216845717656862e+99"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.491316964023272e+100"],"^;","1.491316964023272e+100"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.413001535788958e+100"],"^;","2.413001535788958e+100"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.90431849981223e+100"],"^;","3.90431849981223e+100"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.317320035601188e+100"],"^;","6.317320035601188e+100"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.0221638535413418e+101"],"^;","1.0221638535413418e+101"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.6538958571014605e+101"],"^;","1.6538958571014605e+101"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.6760597106428023e+101"],"^;","2.6760597106428023e+101"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.329955567744263e+101"],"^;","4.329955567744263e+101"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.006015278387065e+101"],"^;","7.006015278387065e+101"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.1335970846131328e+102"],"^;","1.1335970846131328e+102"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.8341986124518392e+102"],"^;","1.8341986124518392e+102"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.967795697064972e+102"],"^;","2.967795697064972e+102"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.801994309516812e+102"],"^;","4.801994309516812e+102"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.769790006581784e+102"],"^;","7.769790006581784e+102"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.2571784316098597e+103"],"^;","1.2571784316098597e+103"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.034157432268038e+103"],"^;","2.034157432268038e+103"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.2913358638778977e+103"],"^;","3.2913358638778977e+103"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.325493296145936e+103"],"^;","5.325493296145936e+103"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.616829160023833e+103"],"^;","8.616829160023833e+103"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.394232245616977e+104"],"^;","1.394232245616977e+104"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.2559151616193602e+104"],"^;","2.2559151616193602e+104"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.6501474072363375e+104"],"^;","3.6501474072363375e+104"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.906062568855698e+104"],"^;","5.906062568855698e+104"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.556209976092036e+104"],"^;","9.556209976092036e+104"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.5462272544947735e+105"],"^;","1.5462272544947735e+105"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.501848252103977e+105"],"^;","2.501848252103977e+105"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.0480755065987505e+105"],"^;","4.0480755065987505e+105"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.549923758702727e+105"],"^;","6.549923758702727e+105"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.0597999265301477e+106"],"^;","1.0597999265301477e+106"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.7147923024004204e+106"],"^;","1.7147923024004204e+106"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.774592228930568e+106"],"^;","2.774592228930568e+106"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.4893845313309884e+106"],"^;","4.4893845313309884e+106"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.263976760261557e+106"],"^;","7.263976760261557e+106"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.1753361291592545e+107"],"^;","1.1753361291592545e+107"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.9017338051854102e+107"],"^;","1.9017338051854102e+107"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.0770699343446646e+107"],"^;","3.0770699343446646e+107"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.978803739530075e+107"],"^;","4.978803739530075e+107"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.055873673874739e+107"],"^;","8.055873673874739e+107"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.3034677413404814e+108"],"^;","1.3034677413404814e+108"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.1090551087279553e+108"],"^;","2.1090551087279553e+108"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.412522850068437e+108"],"^;","3.412522850068437e+108"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.521577958796393e+108"],"^;","5.521577958796393e+108"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.93410080886483e+108"],"^;","8.93410080886483e+108"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.4455678767661223e+109"],"^;","1.4455678767661223e+109"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.3389779576526055e+109"],"^;","2.3389779576526055e+109"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.784545834418728e+109"],"^;","3.784545834418728e+109"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.123523792071334e+109"],"^;","6.123523792071334e+109"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.908069626490062e+109"],"^;","9.908069626490062e+109"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.6031593418561396e+110"],"^;","1.6031593418561396e+110"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.5939663045051458e+110"],"^;","2.5939663045051458e+110"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.197125646361285e+110"],"^;","4.197125646361285e+110"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.791091950866431e+110"],"^;","6.791091950866431e+110"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.0988217597227716e+111"],"^;","1.0988217597227716e+111"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.7779309548094147e+111"],"^;","1.7779309548094147e+111"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.8767527145321864e+111"],"^;","2.8767527145321864e+111"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.654683669341601e+111"],"^;","4.654683669341601e+111"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.531436383873787e+111"],"^;","7.531436383873787e+111"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.218612005321539e+112"],"^;","1.218612005321539e+112"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.9717556437089175e+112"],"^;","1.9717556437089175e+112"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.1903676490304564e+112"],"^;","3.1903676490304564e+112"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.162123292739374e+112"],"^;","5.162123292739374e+112"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.35249094176983e+112"],"^;","8.35249094176983e+112"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.3514614234509204e+113"],"^;","1.3514614234509204e+113"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.1867105176279034e+113"],"^;","2.1867105176279034e+113"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.538171941078824e+113"],"^;","3.538171941078824e+113"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.724882458706727e+113"],"^;","5.724882458706727e+113"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.263054399785552e+113"],"^;","9.263054399785552e+113"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.498793685849228e+114"],"^;","1.498793685849228e+114"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.4250991258277832e+114"],"^;","2.4250991258277832e+114"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.923892811677011e+114"],"^;","3.923892811677011e+114"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.348991937504794e+114"],"^;","6.348991937504794e+114"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.0272884749181806e+115"],"^;","1.0272884749181806e+115"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.6621876686686599e+115"],"^;","1.6621876686686599e+115"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.6894761435868405e+115"],"^;","2.6894761435868405e+115"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.3516638122555e+115"],"^;","4.3516638122555e+115"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.041139955842341e+115"],"^;","7.041139955842341e+115"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.1392803768097841e+116"],"^;","1.1392803768097841e+116"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.8433943723940184e+116"],"^;","1.8433943723940184e+116"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.9826747492038025e+116"],"^;","2.9826747492038025e+116"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.826069121597821e+116"],"^;","4.826069121597821e+116"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.808743870801623e+116"],"^;","7.808743870801623e+116"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.2634812992399444e+117"],"^;","1.2634812992399444e+117"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.0443556863201068e+117"],"^;","2.0443556863201068e+117"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.307836985560051e+117"],"^;","3.307836985560051e+117"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.352192671880158e+117"],"^;","5.352192671880158e+117"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.660029657440209e+117"],"^;","8.660029657440209e+117"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.4012222329320367e+118"],"^;","1.4012222329320367e+118"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.2672251986760575e+118"],"^;","2.2672251986760575e+118"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.668447431608094e+118"],"^;","3.668447431608094e+118"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.935672630284151e+118"],"^;","5.935672630284151e+118"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.604120061892246e+118"],"^;","9.604120061892246e+118"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.5539792692176397e+119"],"^;","1.5539792692176397e+119"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.514391275406864e+119"],"^;","2.514391275406864e+119"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.0683705446245036e+119"],"^;","4.0683705446245036e+119"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.582761820031368e+119"],"^;","6.582761820031368e+119"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.065113236465587e+120"],"^;","1.065113236465587e+120"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.7233894184687237e+120"],"^;","1.7233894184687237e+120"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.788502654934311e+120"],"^;","2.788502654934311e+120"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.5118920734030345e+120"],"^;","4.5118920734030345e+120"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.300394728337345e+120"],"^;","7.300394728337345e+120"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.181228680174038e+121"],"^;","1.181228680174038e+121"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.9112681530077724e+121"],"^;","1.9112681530077724e+121"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.0924968331818106e+121"],"^;","3.0924968331818106e+121"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.003764986189583e+121"],"^;","5.003764986189583e+121"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.096261819371394e+121"],"^;","8.096261819371394e+121"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.3100026805560978e+122"],"^;","1.3100026805560978e+122"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.119628862493237e+122"],"^;","2.119628862493237e+122"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.429631543049335e+122"],"^;","3.429631543049335e+122"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.549260405542572e+122"],"^;","5.549260405542572e+122"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.978891948591907e+122"],"^;","8.978891948591907e+122"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.452815235413448e+123"],"^;","1.452815235413448e+123"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.3507044302726385e+123"],"^;","2.3507044302726385e+123"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.803519665686087e+123"],"^;","3.803519665686087e+123"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.154224095958725e+123"],"^;","6.154224095958725e+123"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.957743761644812e+123"],"^;","9.957743761644812e+123"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.6111967857603536e+124"],"^;","1.6111967857603536e+124"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.6069711619248347e+124"],"^;","2.6069711619248347e+124"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.2181679476851883e+124"],"^;","4.2181679476851883e+124"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.825139109610023e+124"],"^;","6.825139109610023e+124"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.1043307057295211e+125"],"^;","1.1043307057295211e+125"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.7868446166905234e+125"],"^;","1.7868446166905234e+125"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.8911753224200445e+125"],"^;","2.8911753224200445e+125"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.678019939110568e+125"],"^;","4.678019939110568e+125"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.569195261530612e+125"],"^;","7.569195261530612e+125"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.224721520064118e+126"],"^;","1.224721520064118e+126"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.981641046217179e+126"],"^;","1.981641046217179e+126"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.206362566281297e+126"],"^;","3.206362566281297e+126"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.188003612498476e+126"],"^;","5.188003612498476e+126"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.394366178779773e+126"],"^;","8.394366178779773e+126"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.358236979127825e+127"],"^;","1.358236979127825e+127"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.1976735970058023e+127"],"^;","2.1976735970058023e+127"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.5559105761336274e+127"],"^;","3.5559105761336274e+127"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.75358417313943e+127"],"^;","5.75358417313943e+127"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.309494749273056e+127"],"^;","9.309494749273056e+127"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.5063078922412486e+128"],"^;","1.5063078922412486e+128"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.437257367168554e+128"],"^;","2.437257367168554e+128"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.943565259409803e+128"],"^;","3.943565259409803e+128"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.380822626578357e+128"],"^;","6.380822626578357e+128"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.032438788598816e+129"],"^;","1.032438788598816e+129"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.6705210512566517e+129"],"^;","1.6705210512566517e+129"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.7029598398554676e+129"],"^;","2.7029598398554676e+129"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.3734808911121193e+129"],"^;","4.3734808911121193e+129"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.076440730967588e+129"],"^;","7.076440730967588e+129"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.1449921622079707e+130"],"^;","1.1449921622079707e+130"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.8526362353047294e+130"],"^;","1.8526362353047294e+130"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.9976283975127e+130"],"^;","2.9976283975127e+130"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.85026463281743e+130"],"^;","4.85026463281743e+130"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.84789303033013e+130"],"^;","7.84789303033013e+130"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.269815766314756e+131"],"^;","1.269815766314756e+131"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.054605069347769e+131"],"^;","2.054605069347769e+131"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.324420835662525e+131"],"^;","3.324420835662525e+131"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.379025905010295e+131"],"^;","5.379025905010295e+131"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.70344674067282e+131"],"^;","8.70344674067282e+131"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.4082472645683115e+132"],"^;","1.4082472645683115e+132"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.2785919386355933e+132"],"^;","2.2785919386355933e+132"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.6868392032039045e+132"],"^;","3.6868392032039045e+132"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.965431141839498e+132"],"^;","5.965431141839498e+132"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.652270345043403e+132"],"^;","9.652270345043403e+132"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.5617701486882901e+133"],"^;","1.5617701486882901e+133"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.52699718319263e+133"],"^;","2.52699718319263e+133"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.08876733188092e+133"],"^;","4.08876733188092e+133"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.61576451507355e+133"],"^;","6.61576451507355e+133"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.070453184695447e+134"],"^;","1.070453184695447e+134"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.732029636202802e+134"],"^;","1.732029636202802e+134"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.802482820898249e+134"],"^;","2.802482820898249e+134"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.534512457101051e+134"],"^;","4.534512457101051e+134"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.3369952779993e+134"],"^;","7.3369952779993e+134"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.1871507735100351e+135"],"^;","1.1871507735100351e+135"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.920850301309965e+135"],"^;","1.920850301309965e+135"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.1080010748200005e+135"],"^;","3.1080010748200005e+135"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.0288513761299655e+135"],"^;","5.0288513761299655e+135"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.136852450949967e+135"],"^;","8.136852450949967e+135"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.3165703827079932e+136"],"^;","1.3165703827079932e+136"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.1302556278029898e+136"],"^;","2.1302556278029898e+136"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.446826010510983e+136"],"^;","3.446826010510983e+136"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.577081638313973e+136"],"^;","5.577081638313973e+136"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.023907648824956e+136"],"^;","9.023907648824956e+136"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.460098928713893e+137"],"^;","1.460098928713893e+137"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.3624896935963886e+137"],"^;","2.3624896935963886e+137"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.822588622310282e+137"],"^;","3.822588622310282e+137"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.1850783159066705e+137"],"^;","6.1850783159066705e+137"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.0007666938216952e+138"],"^;","1.0007666938216952e+138"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.6192745254123623e+138"],"^;","1.6192745254123623e+138"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.6200412192340575e+138"],"^;","2.6200412192340575e+138"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.2393157446464195e+138"],"^;","4.2393157446464195e+138"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.859356963880477e+138"],"^;","6.859356963880477e+138"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.1098672708526896e+139"],"^;","1.1098672708526896e+139"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.7958029672407375e+139"],"^;","1.7958029672407375e+139"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.905670238093427e+139"],"^;","2.905670238093427e+139"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.7014732053341643e+139"],"^;","4.7014732053341643e+139"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.607143443427591e+139"],"^;","7.607143443427591e+139"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.2308616648761756e+140"],"^;","1.2308616648761756e+140"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.9915760092189344e+140"],"^;","1.9915760092189344e+140"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.22243767409511e+140"],"^;","3.22243767409511e+140"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.2140136833140446e+140"],"^;","5.2140136833140446e+140"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.436451357409155e+140"],"^;","8.436451357409155e+140"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.36504650407232e+141"],"^;","1.36504650407232e+141"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.2086916398132357e+141"],"^;","2.2086916398132357e+141"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.573738143885556e+141"],"^;","3.573738143885556e+141"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.782429783698791e+141"],"^;","5.782429783698791e+141"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.356167927584346e+141"],"^;","9.356167927584346e+141"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.513859771128314e+142"],"^;","1.513859771128314e+142"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.4494765638867485e+142"],"^;","2.4494765638867485e+142"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.9633363350150624e+142"],"^;","3.9633363350150624e+142"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.412812898901811e+142"],"^;","6.412812898901811e+142"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.0376149233916874e+143"],"^;","1.0376149233916874e+143"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.6788962132818685e+143"],"^;","1.6788962132818685e+143"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.716511136673556e+143"],"^;","2.716511136673556e+143"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.395407349955425e+143"],"^;","4.395407349955425e+143"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.111918486628981e+143"],"^;","7.111918486628981e+143"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.1507325836584407e+144"],"^;","1.1507325836584407e+144"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.861924432321339e+144"],"^;","1.861924432321339e+144"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.0126570159797796e+144"],"^;","3.0126570159797796e+144"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.8745814483011185e+144"],"^;","4.8745814483011185e+144"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.887238464280898e+144"],"^;","7.887238464280898e+144"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.2761819912582017e+145"],"^;","1.2761819912582017e+145"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.0649058376862915e+145"],"^;","2.0649058376862915e+145"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.3410878289444935e+145"],"^;","3.3410878289444935e+145"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.405993666630785e+145"],"^;","5.405993666630785e+145"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.747081495575278e+145"],"^;","8.747081495575278e+145"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.4153075162206063e+146"],"^;","1.4153075162206063e+146"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.2900156657781344e+146"],"^;","2.2900156657781344e+146"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.7053231819987407e+146"],"^;","3.7053231819987407e+146"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.995338847776875e+146"],"^;","5.995338847776875e+146"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.700662029775616e+146"],"^;","9.700662029775616e+146"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.5696000877552492e+147"],"^;","1.5696000877552492e+147"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.5396662907328107e+147"],"^;","2.5396662907328107e+147"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.10926637848806e+147"],"^;","4.10926637848806e+147"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.648932669220871e+147"],"^;","6.648932669220871e+147"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.0758199047708932e+148"],"^;","1.0758199047708932e+148"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.7407131716929801e+148"],"^;","1.7407131716929801e+148"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.8165330764638734e+148"],"^;","2.8165330764638734e+148"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.5572462481568536e+148"],"^;","4.5572462481568536e+148"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.373779324620727e+148"],"^;","7.373779324620727e+148"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.193102557277758e+149"],"^;","1.193102557277758e+149"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.9304804897398307e+149"],"^;","1.9304804897398307e+149"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.1235830470175887e+149"],"^;","3.1235830470175887e+149"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.054063536757419e+149"],"^;","5.054063536757419e+149"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.177646583775008e+149"],"^;","8.177646583775008e+149"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.3231710120532428e+150"],"^;","1.3231710120532428e+150"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.1409356704307436e+150"],"^;","2.1409356704307436e+150"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.464106682483987e+150"],"^;","3.464106682483987e+150"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.60504235291473e+150"],"^;","5.60504235291473e+150"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.069149035398718e+150"],"^;","9.069149035398718e+150"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.4674191388313447e+151"],"^;","1.4674191388313447e+151"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.3743340423712165e+151"],"^;","2.3743340423712165e+151"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.841753181202561e+151"],"^;","3.841753181202561e+151"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.216087223573778e+151"],"^;","6.216087223573778e+151"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.0057840404776338e+152"],"^;","1.0057840404776338e+152"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.6273927628350117e+152"],"^;","1.6273927628350117e+152"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.6331768033126457e+152"],"^;","2.6331768033126457e+152"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.260569566147657e+152"],"^;","4.260569566147657e+152"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.893746369460303e+152"],"^;","6.893746369460303e+152"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.115431593560796e+153"],"^;","1.115431593560796e+153"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.8048062305068262e+153"],"^;","1.8048062305068262e+153"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.920237824067622e+153"],"^;","2.920237824067622e+153"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.725044054574448e+153"],"^;","4.725044054574448e+153"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.64528187864207e+153"],"^;","7.64528187864207e+153"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.2370325933216519e+154"],"^;","1.2370325933216519e+154"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.001560781185859e+154"],"^;","2.001560781185859e+154"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.238593374507511e+154"],"^;","3.238593374507511e+154"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.24015415569337e+154"],"^;","5.24015415569337e+154"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.478747530200881e+154"],"^;","8.478747530200881e+154"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.3718901685894252e+155"],"^;","1.3718901685894252e+155"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.219764921609513e+155"],"^;","2.219764921609513e+155"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.5916550901989383e+155"],"^;","3.5916550901989383e+155"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.811420011808452e+155"],"^;","5.811420011808452e+155"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.403075102007391e+155"],"^;","9.403075102007391e+155"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.5214495113815843e+156"],"^;","1.5214495113815843e+156"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.4617570215823236e+156"],"^;","2.4617570215823236e+156"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.983206532963908e+156"],"^;","3.983206532963908e+156"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.444963554546232e+156"],"^;","6.444963554546232e+156"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.042817008751014e+157"],"^;","1.042817008751014e+157"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.6873133642056372e+157"],"^;","1.6873133642056372e+157"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.7301303729566514e+157"],"^;","2.7301303729566514e+157"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.4174437371622886e+157"],"^;","4.4174437371622886e+157"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.147574110118939e+157"],"^;","7.147574110118939e+157"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.1565017847281227e+158"],"^;","1.1565017847281227e+158"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.8712591957400167e+158"],"^;","1.8712591957400167e+158"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.0277609804681397e+158"],"^;","3.0277609804681397e+158"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.899020176208156e+158"],"^;","4.899020176208156e+158"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.926781156676296e+158"],"^;","7.926781156676296e+158"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.2825801332884451e+159"],"^;","1.2825801332884451e+159"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.075258248956075e+159"],"^;","2.075258248956075e+159"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.35783838224452e+159"],"^;","3.35783838224452e+159"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.433096631200595e+159"],"^;","5.433096631200595e+159"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.790935013445115e+159"],"^;","8.790935013445115e+159"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.422403164464571e+160"],"^;","1.422403164464571e+160"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.3014966658090826e+160"],"^;","2.3014966658090826e+160"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.723899830273653e+160"],"^;","3.723899830273653e+160"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.025396496082736e+160"],"^;","6.025396496082736e+160"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.749296326356389e+160"],"^;","9.749296326356389e+160"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.5774692822439125e+161"],"^;","1.5774692822439125e+161"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.552398914879551e+161"],"^;","2.552398914879551e+161"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.1298681971234637e+161"],"^;","4.1298681971234637e+161"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.682267112003014e+161"],"^;","6.682267112003014e+161"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.0812135309126478e+162"],"^;","1.0812135309126478e+162"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.7494402421129492e+162"],"^;","1.7494402421129492e+162"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.8306537730255968e+162"],"^;","2.8306537730255968e+162"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.580094015138546e+162"],"^;","4.580094015138546e+162"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.410747788164143e+162"],"^;","7.410747788164143e+162"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.1990841803302688e+163"],"^;","1.1990841803302688e+163"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.940158959146683e+163"],"^;","1.940158959146683e+163"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.1392431394769516e+163"],"^;","3.1392431394769516e+163"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.0794020986236347e+163"],"^;","5.0794020986236347e+163"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.218645238100586e+163"],"^;","8.218645238100586e+163"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.329804733672422e+164"],"^;","1.329804733672422e+164"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.1516692574824805e+164"],"^;","2.1516692574824805e+164"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.4814739911549024e+164"],"^;","3.4814739911549024e+164"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.633143248637383e+164"],"^;","5.633143248637383e+164"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.114617239792286e+164"],"^;","9.114617239792286e+164"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.474776048842967e+165"],"^;","1.474776048842967e+165"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.3862377728221955e+165"],"^;","2.3862377728221955e+165"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.8610138216651624e+165"],"^;","3.8610138216651624e+165"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.2472515944873575e+165"],"^;","6.2472515944873575e+165"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.010826541615252e+166"],"^;","1.010826541615252e+166"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.635551701063988e+166"],"^;","1.635551701063988e+166"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.64637824267924e+166"],"^;","2.64637824267924e+166"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.281929943743228e+166"],"^;","4.281929943743228e+166"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.928308186422468e+166"],"^;","6.928308186422468e+166"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.1210238130165696e+167"],"^;","1.1210238130165696e+167"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.8138546316588163e+167"],"^;","1.8138546316588163e+167"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.934878444675386e+167"],"^;","2.934878444675386e+167"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.748733076334203e+167"],"^;","4.748733076334203e+167"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.683611521009589e+167"],"^;","7.683611521009589e+167"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.2432344597343791e+168"],"^;","1.2432344597343791e+168"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.011595611835338e+168"],"^;","2.011595611835338e+168"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.2548300715697173e+168"],"^;","3.2548300715697173e+168"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.266425683405056e+168"],"^;","5.266425683405056e+168"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.521255754974774e+168"],"^;","8.521255754974774e+168"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.378768143837983e+169"],"^;","1.378768143837983e+169"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.2308937193354602e+169"],"^;","2.2308937193354602e+169"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.6096618631734433e+169"],"^;","3.6096618631734433e+169"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.8405555825089035e+169"],"^;","5.8405555825089035e+169"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.450217445682346e+169"],"^;","9.450217445682346e+169"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.529077302819125e+170"],"^;","1.529077302819125e+170"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.47409904738736e+170"],"^;","2.47409904738736e+170"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.0031763502064847e+170"],"^;","4.0031763502064847e+170"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.477275397593844e+170"],"^;","6.477275397593844e+170"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.048045174780033e+171"],"^;","1.048045174780033e+171"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.6957727145394175e+171"],"^;","1.6957727145394175e+171"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.7438178893194507e+171"],"^;","2.7438178893194507e+171"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.439590603858868e+171"],"^;","4.439590603858868e+171"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.183408493178319e+171"],"^;","7.183408493178319e+171"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.1622999097037188e+172"],"^;","1.1622999097037188e+172"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.8806407590215506e+172"],"^;","1.8806407590215506e+172"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.0429406687252694e+172"],"^;","3.0429406687252694e+172"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.92358142774682e+172"],"^;","4.92358142774682e+172"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.96652209647209e+172"],"^;","7.96652209647209e+172"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.289010352421891e+173"],"^;","1.289010352421891e+173"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.0856625620690997e+173"],"^;","2.0856625620690997e+173"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.3746729144909907e+173"],"^;","3.3746729144909907e+173"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.46033547656009e+173"],"^;","5.46033547656009e+173"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.83500839105108e+173"],"^;","8.83500839105108e+173"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.429534386761117e+174"],"^;","1.429534386761117e+174"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.313035225866225e+174"],"^;","2.313035225866225e+174"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.742569612627342e+174"],"^;","3.742569612627342e+174"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.055604838493567e+174"],"^;","6.055604838493567e+174"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.79817445112091e+174"],"^;","9.79817445112091e+174"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.5853779289614475e+175"],"^;","1.5853779289614475e+175"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.5651953740735385e+175"],"^;","2.5651953740735385e+175"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.150573303034986e+175"],"^;","4.150573303034986e+175"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.715768677108524e+175"],"^;","6.715768677108524e+175"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.0866341980143511e+176"],"^;","1.0866341980143511e+176"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.7582110657252035e+176"],"^;","1.7582110657252035e+176"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.8448452637395545e+176"],"^;","2.8448452637395545e+176"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.603056329464758e+176"],"^;","4.603056329464758e+176"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.447901593204313e+176"],"^;","7.447901593204313e+176"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.205095792266907e+177"],"^;","1.205095792266907e+177"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.9498859515873383e+177"],"^;","1.9498859515873383e+177"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.1549817438542456e+177"],"^;","3.1549817438542456e+177"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.104867695441584e+177"],"^;","5.104867695441584e+177"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.25984943929583e+177"],"^;","8.25984943929583e+177"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.3364717134737413e+178"],"^;","1.3364717134737413e+178"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.1624566574033242e+178"],"^;","2.1624566574033242e+178"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.498928370877066e+178"],"^;","3.498928370877066e+178"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.6613850282803905e+178"],"^;","5.6613850282803905e+178"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.160313399157456e+178"],"^;","9.160313399157456e+178"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.4821698427437848e+179"],"^;","1.4821698427437848e+179"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.3982011826595303e+179"],"^;","2.3982011826595303e+179"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.880371025403315e+179"],"^;","3.880371025403315e+179"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.278572208062845e+179"],"^;","6.278572208062845e+179"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.0158943233466161e+180"],"^;","1.0158943233466161e+180"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.6437515441529006e+180"],"^;","1.6437515441529006e+180"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.6596458674995166e+180"],"^;","2.6596458674995166e+180"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.303397411652417e+180"],"^;","4.303397411652417e+180"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.963043279151934e+180"],"^;","6.963043279151934e+180"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.126644069080435e+181"],"^;","1.126644069080435e+181"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.8229483969956285e+181"],"^;","1.8229483969956285e+181"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.9495924660760636e+181"],"^;","2.9495924660760636e+181"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.772540863071692e+181"],"^;","4.772540863071692e+181"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.722133329147755e+181"],"^;","7.722133329147755e+181"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.2494674192219447e+182"],"^;","1.2494674192219447e+182"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.0216807521367203e+182"],"^;","2.0216807521367203e+182"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.271148171358665e+182"],"^;","3.271148171358665e+182"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.2928289234953855e+182"],"^;","5.2928289234953855e+182"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.56397709485405e+182"],"^;","8.56397709485405e+182"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.3856806018349436e+183"],"^;","1.3856806018349436e+183"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.2420783113203486e+183"],"^;","2.2420783113203486e+183"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.627758913155292e+183"],"^;","3.627758913155292e+183"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.869837224475641e+183"],"^;","5.869837224475641e+183"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.497596137630933e+183"],"^;","9.497596137630933e+183"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.5367433362106574e+184"],"^;","1.5367433362106574e+184"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.4865029499737505e+184"],"^;","2.4865029499737505e+184"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.023246286184408e+184"],"^;","4.023246286184408e+184"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.509749236158159e+184"],"^;","6.509749236158159e+184"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.0532995522342567e+185"],"^;","1.0532995522342567e+185"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.7042744758500726e+185"],"^;","1.7042744758500726e+185"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.757574028084329e+185"],"^;","2.757574028084329e+185"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.461848503934402e+185"],"^;","4.461848503934402e+185"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.219422532018732e+185"],"^;","7.219422532018732e+185"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.1681271035953133e+186"],"^;","1.1681271035953133e+186"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.8900693567971865e+186"],"^;","1.8900693567971865e+186"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.0581964603925e+186"],"^;","3.0581964603925e+186"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.948265817189686e+186"],"^;","4.948265817189686e+186"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.006462277582186e+186"],"^;","8.006462277582186e+186"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.2954728094771872e+187"],"^;","1.2954728094771872e+187"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.096119037235406e+187"],"^;","2.096119037235406e+187"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.391591846712593e+187"],"^;","3.391591846712593e+187"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.487710883947999e+187"],"^;","5.487710883947999e+187"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.879302730660591e+187"],"^;","8.879302730660591e+187"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.436701361460859e+188"],"^;","1.436701361460859e+188"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.324631634526918e+188"],"^;","2.324631634526918e+188"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.761332995987777e+188"],"^;","3.761332995987777e+188"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.085964630514695e+188"],"^;","6.085964630514695e+188"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.847297626502471e+188"],"^;","9.847297626502471e+188"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.5933262257017168e+189"],"^;","1.5933262257017168e+189"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.578055988351964e+189"],"^;","2.578055988351964e+189"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.1713822140536807e+189"],"^;","4.1713822140536807e+189"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.749438202405644e+189"],"^;","6.749438202405644e+189"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.0920820416459324e+190"],"^;","1.0920820416459324e+190"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.7670258618864968e+190"],"^;","1.7670258618864968e+190"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.859107903532429e+190"],"^;","2.859107903532429e+190"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.626133765418926e+190"],"^;","4.626133765418926e+190"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.485241668951356e+190"],"^;","7.485241668951356e+190"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.211137543437028e+191"],"^;","1.211137543437028e+191"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.9596617103321636e+191"],"^;","1.9596617103321636e+191"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.170799253769192e+191"],"^;","3.170799253769192e+191"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.130460964101355e+191"],"^;","5.130460964101355e+191"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.301260217870547e+191"],"^;","8.301260217870547e+191"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.34317211819719e+192"],"^;","1.34317211819719e+192"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.1732981399842448e+192"],"^;","2.1732981399842448e+192"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.5164702581814347e+192"],"^;","3.5164702581814347e+192"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.689768398165679e+192"],"^;","5.689768398165679e+192"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.206238656347114e+192"],"^;","9.206238656347114e+192"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.4896007054512793e+193"],"^;","1.4896007054512793e+193"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.4102245710859905e+193"],"^;","2.4102245710859905e+193"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.89982527653727e+193"],"^;","3.89982527653727e+193"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.310049847623261e+193"],"^;","6.310049847623261e+193"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.020987512416053e+194"],"^;","1.020987512416053e+194"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.651992497178379e+194"],"^;","1.651992497178379e+194"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.6729800095944324e+194"],"^;","2.6729800095944324e+194"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.324972506772811e+194"],"^;","4.324972506772811e+194"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.997952516367244e+194"],"^;","6.997952516367244e+194"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.1322925023140055e+195"],"^;","1.1322925023140055e+195"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.8320877539507298e+195"],"^;","1.8320877539507298e+195"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.964380256264735e+195"],"^;","2.964380256264735e+195"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.796468010215465e+195"],"^;","4.796468010215465e+195"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.7608482664802e+195"],"^;","7.7608482664802e+195"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.2557316276695666e+196"],"^;","1.2557316276695666e+196"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.0318164543175863e+196"],"^;","2.0318164543175863e+196"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.287548081987153e+196"],"^;","3.287548081987153e+196"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.31936453630474e+196"],"^;","5.31936453630474e+196"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.606912618291892e+196"],"^;","8.606912618291892e+196"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.3926277154596632e+197"],"^;","1.3926277154596632e+197"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.2533189772888524e+197"],"^;","2.2533189772888524e+197"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.645946692748516e+197"],"^;","3.645946692748516e+197"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.899265670037368e+197"],"^;","5.899265670037368e+197"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.545212362785885e+197"],"^;","9.545212362785885e+197"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.5444478032823252e+198"],"^;","1.5444478032823252e+198"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.4989690395609137e+198"],"^;","2.4989690395609137e+198"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.0434168428432386e+198"],"^;","4.0434168428432386e+198"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.542385882404152e+198"],"^;","6.542385882404152e+198"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.058580272524739e+199"],"^;","1.058580272524739e+199"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.7128188607651542e+199"],"^;","1.7128188607651542e+199"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.771399133289893e+199"],"^;","2.771399133289893e+199"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.484217994055047e+199"],"^;","4.484217994055047e+199"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.25561712734494e+199"],"^;","7.25561712734494e+199"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.1739835121399988e+200"],"^;","1.1739835121399988e+200"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.8995452248744928e+200"],"^;","1.8995452248744928e+200"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.073528737014492e+200"],"^;","3.073528737014492e+200"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.9730739618889846e+200"],"^;","4.9730739618889846e+200"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.046602698903476e+200"],"^;","8.046602698903476e+200"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.301967666079246e+201"],"^;","1.301967666079246e+201"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.1066279359695935e+201"],"^;","2.1066279359695935e+201"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.4085956020488395e+201"],"^;","3.4085956020488395e+201"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.515223538018433e+201"],"^;","5.515223538018433e+201"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.923819140067273e+201"],"^;","8.923819140067273e+201"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.4439042678085704e+202"],"^;","1.4439042678085704e+202"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.3362861818152977e+202"],"^;","2.3362861818152977e+202"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.780190449623868e+202"],"^;","3.780190449623868e+202"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.116476631439166e+202"],"^;","6.116476631439166e+202"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.896667081063034e+202"],"^;","9.896667081063034e+202"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.6013143712502202e+203"],"^;","1.6013143712502202e+203"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.5909810793565236e+203"],"^;","2.5909810793565236e+203"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.192295450606744e+203"],"^;","4.192295450606744e+203"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.783276529963268e+203"],"^;","6.783276529963268e+203"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.0975571980570012e+204"],"^;","1.0975571980570012e+204"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.775884851053328e+204"],"^;","1.775884851053328e+204"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.873442049110329e+204"],"^;","2.873442049110329e+204"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"4.649326900163657e+204"],"^;","4.649326900163657e+204"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"7.522768949273986e+204"],"^;","7.522768949273986e+204"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.2172095849437642e+205"],"^;","1.2172095849437642e+205"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.9694864798711628e+205"],"^;","1.9694864798711628e+205"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.186696064814927e+205"],"^;","3.186696064814927e+205"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.15618254468609e+205"],"^;","5.15618254468609e+205"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"8.342878609501017e+205"],"^;","8.342878609501017e+205"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.3499061154187107e+206"],"^;","1.3499061154187107e+206"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.1841939763688122e+206"],"^;","2.1841939763688122e+206"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.534100091787523e+206"],"^;","3.534100091787523e+206"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"5.718294068156335e+206"],"^;","5.718294068156335e+206"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"9.252394159943859e+206"],"^;","9.252394159943859e+206"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.4970688228100194e+207"],"^;","1.4970688228100194e+207"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.4223082388044054e+207"],"^;","2.4223082388044054e+207"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"3.919377061614425e+207"],"^;","3.919377061614425e+207"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"6.34168530041883e+207"],"^;","6.34168530041883e+207"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.0261062362033255e+208"],"^;","1.0261062362033255e+208"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"1.6602747662452085e+208"],"^;","1.6602747662452085e+208"],["^ ","^0","^9","^:",["^3",["^ ","^4","clj-long"],"2.686381002448534e+208"],"^;","2.686381002448534e+208"]]],"^;","(0 1 1 2 3 5 8 13 21 34 55 89 144 233 377 610 987 1597 2584 4181 6765 10946 17711 28657 46368 75025 121393 196418 317811 514229 832040 1346269 2178309 3524578 5702887 9227465 14930352 24157817 39088169 63245986 102334155 165580141 267914296 433494437 701408733 1134903170 1836311903 2971215073 4807526976 7778742049 12586269025 20365011074 32951280099 53316291173 86267571272 139583862445 225851433717 365435296162 591286729879 956722026041 1548008755920 2504730781961 4052739537881 6557470319842 10610209857723 17167680177565 27777890035288 44945570212853 72723460248141 117669030460994 190392490709135 308061521170129 498454011879264 806515533049393 1304969544928657 2111485077978050 3416454622906707 5527939700884757 8944394323791464 14472334024676220 23416728348467684 37889062373143900 61305790721611580 99194853094755490 160500643816367070 259695496911122560 420196140727489660 679891637638612200 1100087778366101900 1779979416004714000 2880067194370816000 4660046610375530000 7540113804746346000 12200160415121877000 19740274219868226000 31940434634990100000 51680708854858330000 83621143489848430000 135301852344706760000 218922995834555200000 354224848179262000000 573147844013817200000 927372692193079200000 1.5005205362068963e+21 2.4278932283999755e+21 3.9284137646068717e+21 6.356306993006848e+21 1.028472075761372e+22 1.6641027750620568e+22 2.6925748508234288e+22 4.356677625885486e+22 7.049252476708914e+22 1.14059301025944e+23 1.8455182579303315e+23 2.9861112681897715e+23 4.831629526120103e+23 7.817740794309875e+23 1.2649370320429978e+24 2.0467111114739851e+24 3.3116481435169827e+24 5.358359254990968e+24 8.670007398507951e+24 1.402836665349892e+25 2.269837405200687e+25 3.6726740705505786e+25 5.942511475751265e+25 9.615185546301844e+25 1.555769702205311e+26 2.5172882568354952e+26 4.0730579590408064e+26 6.590346215876301e+26 1.0663404174917107e+27 1.7253750390793408e+27 2.791715456571052e+27 4.5170904956503927e+27 7.308805952221445e+27 1.1825896447871837e+28 1.9134702400093282e+28 3.096059884796512e+28 5.009530124805841e+28 8.105590009602353e+28 1.3115120134408193e+29 2.1220710144010545e+29 3.4335830278418734e+29 5.5556540422429276e+29 8.989237070084801e+29 1.454489111232773e+30 2.353412818241253e+30 3.807901929474026e+30 6.161314747715279e+30 9.969216677189305e+30 1.6130531424904583e+31 2.6099748102093888e+31 4.223027952699847e+31 6.8330027629092365e+31 1.1056030715609085e+32 1.788903347851832e+32 2.8945064194127406e+32 4.683409767264573e+32 7.577916186677313e+32 1.2261325953941887e+33 1.98392421406192e+33 3.2100568094561087e+33 5.193981023518028e+33 8.404037832974137e+33 1.3598018856492165e+34 2.20020566894663e+34 3.5600075545958467e+34 5.760213223542477e+34 9.320220778138323e+34 1.50804340016808e+35 2.4400654779819122e+35 3.9481088781499925e+35 6.388174356131905e+35 1.0336283234281898e+36 1.6724457590413803e+36 2.70607408246957e+36 4.37851984151095e+36 7.08459392398052e+36 1.146311376549147e+37 1.854770768947199e+37 3.001082145496346e+37 4.855852914443544e+37 7.85693505993989e+37 1.2712787974383434e+38 2.0569723034323324e+38 3.328251100870676e+38 5.385223404303009e+38 8.713474505173684e+38 1.409869790947669e+39 2.2812172414650375e+39 3.691087032412707e+39 5.972304273877745e+39 9.663391306290452e+39 1.5635695580168196e+40 2.529908688645865e+40 4.0934782466626846e+40 6.623386935308549e+40 1.0716865181971233e+41 1.7340252117279783e+41 2.8057117299251016e+41 4.53973694165308e+41 7.34544867157818e+41 1.188518561323126e+42 1.923063428480944e+42 3.11158198980407e+42 5.034645418285014e+42 8.146227408089083e+42 1.3180872826374099e+43 2.1327100234463182e+43 3.450797306083728e+43 5.583507329530046e+43 9.034304635613775e+43 1.4617811965143821e+44 2.3652116600757594e+44 3.826992856590142e+44 6.192204516665901e+44 1.0019197373256042e+45 1.6211401889921942e+45 2.6230599263177984e+45 4.2442001153099927e+45 6.86726004162779e+45 1.1111460156937784e+46 1.7978720198565574e+46 2.9090180355503355e+46 4.706890055406893e+46 7.615908090957229e+46 1.2322798146364122e+47 1.993870623732135e+47 3.2261504383685474e+47 5.2200210621006825e+47 8.44617150046923e+47 1.3666192562569911e+48 2.2112364063039142e+48 3.577855662560905e+48 5.7890920688648195e+48 9.366947731425724e+48 1.5156039800290544e+49 2.452298753171627e+49 3.967902733200681e+49 6.420201486372308e+49 1.0388104219572989e+50 1.6808305705945297e+50 2.7196409925518287e+50 4.400471563146358e+50 7.120112555698187e+50 1.1520584118844544e+51 1.864069667454273e+51 3.016128079338727e+51 4.880197746793e+51 7.896325826131728e+51 1.2776523572924728e+52 2.0672849399056455e+52 3.344937297198118e+52 5.412222237103764e+52 8.757159534301882e+52 1.4169381771405647e+53 2.2926541305707528e+53 3.7095923077113174e+53 6.002246438282071e+53 9.711838745993388e+53 1.571408518427546e+54 2.5425923930268848e+54 4.114000911454431e+54 6.656593304481316e+54 1.0770594215935747e+55 1.7427187520417062e+55 2.819778173635281e+55 4.562496925676987e+55 7.382275099312268e+55 1.1944772024989255e+56 1.9327047124301523e+56 3.1271819149290778e+56 5.05988662735923e+56 8.187068542288308e+56 1.3246955169647538e+57 2.1434023711935847e+57 3.4680978881583385e+57 5.611500259351923e+57 9.07959814751026e+57 1.4691098406862182e+58 2.3770696554372443e+58 3.846179496123462e+58 6.223249151560707e+58 1.0069428647684168e+59 1.6292677799244873e+59 2.636210644692904e+59 4.265478424617391e+59 6.901689069310295e+59 1.1167167493927686e+60 1.806885656323798e+60 2.923602405716567e+60 4.7304880620403654e+60 7.654090467756932e+60 1.2384578529797298e+61 2.003866899755423e+61 3.242324752735153e+61 5.246191652490576e+61 8.488516405225729e+61 1.3734708057716305e+62 2.2223224462942035e+62 3.5957932520658337e+62 5.818115698360037e+62 9.41390895042587e+62 1.5232024648785907e+63 2.4645933599211777e+63 3.987795824799768e+63 6.452389184720946e+63 1.0440185009520713e+64 1.6892574194241658e+64 2.733275920376237e+64 4.422533339800403e+64 7.15580926017664e+64 1.1578342599977044e+65 1.8734151860153683e+65 3.0312494460130726e+65 4.90466463202844e+65 7.9359140780415135e+65 1.2840578710069954e+66 2.0776492788111467e+66 3.361707149818142e+66 5.439356428629289e+66 8.801063578447432e+66 1.424042000707672e+67 2.3041483585524152e+67 3.728190359260087e+67 6.032338717812503e+67 9.760529077072589e+67 1.579286779488509e+68 2.555339687195768e+68 4.134626466684277e+68 6.689966153880045e+68 1.0824592620564322e+69 1.751455877444437e+69 2.833915139500869e+69 4.5853710169453055e+69 7.419286156446174e+69 1.200465717339148e+70 1.9423943329837654e+70 3.1428600503229136e+70 5.085254383306679e+70 8.228114433629592e+70 1.331336881693627e+71 2.1541483250565862e+71 3.485485206750213e+71 5.6396335318068e+71 9.125118738557013e+71 1.4764752270363813e+72 2.3889871008920825e+72 3.865462327928464e+72 6.254449428820547e+72 1.0119911756749011e+73 1.637436118556956e+73 2.649427294231857e+73 4.2868634127888125e+73 6.93629070702067e+73 1.1223154119809483e+74 1.8159444826830153e+74 2.9382598946639633e+74 4.754204377346978e+74 7.692464272010942e+74 1.244666864935792e+75 2.013913292136886e+75 3.258580157072678e+75 5.272493449209564e+75 8.531073606282242e+75 1.3803567055491806e+76 2.2334640661774048e+76 3.613820771726585e+76 5.84728483790399e+76 9.461105609630574e+76 1.5308390447534564e+77 2.476949605716514e+77 4.0077886504699705e+77 6.484738256186484e+77 1.0492526906656455e+78 1.697726516284294e+78 2.7469792069499394e+78 4.444705723234234e+78 7.191684930184173e+78 1.1636390653418406e+79 1.882807558360258e+79 3.046446623702099e+79 4.9292541820623566e+79 7.975700805764455e+79 1.290495498782681e+80 2.0880655793591266e+80 3.3785610781418077e+80 5.466626657500934e+80 8.845187735642742e+80 1.4311814393143676e+81 2.315700212878642e+81 3.7468816521930098e+81 6.062581865071651e+81 9.809463517264662e+81 1.5872045382336313e+82 2.5681508899600975e+82 4.155355428193729e+82 6.723506318153826e+82 1.0878861746347554e+83 1.760236806450138e+83 2.848122981084893e+83 4.608359787535031e+83 7.456482768619924e+83 1.2064842556154955e+84 1.952132532477488e+84 3.1586167880929834e+84 5.110749320570471e+84 8.269366108663455e+84 1.3380115429233926e+85 2.164948153789738e+85 3.5029596967131306e+85 5.667907850502869e+85 9.170867547216e+85 1.483877539771887e+86 2.400964294493487e+86 3.884841834265374e+86 6.285806128758862e+86 1.0170647963024235e+87 1.6456454091783097e+87 2.662710205480733e+87 4.308355614659043e+87 6.971065820139776e+87 1.127942143479882e+88 1.8250487254938595e+88 2.9529908689737415e+88 4.7780395944676006e+88 7.731030463441342e+88 1.2509070057908943e+89 2.0240100521350286e+89 3.274917057925923e+89 5.298927110060952e+89 8.573844167986874e+89 1.3872771278047826e+90 2.24466154460347e+90 3.631938672408253e+90 5.876600217011723e+90 9.508538889419975e+90 1.5385139106431697e+91 2.489367799585167e+91 4.0278817102283365e+91 6.5172495098135036e+91 1.054513122004184e+92 1.7062380729855341e+92 2.760751194989718e+92 4.466989267975252e+92 7.22774046296497e+92 1.1694729730940222e+93 1.8922470193905192e+93 3.0617199924845414e+93 4.95396701187506e+93 8.015687004359602e+93 1.2969654016234662e+94 2.0985341020594266e+94 3.395499503682893e+94 5.4940336057423194e+94 8.889533109425212e+94 1.438356671516753e+95 2.327309982459274e+95 3.765666653976027e+95 6.092976636435301e+95 9.858643290411328e+95 1.5951619926846628e+96 2.5810263217257956e+96 4.1761883144104584e+96 6.7572146361362535e+96 1.0933402950546712e+97 1.7690617586682965e+97 2.8624020537229677e+97 4.631463812391264e+97 7.493865866114232e+97 1.2125329678505497e+98 1.961919554461973e+98 3.1744525223125226e+98 5.1363720767744955e+98 8.310824599087018e+98 1.3447196675861514e+99 2.175802127494853e+99 3.520521795081005e+99 5.696323922575858e+99 9.216845717656862e+99 1.491316964023272e+100 2.413001535788958e+100 3.90431849981223e+100 6.317320035601188e+100 1.0221638535413418e+101 1.6538958571014605e+101 2.6760597106428023e+101 4.329955567744263e+101 7.006015278387065e+101 1.1335970846131328e+102 1.8341986124518392e+102 2.967795697064972e+102 4.801994309516812e+102 7.769790006581784e+102 1.2571784316098597e+103 2.034157432268038e+103 3.2913358638778977e+103 5.325493296145936e+103 8.616829160023833e+103 1.394232245616977e+104 2.2559151616193602e+104 3.6501474072363375e+104 5.906062568855698e+104 9.556209976092036e+104 1.5462272544947735e+105 2.501848252103977e+105 4.0480755065987505e+105 6.549923758702727e+105 1.0597999265301477e+106 1.7147923024004204e+106 2.774592228930568e+106 4.4893845313309884e+106 7.263976760261557e+106 1.1753361291592545e+107 1.9017338051854102e+107 3.0770699343446646e+107 4.978803739530075e+107 8.055873673874739e+107 1.3034677413404814e+108 2.1090551087279553e+108 3.412522850068437e+108 5.521577958796393e+108 8.93410080886483e+108 1.4455678767661223e+109 2.3389779576526055e+109 3.784545834418728e+109 6.123523792071334e+109 9.908069626490062e+109 1.6031593418561396e+110 2.5939663045051458e+110 4.197125646361285e+110 6.791091950866431e+110 1.0988217597227716e+111 1.7779309548094147e+111 2.8767527145321864e+111 4.654683669341601e+111 7.531436383873787e+111 1.218612005321539e+112 1.9717556437089175e+112 3.1903676490304564e+112 5.162123292739374e+112 8.35249094176983e+112 1.3514614234509204e+113 2.1867105176279034e+113 3.538171941078824e+113 5.724882458706727e+113 9.263054399785552e+113 1.498793685849228e+114 2.4250991258277832e+114 3.923892811677011e+114 6.348991937504794e+114 1.0272884749181806e+115 1.6621876686686599e+115 2.6894761435868405e+115 4.3516638122555e+115 7.041139955842341e+115 1.1392803768097841e+116 1.8433943723940184e+116 2.9826747492038025e+116 4.826069121597821e+116 7.808743870801623e+116 1.2634812992399444e+117 2.0443556863201068e+117 3.307836985560051e+117 5.352192671880158e+117 8.660029657440209e+117 1.4012222329320367e+118 2.2672251986760575e+118 3.668447431608094e+118 5.935672630284151e+118 9.604120061892246e+118 1.5539792692176397e+119 2.514391275406864e+119 4.0683705446245036e+119 6.582761820031368e+119 1.065113236465587e+120 1.7233894184687237e+120 2.788502654934311e+120 4.5118920734030345e+120 7.300394728337345e+120 1.181228680174038e+121 1.9112681530077724e+121 3.0924968331818106e+121 5.003764986189583e+121 8.096261819371394e+121 1.3100026805560978e+122 2.119628862493237e+122 3.429631543049335e+122 5.549260405542572e+122 8.978891948591907e+122 1.452815235413448e+123 2.3507044302726385e+123 3.803519665686087e+123 6.154224095958725e+123 9.957743761644812e+123 1.6111967857603536e+124 2.6069711619248347e+124 4.2181679476851883e+124 6.825139109610023e+124 1.1043307057295211e+125 1.7868446166905234e+125 2.8911753224200445e+125 4.678019939110568e+125 7.569195261530612e+125 1.224721520064118e+126 1.981641046217179e+126 3.206362566281297e+126 5.188003612498476e+126 8.394366178779773e+126 1.358236979127825e+127 2.1976735970058023e+127 3.5559105761336274e+127 5.75358417313943e+127 9.309494749273056e+127 1.5063078922412486e+128 2.437257367168554e+128 3.943565259409803e+128 6.380822626578357e+128 1.032438788598816e+129 1.6705210512566517e+129 2.7029598398554676e+129 4.3734808911121193e+129 7.076440730967588e+129 1.1449921622079707e+130 1.8526362353047294e+130 2.9976283975127e+130 4.85026463281743e+130 7.84789303033013e+130 1.269815766314756e+131 2.054605069347769e+131 3.324420835662525e+131 5.379025905010295e+131 8.70344674067282e+131 1.4082472645683115e+132 2.2785919386355933e+132 3.6868392032039045e+132 5.965431141839498e+132 9.652270345043403e+132 1.5617701486882901e+133 2.52699718319263e+133 4.08876733188092e+133 6.61576451507355e+133 1.070453184695447e+134 1.732029636202802e+134 2.802482820898249e+134 4.534512457101051e+134 7.3369952779993e+134 1.1871507735100351e+135 1.920850301309965e+135 3.1080010748200005e+135 5.0288513761299655e+135 8.136852450949967e+135 1.3165703827079932e+136 2.1302556278029898e+136 3.446826010510983e+136 5.577081638313973e+136 9.023907648824956e+136 1.460098928713893e+137 2.3624896935963886e+137 3.822588622310282e+137 6.1850783159066705e+137 1.0007666938216952e+138 1.6192745254123623e+138 2.6200412192340575e+138 4.2393157446464195e+138 6.859356963880477e+138 1.1098672708526896e+139 1.7958029672407375e+139 2.905670238093427e+139 4.7014732053341643e+139 7.607143443427591e+139 1.2308616648761756e+140 1.9915760092189344e+140 3.22243767409511e+140 5.2140136833140446e+140 8.436451357409155e+140 1.36504650407232e+141 2.2086916398132357e+141 3.573738143885556e+141 5.782429783698791e+141 9.356167927584346e+141 1.513859771128314e+142 2.4494765638867485e+142 3.9633363350150624e+142 6.412812898901811e+142 1.0376149233916874e+143 1.6788962132818685e+143 2.716511136673556e+143 4.395407349955425e+143 7.111918486628981e+143 1.1507325836584407e+144 1.861924432321339e+144 3.0126570159797796e+144 4.8745814483011185e+144 7.887238464280898e+144 1.2761819912582017e+145 2.0649058376862915e+145 3.3410878289444935e+145 5.405993666630785e+145 8.747081495575278e+145 1.4153075162206063e+146 2.2900156657781344e+146 3.7053231819987407e+146 5.995338847776875e+146 9.700662029775616e+146 1.5696000877552492e+147 2.5396662907328107e+147 4.10926637848806e+147 6.648932669220871e+147 1.0758199047708932e+148 1.7407131716929801e+148 2.8165330764638734e+148 4.5572462481568536e+148 7.373779324620727e+148 1.193102557277758e+149 1.9304804897398307e+149 3.1235830470175887e+149 5.054063536757419e+149 8.177646583775008e+149 1.3231710120532428e+150 2.1409356704307436e+150 3.464106682483987e+150 5.60504235291473e+150 9.069149035398718e+150 1.4674191388313447e+151 2.3743340423712165e+151 3.841753181202561e+151 6.216087223573778e+151 1.0057840404776338e+152 1.6273927628350117e+152 2.6331768033126457e+152 4.260569566147657e+152 6.893746369460303e+152 1.115431593560796e+153 1.8048062305068262e+153 2.920237824067622e+153 4.725044054574448e+153 7.64528187864207e+153 1.2370325933216519e+154 2.001560781185859e+154 3.238593374507511e+154 5.24015415569337e+154 8.478747530200881e+154 1.3718901685894252e+155 2.219764921609513e+155 3.5916550901989383e+155 5.811420011808452e+155 9.403075102007391e+155 1.5214495113815843e+156 2.4617570215823236e+156 3.983206532963908e+156 6.444963554546232e+156 1.042817008751014e+157 1.6873133642056372e+157 2.7301303729566514e+157 4.4174437371622886e+157 7.147574110118939e+157 1.1565017847281227e+158 1.8712591957400167e+158 3.0277609804681397e+158 4.899020176208156e+158 7.926781156676296e+158 1.2825801332884451e+159 2.075258248956075e+159 3.35783838224452e+159 5.433096631200595e+159 8.790935013445115e+159 1.422403164464571e+160 2.3014966658090826e+160 3.723899830273653e+160 6.025396496082736e+160 9.749296326356389e+160 1.5774692822439125e+161 2.552398914879551e+161 4.1298681971234637e+161 6.682267112003014e+161 1.0812135309126478e+162 1.7494402421129492e+162 2.8306537730255968e+162 4.580094015138546e+162 7.410747788164143e+162 1.1990841803302688e+163 1.940158959146683e+163 3.1392431394769516e+163 5.0794020986236347e+163 8.218645238100586e+163 1.329804733672422e+164 2.1516692574824805e+164 3.4814739911549024e+164 5.633143248637383e+164 9.114617239792286e+164 1.474776048842967e+165 2.3862377728221955e+165 3.8610138216651624e+165 6.2472515944873575e+165 1.010826541615252e+166 1.635551701063988e+166 2.64637824267924e+166 4.281929943743228e+166 6.928308186422468e+166 1.1210238130165696e+167 1.8138546316588163e+167 2.934878444675386e+167 4.748733076334203e+167 7.683611521009589e+167 1.2432344597343791e+168 2.011595611835338e+168 3.2548300715697173e+168 5.266425683405056e+168 8.521255754974774e+168 1.378768143837983e+169 2.2308937193354602e+169 3.6096618631734433e+169 5.8405555825089035e+169 9.450217445682346e+169 1.529077302819125e+170 2.47409904738736e+170 4.0031763502064847e+170 6.477275397593844e+170 1.048045174780033e+171 1.6957727145394175e+171 2.7438178893194507e+171 4.439590603858868e+171 7.183408493178319e+171 1.1622999097037188e+172 1.8806407590215506e+172 3.0429406687252694e+172 4.92358142774682e+172 7.96652209647209e+172 1.289010352421891e+173 2.0856625620690997e+173 3.3746729144909907e+173 5.46033547656009e+173 8.83500839105108e+173 1.429534386761117e+174 2.313035225866225e+174 3.742569612627342e+174 6.055604838493567e+174 9.79817445112091e+174 1.5853779289614475e+175 2.5651953740735385e+175 4.150573303034986e+175 6.715768677108524e+175 1.0866341980143511e+176 1.7582110657252035e+176 2.8448452637395545e+176 4.603056329464758e+176 7.447901593204313e+176 1.205095792266907e+177 1.9498859515873383e+177 3.1549817438542456e+177 5.104867695441584e+177 8.25984943929583e+177 1.3364717134737413e+178 2.1624566574033242e+178 3.498928370877066e+178 5.6613850282803905e+178 9.160313399157456e+178 1.4821698427437848e+179 2.3982011826595303e+179 3.880371025403315e+179 6.278572208062845e+179 1.0158943233466161e+180 1.6437515441529006e+180 2.6596458674995166e+180 4.303397411652417e+180 6.963043279151934e+180 1.126644069080435e+181 1.8229483969956285e+181 2.9495924660760636e+181 4.772540863071692e+181 7.722133329147755e+181 1.2494674192219447e+182 2.0216807521367203e+182 3.271148171358665e+182 5.2928289234953855e+182 8.56397709485405e+182 1.3856806018349436e+183 2.2420783113203486e+183 3.627758913155292e+183 5.869837224475641e+183 9.497596137630933e+183 1.5367433362106574e+184 2.4865029499737505e+184 4.023246286184408e+184 6.509749236158159e+184 1.0532995522342567e+185 1.7042744758500726e+185 2.757574028084329e+185 4.461848503934402e+185 7.219422532018732e+185 1.1681271035953133e+186 1.8900693567971865e+186 3.0581964603925e+186 4.948265817189686e+186 8.006462277582186e+186 1.2954728094771872e+187 2.096119037235406e+187 3.391591846712593e+187 5.487710883947999e+187 8.879302730660591e+187 1.436701361460859e+188 2.324631634526918e+188 3.761332995987777e+188 6.085964630514695e+188 9.847297626502471e+188 1.5933262257017168e+189 2.578055988351964e+189 4.1713822140536807e+189 6.749438202405644e+189 1.0920820416459324e+190 1.7670258618864968e+190 2.859107903532429e+190 4.626133765418926e+190 7.485241668951356e+190 1.211137543437028e+191 1.9596617103321636e+191 3.170799253769192e+191 5.130460964101355e+191 8.301260217870547e+191 1.34317211819719e+192 2.1732981399842448e+192 3.5164702581814347e+192 5.689768398165679e+192 9.206238656347114e+192 1.4896007054512793e+193 2.4102245710859905e+193 3.89982527653727e+193 6.310049847623261e+193 1.020987512416053e+194 1.651992497178379e+194 2.6729800095944324e+194 4.324972506772811e+194 6.997952516367244e+194 1.1322925023140055e+195 1.8320877539507298e+195 2.964380256264735e+195 4.796468010215465e+195 7.7608482664802e+195 1.2557316276695666e+196 2.0318164543175863e+196 3.287548081987153e+196 5.31936453630474e+196 8.606912618291892e+196 1.3926277154596632e+197 2.2533189772888524e+197 3.645946692748516e+197 5.899265670037368e+197 9.545212362785885e+197 1.5444478032823252e+198 2.4989690395609137e+198 4.0434168428432386e+198 6.542385882404152e+198 1.058580272524739e+199 1.7128188607651542e+199 2.771399133289893e+199 4.484217994055047e+199 7.25561712734494e+199 1.1739835121399988e+200 1.8995452248744928e+200 3.073528737014492e+200 4.9730739618889846e+200 8.046602698903476e+200 1.301967666079246e+201 2.1066279359695935e+201 3.4085956020488395e+201 5.515223538018433e+201 8.923819140067273e+201 1.4439042678085704e+202 2.3362861818152977e+202 3.780190449623868e+202 6.116476631439166e+202 9.896667081063034e+202 1.6013143712502202e+203 2.5909810793565236e+203 4.192295450606744e+203 6.783276529963268e+203 1.0975571980570012e+204 1.775884851053328e+204 2.873442049110329e+204 4.649326900163657e+204 7.522768949273986e+204 1.2172095849437642e+205 1.9694864798711628e+205 3.186696064814927e+205 5.15618254468609e+205 8.342878609501017e+205 1.3499061154187107e+206 2.1841939763688122e+206 3.534100091787523e+206 5.718294068156335e+206 9.252394159943859e+206 1.4970688228100194e+207 2.4223082388044054e+207 3.919377061614425e+207 6.34168530041883e+207 1.0261062362033255e+208 1.6602747662452085e+208 2.686381002448534e+208)"]
;; <=

;; @@ [cljs]
(defn foo
  ([] "foo")
  ([x] x)
  ([x y] y))
;; @@
;; =>
;;; ["^ ","~:type","~:html","~:content",["~:span",["^ ","~:class","clj-unknown"],"#'bongo.trott/foo"],"~:value","#'bongo.trott/foo"]
;; <=

;; @@ [cljs]
(foo 7)
;; @@
;; =>
;;; ["^ ","~:type","~:html","~:content",["~:span",["^ ","~:class","clj-long"],"7"],"~:value","7"]
;; <=

;; @@ [cljs]
; macros in clojurescript
; http://blog.klipse.tech/clojure/2016/05/09/macro-tutorial-4.html

(ns my.best$macros)

(defn symbol-several
  "returns a symbol with the concatenation of the str values of the args"
  [& x]
  (symbol (apply str x)))

(defmacro disp [& forms]
  (cons
   `symbol-several
   (for [form forms]
     `(str '~form " => " ~form "\n"))))

(my.best/disp
 (map inc [1 2 3])
 (+ 4 5 6))
;; @@
;; =>
;;; ["^ ","~:type","~:html","~:content",["~:span",["^ ","~:class","clj-symbol"],"(map inc [1 2 3]) => (2 3 4)\n(+ 4 5 6) => 15\n"],"~:value","(map inc [1 2 3]) => (2 3 4)\n(+ 4 5 6) => 15\n"]
;; <=

;; @@ [cljs]
(+ "hello " "my dear")
;; @@
;; =>
;;; ["^ ","~:type","~:html","~:content",["~:span",["^ ","~:class","clj-string"],"\"hello my dear\""],"~:value","\"hello my dear\""]
;; <=

;; @@ [cljs]
(<= "apples" "oranges")
;; @@
;; =>
;;; ["^ ","~:type","~:html","~:content",["~:span",["^ ","~:class","clj-boolean"],"true"],"~:value","true"]
;; <=

;; @@ [cljs]
(+ 3 4 7777)
;; @@
;; =>
;;; ["^ ","~:type","~:html","~:content",["~:span",["^ ","~:class","clj-long"],"7784"],"~:value","7784"]
;; <=

;; @@ [cljs]
(+ 77 7)
;; @@
;; =>
;;; ["^ ","~:type","~:html","~:content",["~:span",["^ ","~:class","clj-long"],"84"],"~:value","84"]
;; <=

;; @@ [cljs]
;meta data on var - not working
^{:foo 8} 77
;; @@

;; @@ [cljs]
;meta data on fn
(def ^{:foo 8} t 67)
(def ^{:foo 8} p 70)
;; @@
;; =>
;;; ["^ ","~:type","~:html","~:content",["~:span",["^ ","~:class","clj-unknown"],"#'my.best$macros/p"],"~:value","#'my.best$macros/p"]
;; <=

;; @@ [cljs]
t
;; @@
;; =>
;;; ["^ ","~:type","~:html","~:content",["~:span",["^ ","~:class","clj-long"],"67"],"~:value","67"]
;; <=

;; @@ [cljs]
; it seems shadow has problems with meta
(meta t)
;; @@
;; =>
;;; ["^ ","~:type","~:html","~:content",["~:span",["^ ","~:class","clj-nil"],"nil"],"~:value","nil"]
;; <=

;; @@ [cljs]
; shadow does bnot have doc yet
(doc t)
;; @@

;; @@ [clj]

;; @@
