(ns goldly.sci.bindings
  (:require
   [clojure.core]
   [clojure.string :as str]
   [fipp.clojure]
   [modular.date :refer [now-str]]))

; config management

#_(defonce goldly-namespaces (atom []))
#_(defonce goldly-bindings (atom {}))

#_(defonce goldly-ns-bindings (atom {}))

#_(defmacro add-cljs-namespace [n]
    `(swap! goldly-namespaces conj '~n))

#_(defmacro add-cljs-bindings [b]
    `(swap! goldly-bindings merge '~b))

#_(defmacro add-cljs-ns-bindings [n b]
    `(swap! goldly-ns-bindings assoc '~n '~b))

#_(defn sci-config-old []
    {:requires @goldly-namespaces
     :bindings @goldly-bindings
     :ns-bindings @goldly-ns-bindings})

; generate forms

(defmacro generate-require [namespaces]
  `(concat (list :require) ~namespaces))

(defn make-sci-lazy-ns-bindings [sci-lazy-ns-bindings]
  ; sci lazy module
  ; {'fun {:module "fun", :sci-ns-def {'joke demo.funny/joke}},
  ;  'adder {:module "adder", :sci-ns-def {'add adder/add}}}
  (into {}
        (map (fn [[sci-ns {:keys [module sci-ns-def]}]]
               [sci-ns {:module module
                        :loadable (list 'shadow.lazy/loadable sci-ns-def)}])
             sci-lazy-ns-bindings)))

(defn make-forms [{:keys [requires bindings ns-bindings ns-module-lazy]}]
  (let [nsl '(ns goldly-bindings-generated)
        r (generate-require requires)
        rl (list r)
        nslr (concat nsl rl)
        lazy-lookup (make-sci-lazy-ns-bindings ns-module-lazy)]
    [nslr
     (list 'def 'compile-time (now-str))
     (list 'def 'bindings-generated bindings)
     (list 'def 'ns-generated ns-bindings)
     (list 'def 'lazy-lookup lazy-lookup)]))

; write forms to cljs 

(defn form->str [f]
  (with-out-str
    (fipp.clojure/pprint f {:width 120})))

(defn write-forms [filename forms]
  (let [comment (str "; generated by goldly on " (now-str) "\r\n")
        s-forms (-> (map form->str forms)
                    (str/join))
        ;s-compile-time (str "\r\n(def binding-compile-time " (now-str) ") \r\n") 
        s (str comment  s-forms)]
    (spit filename s)))

;; all together

(defn write-sci-binding-cljs-file [sci-config filename]
  (let [forms (make-forms sci-config)]
    (write-forms filename forms)))

(comment

  ;config management  
  ; PRODUCE LINT ERRORS
  ;(add-cljs-namespace [clojure.walk :as walk])
  ;(add-cljs-namespace [goldly.sci.bindings-goldly])
  ;(add-cljs-namespace [goldly.code.core])
  ;(add-cljs-bindings {'sin sin
  ;                    'println println})

  ; generate forms

  (def static-forms
    ['(ns goldly.sci.bindings-generated
        (:require
         [clojure.walk :as walk]
         [goldly.sci.bindings-goldly :refer [sin]]))
     '(def bindings-generated
        {'sin sin
         'println println})])

  (make-forms)

  (sci-bindings-filename)
  ; all together
  (generate-bindings)
  ;
  )