goog.provide('ajax.xml_http_request');
goog.require('cljs.core');
goog.require('ajax.protocols');
goog.require('goog.string');
ajax.xml_http_request.ready_state = (function ajax$xml_http_request$ready_state(e){
var G__11037 = e.target.readyState;
var fexpr__11036 = new cljs.core.PersistentArrayMap(null, 6, [(0),new cljs.core.Keyword(null,"not-initialized","not-initialized",-1937378906),(1),new cljs.core.Keyword(null,"connection-established","connection-established",-1403749733),(2),new cljs.core.Keyword(null,"request-received","request-received",2110590540),(3),new cljs.core.Keyword(null,"processing-request","processing-request",-264947221),(4),new cljs.core.Keyword(null,"response-ready","response-ready",245208276),new cljs.core.Keyword("cljs.analyzer","analyzed","cljs.analyzer/analyzed",-735094162),true], null);
return (fexpr__11036.cljs$core$IFn$_invoke$arity$1 ? fexpr__11036.cljs$core$IFn$_invoke$arity$1(G__11037) : fexpr__11036.call(null,G__11037));
});
ajax.xml_http_request.append = (function ajax$xml_http_request$append(current,next){
if(cljs.core.truth_(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current),", ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(next)].join('');
} else {
return next;
}
});
ajax.xml_http_request.process_headers = (function ajax$xml_http_request$process_headers(header_str){
if(cljs.core.truth_(header_str)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (headers,header_line){
if(cljs.core.truth_(goog.string.isEmptyOrWhitespace(header_line))){
return headers;
} else {
var key_value = goog.string.splitLimit(header_line,": ",(2));
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(headers,(key_value[(0)]),ajax.xml_http_request.append,(key_value[(1)]));
}
}),cljs.core.PersistentArrayMap.EMPTY,header_str.split("\r\n"));
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
ajax.xml_http_request.xmlhttprequest = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_target_STAR_,"nodejs"))?(function (){var xmlhttprequest = require("xmlhttprequest").XMLHttpRequest;
goog.object.set(global,"XMLHttpRequest",xmlhttprequest);

return xmlhttprequest;
})():XMLHttpRequest);
(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxImpl$ = cljs.core.PROTOCOL_SENTINEL);

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxImpl$_js_ajax_request$arity$3 = (function (this$,p__11050,handler){
var map__11051 = p__11050;
var map__11051__$1 = (((((!((map__11051 == null))))?(((((map__11051.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11051.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11051):map__11051);
var uri = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11051__$1,new cljs.core.Keyword(null,"uri","uri",-774711847));
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11051__$1,new cljs.core.Keyword(null,"method","method",55703592));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11051__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11051__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__11051__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(0));
var with_credentials = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__11051__$1,new cljs.core.Keyword(null,"with-credentials","with-credentials",-1163127235),false);
var response_format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11051__$1,new cljs.core.Keyword(null,"response-format","response-format",1664465322));
var this$__$1 = this;
(this$__$1.withCredentials = with_credentials);

(this$__$1.onreadystatechange = (function (p1__11043_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"response-ready","response-ready",245208276),ajax.xml_http_request.ready_state(p1__11043_SHARP_))){
return (handler.cljs$core$IFn$_invoke$arity$1 ? handler.cljs$core$IFn$_invoke$arity$1(this$__$1) : handler.call(null,this$__$1));
} else {
return null;
}
}));

this$__$1.open(method,uri,true);

(this$__$1.timeout = timeout);

var temp__5735__auto___11081 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(response_format);
if(cljs.core.truth_(temp__5735__auto___11081)){
var response_type_11082 = temp__5735__auto___11081;
(this$__$1.responseType = cljs.core.name(response_type_11082));
} else {
}

var seq__11054_11083 = cljs.core.seq(headers);
var chunk__11055_11084 = null;
var count__11056_11085 = (0);
var i__11057_11086 = (0);
while(true){
if((i__11057_11086 < count__11056_11085)){
var vec__11064_11087 = chunk__11055_11084.cljs$core$IIndexed$_nth$arity$2(null,i__11057_11086);
var k_11088 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11064_11087,(0),null);
var v_11089 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11064_11087,(1),null);
this$__$1.setRequestHeader(k_11088,v_11089);


var G__11090 = seq__11054_11083;
var G__11091 = chunk__11055_11084;
var G__11092 = count__11056_11085;
var G__11093 = (i__11057_11086 + (1));
seq__11054_11083 = G__11090;
chunk__11055_11084 = G__11091;
count__11056_11085 = G__11092;
i__11057_11086 = G__11093;
continue;
} else {
var temp__5735__auto___11094 = cljs.core.seq(seq__11054_11083);
if(temp__5735__auto___11094){
var seq__11054_11095__$1 = temp__5735__auto___11094;
if(cljs.core.chunked_seq_QMARK_(seq__11054_11095__$1)){
var c__4609__auto___11096 = cljs.core.chunk_first(seq__11054_11095__$1);
var G__11097 = cljs.core.chunk_rest(seq__11054_11095__$1);
var G__11098 = c__4609__auto___11096;
var G__11099 = cljs.core.count(c__4609__auto___11096);
var G__11100 = (0);
seq__11054_11083 = G__11097;
chunk__11055_11084 = G__11098;
count__11056_11085 = G__11099;
i__11057_11086 = G__11100;
continue;
} else {
var vec__11070_11101 = cljs.core.first(seq__11054_11095__$1);
var k_11102 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11070_11101,(0),null);
var v_11103 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11070_11101,(1),null);
this$__$1.setRequestHeader(k_11102,v_11103);


var G__11104 = cljs.core.next(seq__11054_11095__$1);
var G__11105 = null;
var G__11106 = (0);
var G__11107 = (0);
seq__11054_11083 = G__11104;
chunk__11055_11084 = G__11105;
count__11056_11085 = G__11106;
i__11057_11086 = G__11107;
continue;
}
} else {
}
}
break;
}

this$__$1.send((function (){var or__4185__auto__ = body;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return "";
}
})());

return this$__$1;
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxRequest$ = cljs.core.PROTOCOL_SENTINEL);

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxRequest$_abort$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.abort();
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$ = cljs.core.PROTOCOL_SENTINEL);

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_body$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.response;
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_status$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.status;
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_status_text$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.statusText;
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_get_all_headers$arity$1 = (function (this$){
var this$__$1 = this;
return ajax.xml_http_request.process_headers(this$__$1.getAllResponseHeaders());
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_get_response_header$arity$2 = (function (this$,header){
var this$__$1 = this;
return this$__$1.getResponseHeader(header);
}));

(ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_was_aborted$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),this$__$1.readyState);
}));

//# sourceMappingURL=ajax.xml_http_request.js.map
