goog.provide('chord.client');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('chord.channels');
goog.require('chord.format');
chord.client.close_event__GT_maybe_error = (function chord$client$close_event__GT_maybe_error(ev){
if(cljs.core.truth_(ev.wasClean)){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reason","reason",-2070751759),ev.reason,new cljs.core.Keyword(null,"code","code",1586293142),ev.code], null);
}
});
chord.client.create_ws = (function chord$client$create_ws(url,opts){
if(cljs.core.truth_((((typeof require !== 'undefined'))?(function (){try{return require("ws");
}catch (e16463){var e = e16463;
return false;
}})():false))){
var ws = require("ws");
if(cljs.core.truth_(opts)){
return (new ws(url,cljs.core.clj__GT_js(opts)));
} else {
return (new ws(url));
}
} else {
return (new WebSocket(url));

}
});
/**
 * Creates websockets connection and returns a 2-sided channel when the websocket is opened.
 * Arguments:
 *  ws-url           - (required) link to websocket service
 *  opts             - (optional) map to configure reading/writing channels
 *    :read-ch       - (optional) (possibly buffered) channel to use for reading the websocket
 *    :write-ch      - (optional) (possibly buffered) channel to use for writing to the websocket
 *    :format        - (optional) data format to use on the channel, (at the moment)
 *                                either :edn (default), :json, :json-kw or :str.
 *    :ws-opts       - (optional) Other options to be passed to the websocket constructor (NodeJS only)
 *                                see https://github.com/websockets/ws/blob/master/doc/ws.md#new-websocketaddress-protocols-options
 * 
 * Usage:
 *  (:require [cljs.core.async :as a])
 * 
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437"))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))}))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))
 *                                        :write-ch (a/chan (a/dropping-buffer 10))}))
 */
chord.client.ws_ch = (function chord$client$ws_ch(var_args){
var args__4795__auto__ = [];
var len__4789__auto___16581 = arguments.length;
var i__4790__auto___16582 = (0);
while(true){
if((i__4790__auto___16582 < len__4789__auto___16581)){
args__4795__auto__.push((arguments[i__4790__auto___16582]));

var G__16583 = (i__4790__auto___16582 + (1));
i__4790__auto___16582 = G__16583;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic = (function (ws_url,p__16470){
var vec__16472 = p__16470;
var map__16475 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16472,(0),null);
var map__16475__$1 = (((((!((map__16475 == null))))?(((((map__16475.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16475.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16475):map__16475);
var opts = map__16475__$1;
var read_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16475__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16475__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16475__$1,new cljs.core.Keyword(null,"format","format",-1306924766));
var ws_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16475__$1,new cljs.core.Keyword(null,"ws-opts","ws-opts",1487801643));
var web_socket = chord.client.create_ws(ws_url,ws_opts);
var map__16477 = chord.format.wrap_format(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"read-ch","read-ch",-38486414),(function (){var or__4185__auto__ = read_ch;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})(),new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599),(function (){var or__4185__auto__ = write_ch;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})()], null),opts);
var map__16477__$1 = (((((!((map__16477 == null))))?(((((map__16477.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16477.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16477):map__16477);
var read_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16477__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16477__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var open_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var close_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
(web_socket.binaryType = "arraybuffer");

chord.channels.read_from_ws_BANG_(web_socket,read_ch__$1);

chord.channels.write_to_ws_BANG_(web_socket,write_ch__$1);

(web_socket.onopen = (function (p1__16465_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_ch,p1__16465_SHARP_);
}));

(web_socket.onclose = (function (p1__16466_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(close_ch,p1__16466_SHARP_);
}));

var ws_chan = chord.channels.bidi_ch.cljs$core$IFn$_invoke$arity$variadic(read_ch__$1,write_ch__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-close","on-close",-761178394),(function (){
return web_socket.close();
})], null)], 0));
var initial_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__13675__auto___16590 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13676__auto__ = (function (){var switch__13556__auto__ = (function (state_16544){
var state_val_16545 = (state_16544[(1)]);
if((state_val_16545 === (7))){
var inst_16540 = (state_16544[(2)]);
var state_16544__$1 = state_16544;
var statearr_16546_16592 = state_16544__$1;
(statearr_16546_16592[(2)] = inst_16540);

(statearr_16546_16592[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16545 === (20))){
var state_16544__$1 = state_16544;
var statearr_16547_16593 = state_16544__$1;
(statearr_16547_16593[(2)] = null);

(statearr_16547_16593[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16545 === (1))){
var inst_16479 = false;
var state_16544__$1 = (function (){var statearr_16548 = state_16544;
(statearr_16548[(7)] = inst_16479);

return statearr_16548;
})();
var statearr_16549_16595 = state_16544__$1;
(statearr_16549_16595[(2)] = null);

(statearr_16549_16595[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16545 === (4))){
var inst_16492 = (state_16544[(8)]);
var inst_16494 = (state_16544[(9)]);
var inst_16492__$1 = (state_16544[(2)]);
var inst_16493 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16492__$1,(0),null);
var inst_16494__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16492__$1,(1),null);
var inst_16495 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_16494__$1,open_ch);
var state_16544__$1 = (function (){var statearr_16550 = state_16544;
(statearr_16550[(8)] = inst_16492__$1);

(statearr_16550[(9)] = inst_16494__$1);

(statearr_16550[(10)] = inst_16493);

return statearr_16550;
})();
if(inst_16495){
var statearr_16551_16597 = state_16544__$1;
(statearr_16551_16597[(1)] = (5));

} else {
var statearr_16552_16598 = state_16544__$1;
(statearr_16552_16598[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16545 === (15))){
var inst_16525 = (state_16544[(2)]);
var state_16544__$1 = state_16544;
var statearr_16553_16599 = state_16544__$1;
(statearr_16553_16599[(2)] = inst_16525);

(statearr_16553_16599[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16545 === (21))){
var inst_16536 = (state_16544[(2)]);
var state_16544__$1 = state_16544;
var statearr_16554_16600 = state_16544__$1;
(statearr_16554_16600[(2)] = inst_16536);

(statearr_16554_16600[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16545 === (13))){
var state_16544__$1 = state_16544;
var statearr_16555_16601 = state_16544__$1;
(statearr_16555_16601[(2)] = null);

(statearr_16555_16601[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16545 === (6))){
var inst_16494 = (state_16544[(9)]);
var inst_16509 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_16494,close_ch);
var state_16544__$1 = state_16544;
if(inst_16509){
var statearr_16556_16603 = state_16544__$1;
(statearr_16556_16603[(1)] = (9));

} else {
var statearr_16557_16604 = state_16544__$1;
(statearr_16557_16604[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16545 === (17))){
var state_16544__$1 = state_16544;
var statearr_16558_16605 = state_16544__$1;
(statearr_16558_16605[(2)] = initial_ch);

(statearr_16558_16605[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16545 === (3))){
var inst_16542 = (state_16544[(2)]);
var state_16544__$1 = state_16544;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16544__$1,inst_16542);
} else {
if((state_val_16545 === (12))){
var inst_16479 = (state_16544[(7)]);
var state_16544__$1 = state_16544;
if(cljs.core.truth_(inst_16479)){
var statearr_16559_16607 = state_16544__$1;
(statearr_16559_16607[(1)] = (16));

} else {
var statearr_16560_16608 = state_16544__$1;
(statearr_16560_16608[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16545 === (2))){
var inst_16488 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16489 = [open_ch,close_ch];
var inst_16490 = (new cljs.core.PersistentVector(null,2,(5),inst_16488,inst_16489,null));
var state_16544__$1 = state_16544;
return cljs.core.async.ioc_alts_BANG_(state_16544__$1,(4),inst_16490);
} else {
if((state_val_16545 === (19))){
var inst_16493 = (state_16544[(10)]);
var state_16544__$1 = state_16544;
var statearr_16561_16610 = state_16544__$1;
(statearr_16561_16610[(2)] = inst_16493);

(statearr_16561_16610[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16545 === (11))){
var inst_16538 = (state_16544[(2)]);
var state_16544__$1 = state_16544;
var statearr_16562_16611 = state_16544__$1;
(statearr_16562_16611[(2)] = inst_16538);

(statearr_16562_16611[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16545 === (9))){
var inst_16492 = (state_16544[(8)]);
var inst_16515 = (state_16544[(11)]);
var inst_16514 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16492,(0),null);
var inst_16515__$1 = chord.client.close_event__GT_maybe_error(inst_16514);
var state_16544__$1 = (function (){var statearr_16563 = state_16544;
(statearr_16563[(11)] = inst_16515__$1);

return statearr_16563;
})();
if(cljs.core.truth_(inst_16515__$1)){
var statearr_16564_16612 = state_16544__$1;
(statearr_16564_16612[(1)] = (12));

} else {
var statearr_16565_16613 = state_16544__$1;
(statearr_16565_16613[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16545 === (5))){
var inst_16492 = (state_16544[(8)]);
var inst_16500 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16492,(0),null);
var inst_16501 = [new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174)];
var inst_16502 = [ws_chan];
var inst_16503 = cljs.core.PersistentHashMap.fromArrays(inst_16501,inst_16502);
var state_16544__$1 = (function (){var statearr_16566 = state_16544;
(statearr_16566[(12)] = inst_16500);

return statearr_16566;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16544__$1,(8),initial_ch,inst_16503);
} else {
if((state_val_16545 === (14))){
var inst_16528 = (state_16544[(2)]);
var inst_16529 = cljs.core.async.close_BANG_(ws_chan);
var inst_16530 = cljs.core.async.close_BANG_(initial_ch);
var state_16544__$1 = (function (){var statearr_16567 = state_16544;
(statearr_16567[(13)] = inst_16529);

(statearr_16567[(14)] = inst_16528);

return statearr_16567;
})();
var statearr_16568_16615 = state_16544__$1;
(statearr_16568_16615[(2)] = inst_16530);

(statearr_16568_16615[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16545 === (16))){
var state_16544__$1 = state_16544;
var statearr_16569_16616 = state_16544__$1;
(statearr_16569_16616[(2)] = read_ch__$1);

(statearr_16569_16616[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16545 === (10))){
var inst_16494 = (state_16544[(9)]);
var inst_16532 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_16494,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_16544__$1 = state_16544;
if(inst_16532){
var statearr_16570_16618 = state_16544__$1;
(statearr_16570_16618[(1)] = (19));

} else {
var statearr_16571_16619 = state_16544__$1;
(statearr_16571_16619[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16545 === (18))){
var inst_16515 = (state_16544[(11)]);
var inst_16520 = (state_16544[(2)]);
var inst_16521 = [new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16522 = [inst_16515];
var inst_16523 = cljs.core.PersistentHashMap.fromArrays(inst_16521,inst_16522);
var state_16544__$1 = state_16544;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16544__$1,(15),inst_16520,inst_16523);
} else {
if((state_val_16545 === (8))){
var inst_16505 = (state_16544[(2)]);
var inst_16506 = cljs.core.async.close_BANG_(initial_ch);
var inst_16479 = true;
var state_16544__$1 = (function (){var statearr_16572 = state_16544;
(statearr_16572[(7)] = inst_16479);

(statearr_16572[(15)] = inst_16506);

(statearr_16572[(16)] = inst_16505);

return statearr_16572;
})();
var statearr_16573_16621 = state_16544__$1;
(statearr_16573_16621[(2)] = null);

(statearr_16573_16621[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var chord$client$state_machine__13557__auto__ = null;
var chord$client$state_machine__13557__auto____0 = (function (){
var statearr_16574 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16574[(0)] = chord$client$state_machine__13557__auto__);

(statearr_16574[(1)] = (1));

return statearr_16574;
});
var chord$client$state_machine__13557__auto____1 = (function (state_16544){
while(true){
var ret_value__13558__auto__ = (function (){try{while(true){
var result__13559__auto__ = switch__13556__auto__(state_16544);
if(cljs.core.keyword_identical_QMARK_(result__13559__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13559__auto__;
}
break;
}
}catch (e16575){if((e16575 instanceof Object)){
var ex__13560__auto__ = e16575;
var statearr_16576_16632 = state_16544;
(statearr_16576_16632[(5)] = ex__13560__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16544);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16575;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13558__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16634 = state_16544;
state_16544 = G__16634;
continue;
} else {
return ret_value__13558__auto__;
}
break;
}
});
chord$client$state_machine__13557__auto__ = function(state_16544){
switch(arguments.length){
case 0:
return chord$client$state_machine__13557__auto____0.call(this);
case 1:
return chord$client$state_machine__13557__auto____1.call(this,state_16544);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chord$client$state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$0 = chord$client$state_machine__13557__auto____0;
chord$client$state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$1 = chord$client$state_machine__13557__auto____1;
return chord$client$state_machine__13557__auto__;
})()
})();
var state__13677__auto__ = (function (){var statearr_16577 = (f__13676__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13676__auto__.cljs$core$IFn$_invoke$arity$0() : f__13676__auto__.call(null));
(statearr_16577[(6)] = c__13675__auto___16590);

return statearr_16577;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13677__auto__);
}));


return initial_ch;
}));

(chord.client.ws_ch.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(chord.client.ws_ch.cljs$lang$applyTo = (function (seq16467){
var G__16468 = cljs.core.first(seq16467);
var seq16467__$1 = cljs.core.next(seq16467);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16468,seq16467__$1);
}));


//# sourceMappingURL=chord.client.js.map
