goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.tools.reader');
goog.require('cljs.env');
goog.require('cljs.analyzer');
goog.require('cljs.source_map');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__22757 = s;
var map__22757__$1 = (((((!((map__22757 == null))))?(((((map__22757.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22757.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22757):map__22757);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22757__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22757__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__22769 = info;
var map__22770 = G__22769;
var map__22770__$1 = (((((!((map__22770 == null))))?(((((map__22770.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22770.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22770):map__22770);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22770__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__22769__$1 = G__22769;
while(true){
var d__$2 = d__$1;
var map__22791 = G__22769__$1;
var map__22791__$1 = (((((!((map__22791 == null))))?(((((map__22791.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22791.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22791):map__22791);
var shadow__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22791__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$2)){
var G__23495 = (d__$2 + (1));
var G__23496 = shadow__$2;
d__$1 = G__23495;
G__22769__$1 = G__23496;
continue;
} else {
if(cljs.core.truth_((cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)) : cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name))))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__22800){
var map__22801 = p__22800;
var map__22801__$1 = (((((!((map__22801 == null))))?(((((map__22801.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22801.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22801):map__22801);
var name_var = map__22801__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22801__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22801__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__22803 = info;
var map__22803__$1 = (((((!((map__22803 == null))))?(((((map__22803.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22803.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22803):map__22803);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22803__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22803__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__22805 = [clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__22805) : cljs.compiler.munge.call(null,G__22805));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__22807 = arguments.length;
switch (G__22807) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.cljs_map_QMARK_(s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if((!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__22808 = new cljs.core.Var(function(){return cljs.core.munge_str;},new cljs.core.Symbol("cljs.core","munge-str","cljs.core/munge-str",-301346665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"munge-str","munge-str",-2042069652,null),"cljs/core.cljs",25,1,11472,11472,new cljs.core.Symbol(null,"string","string",-349010059,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__22808.cljs$core$IFn$_invoke$arity$1 ? fexpr__22808.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__22808.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__22809 = cp;
switch (G__22809) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__22810_23544 = cljs.core.seq(s);
var chunk__22811_23545 = null;
var count__22812_23546 = (0);
var i__22813_23547 = (0);
while(true){
if((i__22813_23547 < count__22812_23546)){
var c_23551 = chunk__22811_23545.cljs$core$IIndexed$_nth$arity$2(null,i__22813_23547);
sb.append(cljs.compiler.escape_char(c_23551));


var G__23555 = seq__22810_23544;
var G__23556 = chunk__22811_23545;
var G__23557 = count__22812_23546;
var G__23558 = (i__22813_23547 + (1));
seq__22810_23544 = G__23555;
chunk__22811_23545 = G__23556;
count__22812_23546 = G__23557;
i__22813_23547 = G__23558;
continue;
} else {
var temp__5735__auto___23560 = cljs.core.seq(seq__22810_23544);
if(temp__5735__auto___23560){
var seq__22810_23561__$1 = temp__5735__auto___23560;
if(cljs.core.chunked_seq_QMARK_(seq__22810_23561__$1)){
var c__4609__auto___23566 = cljs.core.chunk_first(seq__22810_23561__$1);
var G__23567 = cljs.core.chunk_rest(seq__22810_23561__$1);
var G__23568 = c__4609__auto___23566;
var G__23569 = cljs.core.count(c__4609__auto___23566);
var G__23570 = (0);
seq__22810_23544 = G__23567;
chunk__22811_23545 = G__23568;
count__22812_23546 = G__23569;
i__22813_23547 = G__23570;
continue;
} else {
var c_23571 = cljs.core.first(seq__22810_23561__$1);
sb.append(cljs.compiler.escape_char(c_23571));


var G__23573 = cljs.core.next(seq__22810_23561__$1);
var G__23574 = null;
var G__23575 = (0);
var G__23576 = (0);
seq__22810_23544 = G__23573;
chunk__22811_23545 = G__23574;
count__22812_23546 = G__23575;
i__22813_23547 = G__23576;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4672__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4673__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4674__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4675__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4676__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__22814 = cljs.core.get_global_hierarchy;
return (fexpr__22814.cljs$core$IFn$_invoke$arity$0 ? fexpr__22814.cljs$core$IFn$_invoke$arity$0() : fexpr__22814.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4676__auto__,method_table__4672__auto__,prefer_table__4673__auto__,method_cache__4674__auto__,cached_hierarchy__4675__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__22815_23592 = ast;
var map__22815_23593__$1 = (((((!((map__22815_23592 == null))))?(((((map__22815_23592.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22815_23592.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22815_23592):map__22815_23592);
var env_23594 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22815_23593__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_23594))){
var map__22817_23596 = env_23594;
var map__22817_23597__$1 = (((((!((map__22817_23596 == null))))?(((((map__22817_23596.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22817_23596.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22817_23596):map__22817_23596);
var line_23598 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22817_23597__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_23599 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22817_23597__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__22819 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__22821 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__22820 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"binding","binding",539932593),null,new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__22820.cljs$core$IFn$_invoke$arity$1 ? fexpr__22820.cljs$core$IFn$_invoke$arity$1(G__22821) : fexpr__22820.call(null,G__22821));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__22819,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__22819;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_23598 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_23599)?(column_23599 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}));
} else {
}
} else {
}

return (cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast) : cljs.compiler.emit_STAR_.call(null,ast));
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__22830 = arguments.length;
switch (G__22830) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___23617 = arguments.length;
var i__4790__auto___23618 = (0);
while(true){
if((i__4790__auto___23618 < len__4789__auto___23617)){
args_arr__4810__auto__.push((arguments[i__4790__auto___23618]));

var G__23620 = (i__4790__auto___23618 + (1));
i__4790__auto___23618 = G__23620;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4811__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(goog.isFunction(a)){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_23623 = (function (){var G__22831 = a;
if((!(typeof a === 'string'))){
return G__22831.toString();
} else {
return G__22831;
}
})();
var temp__5739__auto___23624 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5739__auto___23624 == null)){
} else {
var sm_data_23625 = temp__5739__auto___23624;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_23625,cljs.core.update,new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(function (p1__22822_SHARP_){
return (p1__22822_SHARP_ + s_23623.length);
}));
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_23623], 0));

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__22832 = cljs.core.seq(xs);
var chunk__22833 = null;
var count__22834 = (0);
var i__22835 = (0);
while(true){
if((i__22835 < count__22834)){
var x = chunk__22833.cljs$core$IIndexed$_nth$arity$2(null,i__22835);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__23628 = seq__22832;
var G__23629 = chunk__22833;
var G__23630 = count__22834;
var G__23631 = (i__22835 + (1));
seq__22832 = G__23628;
chunk__22833 = G__23629;
count__22834 = G__23630;
i__22835 = G__23631;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__22832);
if(temp__5735__auto__){
var seq__22832__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__22832__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__22832__$1);
var G__23632 = cljs.core.chunk_rest(seq__22832__$1);
var G__23633 = c__4609__auto__;
var G__23634 = cljs.core.count(c__4609__auto__);
var G__23635 = (0);
seq__22832 = G__23632;
chunk__22833 = G__23633;
count__22834 = G__23634;
i__22835 = G__23635;
continue;
} else {
var x = cljs.core.first(seq__22832__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__23636 = cljs.core.next(seq__22832__$1);
var G__23637 = null;
var G__23638 = (0);
var G__23639 = (0);
seq__22832 = G__23636;
chunk__22833 = G__23637;
count__22834 = G__23638;
i__22835 = G__23639;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq22824){
var G__22825 = cljs.core.first(seq22824);
var seq22824__$1 = cljs.core.next(seq22824);
var G__22826 = cljs.core.first(seq22824__$1);
var seq22824__$2 = cljs.core.next(seq22824__$1);
var G__22827 = cljs.core.first(seq22824__$2);
var seq22824__$3 = cljs.core.next(seq22824__$2);
var G__22828 = cljs.core.first(seq22824__$3);
var seq22824__$4 = cljs.core.next(seq22824__$3);
var G__22829 = cljs.core.first(seq22824__$4);
var seq22824__$5 = cljs.core.next(seq22824__$4);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__22825,G__22826,G__22827,G__22828,G__22829,seq22824__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__22837){
var map__22838 = p__22837;
var map__22838__$1 = (((((!((map__22838 == null))))?(((((map__22838.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22838.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22838):map__22838);
var m = map__22838__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22838__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__22849 = arguments.length;
switch (G__22849) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4810__auto__ = [];
var len__4789__auto___23645 = arguments.length;
var i__4790__auto___23646 = (0);
while(true){
if((i__4790__auto___23646 < len__4789__auto___23645)){
args_arr__4810__auto__.push((arguments[i__4790__auto___23646]));

var G__23647 = (i__4790__auto___23646 + (1));
i__4790__auto___23646 = G__23647;
continue;
} else {
}
break;
}

var argseq__4811__auto__ = (new cljs.core.IndexedSeq(args_arr__4810__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4811__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__22851_23679 = cljs.core.seq(xs);
var chunk__22852_23680 = null;
var count__22853_23681 = (0);
var i__22854_23682 = (0);
while(true){
if((i__22854_23682 < count__22853_23681)){
var x_23685 = chunk__22852_23680.cljs$core$IIndexed$_nth$arity$2(null,i__22854_23682);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_23685);


var G__23686 = seq__22851_23679;
var G__23687 = chunk__22852_23680;
var G__23688 = count__22853_23681;
var G__23689 = (i__22854_23682 + (1));
seq__22851_23679 = G__23686;
chunk__22852_23680 = G__23687;
count__22853_23681 = G__23688;
i__22854_23682 = G__23689;
continue;
} else {
var temp__5735__auto___23690 = cljs.core.seq(seq__22851_23679);
if(temp__5735__auto___23690){
var seq__22851_23691__$1 = temp__5735__auto___23690;
if(cljs.core.chunked_seq_QMARK_(seq__22851_23691__$1)){
var c__4609__auto___23692 = cljs.core.chunk_first(seq__22851_23691__$1);
var G__23693 = cljs.core.chunk_rest(seq__22851_23691__$1);
var G__23694 = c__4609__auto___23692;
var G__23695 = cljs.core.count(c__4609__auto___23692);
var G__23696 = (0);
seq__22851_23679 = G__23693;
chunk__22852_23680 = G__23694;
count__22853_23681 = G__23695;
i__22854_23682 = G__23696;
continue;
} else {
var x_23701 = cljs.core.first(seq__22851_23691__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_23701);


var G__23703 = cljs.core.next(seq__22851_23691__$1);
var G__23704 = null;
var G__23705 = (0);
var G__23706 = (0);
seq__22851_23679 = G__23703;
chunk__22852_23680 = G__23704;
count__22853_23681 = G__23705;
i__22854_23682 = G__23706;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq22841){
var G__22842 = cljs.core.first(seq22841);
var seq22841__$1 = cljs.core.next(seq22841);
var G__22843 = cljs.core.first(seq22841__$1);
var seq22841__$2 = cljs.core.next(seq22841__$1);
var G__22844 = cljs.core.first(seq22841__$2);
var seq22841__$3 = cljs.core.next(seq22841__$2);
var G__22845 = cljs.core.first(seq22841__$3);
var seq22841__$4 = cljs.core.next(seq22841__$3);
var G__22846 = cljs.core.first(seq22841__$4);
var seq22841__$5 = cljs.core.next(seq22841__$4);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__22842,G__22843,G__22844,G__22845,G__22846,seq22841__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4720__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__22855_23716 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__22856_23717 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__22857_23718 = true;
var _STAR_print_fn_STAR__temp_val__22858_23719 = (function (x__4721__auto__){
return sb__4720__auto__.append(x__4721__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__22857_23718);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__22858_23719);

try{cljs.compiler.emit(expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__22856_23717);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__22855_23716);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4720__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4672__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4673__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4674__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4675__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4676__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__22860 = cljs.core.get_global_hierarchy;
return (fexpr__22860.cljs$core$IFn$_invoke$arity$0 ? fexpr__22860.cljs$core$IFn$_invoke$arity$0() : fexpr__22860.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4676__auto__,method_table__4672__auto__,prefer_table__4673__auto__,method_cache__4674__auto__,cached_hierarchy__4675__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__22862 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22862,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22862,(1),null);
var G__22865 = ns;
var G__22866 = name;
var G__22867 = (function (){
var G__22868 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__22868) : cljs.compiler.emit_constant.call(null,G__22868));
});
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__22865,G__22866,G__22867) : cljs.compiler.emit_record_value.call(null,G__22865,G__22866,G__22867));
} else {
if(cljs.analyzer.cljs_map_QMARK_(x)){
var G__22869 = cljs.core.keys(x);
var G__22870 = cljs.core.vals(x);
var G__22871 = cljs.compiler.emit_constants_comma_sep;
var G__22872 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__22869,G__22870,G__22871,G__22872) : cljs.compiler.emit_map.call(null,G__22869,G__22870,G__22871,G__22872));
} else {
if(cljs.analyzer.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return (cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.compiler.emit_constant_STAR_.call(null,x));

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__22873 = (function (){
return cljs.compiler.emit_constant_no_meta(v);
});
var G__22874 = (function (){
return cljs.compiler.emit_constant_no_meta(m);
});
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__22873,G__22874) : cljs.compiler.emit_with_meta.call(null,G__22873,G__22874));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type(x),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__22884 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22884,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22884,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22884,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5733__auto__ = (function (){var and__4174__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4174__auto__)){
var G__22893 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__22893) : x.call(null,G__22893));
} else {
return and__4174__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5733__auto__ = (function (){var and__4174__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4174__auto__)){
var G__22894 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__22894) : x.call(null,G__22894));
} else {
return and__4174__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",date.getTime(),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__22896 = items;
var G__22897 = (function (p1__22895_SHARP_){
return (function (){
return cljs.compiler.emit_constant(p1__22895_SHARP_);
});
});
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__22896,G__22897) : cljs.compiler.emit_js_object.call(null,G__22896,G__22897));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__22900){
var map__22901 = p__22900;
var map__22901__$1 = (((((!((map__22901 == null))))?(((((map__22901.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22901.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22901):map__22901);
var ast = map__22901__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22901__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22901__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22901__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__5733__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5733__auto__)){
var const_expr = temp__5733__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__22903 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__22903__$1 = (((((!((map__22903 == null))))?(((((map__22903.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22903.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22903):map__22903);
var cenv = map__22903__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22903__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name(var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__4185__auto__ = js_module_name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__22906 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4174__auto__ = (function (){var G__22909 = new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__22909) : cljs.compiler.es5_GT__EQ_.call(null,G__22909));
})();
if(cljs.core.truth_(and__4174__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__4174__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__22906,cljs.analyzer.es5_allowed);
} else {
return G__22906;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-namespaces","js-namespaces",-471353612),(function (){var or__4185__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__22911 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__22911,reserved);
} else {
return G__22911;
}
})();
var env__22733__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__22733__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__22912_23778 = new cljs.core.Keyword(null,"module-type","module-type",1392760304).cljs$core$IFn$_invoke$arity$1(js_module);
var G__22912_23779__$1 = (((G__22912_23778 instanceof cljs.core.Keyword))?G__22912_23778.fqn:null);
switch (G__22912_23779__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__4174__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__22733__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"var","var",-769682797),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"binding","binding",539932593),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local","local",-1497766724),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"the-var","the-var",1428415613),(function (p__22913){
var map__22914 = p__22913;
var map__22914__$1 = (((((!((map__22914 == null))))?(((((map__22914.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22914.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22914):map__22914);
var arg = map__22914__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22914__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22914__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22914__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22914__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.analyzer.ast_QMARK_(sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_(meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__22919 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__22919__$1 = (((((!((map__22919 == null))))?(((((map__22919.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22919.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22919):map__22919);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22919__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__22733__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__22733__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__22733__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"with-meta","with-meta",-1566856820),(function (p__22922){
var map__22923 = p__22922;
var map__22923__$1 = (((((!((map__22923 == null))))?(((((map__22923.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22923.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22923):map__22923);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22923__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22923__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22923__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__22733__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__22733__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__22733__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_((function (p1__22926_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__22926_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__22931 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__22931) : comma_sep.call(null,G__22931));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__22932 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__22932) : comma_sep.call(null,G__22932));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__22934){
var map__22935 = p__22934;
var map__22935__$1 = (((((!((map__22935 == null))))?(((((map__22935.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22935.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22935):map__22935);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22935__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22935__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22935__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__22733__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__22733__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__22733__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__22937){
var map__22938 = p__22937;
var map__22938__$1 = (((((!((map__22938 == null))))?(((((map__22938.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22938.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22938):map__22938);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22938__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22938__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__22733__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__22733__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__22733__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_((function (p1__22940_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__22940_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__22941 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__22941) : comma_sep.call(null,G__22941));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set","set",304602554),(function (p__22942){
var map__22943 = p__22942;
var map__22943__$1 = (((((!((map__22943 == null))))?(((((map__22943.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22943.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22943):map__22943);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22943__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22943__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__22733__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__22733__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__22733__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5735__auto___23821 = cljs.core.seq(items);
if(temp__5735__auto___23821){
var items_23823__$1 = temp__5735__auto___23821;
var vec__22945_23824 = items_23823__$1;
var seq__22946_23825 = cljs.core.seq(vec__22945_23824);
var first__22947_23826 = cljs.core.first(seq__22946_23825);
var seq__22946_23827__$1 = cljs.core.next(seq__22946_23825);
var vec__22948_23828 = first__22947_23826;
var k_23829 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22948_23828,(0),null);
var v_23830 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22948_23828,(1),null);
var r_23831 = seq__22946_23827__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_23829),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_23830) : emit_js_object_val.call(null,v_23830)));

var seq__22952_23836 = cljs.core.seq(r_23831);
var chunk__22953_23837 = null;
var count__22954_23838 = (0);
var i__22955_23839 = (0);
while(true){
if((i__22955_23839 < count__22954_23838)){
var vec__22962_23844 = chunk__22953_23837.cljs$core$IIndexed$_nth$arity$2(null,i__22955_23839);
var k_23845__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22962_23844,(0),null);
var v_23846__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22962_23844,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_23845__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_23846__$1) : emit_js_object_val.call(null,v_23846__$1)));


var G__23847 = seq__22952_23836;
var G__23848 = chunk__22953_23837;
var G__23849 = count__22954_23838;
var G__23850 = (i__22955_23839 + (1));
seq__22952_23836 = G__23847;
chunk__22953_23837 = G__23848;
count__22954_23838 = G__23849;
i__22955_23839 = G__23850;
continue;
} else {
var temp__5735__auto___23852__$1 = cljs.core.seq(seq__22952_23836);
if(temp__5735__auto___23852__$1){
var seq__22952_23853__$1 = temp__5735__auto___23852__$1;
if(cljs.core.chunked_seq_QMARK_(seq__22952_23853__$1)){
var c__4609__auto___23854 = cljs.core.chunk_first(seq__22952_23853__$1);
var G__23855 = cljs.core.chunk_rest(seq__22952_23853__$1);
var G__23856 = c__4609__auto___23854;
var G__23857 = cljs.core.count(c__4609__auto___23854);
var G__23858 = (0);
seq__22952_23836 = G__23855;
chunk__22953_23837 = G__23856;
count__22954_23838 = G__23857;
i__22955_23839 = G__23858;
continue;
} else {
var vec__22966_23860 = cljs.core.first(seq__22952_23853__$1);
var k_23861__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22966_23860,(0),null);
var v_23862__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22966_23860,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_23861__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_23862__$1) : emit_js_object_val.call(null,v_23862__$1)));


var G__23863 = cljs.core.next(seq__22952_23853__$1);
var G__23864 = null;
var G__23865 = (0);
var G__23866 = (0);
seq__22952_23836 = G__23863;
chunk__22953_23837 = G__23864;
count__22954_23838 = G__23865;
i__22955_23839 = G__23866;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-object","js-object",1830199158),(function (p__22969){
var map__22970 = p__22969;
var map__22970__$1 = (((((!((map__22970 == null))))?(((((map__22970.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22970.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22970):map__22970);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22970__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22970__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22970__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__22733__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__22733__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__22733__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-array","js-array",-1210185421),(function (p__22972){
var map__22973 = p__22972;
var map__22973__$1 = (((((!((map__22973 == null))))?(((((map__22973.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22973.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22973):map__22973);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22973__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22973__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__22733__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__22733__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__22733__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"quote","quote",-262615245),(function (p__22975){
var map__22976 = p__22975;
var map__22976__$1 = (((((!((map__22976 == null))))?(((((map__22976.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22976.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22976):map__22976);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22976__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"const","const",1709929842),(function (p__22978){
var map__22982 = p__22978;
var map__22982__$1 = (((((!((map__22982 == null))))?(((((map__22982.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22982.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22982):map__22982);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22982__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22982__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__22733__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__22733__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__22733__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__22984 = cljs.analyzer.unwrap_quote(expr);
var map__22984__$1 = (((((!((map__22984 == null))))?(((((map__22984.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22984.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22984):map__22984);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22984__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22984__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22984__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4185__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842)))?(function (){var and__4174__auto__ = form;
if(cljs.core.truth_(and__4174__auto__)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4174__auto__;
}
})():false);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__22986 = cljs.analyzer.unwrap_quote(expr);
var map__22986__$1 = (((((!((map__22986 == null))))?(((((map__22986.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22986.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22986):map__22986);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22986__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22986__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22986__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4185__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842))) && (((form === false) || ((form == null)))));
if(or__4185__auto__){
return or__4185__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__4185__auto__ = (function (){var fexpr__22989 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null);
return (fexpr__22989.cljs$core$IFn$_invoke$arity$1 ? fexpr__22989.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__22989.call(null,tag));
})();
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__22993){
var map__22994 = p__22993;
var map__22994__$1 = (((((!((map__22994 == null))))?(((((map__22994.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22994.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22994):map__22994);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22994__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22994__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22994__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22994__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22994__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__4185__auto__ = unchecked;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"case","case",1143702196),(function (p__22999){
var map__23000 = p__22999;
var map__23000__$1 = (((((!((map__23000 == null))))?(((((map__23000.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23000.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23000):map__23000);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23000__$1,new cljs.core.Keyword(null,"test","test",577538877));
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23000__$1,new cljs.core.Keyword(null,"nodes","nodes",-2099585805));
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23000__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23000__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__23002_23886 = cljs.core.seq(nodes);
var chunk__23003_23887 = null;
var count__23004_23888 = (0);
var i__23005_23889 = (0);
while(true){
if((i__23005_23889 < count__23004_23888)){
var map__23038_23890 = chunk__23003_23887.cljs$core$IIndexed$_nth$arity$2(null,i__23005_23889);
var map__23038_23891__$1 = (((((!((map__23038_23890 == null))))?(((((map__23038_23890.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23038_23890.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23038_23890):map__23038_23890);
var ts_23892 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23038_23891__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__23039_23893 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23038_23891__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__23039_23894__$1 = (((((!((map__23039_23893 == null))))?(((((map__23039_23893.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23039_23893.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23039_23893):map__23039_23893);
var then_23895 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23039_23894__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__23042_23899 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_23892));
var chunk__23043_23900 = null;
var count__23044_23901 = (0);
var i__23045_23902 = (0);
while(true){
if((i__23045_23902 < count__23044_23901)){
var test_23906 = chunk__23043_23900.cljs$core$IIndexed$_nth$arity$2(null,i__23045_23902);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_23906,":");


var G__23907 = seq__23042_23899;
var G__23908 = chunk__23043_23900;
var G__23909 = count__23044_23901;
var G__23910 = (i__23045_23902 + (1));
seq__23042_23899 = G__23907;
chunk__23043_23900 = G__23908;
count__23044_23901 = G__23909;
i__23045_23902 = G__23910;
continue;
} else {
var temp__5735__auto___23911 = cljs.core.seq(seq__23042_23899);
if(temp__5735__auto___23911){
var seq__23042_23912__$1 = temp__5735__auto___23911;
if(cljs.core.chunked_seq_QMARK_(seq__23042_23912__$1)){
var c__4609__auto___23913 = cljs.core.chunk_first(seq__23042_23912__$1);
var G__23914 = cljs.core.chunk_rest(seq__23042_23912__$1);
var G__23915 = c__4609__auto___23913;
var G__23916 = cljs.core.count(c__4609__auto___23913);
var G__23917 = (0);
seq__23042_23899 = G__23914;
chunk__23043_23900 = G__23915;
count__23044_23901 = G__23916;
i__23045_23902 = G__23917;
continue;
} else {
var test_23918 = cljs.core.first(seq__23042_23912__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_23918,":");


var G__23919 = cljs.core.next(seq__23042_23912__$1);
var G__23920 = null;
var G__23921 = (0);
var G__23922 = (0);
seq__23042_23899 = G__23919;
chunk__23043_23900 = G__23920;
count__23044_23901 = G__23921;
i__23045_23902 = G__23922;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_23895);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_23895);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__23927 = seq__23002_23886;
var G__23928 = chunk__23003_23887;
var G__23929 = count__23004_23888;
var G__23930 = (i__23005_23889 + (1));
seq__23002_23886 = G__23927;
chunk__23003_23887 = G__23928;
count__23004_23888 = G__23929;
i__23005_23889 = G__23930;
continue;
} else {
var temp__5735__auto___23932 = cljs.core.seq(seq__23002_23886);
if(temp__5735__auto___23932){
var seq__23002_23934__$1 = temp__5735__auto___23932;
if(cljs.core.chunked_seq_QMARK_(seq__23002_23934__$1)){
var c__4609__auto___23935 = cljs.core.chunk_first(seq__23002_23934__$1);
var G__23936 = cljs.core.chunk_rest(seq__23002_23934__$1);
var G__23937 = c__4609__auto___23935;
var G__23938 = cljs.core.count(c__4609__auto___23935);
var G__23939 = (0);
seq__23002_23886 = G__23936;
chunk__23003_23887 = G__23937;
count__23004_23888 = G__23938;
i__23005_23889 = G__23939;
continue;
} else {
var map__23046_23940 = cljs.core.first(seq__23002_23934__$1);
var map__23046_23941__$1 = (((((!((map__23046_23940 == null))))?(((((map__23046_23940.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23046_23940.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23046_23940):map__23046_23940);
var ts_23942 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23046_23941__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__23047_23943 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23046_23941__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__23047_23944__$1 = (((((!((map__23047_23943 == null))))?(((((map__23047_23943.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23047_23943.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23047_23943):map__23047_23943);
var then_23945 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23047_23944__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__23050_23953 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_23942));
var chunk__23051_23954 = null;
var count__23052_23955 = (0);
var i__23053_23956 = (0);
while(true){
if((i__23053_23956 < count__23052_23955)){
var test_23958 = chunk__23051_23954.cljs$core$IIndexed$_nth$arity$2(null,i__23053_23956);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_23958,":");


var G__23959 = seq__23050_23953;
var G__23960 = chunk__23051_23954;
var G__23961 = count__23052_23955;
var G__23962 = (i__23053_23956 + (1));
seq__23050_23953 = G__23959;
chunk__23051_23954 = G__23960;
count__23052_23955 = G__23961;
i__23053_23956 = G__23962;
continue;
} else {
var temp__5735__auto___23963__$1 = cljs.core.seq(seq__23050_23953);
if(temp__5735__auto___23963__$1){
var seq__23050_23964__$1 = temp__5735__auto___23963__$1;
if(cljs.core.chunked_seq_QMARK_(seq__23050_23964__$1)){
var c__4609__auto___23965 = cljs.core.chunk_first(seq__23050_23964__$1);
var G__23966 = cljs.core.chunk_rest(seq__23050_23964__$1);
var G__23967 = c__4609__auto___23965;
var G__23968 = cljs.core.count(c__4609__auto___23965);
var G__23969 = (0);
seq__23050_23953 = G__23966;
chunk__23051_23954 = G__23967;
count__23052_23955 = G__23968;
i__23053_23956 = G__23969;
continue;
} else {
var test_23970 = cljs.core.first(seq__23050_23964__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_23970,":");


var G__23971 = cljs.core.next(seq__23050_23964__$1);
var G__23972 = null;
var G__23973 = (0);
var G__23974 = (0);
seq__23050_23953 = G__23971;
chunk__23051_23954 = G__23972;
count__23052_23955 = G__23973;
i__23053_23956 = G__23974;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_23945);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_23945);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__23975 = cljs.core.next(seq__23002_23934__$1);
var G__23976 = null;
var G__23977 = (0);
var G__23978 = (0);
seq__23002_23886 = G__23975;
chunk__23003_23887 = G__23976;
count__23004_23888 = G__23977;
i__23005_23889 = G__23978;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__23054){
var map__23055 = p__23054;
var map__23055__$1 = (((((!((map__23055 == null))))?(((((map__23055.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23055.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23055):map__23055);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23055__$1,new cljs.core.Keyword(null,"exception","exception",-335277064));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23055__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"!"))){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__23060 = env;
var G__23061 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__23060,G__23061) : cljs.compiler.resolve_type.call(null,G__23060,G__23061));
})())].join('');
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"{"))){
return t;
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"function"))){
var idx = t.lastIndexOf(":");
var vec__23062 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23062,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23062,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2((function (p1__23057_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__23057_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__23057_SHARP_));
}),clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__23065 = ["function(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__23065,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__23065;
}
} else {
if(cljs.core.truth_(goog.string.endsWith(t,"="))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__23068 = env;
var G__23069 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__23068,G__23069) : cljs.compiler.resolve_type.call(null,G__23068,G__23069));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__23071_SHARP_){
return cljs.compiler.resolve_type(env,p1__23071_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__23072 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__23073 = cljs.core.seq(vec__23072);
var first__23074 = cljs.core.first(seq__23073);
var seq__23073__$1 = cljs.core.next(seq__23073);
var p = first__23074;
var first__23074__$1 = cljs.core.first(seq__23073__$1);
var seq__23073__$2 = cljs.core.next(seq__23073__$1);
var ts = first__23074__$1;
var first__23074__$2 = cljs.core.first(seq__23073__$2);
var seq__23073__$3 = cljs.core.next(seq__23073__$2);
var n = first__23074__$2;
var xs = seq__23073__$3;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p))?(function (){var and__4174__auto__ = ts;
if(cljs.core.truth_(and__4174__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4174__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__23075 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__23076 = cljs.core.seq(vec__23075);
var first__23077 = cljs.core.first(seq__23076);
var seq__23076__$1 = cljs.core.next(seq__23076);
var p = first__23077;
var first__23077__$1 = cljs.core.first(seq__23076__$1);
var seq__23076__$2 = cljs.core.next(seq__23076__$1);
var ts = first__23077__$1;
var xs = seq__23076__$2;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p))?(function (){var and__4174__auto__ = ts;
if(cljs.core.truth_(and__4174__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4174__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__23083 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null));
var fexpr__23082 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null);
return (fexpr__23082.cljs$core$IFn$_invoke$arity$1 ? fexpr__23082.cljs$core$IFn$_invoke$arity$1(G__23083) : fexpr__23082.call(null,G__23083));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__23086 = arguments.length;
switch (G__23086) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__23094 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__23084_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__23084_SHARP_);
} else {
return p1__23084_SHARP_;
}
}),clojure.string.split_lines(e));
var seq__23095 = cljs.core.seq(vec__23094);
var first__23096 = cljs.core.first(seq__23095);
var seq__23095__$1 = cljs.core.next(seq__23095);
var x = first__23096;
var ys = seq__23095__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__23097 = cljs.core.seq(ys);
var chunk__23098 = null;
var count__23099 = (0);
var i__23100 = (0);
while(true){
if((i__23100 < count__23099)){
var next_line = chunk__23098.cljs$core$IIndexed$_nth$arity$2(null,i__23100);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__24023 = seq__23097;
var G__24024 = chunk__23098;
var G__24025 = count__23099;
var G__24026 = (i__23100 + (1));
seq__23097 = G__24023;
chunk__23098 = G__24024;
count__23099 = G__24025;
i__23100 = G__24026;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__23097);
if(temp__5735__auto__){
var seq__23097__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__23097__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__23097__$1);
var G__24027 = cljs.core.chunk_rest(seq__23097__$1);
var G__24028 = c__4609__auto__;
var G__24029 = cljs.core.count(c__4609__auto__);
var G__24030 = (0);
seq__23097 = G__24027;
chunk__23098 = G__24028;
count__23099 = G__24029;
i__23100 = G__24030;
continue;
} else {
var next_line = cljs.core.first(seq__23097__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__24033 = cljs.core.next(seq__23097__$1);
var G__24034 = null;
var G__24035 = (0);
var G__24036 = (0);
seq__23097 = G__24033;
chunk__23098 = G__24034;
count__23099 = G__24035;
i__23100 = G__24036;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__23101_24037 = cljs.core.seq(docs__$2);
var chunk__23102_24038 = null;
var count__23103_24039 = (0);
var i__23104_24040 = (0);
while(true){
if((i__23104_24040 < count__23103_24039)){
var e_24041 = chunk__23102_24038.cljs$core$IIndexed$_nth$arity$2(null,i__23104_24040);
if(cljs.core.truth_(e_24041)){
print_comment_lines(e_24041);
} else {
}


var G__24042 = seq__23101_24037;
var G__24043 = chunk__23102_24038;
var G__24044 = count__23103_24039;
var G__24045 = (i__23104_24040 + (1));
seq__23101_24037 = G__24042;
chunk__23102_24038 = G__24043;
count__23103_24039 = G__24044;
i__23104_24040 = G__24045;
continue;
} else {
var temp__5735__auto___24047 = cljs.core.seq(seq__23101_24037);
if(temp__5735__auto___24047){
var seq__23101_24049__$1 = temp__5735__auto___24047;
if(cljs.core.chunked_seq_QMARK_(seq__23101_24049__$1)){
var c__4609__auto___24050 = cljs.core.chunk_first(seq__23101_24049__$1);
var G__24051 = cljs.core.chunk_rest(seq__23101_24049__$1);
var G__24052 = c__4609__auto___24050;
var G__24053 = cljs.core.count(c__4609__auto___24050);
var G__24054 = (0);
seq__23101_24037 = G__24051;
chunk__23102_24038 = G__24052;
count__23103_24039 = G__24053;
i__23104_24040 = G__24054;
continue;
} else {
var e_24055 = cljs.core.first(seq__23101_24049__$1);
if(cljs.core.truth_(e_24055)){
print_comment_lines(e_24055);
} else {
}


var G__24056 = cljs.core.next(seq__23101_24049__$1);
var G__24057 = null;
var G__24058 = (0);
var G__24059 = (0);
seq__23101_24037 = G__24056;
chunk__23102_24038 = G__24057;
count__23103_24039 = G__24058;
i__23104_24040 = G__24059;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (x === true) || (x === false) || (typeof x === 'number'));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__4174__auto__ = cljs.core.some((function (p1__23106_SHARP_){
return goog.string.startsWith(p1__23106_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4174__auto__)){
var and__4174__auto____$1 = opts;
if(cljs.core.truth_(and__4174__auto____$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478))){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return false;
}
} else {
return and__4174__auto____$1;
}
} else {
return and__4174__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__23107){
var map__23108 = p__23107;
var map__23108__$1 = (((((!((map__23108 == null))))?(((((map__23108.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23108.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23108):map__23108);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23108__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23108__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23108__$1,new cljs.core.Keyword(null,"test","test",577538877));
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23108__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23108__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23108__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23108__$1,new cljs.core.Keyword(null,"export","export",214356590));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23108__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23108__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__4185__auto__ = init;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(jsdoc,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5733__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5733__auto__)){
var define = temp__5733__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"the-var","the-var",1428415613),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
return test;
} else {
return and__4174__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__23110){
var map__23111 = p__23110;
var map__23111__$1 = (((((!((map__23111 == null))))?(((((map__23111.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23111.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23111):map__23111);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23111__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23111__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23111__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__23113_24085 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__23114_24086 = null;
var count__23115_24087 = (0);
var i__23116_24088 = (0);
while(true){
if((i__23116_24088 < count__23115_24087)){
var vec__23123_24091 = chunk__23114_24086.cljs$core$IIndexed$_nth$arity$2(null,i__23116_24088);
var i_24092 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23123_24091,(0),null);
var param_24093 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23123_24091,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_24093);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__24094 = seq__23113_24085;
var G__24095 = chunk__23114_24086;
var G__24096 = count__23115_24087;
var G__24097 = (i__23116_24088 + (1));
seq__23113_24085 = G__24094;
chunk__23114_24086 = G__24095;
count__23115_24087 = G__24096;
i__23116_24088 = G__24097;
continue;
} else {
var temp__5735__auto___24098 = cljs.core.seq(seq__23113_24085);
if(temp__5735__auto___24098){
var seq__23113_24099__$1 = temp__5735__auto___24098;
if(cljs.core.chunked_seq_QMARK_(seq__23113_24099__$1)){
var c__4609__auto___24101 = cljs.core.chunk_first(seq__23113_24099__$1);
var G__24103 = cljs.core.chunk_rest(seq__23113_24099__$1);
var G__24104 = c__4609__auto___24101;
var G__24105 = cljs.core.count(c__4609__auto___24101);
var G__24106 = (0);
seq__23113_24085 = G__24103;
chunk__23114_24086 = G__24104;
count__23115_24087 = G__24105;
i__23116_24088 = G__24106;
continue;
} else {
var vec__23126_24107 = cljs.core.first(seq__23113_24099__$1);
var i_24108 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23126_24107,(0),null);
var param_24109 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23126_24107,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_24109);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__24111 = cljs.core.next(seq__23113_24099__$1);
var G__24112 = null;
var G__24113 = (0);
var G__24114 = (0);
seq__23113_24085 = G__24111;
chunk__23114_24086 = G__24112;
count__23115_24087 = G__24113;
i__23116_24088 = G__24114;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__23129_24117 = cljs.core.seq(params);
var chunk__23130_24118 = null;
var count__23131_24119 = (0);
var i__23132_24120 = (0);
while(true){
if((i__23132_24120 < count__23131_24119)){
var param_24125 = chunk__23130_24118.cljs$core$IIndexed$_nth$arity$2(null,i__23132_24120);
cljs.compiler.emit(param_24125);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_24125,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__24126 = seq__23129_24117;
var G__24127 = chunk__23130_24118;
var G__24128 = count__23131_24119;
var G__24129 = (i__23132_24120 + (1));
seq__23129_24117 = G__24126;
chunk__23130_24118 = G__24127;
count__23131_24119 = G__24128;
i__23132_24120 = G__24129;
continue;
} else {
var temp__5735__auto___24132 = cljs.core.seq(seq__23129_24117);
if(temp__5735__auto___24132){
var seq__23129_24133__$1 = temp__5735__auto___24132;
if(cljs.core.chunked_seq_QMARK_(seq__23129_24133__$1)){
var c__4609__auto___24134 = cljs.core.chunk_first(seq__23129_24133__$1);
var G__24139 = cljs.core.chunk_rest(seq__23129_24133__$1);
var G__24140 = c__4609__auto___24134;
var G__24141 = cljs.core.count(c__4609__auto___24134);
var G__24142 = (0);
seq__23129_24117 = G__24139;
chunk__23130_24118 = G__24140;
count__23131_24119 = G__24141;
i__23132_24120 = G__24142;
continue;
} else {
var param_24143 = cljs.core.first(seq__23129_24133__$1);
cljs.compiler.emit(param_24143);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_24143,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__24145 = cljs.core.next(seq__23129_24133__$1);
var G__24146 = null;
var G__24147 = (0);
var G__24148 = (0);
seq__23129_24117 = G__24145;
chunk__23130_24118 = G__24146;
count__23131_24119 = G__24147;
i__23132_24120 = G__24148;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__23133_24151 = cljs.core.seq(params);
var chunk__23134_24152 = null;
var count__23135_24153 = (0);
var i__23136_24154 = (0);
while(true){
if((i__23136_24154 < count__23135_24153)){
var param_24155 = chunk__23134_24152.cljs$core$IIndexed$_nth$arity$2(null,i__23136_24154);
cljs.compiler.emit(param_24155);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_24155,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__24157 = seq__23133_24151;
var G__24158 = chunk__23134_24152;
var G__24159 = count__23135_24153;
var G__24160 = (i__23136_24154 + (1));
seq__23133_24151 = G__24157;
chunk__23134_24152 = G__24158;
count__23135_24153 = G__24159;
i__23136_24154 = G__24160;
continue;
} else {
var temp__5735__auto___24161 = cljs.core.seq(seq__23133_24151);
if(temp__5735__auto___24161){
var seq__23133_24162__$1 = temp__5735__auto___24161;
if(cljs.core.chunked_seq_QMARK_(seq__23133_24162__$1)){
var c__4609__auto___24165 = cljs.core.chunk_first(seq__23133_24162__$1);
var G__24166 = cljs.core.chunk_rest(seq__23133_24162__$1);
var G__24167 = c__4609__auto___24165;
var G__24168 = cljs.core.count(c__4609__auto___24165);
var G__24169 = (0);
seq__23133_24151 = G__24166;
chunk__23134_24152 = G__24167;
count__23135_24153 = G__24168;
i__23136_24154 = G__24169;
continue;
} else {
var param_24170 = cljs.core.first(seq__23133_24162__$1);
cljs.compiler.emit(param_24170);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_24170,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__24171 = cljs.core.next(seq__23133_24162__$1);
var G__24172 = null;
var G__24173 = (0);
var G__24174 = (0);
seq__23133_24151 = G__24171;
chunk__23134_24152 = G__24172;
count__23135_24153 = G__24173;
i__23136_24154 = G__24174;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__23137 = cljs.core.seq(params);
var chunk__23138 = null;
var count__23139 = (0);
var i__23140 = (0);
while(true){
if((i__23140 < count__23139)){
var param = chunk__23138.cljs$core$IIndexed$_nth$arity$2(null,i__23140);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__24176 = seq__23137;
var G__24177 = chunk__23138;
var G__24178 = count__23139;
var G__24179 = (i__23140 + (1));
seq__23137 = G__24176;
chunk__23138 = G__24177;
count__23139 = G__24178;
i__23140 = G__24179;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__23137);
if(temp__5735__auto__){
var seq__23137__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__23137__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__23137__$1);
var G__24180 = cljs.core.chunk_rest(seq__23137__$1);
var G__24181 = c__4609__auto__;
var G__24182 = cljs.core.count(c__4609__auto__);
var G__24183 = (0);
seq__23137 = G__24180;
chunk__23138 = G__24181;
count__23139 = G__24182;
i__23140 = G__24183;
continue;
} else {
var param = cljs.core.first(seq__23137__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__24184 = cljs.core.next(seq__23137__$1);
var G__24185 = null;
var G__24186 = (0);
var G__24187 = (0);
seq__23137 = G__24184;
chunk__23138 = G__24185;
count__23139 = G__24186;
i__23140 = G__24187;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__23143){
var map__23144 = p__23143;
var map__23144__$1 = (((((!((map__23144 == null))))?(((((map__23144.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23144.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23144):map__23144);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23144__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23144__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23144__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23144__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23144__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23144__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__22733__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__22733__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__22733__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_(startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__23152){
var map__23153 = p__23152;
var map__23153__$1 = (((((!((map__23153 == null))))?(((((map__23153.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23153.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23153):map__23153);
var f = map__23153__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23153__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23153__$1,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869));
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23153__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23153__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23153__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23153__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23153__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23153__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__22733__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__22733__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_24218__$1 = (function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_24219 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_24218__$1);
var delegate_name_24220 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_24219),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_24220," = function (");

var seq__23155_24221 = cljs.core.seq(params);
var chunk__23156_24222 = null;
var count__23157_24223 = (0);
var i__23158_24224 = (0);
while(true){
if((i__23158_24224 < count__23157_24223)){
var param_24225 = chunk__23156_24222.cljs$core$IIndexed$_nth$arity$2(null,i__23158_24224);
cljs.compiler.emit(param_24225);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_24225,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__24226 = seq__23155_24221;
var G__24227 = chunk__23156_24222;
var G__24228 = count__23157_24223;
var G__24229 = (i__23158_24224 + (1));
seq__23155_24221 = G__24226;
chunk__23156_24222 = G__24227;
count__23157_24223 = G__24228;
i__23158_24224 = G__24229;
continue;
} else {
var temp__5735__auto___24230 = cljs.core.seq(seq__23155_24221);
if(temp__5735__auto___24230){
var seq__23155_24231__$1 = temp__5735__auto___24230;
if(cljs.core.chunked_seq_QMARK_(seq__23155_24231__$1)){
var c__4609__auto___24232 = cljs.core.chunk_first(seq__23155_24231__$1);
var G__24233 = cljs.core.chunk_rest(seq__23155_24231__$1);
var G__24234 = c__4609__auto___24232;
var G__24235 = cljs.core.count(c__4609__auto___24232);
var G__24236 = (0);
seq__23155_24221 = G__24233;
chunk__23156_24222 = G__24234;
count__23157_24223 = G__24235;
i__23158_24224 = G__24236;
continue;
} else {
var param_24238 = cljs.core.first(seq__23155_24231__$1);
cljs.compiler.emit(param_24238);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_24238,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__24240 = cljs.core.next(seq__23155_24231__$1);
var G__24241 = null;
var G__24242 = (0);
var G__24243 = (0);
seq__23155_24221 = G__24240;
chunk__23156_24222 = G__24241;
count__23157_24223 = G__24242;
i__23158_24224 = G__24243;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_24219," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_24254 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_24254,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_24220,".call(this,");

var seq__23159_24255 = cljs.core.seq(params);
var chunk__23160_24256 = null;
var count__23161_24257 = (0);
var i__23162_24258 = (0);
while(true){
if((i__23162_24258 < count__23161_24257)){
var param_24260 = chunk__23160_24256.cljs$core$IIndexed$_nth$arity$2(null,i__23162_24258);
cljs.compiler.emit(param_24260);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_24260,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__24261 = seq__23159_24255;
var G__24262 = chunk__23160_24256;
var G__24263 = count__23161_24257;
var G__24264 = (i__23162_24258 + (1));
seq__23159_24255 = G__24261;
chunk__23160_24256 = G__24262;
count__23161_24257 = G__24263;
i__23162_24258 = G__24264;
continue;
} else {
var temp__5735__auto___24267 = cljs.core.seq(seq__23159_24255);
if(temp__5735__auto___24267){
var seq__23159_24268__$1 = temp__5735__auto___24267;
if(cljs.core.chunked_seq_QMARK_(seq__23159_24268__$1)){
var c__4609__auto___24269 = cljs.core.chunk_first(seq__23159_24268__$1);
var G__24270 = cljs.core.chunk_rest(seq__23159_24268__$1);
var G__24271 = c__4609__auto___24269;
var G__24272 = cljs.core.count(c__4609__auto___24269);
var G__24273 = (0);
seq__23159_24255 = G__24270;
chunk__23160_24256 = G__24271;
count__23161_24257 = G__24272;
i__23162_24258 = G__24273;
continue;
} else {
var param_24274 = cljs.core.first(seq__23159_24268__$1);
cljs.compiler.emit(param_24274);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_24274,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__24279 = cljs.core.next(seq__23159_24268__$1);
var G__24280 = null;
var G__24281 = (0);
var G__24282 = (0);
seq__23159_24255 = G__24279;
chunk__23160_24256 = G__24280;
count__23161_24257 = G__24281;
i__23162_24258 = G__24282;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_24219,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_24219,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.Keyword(null,"name","name",1843675177),name_24218__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_24219,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_24220,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_24219,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__22733__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__23166){
var map__23167 = p__23166;
var map__23167__$1 = (((((!((map__23167 == null))))?(((((map__23167.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23167.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23167):map__23167);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23167__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23167__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23167__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23167__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23167__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23167__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var in_loop = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23167__$1,new cljs.core.Keyword(null,"in-loop","in-loop",-187298246));
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23167__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__23163_SHARP_){
var and__4174__auto__ = p1__23163_SHARP_;
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core.deref(new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__23163_SHARP_));
} else {
return and__4174__auto__;
}
}),recur_frames)], 0));
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(recur_params,(cljs.core.truth_((function (){var or__4185__auto__ = in_loop;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.seq(recur_params);
}
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)):null))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_24295__$1 = (function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_24296 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_24295__$1);
var maxparams_24297 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_24298 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_24296),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_24299 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__23164_SHARP_){
return cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__23164_SHARP_)));
}),cljs.core.seq(mmap_24298));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_24296," = null;");

var seq__23170_24300 = cljs.core.seq(ms_24299);
var chunk__23171_24301 = null;
var count__23172_24302 = (0);
var i__23173_24303 = (0);
while(true){
if((i__23173_24303 < count__23172_24302)){
var vec__23181_24304 = chunk__23171_24301.cljs$core$IIndexed$_nth$arity$2(null,i__23173_24303);
var n_24305 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23181_24304,(0),null);
var meth_24306 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23181_24304,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_24305," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_24306))){
cljs.compiler.emit_variadic_fn_method(meth_24306);
} else {
cljs.compiler.emit_fn_method(meth_24306);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__24307 = seq__23170_24300;
var G__24308 = chunk__23171_24301;
var G__24309 = count__23172_24302;
var G__24310 = (i__23173_24303 + (1));
seq__23170_24300 = G__24307;
chunk__23171_24301 = G__24308;
count__23172_24302 = G__24309;
i__23173_24303 = G__24310;
continue;
} else {
var temp__5735__auto___24313 = cljs.core.seq(seq__23170_24300);
if(temp__5735__auto___24313){
var seq__23170_24314__$1 = temp__5735__auto___24313;
if(cljs.core.chunked_seq_QMARK_(seq__23170_24314__$1)){
var c__4609__auto___24315 = cljs.core.chunk_first(seq__23170_24314__$1);
var G__24317 = cljs.core.chunk_rest(seq__23170_24314__$1);
var G__24318 = c__4609__auto___24315;
var G__24319 = cljs.core.count(c__4609__auto___24315);
var G__24320 = (0);
seq__23170_24300 = G__24317;
chunk__23171_24301 = G__24318;
count__23172_24302 = G__24319;
i__23173_24303 = G__24320;
continue;
} else {
var vec__23184_24321 = cljs.core.first(seq__23170_24314__$1);
var n_24322 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23184_24321,(0),null);
var meth_24323 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23184_24321,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_24322," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_24323))){
cljs.compiler.emit_variadic_fn_method(meth_24323);
} else {
cljs.compiler.emit_fn_method(meth_24323);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__24348 = cljs.core.next(seq__23170_24314__$1);
var G__24349 = null;
var G__24350 = (0);
var G__24351 = (0);
seq__23170_24300 = G__24348;
chunk__23171_24301 = G__24349;
count__23172_24302 = G__24350;
i__23173_24303 = G__24351;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_24296," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_24297),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_24297)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_24297));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__23187_24352 = cljs.core.seq(ms_24299);
var chunk__23188_24353 = null;
var count__23189_24354 = (0);
var i__23190_24355 = (0);
while(true){
if((i__23190_24355 < count__23189_24354)){
var vec__23201_24356 = chunk__23188_24353.cljs$core$IIndexed$_nth$arity$2(null,i__23190_24355);
var n_24357 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23201_24356,(0),null);
var meth_24358 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23201_24356,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_24358))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_24359 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_24359," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_24361 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_24359," = new cljs.core.IndexedSeq(",a_24361,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_24357,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_24297)),(((cljs.core.count(maxparams_24297) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_24359,");"], 0));
} else {
var pcnt_24363 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_24358));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_24363,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_24357,".call(this",(((pcnt_24363 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_24363,maxparams_24297)),null,(1),null)),(2),null))),");");
}


var G__24365 = seq__23187_24352;
var G__24366 = chunk__23188_24353;
var G__24367 = count__23189_24354;
var G__24368 = (i__23190_24355 + (1));
seq__23187_24352 = G__24365;
chunk__23188_24353 = G__24366;
count__23189_24354 = G__24367;
i__23190_24355 = G__24368;
continue;
} else {
var temp__5735__auto___24371 = cljs.core.seq(seq__23187_24352);
if(temp__5735__auto___24371){
var seq__23187_24378__$1 = temp__5735__auto___24371;
if(cljs.core.chunked_seq_QMARK_(seq__23187_24378__$1)){
var c__4609__auto___24379 = cljs.core.chunk_first(seq__23187_24378__$1);
var G__24380 = cljs.core.chunk_rest(seq__23187_24378__$1);
var G__24381 = c__4609__auto___24379;
var G__24382 = cljs.core.count(c__4609__auto___24379);
var G__24383 = (0);
seq__23187_24352 = G__24380;
chunk__23188_24353 = G__24381;
count__23189_24354 = G__24382;
i__23190_24355 = G__24383;
continue;
} else {
var vec__23204_24384 = cljs.core.first(seq__23187_24378__$1);
var n_24385 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23204_24384,(0),null);
var meth_24386 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23204_24384,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_24386))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_24388 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_24388," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_24389 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_24388," = new cljs.core.IndexedSeq(",a_24389,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_24385,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_24297)),(((cljs.core.count(maxparams_24297) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_24388,");"], 0));
} else {
var pcnt_24391 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_24386));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_24391,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_24385,".call(this",(((pcnt_24391 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_24391,maxparams_24297)),null,(1),null)),(2),null))),");");
}


var G__24394 = cljs.core.next(seq__23187_24378__$1);
var G__24395 = null;
var G__24396 = (0);
var G__24397 = (0);
seq__23187_24352 = G__24394;
chunk__23188_24353 = G__24395;
count__23189_24354 = G__24396;
i__23190_24355 = G__24397;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_24398 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_24299)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_24398,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_24296,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_24296,".cljs$lang$applyTo = ",cljs.core.some((function (p1__23165_SHARP_){
var vec__23207 = p1__23165_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23207,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23207,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_24299),".cljs$lang$applyTo;");
} else {
}

var seq__23210_24399 = cljs.core.seq(ms_24299);
var chunk__23211_24400 = null;
var count__23212_24401 = (0);
var i__23213_24402 = (0);
while(true){
if((i__23213_24402 < count__23212_24401)){
var vec__23222_24403 = chunk__23211_24400.cljs$core$IIndexed$_nth$arity$2(null,i__23213_24402);
var n_24404 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23222_24403,(0),null);
var meth_24405 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23222_24403,(1),null);
var c_24406 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_24405));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_24405))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_24296,".cljs$core$IFn$_invoke$arity$variadic = ",n_24404,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_24296,".cljs$core$IFn$_invoke$arity$",c_24406," = ",n_24404,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__24407 = seq__23210_24399;
var G__24408 = chunk__23211_24400;
var G__24409 = count__23212_24401;
var G__24410 = (i__23213_24402 + (1));
seq__23210_24399 = G__24407;
chunk__23211_24400 = G__24408;
count__23212_24401 = G__24409;
i__23213_24402 = G__24410;
continue;
} else {
var temp__5735__auto___24411 = cljs.core.seq(seq__23210_24399);
if(temp__5735__auto___24411){
var seq__23210_24412__$1 = temp__5735__auto___24411;
if(cljs.core.chunked_seq_QMARK_(seq__23210_24412__$1)){
var c__4609__auto___24413 = cljs.core.chunk_first(seq__23210_24412__$1);
var G__24414 = cljs.core.chunk_rest(seq__23210_24412__$1);
var G__24415 = c__4609__auto___24413;
var G__24416 = cljs.core.count(c__4609__auto___24413);
var G__24417 = (0);
seq__23210_24399 = G__24414;
chunk__23211_24400 = G__24415;
count__23212_24401 = G__24416;
i__23213_24402 = G__24417;
continue;
} else {
var vec__23225_24418 = cljs.core.first(seq__23210_24412__$1);
var n_24419 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23225_24418,(0),null);
var meth_24420 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23225_24418,(1),null);
var c_24421 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_24420));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_24420))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_24296,".cljs$core$IFn$_invoke$arity$variadic = ",n_24419,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_24296,".cljs$core$IFn$_invoke$arity$",c_24421," = ",n_24419,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__24422 = cljs.core.next(seq__23210_24412__$1);
var G__24423 = null;
var G__24424 = (0);
var G__24425 = (0);
seq__23210_24399 = G__24422;
chunk__23211_24400 = G__24423;
count__23212_24401 = G__24424;
i__23213_24402 = G__24425;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_24296,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"do","do",46310725),(function (p__23228){
var map__23229 = p__23228;
var map__23229__$1 = (((((!((map__23229 == null))))?(((((map__23229.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23229.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23229):map__23229);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23229__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23229__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23229__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__23231_24449 = cljs.core.seq(statements);
var chunk__23232_24450 = null;
var count__23233_24451 = (0);
var i__23234_24452 = (0);
while(true){
if((i__23234_24452 < count__23233_24451)){
var s_24453 = chunk__23232_24450.cljs$core$IIndexed$_nth$arity$2(null,i__23234_24452);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_24453);


var G__24454 = seq__23231_24449;
var G__24455 = chunk__23232_24450;
var G__24456 = count__23233_24451;
var G__24457 = (i__23234_24452 + (1));
seq__23231_24449 = G__24454;
chunk__23232_24450 = G__24455;
count__23233_24451 = G__24456;
i__23234_24452 = G__24457;
continue;
} else {
var temp__5735__auto___24458 = cljs.core.seq(seq__23231_24449);
if(temp__5735__auto___24458){
var seq__23231_24459__$1 = temp__5735__auto___24458;
if(cljs.core.chunked_seq_QMARK_(seq__23231_24459__$1)){
var c__4609__auto___24460 = cljs.core.chunk_first(seq__23231_24459__$1);
var G__24461 = cljs.core.chunk_rest(seq__23231_24459__$1);
var G__24462 = c__4609__auto___24460;
var G__24463 = cljs.core.count(c__4609__auto___24460);
var G__24464 = (0);
seq__23231_24449 = G__24461;
chunk__23232_24450 = G__24462;
count__23233_24451 = G__24463;
i__23234_24452 = G__24464;
continue;
} else {
var s_24465 = cljs.core.first(seq__23231_24459__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_24465);


var G__24466 = cljs.core.next(seq__23231_24459__$1);
var G__24467 = null;
var G__24468 = (0);
var G__24469 = (0);
seq__23231_24449 = G__24466;
chunk__23232_24450 = G__24467;
count__23233_24451 = G__24468;
i__23234_24452 = G__24469;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__23235){
var map__23236 = p__23235;
var map__23236__$1 = (((((!((map__23236 == null))))?(((((map__23236.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23236.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23236):map__23236);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23236__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23236__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23236__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23236__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23236__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4185__auto__ = name;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"const","const",1709929842),new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote(finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__23238,is_loop){
var map__23239 = p__23238;
var map__23239__$1 = (((((!((map__23239 == null))))?(((((map__23239.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23239.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23239):map__23239);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23239__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23239__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23239__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__23241_24485 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__23242_24486 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__23242_24486);

try{var seq__23243_24491 = cljs.core.seq(bindings);
var chunk__23244_24492 = null;
var count__23245_24493 = (0);
var i__23246_24494 = (0);
while(true){
if((i__23246_24494 < count__23245_24493)){
var map__23251_24496 = chunk__23244_24492.cljs$core$IIndexed$_nth$arity$2(null,i__23246_24494);
var map__23251_24497__$1 = (((((!((map__23251_24496 == null))))?(((((map__23251_24496.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23251_24496.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23251_24496):map__23251_24496);
var binding_24498 = map__23251_24497__$1;
var init_24499 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23251_24497__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_24498);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_24499,";");


var G__24500 = seq__23243_24491;
var G__24501 = chunk__23244_24492;
var G__24502 = count__23245_24493;
var G__24503 = (i__23246_24494 + (1));
seq__23243_24491 = G__24500;
chunk__23244_24492 = G__24501;
count__23245_24493 = G__24502;
i__23246_24494 = G__24503;
continue;
} else {
var temp__5735__auto___24505 = cljs.core.seq(seq__23243_24491);
if(temp__5735__auto___24505){
var seq__23243_24507__$1 = temp__5735__auto___24505;
if(cljs.core.chunked_seq_QMARK_(seq__23243_24507__$1)){
var c__4609__auto___24508 = cljs.core.chunk_first(seq__23243_24507__$1);
var G__24509 = cljs.core.chunk_rest(seq__23243_24507__$1);
var G__24510 = c__4609__auto___24508;
var G__24511 = cljs.core.count(c__4609__auto___24508);
var G__24512 = (0);
seq__23243_24491 = G__24509;
chunk__23244_24492 = G__24510;
count__23245_24493 = G__24511;
i__23246_24494 = G__24512;
continue;
} else {
var map__23253_24513 = cljs.core.first(seq__23243_24507__$1);
var map__23253_24514__$1 = (((((!((map__23253_24513 == null))))?(((((map__23253_24513.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23253_24513.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23253_24513):map__23253_24513);
var binding_24515 = map__23253_24514__$1;
var init_24516 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23253_24514__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_24515);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_24516,";");


var G__24517 = cljs.core.next(seq__23243_24507__$1);
var G__24518 = null;
var G__24519 = (0);
var G__24520 = (0);
seq__23243_24491 = G__24517;
chunk__23244_24492 = G__24518;
count__23245_24493 = G__24519;
i__23246_24494 = G__24520;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__23241_24485);
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__23255){
var map__23256 = p__23255;
var map__23256__$1 = (((((!((map__23256 == null))))?(((((map__23256.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23256.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23256):map__23256);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23256__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23256__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23256__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__4666__auto___24521 = cljs.core.count(exprs);
var i_24522 = (0);
while(true){
if((i_24522 < n__4666__auto___24521)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_24522) : temps.call(null,i_24522))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_24522) : exprs.call(null,i_24522)),";");

var G__24525 = (i_24522 + (1));
i_24522 = G__24525;
continue;
} else {
}
break;
}

var n__4666__auto___24526 = cljs.core.count(exprs);
var i_24527 = (0);
while(true){
if((i_24527 < n__4666__auto___24526)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_24527) : params.call(null,i_24527)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_24527) : temps.call(null,i_24527)),";");

var G__24529 = (i_24527 + (1));
i_24527 = G__24529;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__23258){
var map__23259 = p__23258;
var map__23259__$1 = (((((!((map__23259 == null))))?(((((map__23259.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23259.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23259):map__23259);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23259__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23259__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23259__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__23261_24552 = cljs.core.seq(bindings);
var chunk__23262_24553 = null;
var count__23263_24554 = (0);
var i__23264_24555 = (0);
while(true){
if((i__23264_24555 < count__23263_24554)){
var map__23269_24556 = chunk__23262_24553.cljs$core$IIndexed$_nth$arity$2(null,i__23264_24555);
var map__23269_24557__$1 = (((((!((map__23269_24556 == null))))?(((((map__23269_24556.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23269_24556.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23269_24556):map__23269_24556);
var binding_24558 = map__23269_24557__$1;
var init_24559 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23269_24557__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_24558)," = ",init_24559,";");


var G__24561 = seq__23261_24552;
var G__24562 = chunk__23262_24553;
var G__24563 = count__23263_24554;
var G__24564 = (i__23264_24555 + (1));
seq__23261_24552 = G__24561;
chunk__23262_24553 = G__24562;
count__23263_24554 = G__24563;
i__23264_24555 = G__24564;
continue;
} else {
var temp__5735__auto___24565 = cljs.core.seq(seq__23261_24552);
if(temp__5735__auto___24565){
var seq__23261_24567__$1 = temp__5735__auto___24565;
if(cljs.core.chunked_seq_QMARK_(seq__23261_24567__$1)){
var c__4609__auto___24568 = cljs.core.chunk_first(seq__23261_24567__$1);
var G__24569 = cljs.core.chunk_rest(seq__23261_24567__$1);
var G__24570 = c__4609__auto___24568;
var G__24571 = cljs.core.count(c__4609__auto___24568);
var G__24572 = (0);
seq__23261_24552 = G__24569;
chunk__23262_24553 = G__24570;
count__23263_24554 = G__24571;
i__23264_24555 = G__24572;
continue;
} else {
var map__23271_24574 = cljs.core.first(seq__23261_24567__$1);
var map__23271_24575__$1 = (((((!((map__23271_24574 == null))))?(((((map__23271_24574.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23271_24574.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23271_24574):map__23271_24574);
var binding_24576 = map__23271_24575__$1;
var init_24577 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23271_24575__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_24576)," = ",init_24577,";");


var G__24583 = cljs.core.next(seq__23261_24567__$1);
var G__24584 = null;
var G__24585 = (0);
var G__24586 = (0);
seq__23261_24552 = G__24583;
chunk__23262_24553 = G__24584;
count__23263_24554 = G__24585;
i__23264_24555 = G__24586;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__23275){
var map__23276 = p__23275;
var map__23276__$1 = (((((!((map__23276 == null))))?(((((map__23276.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23276.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23276):map__23276);
var expr = map__23276__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23276__$1,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23276__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23276__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4174__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
if(cljs.core.not(new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info))){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return false;
}
} else {
return and__4174__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4174__auto__ = protocol;
if(cljs.core.truth_(and__4174__auto__)){
var and__4174__auto____$1 = tag;
if(cljs.core.truth_(and__4174__auto____$1)){
var or__4185__auto__ = (function (){var and__4174__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto____$2)){
var and__4174__auto____$3 = protocol;
if(cljs.core.truth_(and__4174__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__4174__auto____$3;
}
} else {
return and__4174__auto____$2;
}
})();
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
var and__4174__auto____$2 = (function (){var or__4185__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4174__auto____$2)){
var or__4185__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__4185__auto____$1){
return or__4185__auto____$1;
} else {
if((!(cljs.core.set_QMARK_(tag)))){
if(cljs.core.not((function (){var fexpr__23291 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"object","object",-1179821820,null),"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null",new cljs.core.Symbol(null,"js","js",-886355190,null),"null",new cljs.core.Symbol(null,"number","number",-1084057331,null),"null",new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),"null",new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null",new cljs.core.Symbol(null,"function","function",-486723946,null),"null",new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"null"], null), null);
return (fexpr__23291.cljs$core$IFn$_invoke$arity$1 ? fexpr__23291.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__23291.call(null,tag));
})())){
var temp__5735__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,tag));
if(cljs.core.truth_(temp__5735__auto__)){
var ps = temp__5735__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return false;
}
} else {
return false;
}
}
} else {
return and__4174__auto____$2;
}
}
} else {
return and__4174__auto____$1;
}
} else {
return and__4174__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(first_arg_tag,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null))));
var opt_count_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))) && (cljs.core.boolean$((function (){var fexpr__23293 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null"], null), null);
return (fexpr__23293.cljs$core$IFn$_invoke$arity$1 ? fexpr__23293.cljs$core$IFn$_invoke$arity$1(first_arg_tag) : fexpr__23293.call(null,first_arg_tag));
})())));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag(env,f);
var js_QMARK_ = (function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"js","js",-886355190,null));
if(or__4185__auto__){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null));
if(or__4185__auto____$1){
return or__4185__auto____$1;
} else {
return new cljs.core.Keyword(null,"foreign","foreign",990521149).cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__4185__auto__){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = (function (){var temp__5735__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5735__auto__)){
var ns_str = temp__5735__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4185__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),ftag);
if(or__4185__auto__){
return or__4185__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"const","const",1709929842))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__23281 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4174__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4174__auto__)){
return (arity > mfa);
} else {
return and__4174__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__23273_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__23273_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__23274_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__23274_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23281,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23281,(1),null);
var env__22733__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__22733__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("((",cljs.core.first(args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_24618 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_24618,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_24643 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_24643,args)),(((mfa_24643 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_24643,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
var or__4185__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4185__auto____$1)){
return or__4185__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__4174__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4174__auto__)){
var G__23295 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__23294 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__23294.cljs$core$IFn$_invoke$arity$1 ? fexpr__23294.cljs$core$IFn$_invoke$arity$1(G__23295) : fexpr__23294.call(null,G__23295));
} else {
return and__4174__auto__;
}
})())){
var fprop_24645 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_24645," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_24645,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_24645," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_24645,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__22733__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__23296){
var map__23297 = p__23296;
var map__23297__$1 = (((((!((map__23297 == null))))?(((((map__23297.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23297.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23297):map__23297);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23297__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23297__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23297__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__22733__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__22733__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__22733__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__23299){
var map__23300 = p__23299;
var map__23300__$1 = (((((!((map__23300 == null))))?(((((map__23300.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23300.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23300):map__23300);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23300__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23300__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23300__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__22733__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__22733__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(",target," = ",val,")");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__22733__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__4185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__23302 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__23302__$1 = (((((!((map__23302 == null))))?(((((map__23302.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23302.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23302):map__23302);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23302__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23302__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__23303 = options;
var map__23303__$1 = (((((!((map__23303 == null))))?(((((map__23303.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23303.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23303):map__23303);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23303__$1,new cljs.core.Keyword(null,"target","target",253001721));
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23303__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__23304 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__23312 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__23312__$1 = (((((!((map__23312 == null))))?(((((map__23312.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23312.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23312):map__23312);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23312__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23312__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23304,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23304,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__23314_24677 = cljs.core.seq(libs_to_load);
var chunk__23315_24678 = null;
var count__23316_24679 = (0);
var i__23317_24680 = (0);
while(true){
if((i__23317_24680 < count__23316_24679)){
var lib_24681 = chunk__23315_24678.cljs$core$IIndexed$_nth$arity$2(null,i__23317_24680);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_24681)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_24681),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_24681),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_24681),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_24681),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_24681,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_24681),"');");
}

}
}
}


var G__24684 = seq__23314_24677;
var G__24685 = chunk__23315_24678;
var G__24686 = count__23316_24679;
var G__24687 = (i__23317_24680 + (1));
seq__23314_24677 = G__24684;
chunk__23315_24678 = G__24685;
count__23316_24679 = G__24686;
i__23317_24680 = G__24687;
continue;
} else {
var temp__5735__auto___24688 = cljs.core.seq(seq__23314_24677);
if(temp__5735__auto___24688){
var seq__23314_24689__$1 = temp__5735__auto___24688;
if(cljs.core.chunked_seq_QMARK_(seq__23314_24689__$1)){
var c__4609__auto___24690 = cljs.core.chunk_first(seq__23314_24689__$1);
var G__24691 = cljs.core.chunk_rest(seq__23314_24689__$1);
var G__24692 = c__4609__auto___24690;
var G__24693 = cljs.core.count(c__4609__auto___24690);
var G__24694 = (0);
seq__23314_24677 = G__24691;
chunk__23315_24678 = G__24692;
count__23316_24679 = G__24693;
i__23317_24680 = G__24694;
continue;
} else {
var lib_24696 = cljs.core.first(seq__23314_24689__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_24696)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_24696),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_24696),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4185__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_24696),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_24696),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_24696,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_24696),"');");
}

}
}
}


var G__24699 = cljs.core.next(seq__23314_24689__$1);
var G__24700 = null;
var G__24701 = (0);
var G__24702 = (0);
seq__23314_24677 = G__24699;
chunk__23315_24678 = G__24700;
count__23316_24679 = G__24701;
i__23317_24680 = G__24702;
continue;
}
} else {
}
}
break;
}

var seq__23322_24703 = cljs.core.seq(node_libs);
var chunk__23323_24704 = null;
var count__23324_24705 = (0);
var i__23325_24706 = (0);
while(true){
if((i__23325_24706 < count__23324_24705)){
var lib_24707 = chunk__23323_24704.cljs$core$IIndexed$_nth$arity$2(null,i__23325_24706);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_24707)," = require('",lib_24707,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__24708 = seq__23322_24703;
var G__24709 = chunk__23323_24704;
var G__24710 = count__23324_24705;
var G__24711 = (i__23325_24706 + (1));
seq__23322_24703 = G__24708;
chunk__23323_24704 = G__24709;
count__23324_24705 = G__24710;
i__23325_24706 = G__24711;
continue;
} else {
var temp__5735__auto___24712 = cljs.core.seq(seq__23322_24703);
if(temp__5735__auto___24712){
var seq__23322_24713__$1 = temp__5735__auto___24712;
if(cljs.core.chunked_seq_QMARK_(seq__23322_24713__$1)){
var c__4609__auto___24714 = cljs.core.chunk_first(seq__23322_24713__$1);
var G__24715 = cljs.core.chunk_rest(seq__23322_24713__$1);
var G__24716 = c__4609__auto___24714;
var G__24717 = cljs.core.count(c__4609__auto___24714);
var G__24718 = (0);
seq__23322_24703 = G__24715;
chunk__23323_24704 = G__24716;
count__23324_24705 = G__24717;
i__23325_24706 = G__24718;
continue;
} else {
var lib_24719 = cljs.core.first(seq__23322_24713__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_24719)," = require('",lib_24719,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__24720 = cljs.core.next(seq__23322_24713__$1);
var G__24721 = null;
var G__24722 = (0);
var G__24723 = (0);
seq__23322_24703 = G__24720;
chunk__23323_24704 = G__24721;
count__23324_24705 = G__24722;
i__23325_24706 = G__24723;
continue;
}
} else {
}
}
break;
}

var seq__23326_24727 = cljs.core.seq(global_exports_libs);
var chunk__23327_24728 = null;
var count__23328_24729 = (0);
var i__23329_24730 = (0);
while(true){
if((i__23329_24730 < count__23328_24729)){
var lib_24734 = chunk__23327_24728.cljs$core$IIndexed$_nth$arity$2(null,i__23329_24730);
var map__23334_24735 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_24734));
var map__23334_24736__$1 = (((((!((map__23334_24735 == null))))?(((((map__23334_24735.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23334_24735.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23334_24735):map__23334_24735);
var global_exports_24737 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23334_24736__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_24737,lib_24734);


var G__24738 = seq__23326_24727;
var G__24739 = chunk__23327_24728;
var G__24740 = count__23328_24729;
var G__24741 = (i__23329_24730 + (1));
seq__23326_24727 = G__24738;
chunk__23327_24728 = G__24739;
count__23328_24729 = G__24740;
i__23329_24730 = G__24741;
continue;
} else {
var temp__5735__auto___24742 = cljs.core.seq(seq__23326_24727);
if(temp__5735__auto___24742){
var seq__23326_24743__$1 = temp__5735__auto___24742;
if(cljs.core.chunked_seq_QMARK_(seq__23326_24743__$1)){
var c__4609__auto___24744 = cljs.core.chunk_first(seq__23326_24743__$1);
var G__24745 = cljs.core.chunk_rest(seq__23326_24743__$1);
var G__24746 = c__4609__auto___24744;
var G__24747 = cljs.core.count(c__4609__auto___24744);
var G__24748 = (0);
seq__23326_24727 = G__24745;
chunk__23327_24728 = G__24746;
count__23328_24729 = G__24747;
i__23329_24730 = G__24748;
continue;
} else {
var lib_24749 = cljs.core.first(seq__23326_24743__$1);
var map__23336_24750 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_24749));
var map__23336_24751__$1 = (((((!((map__23336_24750 == null))))?(((((map__23336_24750.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23336_24750.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23336_24750):map__23336_24750);
var global_exports_24752 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23336_24751__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_24752,lib_24749);


var G__24755 = cljs.core.next(seq__23326_24743__$1);
var G__24756 = null;
var G__24757 = (0);
var G__24758 = (0);
seq__23326_24727 = G__24755;
chunk__23327_24728 = G__24756;
count__23328_24729 = G__24757;
i__23329_24730 = G__24758;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__23338){
var map__23339 = p__23338;
var map__23339__$1 = (((((!((map__23339 == null))))?(((((map__23339.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23339.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23339):map__23339);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23339__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23339__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23339__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23339__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23339__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23339__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23339__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__23341){
var map__23342 = p__23341;
var map__23342__$1 = (((((!((map__23342 == null))))?(((((map__23342.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23342.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23342):map__23342);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23342__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23342__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23342__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23342__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23342__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23342__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23342__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"deftype","deftype",340294561),(function (p__23344){
var map__23345 = p__23344;
var map__23345__$1 = (((((!((map__23345 == null))))?(((((map__23345.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23345.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23345):map__23345);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23345__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23345__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23345__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23345__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23345__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__23347_24765 = cljs.core.seq(protocols);
var chunk__23348_24766 = null;
var count__23349_24767 = (0);
var i__23350_24768 = (0);
while(true){
if((i__23350_24768 < count__23349_24767)){
var protocol_24769 = chunk__23348_24766.cljs$core$IIndexed$_nth$arity$2(null,i__23350_24768);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_24769)),"}");


var G__24771 = seq__23347_24765;
var G__24772 = chunk__23348_24766;
var G__24773 = count__23349_24767;
var G__24774 = (i__23350_24768 + (1));
seq__23347_24765 = G__24771;
chunk__23348_24766 = G__24772;
count__23349_24767 = G__24773;
i__23350_24768 = G__24774;
continue;
} else {
var temp__5735__auto___24775 = cljs.core.seq(seq__23347_24765);
if(temp__5735__auto___24775){
var seq__23347_24778__$1 = temp__5735__auto___24775;
if(cljs.core.chunked_seq_QMARK_(seq__23347_24778__$1)){
var c__4609__auto___24779 = cljs.core.chunk_first(seq__23347_24778__$1);
var G__24781 = cljs.core.chunk_rest(seq__23347_24778__$1);
var G__24782 = c__4609__auto___24779;
var G__24783 = cljs.core.count(c__4609__auto___24779);
var G__24784 = (0);
seq__23347_24765 = G__24781;
chunk__23348_24766 = G__24782;
count__23349_24767 = G__24783;
i__23350_24768 = G__24784;
continue;
} else {
var protocol_24787 = cljs.core.first(seq__23347_24778__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_24787)),"}");


var G__24789 = cljs.core.next(seq__23347_24778__$1);
var G__24790 = null;
var G__24791 = (0);
var G__24792 = (0);
seq__23347_24765 = G__24789;
chunk__23348_24766 = G__24790;
count__23349_24767 = G__24791;
i__23350_24768 = G__24792;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__23351_24793 = cljs.core.seq(fields__$1);
var chunk__23352_24794 = null;
var count__23353_24795 = (0);
var i__23354_24796 = (0);
while(true){
if((i__23354_24796 < count__23353_24795)){
var fld_24798 = chunk__23352_24794.cljs$core$IIndexed$_nth$arity$2(null,i__23354_24796);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_24798," = ",fld_24798,";");


var G__24799 = seq__23351_24793;
var G__24800 = chunk__23352_24794;
var G__24801 = count__23353_24795;
var G__24802 = (i__23354_24796 + (1));
seq__23351_24793 = G__24799;
chunk__23352_24794 = G__24800;
count__23353_24795 = G__24801;
i__23354_24796 = G__24802;
continue;
} else {
var temp__5735__auto___24804 = cljs.core.seq(seq__23351_24793);
if(temp__5735__auto___24804){
var seq__23351_24807__$1 = temp__5735__auto___24804;
if(cljs.core.chunked_seq_QMARK_(seq__23351_24807__$1)){
var c__4609__auto___24809 = cljs.core.chunk_first(seq__23351_24807__$1);
var G__24812 = cljs.core.chunk_rest(seq__23351_24807__$1);
var G__24813 = c__4609__auto___24809;
var G__24814 = cljs.core.count(c__4609__auto___24809);
var G__24815 = (0);
seq__23351_24793 = G__24812;
chunk__23352_24794 = G__24813;
count__23353_24795 = G__24814;
i__23354_24796 = G__24815;
continue;
} else {
var fld_24816 = cljs.core.first(seq__23351_24807__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_24816," = ",fld_24816,";");


var G__24817 = cljs.core.next(seq__23351_24807__$1);
var G__24818 = null;
var G__24819 = (0);
var G__24820 = (0);
seq__23351_24793 = G__24817;
chunk__23352_24794 = G__24818;
count__23353_24795 = G__24819;
i__23354_24796 = G__24820;
continue;
}
} else {
}
}
break;
}

var seq__23356_24822 = cljs.core.seq(pmasks);
var chunk__23357_24823 = null;
var count__23358_24824 = (0);
var i__23359_24825 = (0);
while(true){
if((i__23359_24825 < count__23358_24824)){
var vec__23366_24829 = chunk__23357_24823.cljs$core$IIndexed$_nth$arity$2(null,i__23359_24825);
var pno_24830 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23366_24829,(0),null);
var pmask_24831 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23366_24829,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_24830,"$ = ",pmask_24831,";");


var G__24836 = seq__23356_24822;
var G__24837 = chunk__23357_24823;
var G__24838 = count__23358_24824;
var G__24839 = (i__23359_24825 + (1));
seq__23356_24822 = G__24836;
chunk__23357_24823 = G__24837;
count__23358_24824 = G__24838;
i__23359_24825 = G__24839;
continue;
} else {
var temp__5735__auto___24840 = cljs.core.seq(seq__23356_24822);
if(temp__5735__auto___24840){
var seq__23356_24841__$1 = temp__5735__auto___24840;
if(cljs.core.chunked_seq_QMARK_(seq__23356_24841__$1)){
var c__4609__auto___24842 = cljs.core.chunk_first(seq__23356_24841__$1);
var G__24844 = cljs.core.chunk_rest(seq__23356_24841__$1);
var G__24845 = c__4609__auto___24842;
var G__24846 = cljs.core.count(c__4609__auto___24842);
var G__24847 = (0);
seq__23356_24822 = G__24844;
chunk__23357_24823 = G__24845;
count__23358_24824 = G__24846;
i__23359_24825 = G__24847;
continue;
} else {
var vec__23373_24848 = cljs.core.first(seq__23356_24841__$1);
var pno_24849 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23373_24848,(0),null);
var pmask_24850 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23373_24848,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_24849,"$ = ",pmask_24850,";");


var G__24851 = cljs.core.next(seq__23356_24841__$1);
var G__24852 = null;
var G__24853 = (0);
var G__24854 = (0);
seq__23356_24822 = G__24851;
chunk__23357_24823 = G__24852;
count__23358_24824 = G__24853;
i__23359_24825 = G__24854;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"defrecord","defrecord",-1367493418),(function (p__23376){
var map__23377 = p__23376;
var map__23377__$1 = (((((!((map__23377 == null))))?(((((map__23377.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23377.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23377):map__23377);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23377__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23377__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23377__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23377__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23377__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__23379_24863 = cljs.core.seq(protocols);
var chunk__23380_24864 = null;
var count__23381_24865 = (0);
var i__23382_24866 = (0);
while(true){
if((i__23382_24866 < count__23381_24865)){
var protocol_24867 = chunk__23380_24864.cljs$core$IIndexed$_nth$arity$2(null,i__23382_24866);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_24867)),"}");


var G__24868 = seq__23379_24863;
var G__24869 = chunk__23380_24864;
var G__24870 = count__23381_24865;
var G__24871 = (i__23382_24866 + (1));
seq__23379_24863 = G__24868;
chunk__23380_24864 = G__24869;
count__23381_24865 = G__24870;
i__23382_24866 = G__24871;
continue;
} else {
var temp__5735__auto___24875 = cljs.core.seq(seq__23379_24863);
if(temp__5735__auto___24875){
var seq__23379_24876__$1 = temp__5735__auto___24875;
if(cljs.core.chunked_seq_QMARK_(seq__23379_24876__$1)){
var c__4609__auto___24877 = cljs.core.chunk_first(seq__23379_24876__$1);
var G__24879 = cljs.core.chunk_rest(seq__23379_24876__$1);
var G__24880 = c__4609__auto___24877;
var G__24881 = cljs.core.count(c__4609__auto___24877);
var G__24882 = (0);
seq__23379_24863 = G__24879;
chunk__23380_24864 = G__24880;
count__23381_24865 = G__24881;
i__23382_24866 = G__24882;
continue;
} else {
var protocol_24885 = cljs.core.first(seq__23379_24876__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_24885)),"}");


var G__24888 = cljs.core.next(seq__23379_24876__$1);
var G__24889 = null;
var G__24890 = (0);
var G__24891 = (0);
seq__23379_24863 = G__24888;
chunk__23380_24864 = G__24889;
count__23381_24865 = G__24890;
i__23382_24866 = G__24891;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__23384_24893 = cljs.core.seq(fields__$1);
var chunk__23385_24894 = null;
var count__23386_24895 = (0);
var i__23387_24896 = (0);
while(true){
if((i__23387_24896 < count__23386_24895)){
var fld_24897 = chunk__23385_24894.cljs$core$IIndexed$_nth$arity$2(null,i__23387_24896);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_24897," = ",fld_24897,";");


var G__24905 = seq__23384_24893;
var G__24906 = chunk__23385_24894;
var G__24907 = count__23386_24895;
var G__24908 = (i__23387_24896 + (1));
seq__23384_24893 = G__24905;
chunk__23385_24894 = G__24906;
count__23386_24895 = G__24907;
i__23387_24896 = G__24908;
continue;
} else {
var temp__5735__auto___24910 = cljs.core.seq(seq__23384_24893);
if(temp__5735__auto___24910){
var seq__23384_24911__$1 = temp__5735__auto___24910;
if(cljs.core.chunked_seq_QMARK_(seq__23384_24911__$1)){
var c__4609__auto___24912 = cljs.core.chunk_first(seq__23384_24911__$1);
var G__24913 = cljs.core.chunk_rest(seq__23384_24911__$1);
var G__24914 = c__4609__auto___24912;
var G__24915 = cljs.core.count(c__4609__auto___24912);
var G__24916 = (0);
seq__23384_24893 = G__24913;
chunk__23385_24894 = G__24914;
count__23386_24895 = G__24915;
i__23387_24896 = G__24916;
continue;
} else {
var fld_24917 = cljs.core.first(seq__23384_24911__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_24917," = ",fld_24917,";");


var G__24918 = cljs.core.next(seq__23384_24911__$1);
var G__24919 = null;
var G__24920 = (0);
var G__24921 = (0);
seq__23384_24893 = G__24918;
chunk__23385_24894 = G__24919;
count__23386_24895 = G__24920;
i__23387_24896 = G__24921;
continue;
}
} else {
}
}
break;
}

var seq__23388_24923 = cljs.core.seq(pmasks);
var chunk__23389_24924 = null;
var count__23390_24925 = (0);
var i__23391_24926 = (0);
while(true){
if((i__23391_24926 < count__23390_24925)){
var vec__23403_24928 = chunk__23389_24924.cljs$core$IIndexed$_nth$arity$2(null,i__23391_24926);
var pno_24929 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23403_24928,(0),null);
var pmask_24930 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23403_24928,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_24929,"$ = ",pmask_24930,";");


var G__24932 = seq__23388_24923;
var G__24933 = chunk__23389_24924;
var G__24934 = count__23390_24925;
var G__24935 = (i__23391_24926 + (1));
seq__23388_24923 = G__24932;
chunk__23389_24924 = G__24933;
count__23390_24925 = G__24934;
i__23391_24926 = G__24935;
continue;
} else {
var temp__5735__auto___24936 = cljs.core.seq(seq__23388_24923);
if(temp__5735__auto___24936){
var seq__23388_24938__$1 = temp__5735__auto___24936;
if(cljs.core.chunked_seq_QMARK_(seq__23388_24938__$1)){
var c__4609__auto___24940 = cljs.core.chunk_first(seq__23388_24938__$1);
var G__24943 = cljs.core.chunk_rest(seq__23388_24938__$1);
var G__24944 = c__4609__auto___24940;
var G__24945 = cljs.core.count(c__4609__auto___24940);
var G__24946 = (0);
seq__23388_24923 = G__24943;
chunk__23389_24924 = G__24944;
count__23390_24925 = G__24945;
i__23391_24926 = G__24946;
continue;
} else {
var vec__23410_24947 = cljs.core.first(seq__23388_24938__$1);
var pno_24948 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23410_24947,(0),null);
var pmask_24949 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23410_24947,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_24948,"$ = ",pmask_24949,";");


var G__24951 = cljs.core.next(seq__23388_24938__$1);
var G__24952 = null;
var G__24953 = (0);
var G__24954 = (0);
seq__23388_24923 = G__24951;
chunk__23389_24924 = G__24952;
count__23390_24925 = G__24953;
i__23391_24926 = G__24954;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__23414){
var map__23415 = p__23414;
var map__23415__$1 = (((((!((map__23415 == null))))?(((((map__23415.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23415.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23415):map__23415);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23415__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23415__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23415__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23415__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23415__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__22733__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__22733__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__22733__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-field","host-field",-72662140),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-call","host-call",1059629755),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__23421){
var map__23422 = p__23421;
var map__23422__$1 = (((((!((map__23422 == null))))?(((((map__23422.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23422.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23422):map__23422);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23422__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23422__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23422__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23422__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23422__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__4174__auto__ = code;
if(cljs.core.truth_(and__4174__auto__)){
var G__23424 = clojure.string.trim(code);
var G__23425 = "/*";
return goog.string.startsWith(G__23424,G__23425);
} else {
return and__4174__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__22733__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__22733__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__22733__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__23447 = cljs.core.seq(table);
var chunk__23448 = null;
var count__23449 = (0);
var i__23450 = (0);
while(true){
if((i__23450 < count__23449)){
var vec__23478 = chunk__23448.cljs$core$IIndexed$_nth$arity$2(null,i__23450);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23478,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23478,(1),null);
var ns_24972 = cljs.core.namespace(sym);
var name_24973 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__24976 = seq__23447;
var G__24977 = chunk__23448;
var G__24978 = count__23449;
var G__24979 = (i__23450 + (1));
seq__23447 = G__24976;
chunk__23448 = G__24977;
count__23449 = G__24978;
i__23450 = G__24979;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__23447);
if(temp__5735__auto__){
var seq__23447__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__23447__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__23447__$1);
var G__24980 = cljs.core.chunk_rest(seq__23447__$1);
var G__24981 = c__4609__auto__;
var G__24982 = cljs.core.count(c__4609__auto__);
var G__24983 = (0);
seq__23447 = G__24980;
chunk__23448 = G__24981;
count__23449 = G__24982;
i__23450 = G__24983;
continue;
} else {
var vec__23481 = cljs.core.first(seq__23447__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23481,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23481,(1),null);
var ns_24984 = cljs.core.namespace(sym);
var name_24985 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__24989 = cljs.core.next(seq__23447__$1);
var G__24990 = null;
var G__24991 = (0);
var G__24992 = (0);
seq__23447 = G__24989;
chunk__23448 = G__24990;
count__23449 = G__24991;
i__23450 = G__24992;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__23485 = arguments.length;
switch (G__23485) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?new cljs.core.Keyword("cljs.analyzer","externs","cljs.analyzer/externs",893359239).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)):null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_24998 = cljs.core.first(ks);
var vec__23486_24999 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_24998);
var top_25000 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23486_24999,(0),null);
var prefix_SINGLEQUOTE__25001 = vec__23486_24999;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_24998)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__25001) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_25000)) || (cljs.core.contains_QMARK_(known_externs,top_25000)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__25001)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_25000);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__25001)),";");
}
} else {
}

var m_25008 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_24998);
if(cljs.core.empty_QMARK_(m_25008)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__25001,m_25008,top_level,known_externs);
}

var G__25013 = cljs.core.next(ks);
ks = G__25013;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=cljs.compiler.js.map
