goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__13745 = arguments.length;
switch (G__13745) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async13747 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13747 = (function (f,blockable,meta13748){
this.f = f;
this.blockable = blockable;
this.meta13748 = meta13748;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13747.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13749,meta13748__$1){
var self__ = this;
var _13749__$1 = this;
return (new cljs.core.async.t_cljs$core$async13747(self__.f,self__.blockable,meta13748__$1));
}));

(cljs.core.async.t_cljs$core$async13747.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13749){
var self__ = this;
var _13749__$1 = this;
return self__.meta13748;
}));

(cljs.core.async.t_cljs$core$async13747.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13747.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async13747.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async13747.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async13747.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta13748","meta13748",103218016,null)], null);
}));

(cljs.core.async.t_cljs$core$async13747.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13747.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13747");

(cljs.core.async.t_cljs$core$async13747.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async13747");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13747.
 */
cljs.core.async.__GT_t_cljs$core$async13747 = (function cljs$core$async$__GT_t_cljs$core$async13747(f__$1,blockable__$1,meta13748){
return (new cljs.core.async.t_cljs$core$async13747(f__$1,blockable__$1,meta13748));
});

}

return (new cljs.core.async.t_cljs$core$async13747(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__13771 = arguments.length;
switch (G__13771) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__13773 = arguments.length;
switch (G__13773) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__13785 = arguments.length;
switch (G__13785) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_15777 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_15777) : fn1.call(null,val_15777));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_15777) : fn1.call(null,val_15777));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__13788 = arguments.length;
switch (G__13788) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4666__auto___15815 = n;
var x_15816 = (0);
while(true){
if((x_15816 < n__4666__auto___15815)){
(a[x_15816] = x_15816);

var G__15817 = (x_15816 + (1));
x_15816 = G__15817;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async13792 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13792 = (function (flag,meta13793){
this.flag = flag;
this.meta13793 = meta13793;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13792.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13794,meta13793__$1){
var self__ = this;
var _13794__$1 = this;
return (new cljs.core.async.t_cljs$core$async13792(self__.flag,meta13793__$1));
}));

(cljs.core.async.t_cljs$core$async13792.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13794){
var self__ = this;
var _13794__$1 = this;
return self__.meta13793;
}));

(cljs.core.async.t_cljs$core$async13792.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13792.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async13792.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async13792.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async13792.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta13793","meta13793",-871959692,null)], null);
}));

(cljs.core.async.t_cljs$core$async13792.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13792.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13792");

(cljs.core.async.t_cljs$core$async13792.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async13792");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13792.
 */
cljs.core.async.__GT_t_cljs$core$async13792 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async13792(flag__$1,meta13793){
return (new cljs.core.async.t_cljs$core$async13792(flag__$1,meta13793));
});

}

return (new cljs.core.async.t_cljs$core$async13792(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async13798 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13798 = (function (flag,cb,meta13799){
this.flag = flag;
this.cb = cb;
this.meta13799 = meta13799;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13798.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13800,meta13799__$1){
var self__ = this;
var _13800__$1 = this;
return (new cljs.core.async.t_cljs$core$async13798(self__.flag,self__.cb,meta13799__$1));
}));

(cljs.core.async.t_cljs$core$async13798.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13800){
var self__ = this;
var _13800__$1 = this;
return self__.meta13799;
}));

(cljs.core.async.t_cljs$core$async13798.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13798.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async13798.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async13798.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async13798.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta13799","meta13799",-442124164,null)], null);
}));

(cljs.core.async.t_cljs$core$async13798.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13798.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13798");

(cljs.core.async.t_cljs$core$async13798.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async13798");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13798.
 */
cljs.core.async.__GT_t_cljs$core$async13798 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async13798(flag__$1,cb__$1,meta13799){
return (new cljs.core.async.t_cljs$core$async13798(flag__$1,cb__$1,meta13799));
});

}

return (new cljs.core.async.t_cljs$core$async13798(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__13802_SHARP_){
var G__13804 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__13802_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__13804) : fret.call(null,G__13804));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__13803_SHARP_){
var G__13805 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__13803_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__13805) : fret.call(null,G__13805));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4185__auto__ = wport;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return port;
}
})()], null));
} else {
var G__15836 = (i + (1));
i = G__15836;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4185__auto__ = ret;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5735__auto__ = (function (){var and__4174__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4174__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4174__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___15838 = arguments.length;
var i__4790__auto___15839 = (0);
while(true){
if((i__4790__auto___15839 < len__4789__auto___15838)){
args__4795__auto__.push((arguments[i__4790__auto___15839]));

var G__15840 = (i__4790__auto___15839 + (1));
i__4790__auto___15839 = G__15840;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__13808){
var map__13809 = p__13808;
var map__13809__$1 = (((((!((map__13809 == null))))?(((((map__13809.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13809.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13809):map__13809);
var opts = map__13809__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq13806){
var G__13807 = cljs.core.first(seq13806);
var seq13806__$1 = cljs.core.next(seq13806);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__13807,seq13806__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__13816 = arguments.length;
switch (G__13816) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__13675__auto___15855 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13676__auto__ = (function (){var switch__13556__auto__ = (function (state_13860){
var state_val_13861 = (state_13860[(1)]);
if((state_val_13861 === (7))){
var inst_13852 = (state_13860[(2)]);
var state_13860__$1 = state_13860;
var statearr_13869_15859 = state_13860__$1;
(statearr_13869_15859[(2)] = inst_13852);

(statearr_13869_15859[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (1))){
var state_13860__$1 = state_13860;
var statearr_13870_15863 = state_13860__$1;
(statearr_13870_15863[(2)] = null);

(statearr_13870_15863[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (4))){
var inst_13832 = (state_13860[(7)]);
var inst_13832__$1 = (state_13860[(2)]);
var inst_13834 = (inst_13832__$1 == null);
var state_13860__$1 = (function (){var statearr_13872 = state_13860;
(statearr_13872[(7)] = inst_13832__$1);

return statearr_13872;
})();
if(cljs.core.truth_(inst_13834)){
var statearr_13873_15869 = state_13860__$1;
(statearr_13873_15869[(1)] = (5));

} else {
var statearr_13874_15870 = state_13860__$1;
(statearr_13874_15870[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (13))){
var state_13860__$1 = state_13860;
var statearr_13878_15871 = state_13860__$1;
(statearr_13878_15871[(2)] = null);

(statearr_13878_15871[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (6))){
var inst_13832 = (state_13860[(7)]);
var state_13860__$1 = state_13860;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13860__$1,(11),to,inst_13832);
} else {
if((state_val_13861 === (3))){
var inst_13854 = (state_13860[(2)]);
var state_13860__$1 = state_13860;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13860__$1,inst_13854);
} else {
if((state_val_13861 === (12))){
var state_13860__$1 = state_13860;
var statearr_13884_15872 = state_13860__$1;
(statearr_13884_15872[(2)] = null);

(statearr_13884_15872[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (2))){
var state_13860__$1 = state_13860;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13860__$1,(4),from);
} else {
if((state_val_13861 === (11))){
var inst_13843 = (state_13860[(2)]);
var state_13860__$1 = state_13860;
if(cljs.core.truth_(inst_13843)){
var statearr_13889_15876 = state_13860__$1;
(statearr_13889_15876[(1)] = (12));

} else {
var statearr_13890_15878 = state_13860__$1;
(statearr_13890_15878[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (9))){
var state_13860__$1 = state_13860;
var statearr_13891_15879 = state_13860__$1;
(statearr_13891_15879[(2)] = null);

(statearr_13891_15879[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (5))){
var state_13860__$1 = state_13860;
if(cljs.core.truth_(close_QMARK_)){
var statearr_13892_15880 = state_13860__$1;
(statearr_13892_15880[(1)] = (8));

} else {
var statearr_13897_15881 = state_13860__$1;
(statearr_13897_15881[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (14))){
var inst_13850 = (state_13860[(2)]);
var state_13860__$1 = state_13860;
var statearr_13900_15883 = state_13860__$1;
(statearr_13900_15883[(2)] = inst_13850);

(statearr_13900_15883[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (10))){
var inst_13840 = (state_13860[(2)]);
var state_13860__$1 = state_13860;
var statearr_13901_15884 = state_13860__$1;
(statearr_13901_15884[(2)] = inst_13840);

(statearr_13901_15884[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (8))){
var inst_13837 = cljs.core.async.close_BANG_(to);
var state_13860__$1 = state_13860;
var statearr_13903_15885 = state_13860__$1;
(statearr_13903_15885[(2)] = inst_13837);

(statearr_13903_15885[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__13557__auto__ = null;
var cljs$core$async$state_machine__13557__auto____0 = (function (){
var statearr_13906 = [null,null,null,null,null,null,null,null];
(statearr_13906[(0)] = cljs$core$async$state_machine__13557__auto__);

(statearr_13906[(1)] = (1));

return statearr_13906;
});
var cljs$core$async$state_machine__13557__auto____1 = (function (state_13860){
while(true){
var ret_value__13558__auto__ = (function (){try{while(true){
var result__13559__auto__ = switch__13556__auto__(state_13860);
if(cljs.core.keyword_identical_QMARK_(result__13559__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13559__auto__;
}
break;
}
}catch (e13907){if((e13907 instanceof Object)){
var ex__13560__auto__ = e13907;
var statearr_13908_15887 = state_13860;
(statearr_13908_15887[(5)] = ex__13560__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_13860);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13907;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13558__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15891 = state_13860;
state_13860 = G__15891;
continue;
} else {
return ret_value__13558__auto__;
}
break;
}
});
cljs$core$async$state_machine__13557__auto__ = function(state_13860){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13557__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13557__auto____1.call(this,state_13860);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13557__auto____0;
cljs$core$async$state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13557__auto____1;
return cljs$core$async$state_machine__13557__auto__;
})()
})();
var state__13677__auto__ = (function (){var statearr_13912 = (f__13676__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13676__auto__.cljs$core$IFn$_invoke$arity$0() : f__13676__auto__.call(null));
(statearr_13912[(6)] = c__13675__auto___15855);

return statearr_13912;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13677__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__13913){
var vec__13914 = p__13913;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13914,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13914,(1),null);
var job = vec__13914;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__13675__auto___15893 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13676__auto__ = (function (){var switch__13556__auto__ = (function (state_13921){
var state_val_13922 = (state_13921[(1)]);
if((state_val_13922 === (1))){
var state_13921__$1 = state_13921;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13921__$1,(2),res,v);
} else {
if((state_val_13922 === (2))){
var inst_13918 = (state_13921[(2)]);
var inst_13919 = cljs.core.async.close_BANG_(res);
var state_13921__$1 = (function (){var statearr_13924 = state_13921;
(statearr_13924[(7)] = inst_13918);

return statearr_13924;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_13921__$1,inst_13919);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__13557__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__13557__auto____0 = (function (){
var statearr_13925 = [null,null,null,null,null,null,null,null];
(statearr_13925[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__13557__auto__);

(statearr_13925[(1)] = (1));

return statearr_13925;
});
var cljs$core$async$pipeline_STAR__$_state_machine__13557__auto____1 = (function (state_13921){
while(true){
var ret_value__13558__auto__ = (function (){try{while(true){
var result__13559__auto__ = switch__13556__auto__(state_13921);
if(cljs.core.keyword_identical_QMARK_(result__13559__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13559__auto__;
}
break;
}
}catch (e13926){if((e13926 instanceof Object)){
var ex__13560__auto__ = e13926;
var statearr_13927_15896 = state_13921;
(statearr_13927_15896[(5)] = ex__13560__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_13921);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13926;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13558__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15902 = state_13921;
state_13921 = G__15902;
continue;
} else {
return ret_value__13558__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__13557__auto__ = function(state_13921){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__13557__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__13557__auto____1.call(this,state_13921);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__13557__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__13557__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__13557__auto__;
})()
})();
var state__13677__auto__ = (function (){var statearr_13930 = (f__13676__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13676__auto__.cljs$core$IFn$_invoke$arity$0() : f__13676__auto__.call(null));
(statearr_13930[(6)] = c__13675__auto___15893);

return statearr_13930;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13677__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__13931){
var vec__13932 = p__13931;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13932,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13932,(1),null);
var job = vec__13932;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4666__auto___15917 = n;
var __15918 = (0);
while(true){
if((__15918 < n__4666__auto___15917)){
var G__13938_15923 = type;
var G__13938_15924__$1 = (((G__13938_15923 instanceof cljs.core.Keyword))?G__13938_15923.fqn:null);
switch (G__13938_15924__$1) {
case "compute":
var c__13675__auto___15926 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__15918,c__13675__auto___15926,G__13938_15923,G__13938_15924__$1,n__4666__auto___15917,jobs,results,process,async){
return (function (){
var f__13676__auto__ = (function (){var switch__13556__auto__ = ((function (__15918,c__13675__auto___15926,G__13938_15923,G__13938_15924__$1,n__4666__auto___15917,jobs,results,process,async){
return (function (state_13952){
var state_val_13953 = (state_13952[(1)]);
if((state_val_13953 === (1))){
var state_13952__$1 = state_13952;
var statearr_13954_15931 = state_13952__$1;
(statearr_13954_15931[(2)] = null);

(statearr_13954_15931[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13953 === (2))){
var state_13952__$1 = state_13952;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13952__$1,(4),jobs);
} else {
if((state_val_13953 === (3))){
var inst_13950 = (state_13952[(2)]);
var state_13952__$1 = state_13952;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13952__$1,inst_13950);
} else {
if((state_val_13953 === (4))){
var inst_13942 = (state_13952[(2)]);
var inst_13943 = process(inst_13942);
var state_13952__$1 = state_13952;
if(cljs.core.truth_(inst_13943)){
var statearr_13955_15932 = state_13952__$1;
(statearr_13955_15932[(1)] = (5));

} else {
var statearr_13956_15933 = state_13952__$1;
(statearr_13956_15933[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13953 === (5))){
var state_13952__$1 = state_13952;
var statearr_13957_15934 = state_13952__$1;
(statearr_13957_15934[(2)] = null);

(statearr_13957_15934[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13953 === (6))){
var state_13952__$1 = state_13952;
var statearr_13958_15935 = state_13952__$1;
(statearr_13958_15935[(2)] = null);

(statearr_13958_15935[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13953 === (7))){
var inst_13948 = (state_13952[(2)]);
var state_13952__$1 = state_13952;
var statearr_13963_15939 = state_13952__$1;
(statearr_13963_15939[(2)] = inst_13948);

(statearr_13963_15939[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__15918,c__13675__auto___15926,G__13938_15923,G__13938_15924__$1,n__4666__auto___15917,jobs,results,process,async))
;
return ((function (__15918,switch__13556__auto__,c__13675__auto___15926,G__13938_15923,G__13938_15924__$1,n__4666__auto___15917,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__13557__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__13557__auto____0 = (function (){
var statearr_13970 = [null,null,null,null,null,null,null];
(statearr_13970[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__13557__auto__);

(statearr_13970[(1)] = (1));

return statearr_13970;
});
var cljs$core$async$pipeline_STAR__$_state_machine__13557__auto____1 = (function (state_13952){
while(true){
var ret_value__13558__auto__ = (function (){try{while(true){
var result__13559__auto__ = switch__13556__auto__(state_13952);
if(cljs.core.keyword_identical_QMARK_(result__13559__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13559__auto__;
}
break;
}
}catch (e13971){if((e13971 instanceof Object)){
var ex__13560__auto__ = e13971;
var statearr_13972_15944 = state_13952;
(statearr_13972_15944[(5)] = ex__13560__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_13952);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13971;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13558__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15945 = state_13952;
state_13952 = G__15945;
continue;
} else {
return ret_value__13558__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__13557__auto__ = function(state_13952){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__13557__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__13557__auto____1.call(this,state_13952);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__13557__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__13557__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__13557__auto__;
})()
;})(__15918,switch__13556__auto__,c__13675__auto___15926,G__13938_15923,G__13938_15924__$1,n__4666__auto___15917,jobs,results,process,async))
})();
var state__13677__auto__ = (function (){var statearr_13973 = (f__13676__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13676__auto__.cljs$core$IFn$_invoke$arity$0() : f__13676__auto__.call(null));
(statearr_13973[(6)] = c__13675__auto___15926);

return statearr_13973;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13677__auto__);
});})(__15918,c__13675__auto___15926,G__13938_15923,G__13938_15924__$1,n__4666__auto___15917,jobs,results,process,async))
);


break;
case "async":
var c__13675__auto___15946 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__15918,c__13675__auto___15946,G__13938_15923,G__13938_15924__$1,n__4666__auto___15917,jobs,results,process,async){
return (function (){
var f__13676__auto__ = (function (){var switch__13556__auto__ = ((function (__15918,c__13675__auto___15946,G__13938_15923,G__13938_15924__$1,n__4666__auto___15917,jobs,results,process,async){
return (function (state_13990){
var state_val_13991 = (state_13990[(1)]);
if((state_val_13991 === (1))){
var state_13990__$1 = state_13990;
var statearr_13994_15947 = state_13990__$1;
(statearr_13994_15947[(2)] = null);

(statearr_13994_15947[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13991 === (2))){
var state_13990__$1 = state_13990;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13990__$1,(4),jobs);
} else {
if((state_val_13991 === (3))){
var inst_13988 = (state_13990[(2)]);
var state_13990__$1 = state_13990;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13990__$1,inst_13988);
} else {
if((state_val_13991 === (4))){
var inst_13980 = (state_13990[(2)]);
var inst_13981 = async(inst_13980);
var state_13990__$1 = state_13990;
if(cljs.core.truth_(inst_13981)){
var statearr_13995_15948 = state_13990__$1;
(statearr_13995_15948[(1)] = (5));

} else {
var statearr_13996_15949 = state_13990__$1;
(statearr_13996_15949[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13991 === (5))){
var state_13990__$1 = state_13990;
var statearr_13997_15954 = state_13990__$1;
(statearr_13997_15954[(2)] = null);

(statearr_13997_15954[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13991 === (6))){
var state_13990__$1 = state_13990;
var statearr_14000_15955 = state_13990__$1;
(statearr_14000_15955[(2)] = null);

(statearr_14000_15955[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13991 === (7))){
var inst_13986 = (state_13990[(2)]);
var state_13990__$1 = state_13990;
var statearr_14001_15961 = state_13990__$1;
(statearr_14001_15961[(2)] = inst_13986);

(statearr_14001_15961[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__15918,c__13675__auto___15946,G__13938_15923,G__13938_15924__$1,n__4666__auto___15917,jobs,results,process,async))
;
return ((function (__15918,switch__13556__auto__,c__13675__auto___15946,G__13938_15923,G__13938_15924__$1,n__4666__auto___15917,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__13557__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__13557__auto____0 = (function (){
var statearr_14003 = [null,null,null,null,null,null,null];
(statearr_14003[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__13557__auto__);

(statearr_14003[(1)] = (1));

return statearr_14003;
});
var cljs$core$async$pipeline_STAR__$_state_machine__13557__auto____1 = (function (state_13990){
while(true){
var ret_value__13558__auto__ = (function (){try{while(true){
var result__13559__auto__ = switch__13556__auto__(state_13990);
if(cljs.core.keyword_identical_QMARK_(result__13559__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13559__auto__;
}
break;
}
}catch (e14007){if((e14007 instanceof Object)){
var ex__13560__auto__ = e14007;
var statearr_14008_15974 = state_13990;
(statearr_14008_15974[(5)] = ex__13560__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_13990);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14007;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13558__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15979 = state_13990;
state_13990 = G__15979;
continue;
} else {
return ret_value__13558__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__13557__auto__ = function(state_13990){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__13557__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__13557__auto____1.call(this,state_13990);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__13557__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__13557__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__13557__auto__;
})()
;})(__15918,switch__13556__auto__,c__13675__auto___15946,G__13938_15923,G__13938_15924__$1,n__4666__auto___15917,jobs,results,process,async))
})();
var state__13677__auto__ = (function (){var statearr_14013 = (f__13676__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13676__auto__.cljs$core$IFn$_invoke$arity$0() : f__13676__auto__.call(null));
(statearr_14013[(6)] = c__13675__auto___15946);

return statearr_14013;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13677__auto__);
});})(__15918,c__13675__auto___15946,G__13938_15923,G__13938_15924__$1,n__4666__auto___15917,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13938_15924__$1)].join('')));

}

var G__15984 = (__15918 + (1));
__15918 = G__15984;
continue;
} else {
}
break;
}

var c__13675__auto___15985 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13676__auto__ = (function (){var switch__13556__auto__ = (function (state_14035){
var state_val_14036 = (state_14035[(1)]);
if((state_val_14036 === (7))){
var inst_14031 = (state_14035[(2)]);
var state_14035__$1 = state_14035;
var statearr_14043_15990 = state_14035__$1;
(statearr_14043_15990[(2)] = inst_14031);

(statearr_14043_15990[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14036 === (1))){
var state_14035__$1 = state_14035;
var statearr_14044_15991 = state_14035__$1;
(statearr_14044_15991[(2)] = null);

(statearr_14044_15991[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14036 === (4))){
var inst_14016 = (state_14035[(7)]);
var inst_14016__$1 = (state_14035[(2)]);
var inst_14017 = (inst_14016__$1 == null);
var state_14035__$1 = (function (){var statearr_14047 = state_14035;
(statearr_14047[(7)] = inst_14016__$1);

return statearr_14047;
})();
if(cljs.core.truth_(inst_14017)){
var statearr_14050_15997 = state_14035__$1;
(statearr_14050_15997[(1)] = (5));

} else {
var statearr_14051_16002 = state_14035__$1;
(statearr_14051_16002[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14036 === (6))){
var inst_14021 = (state_14035[(8)]);
var inst_14016 = (state_14035[(7)]);
var inst_14021__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_14022 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14023 = [inst_14016,inst_14021__$1];
var inst_14024 = (new cljs.core.PersistentVector(null,2,(5),inst_14022,inst_14023,null));
var state_14035__$1 = (function (){var statearr_14052 = state_14035;
(statearr_14052[(8)] = inst_14021__$1);

return statearr_14052;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14035__$1,(8),jobs,inst_14024);
} else {
if((state_val_14036 === (3))){
var inst_14033 = (state_14035[(2)]);
var state_14035__$1 = state_14035;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14035__$1,inst_14033);
} else {
if((state_val_14036 === (2))){
var state_14035__$1 = state_14035;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14035__$1,(4),from);
} else {
if((state_val_14036 === (9))){
var inst_14028 = (state_14035[(2)]);
var state_14035__$1 = (function (){var statearr_14053 = state_14035;
(statearr_14053[(9)] = inst_14028);

return statearr_14053;
})();
var statearr_14054_16020 = state_14035__$1;
(statearr_14054_16020[(2)] = null);

(statearr_14054_16020[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14036 === (5))){
var inst_14019 = cljs.core.async.close_BANG_(jobs);
var state_14035__$1 = state_14035;
var statearr_14055_16027 = state_14035__$1;
(statearr_14055_16027[(2)] = inst_14019);

(statearr_14055_16027[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14036 === (8))){
var inst_14021 = (state_14035[(8)]);
var inst_14026 = (state_14035[(2)]);
var state_14035__$1 = (function (){var statearr_14056 = state_14035;
(statearr_14056[(10)] = inst_14026);

return statearr_14056;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14035__$1,(9),results,inst_14021);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__13557__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__13557__auto____0 = (function (){
var statearr_14057 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14057[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__13557__auto__);

(statearr_14057[(1)] = (1));

return statearr_14057;
});
var cljs$core$async$pipeline_STAR__$_state_machine__13557__auto____1 = (function (state_14035){
while(true){
var ret_value__13558__auto__ = (function (){try{while(true){
var result__13559__auto__ = switch__13556__auto__(state_14035);
if(cljs.core.keyword_identical_QMARK_(result__13559__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13559__auto__;
}
break;
}
}catch (e14059){if((e14059 instanceof Object)){
var ex__13560__auto__ = e14059;
var statearr_14060_16038 = state_14035;
(statearr_14060_16038[(5)] = ex__13560__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_14035);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14059;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13558__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16039 = state_14035;
state_14035 = G__16039;
continue;
} else {
return ret_value__13558__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__13557__auto__ = function(state_14035){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__13557__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__13557__auto____1.call(this,state_14035);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__13557__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__13557__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__13557__auto__;
})()
})();
var state__13677__auto__ = (function (){var statearr_14066 = (f__13676__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13676__auto__.cljs$core$IFn$_invoke$arity$0() : f__13676__auto__.call(null));
(statearr_14066[(6)] = c__13675__auto___15985);

return statearr_14066;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13677__auto__);
}));


var c__13675__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13676__auto__ = (function (){var switch__13556__auto__ = (function (state_14120){
var state_val_14125 = (state_14120[(1)]);
if((state_val_14125 === (7))){
var inst_14116 = (state_14120[(2)]);
var state_14120__$1 = state_14120;
var statearr_14130_16051 = state_14120__$1;
(statearr_14130_16051[(2)] = inst_14116);

(statearr_14130_16051[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14125 === (20))){
var state_14120__$1 = state_14120;
var statearr_14135_16057 = state_14120__$1;
(statearr_14135_16057[(2)] = null);

(statearr_14135_16057[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14125 === (1))){
var state_14120__$1 = state_14120;
var statearr_14136_16059 = state_14120__$1;
(statearr_14136_16059[(2)] = null);

(statearr_14136_16059[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14125 === (4))){
var inst_14074 = (state_14120[(7)]);
var inst_14074__$1 = (state_14120[(2)]);
var inst_14076 = (inst_14074__$1 == null);
var state_14120__$1 = (function (){var statearr_14137 = state_14120;
(statearr_14137[(7)] = inst_14074__$1);

return statearr_14137;
})();
if(cljs.core.truth_(inst_14076)){
var statearr_14138_16064 = state_14120__$1;
(statearr_14138_16064[(1)] = (5));

} else {
var statearr_14139_16065 = state_14120__$1;
(statearr_14139_16065[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14125 === (15))){
var inst_14094 = (state_14120[(8)]);
var state_14120__$1 = state_14120;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14120__$1,(18),to,inst_14094);
} else {
if((state_val_14125 === (21))){
var inst_14111 = (state_14120[(2)]);
var state_14120__$1 = state_14120;
var statearr_14140_16066 = state_14120__$1;
(statearr_14140_16066[(2)] = inst_14111);

(statearr_14140_16066[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14125 === (13))){
var inst_14113 = (state_14120[(2)]);
var state_14120__$1 = (function (){var statearr_14141 = state_14120;
(statearr_14141[(9)] = inst_14113);

return statearr_14141;
})();
var statearr_14142_16068 = state_14120__$1;
(statearr_14142_16068[(2)] = null);

(statearr_14142_16068[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14125 === (6))){
var inst_14074 = (state_14120[(7)]);
var state_14120__$1 = state_14120;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14120__$1,(11),inst_14074);
} else {
if((state_val_14125 === (17))){
var inst_14106 = (state_14120[(2)]);
var state_14120__$1 = state_14120;
if(cljs.core.truth_(inst_14106)){
var statearr_14143_16069 = state_14120__$1;
(statearr_14143_16069[(1)] = (19));

} else {
var statearr_14144_16070 = state_14120__$1;
(statearr_14144_16070[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14125 === (3))){
var inst_14118 = (state_14120[(2)]);
var state_14120__$1 = state_14120;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14120__$1,inst_14118);
} else {
if((state_val_14125 === (12))){
var inst_14090 = (state_14120[(10)]);
var state_14120__$1 = state_14120;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14120__$1,(14),inst_14090);
} else {
if((state_val_14125 === (2))){
var state_14120__$1 = state_14120;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14120__$1,(4),results);
} else {
if((state_val_14125 === (19))){
var state_14120__$1 = state_14120;
var statearr_14145_16071 = state_14120__$1;
(statearr_14145_16071[(2)] = null);

(statearr_14145_16071[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14125 === (11))){
var inst_14090 = (state_14120[(2)]);
var state_14120__$1 = (function (){var statearr_14146 = state_14120;
(statearr_14146[(10)] = inst_14090);

return statearr_14146;
})();
var statearr_14147_16072 = state_14120__$1;
(statearr_14147_16072[(2)] = null);

(statearr_14147_16072[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14125 === (9))){
var state_14120__$1 = state_14120;
var statearr_14148_16074 = state_14120__$1;
(statearr_14148_16074[(2)] = null);

(statearr_14148_16074[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14125 === (5))){
var state_14120__$1 = state_14120;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14149_16075 = state_14120__$1;
(statearr_14149_16075[(1)] = (8));

} else {
var statearr_14151_16076 = state_14120__$1;
(statearr_14151_16076[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14125 === (14))){
var inst_14094 = (state_14120[(8)]);
var inst_14094__$1 = (state_14120[(2)]);
var inst_14099 = (inst_14094__$1 == null);
var inst_14100 = cljs.core.not(inst_14099);
var state_14120__$1 = (function (){var statearr_14152 = state_14120;
(statearr_14152[(8)] = inst_14094__$1);

return statearr_14152;
})();
if(inst_14100){
var statearr_14153_16077 = state_14120__$1;
(statearr_14153_16077[(1)] = (15));

} else {
var statearr_14154_16078 = state_14120__$1;
(statearr_14154_16078[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14125 === (16))){
var state_14120__$1 = state_14120;
var statearr_14155_16081 = state_14120__$1;
(statearr_14155_16081[(2)] = false);

(statearr_14155_16081[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14125 === (10))){
var inst_14083 = (state_14120[(2)]);
var state_14120__$1 = state_14120;
var statearr_14156_16082 = state_14120__$1;
(statearr_14156_16082[(2)] = inst_14083);

(statearr_14156_16082[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14125 === (18))){
var inst_14103 = (state_14120[(2)]);
var state_14120__$1 = state_14120;
var statearr_14157_16083 = state_14120__$1;
(statearr_14157_16083[(2)] = inst_14103);

(statearr_14157_16083[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14125 === (8))){
var inst_14080 = cljs.core.async.close_BANG_(to);
var state_14120__$1 = state_14120;
var statearr_14158_16084 = state_14120__$1;
(statearr_14158_16084[(2)] = inst_14080);

(statearr_14158_16084[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__13557__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__13557__auto____0 = (function (){
var statearr_14159 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14159[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__13557__auto__);

(statearr_14159[(1)] = (1));

return statearr_14159;
});
var cljs$core$async$pipeline_STAR__$_state_machine__13557__auto____1 = (function (state_14120){
while(true){
var ret_value__13558__auto__ = (function (){try{while(true){
var result__13559__auto__ = switch__13556__auto__(state_14120);
if(cljs.core.keyword_identical_QMARK_(result__13559__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13559__auto__;
}
break;
}
}catch (e14160){if((e14160 instanceof Object)){
var ex__13560__auto__ = e14160;
var statearr_14161_16089 = state_14120;
(statearr_14161_16089[(5)] = ex__13560__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_14120);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14160;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13558__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16090 = state_14120;
state_14120 = G__16090;
continue;
} else {
return ret_value__13558__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__13557__auto__ = function(state_14120){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__13557__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__13557__auto____1.call(this,state_14120);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__13557__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__13557__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__13557__auto__;
})()
})();
var state__13677__auto__ = (function (){var statearr_14162 = (f__13676__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13676__auto__.cljs$core$IFn$_invoke$arity$0() : f__13676__auto__.call(null));
(statearr_14162[(6)] = c__13675__auto__);

return statearr_14162;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13677__auto__);
}));

return c__13675__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__14164 = arguments.length;
switch (G__14164) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__14166 = arguments.length;
switch (G__14166) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__14176 = arguments.length;
switch (G__14176) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__13675__auto___16094 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13676__auto__ = (function (){var switch__13556__auto__ = (function (state_14206){
var state_val_14207 = (state_14206[(1)]);
if((state_val_14207 === (7))){
var inst_14202 = (state_14206[(2)]);
var state_14206__$1 = state_14206;
var statearr_14210_16095 = state_14206__$1;
(statearr_14210_16095[(2)] = inst_14202);

(statearr_14210_16095[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14207 === (1))){
var state_14206__$1 = state_14206;
var statearr_14211_16096 = state_14206__$1;
(statearr_14211_16096[(2)] = null);

(statearr_14211_16096[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14207 === (4))){
var inst_14182 = (state_14206[(7)]);
var inst_14182__$1 = (state_14206[(2)]);
var inst_14184 = (inst_14182__$1 == null);
var state_14206__$1 = (function (){var statearr_14212 = state_14206;
(statearr_14212[(7)] = inst_14182__$1);

return statearr_14212;
})();
if(cljs.core.truth_(inst_14184)){
var statearr_14217_16097 = state_14206__$1;
(statearr_14217_16097[(1)] = (5));

} else {
var statearr_14218_16098 = state_14206__$1;
(statearr_14218_16098[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14207 === (13))){
var state_14206__$1 = state_14206;
var statearr_14219_16099 = state_14206__$1;
(statearr_14219_16099[(2)] = null);

(statearr_14219_16099[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14207 === (6))){
var inst_14182 = (state_14206[(7)]);
var inst_14189 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_14182) : p.call(null,inst_14182));
var state_14206__$1 = state_14206;
if(cljs.core.truth_(inst_14189)){
var statearr_14220_16100 = state_14206__$1;
(statearr_14220_16100[(1)] = (9));

} else {
var statearr_14221_16101 = state_14206__$1;
(statearr_14221_16101[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14207 === (3))){
var inst_14204 = (state_14206[(2)]);
var state_14206__$1 = state_14206;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14206__$1,inst_14204);
} else {
if((state_val_14207 === (12))){
var state_14206__$1 = state_14206;
var statearr_14225_16102 = state_14206__$1;
(statearr_14225_16102[(2)] = null);

(statearr_14225_16102[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14207 === (2))){
var state_14206__$1 = state_14206;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14206__$1,(4),ch);
} else {
if((state_val_14207 === (11))){
var inst_14182 = (state_14206[(7)]);
var inst_14193 = (state_14206[(2)]);
var state_14206__$1 = state_14206;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14206__$1,(8),inst_14193,inst_14182);
} else {
if((state_val_14207 === (9))){
var state_14206__$1 = state_14206;
var statearr_14229_16103 = state_14206__$1;
(statearr_14229_16103[(2)] = tc);

(statearr_14229_16103[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14207 === (5))){
var inst_14186 = cljs.core.async.close_BANG_(tc);
var inst_14187 = cljs.core.async.close_BANG_(fc);
var state_14206__$1 = (function (){var statearr_14230 = state_14206;
(statearr_14230[(8)] = inst_14186);

return statearr_14230;
})();
var statearr_14231_16104 = state_14206__$1;
(statearr_14231_16104[(2)] = inst_14187);

(statearr_14231_16104[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14207 === (14))){
var inst_14200 = (state_14206[(2)]);
var state_14206__$1 = state_14206;
var statearr_14232_16105 = state_14206__$1;
(statearr_14232_16105[(2)] = inst_14200);

(statearr_14232_16105[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14207 === (10))){
var state_14206__$1 = state_14206;
var statearr_14233_16106 = state_14206__$1;
(statearr_14233_16106[(2)] = fc);

(statearr_14233_16106[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14207 === (8))){
var inst_14195 = (state_14206[(2)]);
var state_14206__$1 = state_14206;
if(cljs.core.truth_(inst_14195)){
var statearr_14234_16107 = state_14206__$1;
(statearr_14234_16107[(1)] = (12));

} else {
var statearr_14235_16108 = state_14206__$1;
(statearr_14235_16108[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__13557__auto__ = null;
var cljs$core$async$state_machine__13557__auto____0 = (function (){
var statearr_14237 = [null,null,null,null,null,null,null,null,null];
(statearr_14237[(0)] = cljs$core$async$state_machine__13557__auto__);

(statearr_14237[(1)] = (1));

return statearr_14237;
});
var cljs$core$async$state_machine__13557__auto____1 = (function (state_14206){
while(true){
var ret_value__13558__auto__ = (function (){try{while(true){
var result__13559__auto__ = switch__13556__auto__(state_14206);
if(cljs.core.keyword_identical_QMARK_(result__13559__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13559__auto__;
}
break;
}
}catch (e14238){if((e14238 instanceof Object)){
var ex__13560__auto__ = e14238;
var statearr_14240_16109 = state_14206;
(statearr_14240_16109[(5)] = ex__13560__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_14206);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14238;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13558__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16110 = state_14206;
state_14206 = G__16110;
continue;
} else {
return ret_value__13558__auto__;
}
break;
}
});
cljs$core$async$state_machine__13557__auto__ = function(state_14206){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13557__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13557__auto____1.call(this,state_14206);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13557__auto____0;
cljs$core$async$state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13557__auto____1;
return cljs$core$async$state_machine__13557__auto__;
})()
})();
var state__13677__auto__ = (function (){var statearr_14241 = (f__13676__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13676__auto__.cljs$core$IFn$_invoke$arity$0() : f__13676__auto__.call(null));
(statearr_14241[(6)] = c__13675__auto___16094);

return statearr_14241;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13677__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__13675__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13676__auto__ = (function (){var switch__13556__auto__ = (function (state_14267){
var state_val_14268 = (state_14267[(1)]);
if((state_val_14268 === (7))){
var inst_14262 = (state_14267[(2)]);
var state_14267__$1 = state_14267;
var statearr_14269_16111 = state_14267__$1;
(statearr_14269_16111[(2)] = inst_14262);

(statearr_14269_16111[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14268 === (1))){
var inst_14243 = init;
var state_14267__$1 = (function (){var statearr_14270 = state_14267;
(statearr_14270[(7)] = inst_14243);

return statearr_14270;
})();
var statearr_14271_16112 = state_14267__$1;
(statearr_14271_16112[(2)] = null);

(statearr_14271_16112[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14268 === (4))){
var inst_14246 = (state_14267[(8)]);
var inst_14246__$1 = (state_14267[(2)]);
var inst_14247 = (inst_14246__$1 == null);
var state_14267__$1 = (function (){var statearr_14272 = state_14267;
(statearr_14272[(8)] = inst_14246__$1);

return statearr_14272;
})();
if(cljs.core.truth_(inst_14247)){
var statearr_14275_16113 = state_14267__$1;
(statearr_14275_16113[(1)] = (5));

} else {
var statearr_14276_16114 = state_14267__$1;
(statearr_14276_16114[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14268 === (6))){
var inst_14246 = (state_14267[(8)]);
var inst_14251 = (state_14267[(9)]);
var inst_14243 = (state_14267[(7)]);
var inst_14251__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_14243,inst_14246) : f.call(null,inst_14243,inst_14246));
var inst_14252 = cljs.core.reduced_QMARK_(inst_14251__$1);
var state_14267__$1 = (function (){var statearr_14280 = state_14267;
(statearr_14280[(9)] = inst_14251__$1);

return statearr_14280;
})();
if(inst_14252){
var statearr_14283_16115 = state_14267__$1;
(statearr_14283_16115[(1)] = (8));

} else {
var statearr_14285_16116 = state_14267__$1;
(statearr_14285_16116[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14268 === (3))){
var inst_14264 = (state_14267[(2)]);
var state_14267__$1 = state_14267;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14267__$1,inst_14264);
} else {
if((state_val_14268 === (2))){
var state_14267__$1 = state_14267;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14267__$1,(4),ch);
} else {
if((state_val_14268 === (9))){
var inst_14251 = (state_14267[(9)]);
var inst_14243 = inst_14251;
var state_14267__$1 = (function (){var statearr_14286 = state_14267;
(statearr_14286[(7)] = inst_14243);

return statearr_14286;
})();
var statearr_14287_16117 = state_14267__$1;
(statearr_14287_16117[(2)] = null);

(statearr_14287_16117[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14268 === (5))){
var inst_14243 = (state_14267[(7)]);
var state_14267__$1 = state_14267;
var statearr_14288_16118 = state_14267__$1;
(statearr_14288_16118[(2)] = inst_14243);

(statearr_14288_16118[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14268 === (10))){
var inst_14260 = (state_14267[(2)]);
var state_14267__$1 = state_14267;
var statearr_14289_16119 = state_14267__$1;
(statearr_14289_16119[(2)] = inst_14260);

(statearr_14289_16119[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14268 === (8))){
var inst_14251 = (state_14267[(9)]);
var inst_14254 = cljs.core.deref(inst_14251);
var state_14267__$1 = state_14267;
var statearr_14293_16120 = state_14267__$1;
(statearr_14293_16120[(2)] = inst_14254);

(statearr_14293_16120[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__13557__auto__ = null;
var cljs$core$async$reduce_$_state_machine__13557__auto____0 = (function (){
var statearr_14294 = [null,null,null,null,null,null,null,null,null,null];
(statearr_14294[(0)] = cljs$core$async$reduce_$_state_machine__13557__auto__);

(statearr_14294[(1)] = (1));

return statearr_14294;
});
var cljs$core$async$reduce_$_state_machine__13557__auto____1 = (function (state_14267){
while(true){
var ret_value__13558__auto__ = (function (){try{while(true){
var result__13559__auto__ = switch__13556__auto__(state_14267);
if(cljs.core.keyword_identical_QMARK_(result__13559__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13559__auto__;
}
break;
}
}catch (e14295){if((e14295 instanceof Object)){
var ex__13560__auto__ = e14295;
var statearr_14296_16121 = state_14267;
(statearr_14296_16121[(5)] = ex__13560__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_14267);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14295;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13558__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16122 = state_14267;
state_14267 = G__16122;
continue;
} else {
return ret_value__13558__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__13557__auto__ = function(state_14267){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__13557__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__13557__auto____1.call(this,state_14267);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__13557__auto____0;
cljs$core$async$reduce_$_state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__13557__auto____1;
return cljs$core$async$reduce_$_state_machine__13557__auto__;
})()
})();
var state__13677__auto__ = (function (){var statearr_14297 = (f__13676__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13676__auto__.cljs$core$IFn$_invoke$arity$0() : f__13676__auto__.call(null));
(statearr_14297[(6)] = c__13675__auto__);

return statearr_14297;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13677__auto__);
}));

return c__13675__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__13675__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13676__auto__ = (function (){var switch__13556__auto__ = (function (state_14308){
var state_val_14309 = (state_14308[(1)]);
if((state_val_14309 === (1))){
var inst_14302 = cljs.core.async.reduce(f__$1,init,ch);
var state_14308__$1 = state_14308;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14308__$1,(2),inst_14302);
} else {
if((state_val_14309 === (2))){
var inst_14305 = (state_14308[(2)]);
var inst_14306 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_14305) : f__$1.call(null,inst_14305));
var state_14308__$1 = state_14308;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14308__$1,inst_14306);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__13557__auto__ = null;
var cljs$core$async$transduce_$_state_machine__13557__auto____0 = (function (){
var statearr_14310 = [null,null,null,null,null,null,null];
(statearr_14310[(0)] = cljs$core$async$transduce_$_state_machine__13557__auto__);

(statearr_14310[(1)] = (1));

return statearr_14310;
});
var cljs$core$async$transduce_$_state_machine__13557__auto____1 = (function (state_14308){
while(true){
var ret_value__13558__auto__ = (function (){try{while(true){
var result__13559__auto__ = switch__13556__auto__(state_14308);
if(cljs.core.keyword_identical_QMARK_(result__13559__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13559__auto__;
}
break;
}
}catch (e14311){if((e14311 instanceof Object)){
var ex__13560__auto__ = e14311;
var statearr_14312_16123 = state_14308;
(statearr_14312_16123[(5)] = ex__13560__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_14308);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14311;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13558__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16124 = state_14308;
state_14308 = G__16124;
continue;
} else {
return ret_value__13558__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__13557__auto__ = function(state_14308){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__13557__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__13557__auto____1.call(this,state_14308);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__13557__auto____0;
cljs$core$async$transduce_$_state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__13557__auto____1;
return cljs$core$async$transduce_$_state_machine__13557__auto__;
})()
})();
var state__13677__auto__ = (function (){var statearr_14313 = (f__13676__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13676__auto__.cljs$core$IFn$_invoke$arity$0() : f__13676__auto__.call(null));
(statearr_14313[(6)] = c__13675__auto__);

return statearr_14313;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13677__auto__);
}));

return c__13675__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__14316 = arguments.length;
switch (G__14316) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__13675__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13676__auto__ = (function (){var switch__13556__auto__ = (function (state_14348){
var state_val_14349 = (state_14348[(1)]);
if((state_val_14349 === (7))){
var inst_14330 = (state_14348[(2)]);
var state_14348__$1 = state_14348;
var statearr_14353_16126 = state_14348__$1;
(statearr_14353_16126[(2)] = inst_14330);

(statearr_14353_16126[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14349 === (1))){
var inst_14320 = cljs.core.seq(coll);
var inst_14321 = inst_14320;
var state_14348__$1 = (function (){var statearr_14357 = state_14348;
(statearr_14357[(7)] = inst_14321);

return statearr_14357;
})();
var statearr_14358_16127 = state_14348__$1;
(statearr_14358_16127[(2)] = null);

(statearr_14358_16127[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14349 === (4))){
var inst_14321 = (state_14348[(7)]);
var inst_14328 = cljs.core.first(inst_14321);
var state_14348__$1 = state_14348;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14348__$1,(7),ch,inst_14328);
} else {
if((state_val_14349 === (13))){
var inst_14342 = (state_14348[(2)]);
var state_14348__$1 = state_14348;
var statearr_14359_16128 = state_14348__$1;
(statearr_14359_16128[(2)] = inst_14342);

(statearr_14359_16128[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14349 === (6))){
var inst_14333 = (state_14348[(2)]);
var state_14348__$1 = state_14348;
if(cljs.core.truth_(inst_14333)){
var statearr_14364_16129 = state_14348__$1;
(statearr_14364_16129[(1)] = (8));

} else {
var statearr_14365_16130 = state_14348__$1;
(statearr_14365_16130[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14349 === (3))){
var inst_14346 = (state_14348[(2)]);
var state_14348__$1 = state_14348;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14348__$1,inst_14346);
} else {
if((state_val_14349 === (12))){
var state_14348__$1 = state_14348;
var statearr_14366_16131 = state_14348__$1;
(statearr_14366_16131[(2)] = null);

(statearr_14366_16131[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14349 === (2))){
var inst_14321 = (state_14348[(7)]);
var state_14348__$1 = state_14348;
if(cljs.core.truth_(inst_14321)){
var statearr_14370_16132 = state_14348__$1;
(statearr_14370_16132[(1)] = (4));

} else {
var statearr_14371_16133 = state_14348__$1;
(statearr_14371_16133[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14349 === (11))){
var inst_14339 = cljs.core.async.close_BANG_(ch);
var state_14348__$1 = state_14348;
var statearr_14375_16138 = state_14348__$1;
(statearr_14375_16138[(2)] = inst_14339);

(statearr_14375_16138[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14349 === (9))){
var state_14348__$1 = state_14348;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14376_16143 = state_14348__$1;
(statearr_14376_16143[(1)] = (11));

} else {
var statearr_14377_16144 = state_14348__$1;
(statearr_14377_16144[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14349 === (5))){
var inst_14321 = (state_14348[(7)]);
var state_14348__$1 = state_14348;
var statearr_14378_16149 = state_14348__$1;
(statearr_14378_16149[(2)] = inst_14321);

(statearr_14378_16149[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14349 === (10))){
var inst_14344 = (state_14348[(2)]);
var state_14348__$1 = state_14348;
var statearr_14379_16150 = state_14348__$1;
(statearr_14379_16150[(2)] = inst_14344);

(statearr_14379_16150[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14349 === (8))){
var inst_14321 = (state_14348[(7)]);
var inst_14335 = cljs.core.next(inst_14321);
var inst_14321__$1 = inst_14335;
var state_14348__$1 = (function (){var statearr_14384 = state_14348;
(statearr_14384[(7)] = inst_14321__$1);

return statearr_14384;
})();
var statearr_14385_16151 = state_14348__$1;
(statearr_14385_16151[(2)] = null);

(statearr_14385_16151[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__13557__auto__ = null;
var cljs$core$async$state_machine__13557__auto____0 = (function (){
var statearr_14386 = [null,null,null,null,null,null,null,null];
(statearr_14386[(0)] = cljs$core$async$state_machine__13557__auto__);

(statearr_14386[(1)] = (1));

return statearr_14386;
});
var cljs$core$async$state_machine__13557__auto____1 = (function (state_14348){
while(true){
var ret_value__13558__auto__ = (function (){try{while(true){
var result__13559__auto__ = switch__13556__auto__(state_14348);
if(cljs.core.keyword_identical_QMARK_(result__13559__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13559__auto__;
}
break;
}
}catch (e14390){if((e14390 instanceof Object)){
var ex__13560__auto__ = e14390;
var statearr_14391_16160 = state_14348;
(statearr_14391_16160[(5)] = ex__13560__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_14348);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14390;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13558__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16165 = state_14348;
state_14348 = G__16165;
continue;
} else {
return ret_value__13558__auto__;
}
break;
}
});
cljs$core$async$state_machine__13557__auto__ = function(state_14348){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13557__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13557__auto____1.call(this,state_14348);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13557__auto____0;
cljs$core$async$state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13557__auto____1;
return cljs$core$async$state_machine__13557__auto__;
})()
})();
var state__13677__auto__ = (function (){var statearr_14395 = (f__13676__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13676__auto__.cljs$core$IFn$_invoke$arity$0() : f__13676__auto__.call(null));
(statearr_14395[(6)] = c__13675__auto__);

return statearr_14395;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13677__auto__);
}));

return c__13675__auto__;
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4487__auto__ = (((_ == null))?null:_);
var m__4488__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4488__auto__.call(null,_));
} else {
var m__4485__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4485__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4488__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4485__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4485__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4488__auto__.call(null,m,ch));
} else {
var m__4485__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4485__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4488__auto__.call(null,m));
} else {
var m__4485__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4485__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async14419 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14419 = (function (ch,cs,meta14420){
this.ch = ch;
this.cs = cs;
this.meta14420 = meta14420;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async14419.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14421,meta14420__$1){
var self__ = this;
var _14421__$1 = this;
return (new cljs.core.async.t_cljs$core$async14419(self__.ch,self__.cs,meta14420__$1));
}));

(cljs.core.async.t_cljs$core$async14419.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14421){
var self__ = this;
var _14421__$1 = this;
return self__.meta14420;
}));

(cljs.core.async.t_cljs$core$async14419.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14419.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async14419.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14419.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async14419.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async14419.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async14419.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta14420","meta14420",1333243082,null)], null);
}));

(cljs.core.async.t_cljs$core$async14419.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async14419.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14419");

(cljs.core.async.t_cljs$core$async14419.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async14419");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async14419.
 */
cljs.core.async.__GT_t_cljs$core$async14419 = (function cljs$core$async$mult_$___GT_t_cljs$core$async14419(ch__$1,cs__$1,meta14420){
return (new cljs.core.async.t_cljs$core$async14419(ch__$1,cs__$1,meta14420));
});

}

return (new cljs.core.async.t_cljs$core$async14419(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__13675__auto___16166 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13676__auto__ = (function (){var switch__13556__auto__ = (function (state_14567){
var state_val_14568 = (state_14567[(1)]);
if((state_val_14568 === (7))){
var inst_14563 = (state_14567[(2)]);
var state_14567__$1 = state_14567;
var statearr_14569_16167 = state_14567__$1;
(statearr_14569_16167[(2)] = inst_14563);

(statearr_14569_16167[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (20))){
var inst_14466 = (state_14567[(7)]);
var inst_14478 = cljs.core.first(inst_14466);
var inst_14479 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14478,(0),null);
var inst_14480 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14478,(1),null);
var state_14567__$1 = (function (){var statearr_14570 = state_14567;
(statearr_14570[(8)] = inst_14479);

return statearr_14570;
})();
if(cljs.core.truth_(inst_14480)){
var statearr_14572_16168 = state_14567__$1;
(statearr_14572_16168[(1)] = (22));

} else {
var statearr_14574_16169 = state_14567__$1;
(statearr_14574_16169[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (27))){
var inst_14508 = (state_14567[(9)]);
var inst_14510 = (state_14567[(10)]);
var inst_14515 = (state_14567[(11)]);
var inst_14434 = (state_14567[(12)]);
var inst_14515__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_14508,inst_14510);
var inst_14516 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_14515__$1,inst_14434,done);
var state_14567__$1 = (function (){var statearr_14575 = state_14567;
(statearr_14575[(11)] = inst_14515__$1);

return statearr_14575;
})();
if(cljs.core.truth_(inst_14516)){
var statearr_14576_16170 = state_14567__$1;
(statearr_14576_16170[(1)] = (30));

} else {
var statearr_14577_16171 = state_14567__$1;
(statearr_14577_16171[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (1))){
var state_14567__$1 = state_14567;
var statearr_14578_16172 = state_14567__$1;
(statearr_14578_16172[(2)] = null);

(statearr_14578_16172[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (24))){
var inst_14466 = (state_14567[(7)]);
var inst_14485 = (state_14567[(2)]);
var inst_14486 = cljs.core.next(inst_14466);
var inst_14443 = inst_14486;
var inst_14444 = null;
var inst_14445 = (0);
var inst_14446 = (0);
var state_14567__$1 = (function (){var statearr_14579 = state_14567;
(statearr_14579[(13)] = inst_14446);

(statearr_14579[(14)] = inst_14445);

(statearr_14579[(15)] = inst_14485);

(statearr_14579[(16)] = inst_14444);

(statearr_14579[(17)] = inst_14443);

return statearr_14579;
})();
var statearr_14580_16173 = state_14567__$1;
(statearr_14580_16173[(2)] = null);

(statearr_14580_16173[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (39))){
var state_14567__$1 = state_14567;
var statearr_14585_16174 = state_14567__$1;
(statearr_14585_16174[(2)] = null);

(statearr_14585_16174[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (4))){
var inst_14434 = (state_14567[(12)]);
var inst_14434__$1 = (state_14567[(2)]);
var inst_14435 = (inst_14434__$1 == null);
var state_14567__$1 = (function (){var statearr_14586 = state_14567;
(statearr_14586[(12)] = inst_14434__$1);

return statearr_14586;
})();
if(cljs.core.truth_(inst_14435)){
var statearr_14587_16175 = state_14567__$1;
(statearr_14587_16175[(1)] = (5));

} else {
var statearr_14588_16176 = state_14567__$1;
(statearr_14588_16176[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (15))){
var inst_14446 = (state_14567[(13)]);
var inst_14445 = (state_14567[(14)]);
var inst_14444 = (state_14567[(16)]);
var inst_14443 = (state_14567[(17)]);
var inst_14462 = (state_14567[(2)]);
var inst_14463 = (inst_14446 + (1));
var tmp14581 = inst_14445;
var tmp14582 = inst_14444;
var tmp14583 = inst_14443;
var inst_14443__$1 = tmp14583;
var inst_14444__$1 = tmp14582;
var inst_14445__$1 = tmp14581;
var inst_14446__$1 = inst_14463;
var state_14567__$1 = (function (){var statearr_14593 = state_14567;
(statearr_14593[(13)] = inst_14446__$1);

(statearr_14593[(18)] = inst_14462);

(statearr_14593[(14)] = inst_14445__$1);

(statearr_14593[(16)] = inst_14444__$1);

(statearr_14593[(17)] = inst_14443__$1);

return statearr_14593;
})();
var statearr_14594_16177 = state_14567__$1;
(statearr_14594_16177[(2)] = null);

(statearr_14594_16177[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (21))){
var inst_14489 = (state_14567[(2)]);
var state_14567__$1 = state_14567;
var statearr_14598_16178 = state_14567__$1;
(statearr_14598_16178[(2)] = inst_14489);

(statearr_14598_16178[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (31))){
var inst_14515 = (state_14567[(11)]);
var inst_14519 = done(null);
var inst_14520 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_14515);
var state_14567__$1 = (function (){var statearr_14599 = state_14567;
(statearr_14599[(19)] = inst_14519);

return statearr_14599;
})();
var statearr_14601_16179 = state_14567__$1;
(statearr_14601_16179[(2)] = inst_14520);

(statearr_14601_16179[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (32))){
var inst_14507 = (state_14567[(20)]);
var inst_14508 = (state_14567[(9)]);
var inst_14510 = (state_14567[(10)]);
var inst_14509 = (state_14567[(21)]);
var inst_14522 = (state_14567[(2)]);
var inst_14523 = (inst_14510 + (1));
var tmp14595 = inst_14507;
var tmp14596 = inst_14508;
var tmp14597 = inst_14509;
var inst_14507__$1 = tmp14595;
var inst_14508__$1 = tmp14596;
var inst_14509__$1 = tmp14597;
var inst_14510__$1 = inst_14523;
var state_14567__$1 = (function (){var statearr_14602 = state_14567;
(statearr_14602[(20)] = inst_14507__$1);

(statearr_14602[(9)] = inst_14508__$1);

(statearr_14602[(22)] = inst_14522);

(statearr_14602[(10)] = inst_14510__$1);

(statearr_14602[(21)] = inst_14509__$1);

return statearr_14602;
})();
var statearr_14603_16180 = state_14567__$1;
(statearr_14603_16180[(2)] = null);

(statearr_14603_16180[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (40))){
var inst_14535 = (state_14567[(23)]);
var inst_14539 = done(null);
var inst_14540 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_14535);
var state_14567__$1 = (function (){var statearr_14604 = state_14567;
(statearr_14604[(24)] = inst_14539);

return statearr_14604;
})();
var statearr_14606_16181 = state_14567__$1;
(statearr_14606_16181[(2)] = inst_14540);

(statearr_14606_16181[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (33))){
var inst_14526 = (state_14567[(25)]);
var inst_14528 = cljs.core.chunked_seq_QMARK_(inst_14526);
var state_14567__$1 = state_14567;
if(inst_14528){
var statearr_14607_16182 = state_14567__$1;
(statearr_14607_16182[(1)] = (36));

} else {
var statearr_14608_16183 = state_14567__$1;
(statearr_14608_16183[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (13))){
var inst_14456 = (state_14567[(26)]);
var inst_14459 = cljs.core.async.close_BANG_(inst_14456);
var state_14567__$1 = state_14567;
var statearr_14609_16184 = state_14567__$1;
(statearr_14609_16184[(2)] = inst_14459);

(statearr_14609_16184[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (22))){
var inst_14479 = (state_14567[(8)]);
var inst_14482 = cljs.core.async.close_BANG_(inst_14479);
var state_14567__$1 = state_14567;
var statearr_14610_16185 = state_14567__$1;
(statearr_14610_16185[(2)] = inst_14482);

(statearr_14610_16185[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (36))){
var inst_14526 = (state_14567[(25)]);
var inst_14530 = cljs.core.chunk_first(inst_14526);
var inst_14531 = cljs.core.chunk_rest(inst_14526);
var inst_14532 = cljs.core.count(inst_14530);
var inst_14507 = inst_14531;
var inst_14508 = inst_14530;
var inst_14509 = inst_14532;
var inst_14510 = (0);
var state_14567__$1 = (function (){var statearr_14611 = state_14567;
(statearr_14611[(20)] = inst_14507);

(statearr_14611[(9)] = inst_14508);

(statearr_14611[(10)] = inst_14510);

(statearr_14611[(21)] = inst_14509);

return statearr_14611;
})();
var statearr_14612_16186 = state_14567__$1;
(statearr_14612_16186[(2)] = null);

(statearr_14612_16186[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (41))){
var inst_14526 = (state_14567[(25)]);
var inst_14542 = (state_14567[(2)]);
var inst_14543 = cljs.core.next(inst_14526);
var inst_14507 = inst_14543;
var inst_14508 = null;
var inst_14509 = (0);
var inst_14510 = (0);
var state_14567__$1 = (function (){var statearr_14613 = state_14567;
(statearr_14613[(20)] = inst_14507);

(statearr_14613[(9)] = inst_14508);

(statearr_14613[(27)] = inst_14542);

(statearr_14613[(10)] = inst_14510);

(statearr_14613[(21)] = inst_14509);

return statearr_14613;
})();
var statearr_14614_16187 = state_14567__$1;
(statearr_14614_16187[(2)] = null);

(statearr_14614_16187[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (43))){
var state_14567__$1 = state_14567;
var statearr_14615_16188 = state_14567__$1;
(statearr_14615_16188[(2)] = null);

(statearr_14615_16188[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (29))){
var inst_14551 = (state_14567[(2)]);
var state_14567__$1 = state_14567;
var statearr_14616_16189 = state_14567__$1;
(statearr_14616_16189[(2)] = inst_14551);

(statearr_14616_16189[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (44))){
var inst_14560 = (state_14567[(2)]);
var state_14567__$1 = (function (){var statearr_14617 = state_14567;
(statearr_14617[(28)] = inst_14560);

return statearr_14617;
})();
var statearr_14618_16190 = state_14567__$1;
(statearr_14618_16190[(2)] = null);

(statearr_14618_16190[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (6))){
var inst_14499 = (state_14567[(29)]);
var inst_14498 = cljs.core.deref(cs);
var inst_14499__$1 = cljs.core.keys(inst_14498);
var inst_14500 = cljs.core.count(inst_14499__$1);
var inst_14501 = cljs.core.reset_BANG_(dctr,inst_14500);
var inst_14506 = cljs.core.seq(inst_14499__$1);
var inst_14507 = inst_14506;
var inst_14508 = null;
var inst_14509 = (0);
var inst_14510 = (0);
var state_14567__$1 = (function (){var statearr_14620 = state_14567;
(statearr_14620[(20)] = inst_14507);

(statearr_14620[(9)] = inst_14508);

(statearr_14620[(10)] = inst_14510);

(statearr_14620[(29)] = inst_14499__$1);

(statearr_14620[(21)] = inst_14509);

(statearr_14620[(30)] = inst_14501);

return statearr_14620;
})();
var statearr_14621_16191 = state_14567__$1;
(statearr_14621_16191[(2)] = null);

(statearr_14621_16191[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (28))){
var inst_14507 = (state_14567[(20)]);
var inst_14526 = (state_14567[(25)]);
var inst_14526__$1 = cljs.core.seq(inst_14507);
var state_14567__$1 = (function (){var statearr_14622 = state_14567;
(statearr_14622[(25)] = inst_14526__$1);

return statearr_14622;
})();
if(inst_14526__$1){
var statearr_14623_16192 = state_14567__$1;
(statearr_14623_16192[(1)] = (33));

} else {
var statearr_14624_16193 = state_14567__$1;
(statearr_14624_16193[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (25))){
var inst_14510 = (state_14567[(10)]);
var inst_14509 = (state_14567[(21)]);
var inst_14512 = (inst_14510 < inst_14509);
var inst_14513 = inst_14512;
var state_14567__$1 = state_14567;
if(cljs.core.truth_(inst_14513)){
var statearr_14625_16194 = state_14567__$1;
(statearr_14625_16194[(1)] = (27));

} else {
var statearr_14626_16195 = state_14567__$1;
(statearr_14626_16195[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (34))){
var state_14567__$1 = state_14567;
var statearr_14627_16196 = state_14567__$1;
(statearr_14627_16196[(2)] = null);

(statearr_14627_16196[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (17))){
var state_14567__$1 = state_14567;
var statearr_14628_16197 = state_14567__$1;
(statearr_14628_16197[(2)] = null);

(statearr_14628_16197[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (3))){
var inst_14565 = (state_14567[(2)]);
var state_14567__$1 = state_14567;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14567__$1,inst_14565);
} else {
if((state_val_14568 === (12))){
var inst_14494 = (state_14567[(2)]);
var state_14567__$1 = state_14567;
var statearr_14629_16198 = state_14567__$1;
(statearr_14629_16198[(2)] = inst_14494);

(statearr_14629_16198[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (2))){
var state_14567__$1 = state_14567;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14567__$1,(4),ch);
} else {
if((state_val_14568 === (23))){
var state_14567__$1 = state_14567;
var statearr_14630_16199 = state_14567__$1;
(statearr_14630_16199[(2)] = null);

(statearr_14630_16199[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (35))){
var inst_14549 = (state_14567[(2)]);
var state_14567__$1 = state_14567;
var statearr_14631_16200 = state_14567__$1;
(statearr_14631_16200[(2)] = inst_14549);

(statearr_14631_16200[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (19))){
var inst_14466 = (state_14567[(7)]);
var inst_14470 = cljs.core.chunk_first(inst_14466);
var inst_14471 = cljs.core.chunk_rest(inst_14466);
var inst_14472 = cljs.core.count(inst_14470);
var inst_14443 = inst_14471;
var inst_14444 = inst_14470;
var inst_14445 = inst_14472;
var inst_14446 = (0);
var state_14567__$1 = (function (){var statearr_14632 = state_14567;
(statearr_14632[(13)] = inst_14446);

(statearr_14632[(14)] = inst_14445);

(statearr_14632[(16)] = inst_14444);

(statearr_14632[(17)] = inst_14443);

return statearr_14632;
})();
var statearr_14633_16201 = state_14567__$1;
(statearr_14633_16201[(2)] = null);

(statearr_14633_16201[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (11))){
var inst_14466 = (state_14567[(7)]);
var inst_14443 = (state_14567[(17)]);
var inst_14466__$1 = cljs.core.seq(inst_14443);
var state_14567__$1 = (function (){var statearr_14634 = state_14567;
(statearr_14634[(7)] = inst_14466__$1);

return statearr_14634;
})();
if(inst_14466__$1){
var statearr_14635_16202 = state_14567__$1;
(statearr_14635_16202[(1)] = (16));

} else {
var statearr_14636_16203 = state_14567__$1;
(statearr_14636_16203[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (9))){
var inst_14496 = (state_14567[(2)]);
var state_14567__$1 = state_14567;
var statearr_14637_16204 = state_14567__$1;
(statearr_14637_16204[(2)] = inst_14496);

(statearr_14637_16204[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (5))){
var inst_14441 = cljs.core.deref(cs);
var inst_14442 = cljs.core.seq(inst_14441);
var inst_14443 = inst_14442;
var inst_14444 = null;
var inst_14445 = (0);
var inst_14446 = (0);
var state_14567__$1 = (function (){var statearr_14638 = state_14567;
(statearr_14638[(13)] = inst_14446);

(statearr_14638[(14)] = inst_14445);

(statearr_14638[(16)] = inst_14444);

(statearr_14638[(17)] = inst_14443);

return statearr_14638;
})();
var statearr_14639_16205 = state_14567__$1;
(statearr_14639_16205[(2)] = null);

(statearr_14639_16205[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (14))){
var state_14567__$1 = state_14567;
var statearr_14640_16206 = state_14567__$1;
(statearr_14640_16206[(2)] = null);

(statearr_14640_16206[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (45))){
var inst_14557 = (state_14567[(2)]);
var state_14567__$1 = state_14567;
var statearr_14641_16207 = state_14567__$1;
(statearr_14641_16207[(2)] = inst_14557);

(statearr_14641_16207[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (26))){
var inst_14499 = (state_14567[(29)]);
var inst_14553 = (state_14567[(2)]);
var inst_14554 = cljs.core.seq(inst_14499);
var state_14567__$1 = (function (){var statearr_14642 = state_14567;
(statearr_14642[(31)] = inst_14553);

return statearr_14642;
})();
if(inst_14554){
var statearr_14643_16208 = state_14567__$1;
(statearr_14643_16208[(1)] = (42));

} else {
var statearr_14644_16209 = state_14567__$1;
(statearr_14644_16209[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (16))){
var inst_14466 = (state_14567[(7)]);
var inst_14468 = cljs.core.chunked_seq_QMARK_(inst_14466);
var state_14567__$1 = state_14567;
if(inst_14468){
var statearr_14645_16210 = state_14567__$1;
(statearr_14645_16210[(1)] = (19));

} else {
var statearr_14646_16211 = state_14567__$1;
(statearr_14646_16211[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (38))){
var inst_14546 = (state_14567[(2)]);
var state_14567__$1 = state_14567;
var statearr_14647_16212 = state_14567__$1;
(statearr_14647_16212[(2)] = inst_14546);

(statearr_14647_16212[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (30))){
var state_14567__$1 = state_14567;
var statearr_14648_16213 = state_14567__$1;
(statearr_14648_16213[(2)] = null);

(statearr_14648_16213[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (10))){
var inst_14446 = (state_14567[(13)]);
var inst_14444 = (state_14567[(16)]);
var inst_14455 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_14444,inst_14446);
var inst_14456 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14455,(0),null);
var inst_14457 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14455,(1),null);
var state_14567__$1 = (function (){var statearr_14649 = state_14567;
(statearr_14649[(26)] = inst_14456);

return statearr_14649;
})();
if(cljs.core.truth_(inst_14457)){
var statearr_14650_16214 = state_14567__$1;
(statearr_14650_16214[(1)] = (13));

} else {
var statearr_14651_16215 = state_14567__$1;
(statearr_14651_16215[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (18))){
var inst_14492 = (state_14567[(2)]);
var state_14567__$1 = state_14567;
var statearr_14652_16216 = state_14567__$1;
(statearr_14652_16216[(2)] = inst_14492);

(statearr_14652_16216[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (42))){
var state_14567__$1 = state_14567;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14567__$1,(45),dchan);
} else {
if((state_val_14568 === (37))){
var inst_14526 = (state_14567[(25)]);
var inst_14535 = (state_14567[(23)]);
var inst_14434 = (state_14567[(12)]);
var inst_14535__$1 = cljs.core.first(inst_14526);
var inst_14536 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_14535__$1,inst_14434,done);
var state_14567__$1 = (function (){var statearr_14653 = state_14567;
(statearr_14653[(23)] = inst_14535__$1);

return statearr_14653;
})();
if(cljs.core.truth_(inst_14536)){
var statearr_14654_16217 = state_14567__$1;
(statearr_14654_16217[(1)] = (39));

} else {
var statearr_14655_16218 = state_14567__$1;
(statearr_14655_16218[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14568 === (8))){
var inst_14446 = (state_14567[(13)]);
var inst_14445 = (state_14567[(14)]);
var inst_14448 = (inst_14446 < inst_14445);
var inst_14449 = inst_14448;
var state_14567__$1 = state_14567;
if(cljs.core.truth_(inst_14449)){
var statearr_14656_16219 = state_14567__$1;
(statearr_14656_16219[(1)] = (10));

} else {
var statearr_14657_16220 = state_14567__$1;
(statearr_14657_16220[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__13557__auto__ = null;
var cljs$core$async$mult_$_state_machine__13557__auto____0 = (function (){
var statearr_14658 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14658[(0)] = cljs$core$async$mult_$_state_machine__13557__auto__);

(statearr_14658[(1)] = (1));

return statearr_14658;
});
var cljs$core$async$mult_$_state_machine__13557__auto____1 = (function (state_14567){
while(true){
var ret_value__13558__auto__ = (function (){try{while(true){
var result__13559__auto__ = switch__13556__auto__(state_14567);
if(cljs.core.keyword_identical_QMARK_(result__13559__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13559__auto__;
}
break;
}
}catch (e14659){if((e14659 instanceof Object)){
var ex__13560__auto__ = e14659;
var statearr_14660_16221 = state_14567;
(statearr_14660_16221[(5)] = ex__13560__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_14567);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14659;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13558__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16222 = state_14567;
state_14567 = G__16222;
continue;
} else {
return ret_value__13558__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__13557__auto__ = function(state_14567){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__13557__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__13557__auto____1.call(this,state_14567);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__13557__auto____0;
cljs$core$async$mult_$_state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__13557__auto____1;
return cljs$core$async$mult_$_state_machine__13557__auto__;
})()
})();
var state__13677__auto__ = (function (){var statearr_14661 = (f__13676__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13676__auto__.cljs$core$IFn$_invoke$arity$0() : f__13676__auto__.call(null));
(statearr_14661[(6)] = c__13675__auto___16166);

return statearr_14661;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13677__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__14663 = arguments.length;
switch (G__14663) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4488__auto__.call(null,m,ch));
} else {
var m__4485__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4485__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4488__auto__.call(null,m,ch));
} else {
var m__4485__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4485__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4488__auto__.call(null,m));
} else {
var m__4485__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4485__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4488__auto__.call(null,m,state_map));
} else {
var m__4485__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4485__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4488__auto__.call(null,m,mode));
} else {
var m__4485__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4485__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___16224 = arguments.length;
var i__4790__auto___16225 = (0);
while(true){
if((i__4790__auto___16225 < len__4789__auto___16224)){
args__4795__auto__.push((arguments[i__4790__auto___16225]));

var G__16226 = (i__4790__auto___16225 + (1));
i__4790__auto___16225 = G__16226;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((3) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4796__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__14668){
var map__14669 = p__14668;
var map__14669__$1 = (((((!((map__14669 == null))))?(((((map__14669.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14669.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14669):map__14669);
var opts = map__14669__$1;
var statearr_14671_16227 = state;
(statearr_14671_16227[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts((function (val){
var statearr_14672_16228 = state;
(statearr_14672_16228[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_14673_16229 = state;
(statearr_14673_16229[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq14664){
var G__14665 = cljs.core.first(seq14664);
var seq14664__$1 = cljs.core.next(seq14664);
var G__14666 = cljs.core.first(seq14664__$1);
var seq14664__$2 = cljs.core.next(seq14664__$1);
var G__14667 = cljs.core.first(seq14664__$2);
var seq14664__$3 = cljs.core.next(seq14664__$2);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14665,G__14666,G__14667,seq14664__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async14681 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14681 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta14682){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta14682 = meta14682;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async14681.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14683,meta14682__$1){
var self__ = this;
var _14683__$1 = this;
return (new cljs.core.async.t_cljs$core$async14681(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta14682__$1));
}));

(cljs.core.async.t_cljs$core$async14681.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14683){
var self__ = this;
var _14683__$1 = this;
return self__.meta14682;
}));

(cljs.core.async.t_cljs$core$async14681.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14681.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async14681.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14681.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async14681.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async14681.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async14681.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async14681.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async14681.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta14682","meta14682",1402705711,null)], null);
}));

(cljs.core.async.t_cljs$core$async14681.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async14681.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14681");

(cljs.core.async.t_cljs$core$async14681.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async14681");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async14681.
 */
cljs.core.async.__GT_t_cljs$core$async14681 = (function cljs$core$async$mix_$___GT_t_cljs$core$async14681(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta14682){
return (new cljs.core.async.t_cljs$core$async14681(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta14682));
});

}

return (new cljs.core.async.t_cljs$core$async14681(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__13675__auto___16230 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13676__auto__ = (function (){var switch__13556__auto__ = (function (state_14798){
var state_val_14799 = (state_14798[(1)]);
if((state_val_14799 === (7))){
var inst_14713 = (state_14798[(2)]);
var state_14798__$1 = state_14798;
var statearr_14801_16231 = state_14798__$1;
(statearr_14801_16231[(2)] = inst_14713);

(statearr_14801_16231[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (20))){
var inst_14725 = (state_14798[(7)]);
var state_14798__$1 = state_14798;
var statearr_14802_16232 = state_14798__$1;
(statearr_14802_16232[(2)] = inst_14725);

(statearr_14802_16232[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (27))){
var state_14798__$1 = state_14798;
var statearr_14807_16233 = state_14798__$1;
(statearr_14807_16233[(2)] = null);

(statearr_14807_16233[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (1))){
var inst_14700 = (state_14798[(8)]);
var inst_14700__$1 = calc_state();
var inst_14702 = (inst_14700__$1 == null);
var inst_14703 = cljs.core.not(inst_14702);
var state_14798__$1 = (function (){var statearr_14808 = state_14798;
(statearr_14808[(8)] = inst_14700__$1);

return statearr_14808;
})();
if(inst_14703){
var statearr_14809_16234 = state_14798__$1;
(statearr_14809_16234[(1)] = (2));

} else {
var statearr_14810_16235 = state_14798__$1;
(statearr_14810_16235[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (24))){
var inst_14772 = (state_14798[(9)]);
var inst_14749 = (state_14798[(10)]);
var inst_14758 = (state_14798[(11)]);
var inst_14772__$1 = (inst_14749.cljs$core$IFn$_invoke$arity$1 ? inst_14749.cljs$core$IFn$_invoke$arity$1(inst_14758) : inst_14749.call(null,inst_14758));
var state_14798__$1 = (function (){var statearr_14811 = state_14798;
(statearr_14811[(9)] = inst_14772__$1);

return statearr_14811;
})();
if(cljs.core.truth_(inst_14772__$1)){
var statearr_14812_16236 = state_14798__$1;
(statearr_14812_16236[(1)] = (29));

} else {
var statearr_14813_16237 = state_14798__$1;
(statearr_14813_16237[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (4))){
var inst_14716 = (state_14798[(2)]);
var state_14798__$1 = state_14798;
if(cljs.core.truth_(inst_14716)){
var statearr_14818_16238 = state_14798__$1;
(statearr_14818_16238[(1)] = (8));

} else {
var statearr_14819_16239 = state_14798__$1;
(statearr_14819_16239[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (15))){
var inst_14743 = (state_14798[(2)]);
var state_14798__$1 = state_14798;
if(cljs.core.truth_(inst_14743)){
var statearr_14821_16240 = state_14798__$1;
(statearr_14821_16240[(1)] = (19));

} else {
var statearr_14822_16241 = state_14798__$1;
(statearr_14822_16241[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (21))){
var inst_14748 = (state_14798[(12)]);
var inst_14748__$1 = (state_14798[(2)]);
var inst_14749 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14748__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_14750 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14748__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_14751 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14748__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_14798__$1 = (function (){var statearr_14823 = state_14798;
(statearr_14823[(13)] = inst_14750);

(statearr_14823[(10)] = inst_14749);

(statearr_14823[(12)] = inst_14748__$1);

return statearr_14823;
})();
return cljs.core.async.ioc_alts_BANG_(state_14798__$1,(22),inst_14751);
} else {
if((state_val_14799 === (31))){
var inst_14780 = (state_14798[(2)]);
var state_14798__$1 = state_14798;
if(cljs.core.truth_(inst_14780)){
var statearr_14824_16242 = state_14798__$1;
(statearr_14824_16242[(1)] = (32));

} else {
var statearr_14826_16243 = state_14798__$1;
(statearr_14826_16243[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (32))){
var inst_14757 = (state_14798[(14)]);
var state_14798__$1 = state_14798;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14798__$1,(35),out,inst_14757);
} else {
if((state_val_14799 === (33))){
var inst_14748 = (state_14798[(12)]);
var inst_14725 = inst_14748;
var state_14798__$1 = (function (){var statearr_14827 = state_14798;
(statearr_14827[(7)] = inst_14725);

return statearr_14827;
})();
var statearr_14828_16245 = state_14798__$1;
(statearr_14828_16245[(2)] = null);

(statearr_14828_16245[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (13))){
var inst_14725 = (state_14798[(7)]);
var inst_14732 = inst_14725.cljs$lang$protocol_mask$partition0$;
var inst_14733 = (inst_14732 & (64));
var inst_14734 = inst_14725.cljs$core$ISeq$;
var inst_14735 = (cljs.core.PROTOCOL_SENTINEL === inst_14734);
var inst_14736 = ((inst_14733) || (inst_14735));
var state_14798__$1 = state_14798;
if(cljs.core.truth_(inst_14736)){
var statearr_14833_16247 = state_14798__$1;
(statearr_14833_16247[(1)] = (16));

} else {
var statearr_14834_16248 = state_14798__$1;
(statearr_14834_16248[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (22))){
var inst_14758 = (state_14798[(11)]);
var inst_14757 = (state_14798[(14)]);
var inst_14756 = (state_14798[(2)]);
var inst_14757__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14756,(0),null);
var inst_14758__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14756,(1),null);
var inst_14759 = (inst_14757__$1 == null);
var inst_14760 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_14758__$1,change);
var inst_14761 = ((inst_14759) || (inst_14760));
var state_14798__$1 = (function (){var statearr_14835 = state_14798;
(statearr_14835[(11)] = inst_14758__$1);

(statearr_14835[(14)] = inst_14757__$1);

return statearr_14835;
})();
if(cljs.core.truth_(inst_14761)){
var statearr_14836_16250 = state_14798__$1;
(statearr_14836_16250[(1)] = (23));

} else {
var statearr_14837_16251 = state_14798__$1;
(statearr_14837_16251[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (36))){
var inst_14748 = (state_14798[(12)]);
var inst_14725 = inst_14748;
var state_14798__$1 = (function (){var statearr_14838 = state_14798;
(statearr_14838[(7)] = inst_14725);

return statearr_14838;
})();
var statearr_14839_16252 = state_14798__$1;
(statearr_14839_16252[(2)] = null);

(statearr_14839_16252[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (29))){
var inst_14772 = (state_14798[(9)]);
var state_14798__$1 = state_14798;
var statearr_14840_16254 = state_14798__$1;
(statearr_14840_16254[(2)] = inst_14772);

(statearr_14840_16254[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (6))){
var state_14798__$1 = state_14798;
var statearr_14841_16255 = state_14798__$1;
(statearr_14841_16255[(2)] = false);

(statearr_14841_16255[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (28))){
var inst_14768 = (state_14798[(2)]);
var inst_14769 = calc_state();
var inst_14725 = inst_14769;
var state_14798__$1 = (function (){var statearr_14842 = state_14798;
(statearr_14842[(7)] = inst_14725);

(statearr_14842[(15)] = inst_14768);

return statearr_14842;
})();
var statearr_14843_16256 = state_14798__$1;
(statearr_14843_16256[(2)] = null);

(statearr_14843_16256[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (25))){
var inst_14794 = (state_14798[(2)]);
var state_14798__$1 = state_14798;
var statearr_14844_16257 = state_14798__$1;
(statearr_14844_16257[(2)] = inst_14794);

(statearr_14844_16257[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (34))){
var inst_14792 = (state_14798[(2)]);
var state_14798__$1 = state_14798;
var statearr_14845_16258 = state_14798__$1;
(statearr_14845_16258[(2)] = inst_14792);

(statearr_14845_16258[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (17))){
var state_14798__$1 = state_14798;
var statearr_14846_16259 = state_14798__$1;
(statearr_14846_16259[(2)] = false);

(statearr_14846_16259[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (3))){
var state_14798__$1 = state_14798;
var statearr_14847_16260 = state_14798__$1;
(statearr_14847_16260[(2)] = false);

(statearr_14847_16260[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (12))){
var inst_14796 = (state_14798[(2)]);
var state_14798__$1 = state_14798;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14798__$1,inst_14796);
} else {
if((state_val_14799 === (2))){
var inst_14700 = (state_14798[(8)]);
var inst_14705 = inst_14700.cljs$lang$protocol_mask$partition0$;
var inst_14706 = (inst_14705 & (64));
var inst_14707 = inst_14700.cljs$core$ISeq$;
var inst_14708 = (cljs.core.PROTOCOL_SENTINEL === inst_14707);
var inst_14709 = ((inst_14706) || (inst_14708));
var state_14798__$1 = state_14798;
if(cljs.core.truth_(inst_14709)){
var statearr_14849_16261 = state_14798__$1;
(statearr_14849_16261[(1)] = (5));

} else {
var statearr_14850_16262 = state_14798__$1;
(statearr_14850_16262[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (23))){
var inst_14757 = (state_14798[(14)]);
var inst_14763 = (inst_14757 == null);
var state_14798__$1 = state_14798;
if(cljs.core.truth_(inst_14763)){
var statearr_14851_16263 = state_14798__$1;
(statearr_14851_16263[(1)] = (26));

} else {
var statearr_14852_16264 = state_14798__$1;
(statearr_14852_16264[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (35))){
var inst_14783 = (state_14798[(2)]);
var state_14798__$1 = state_14798;
if(cljs.core.truth_(inst_14783)){
var statearr_14853_16265 = state_14798__$1;
(statearr_14853_16265[(1)] = (36));

} else {
var statearr_14854_16266 = state_14798__$1;
(statearr_14854_16266[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (19))){
var inst_14725 = (state_14798[(7)]);
var inst_14745 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_14725);
var state_14798__$1 = state_14798;
var statearr_14855_16267 = state_14798__$1;
(statearr_14855_16267[(2)] = inst_14745);

(statearr_14855_16267[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (11))){
var inst_14725 = (state_14798[(7)]);
var inst_14729 = (inst_14725 == null);
var inst_14730 = cljs.core.not(inst_14729);
var state_14798__$1 = state_14798;
if(inst_14730){
var statearr_14856_16269 = state_14798__$1;
(statearr_14856_16269[(1)] = (13));

} else {
var statearr_14857_16270 = state_14798__$1;
(statearr_14857_16270[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (9))){
var inst_14700 = (state_14798[(8)]);
var state_14798__$1 = state_14798;
var statearr_14858_16271 = state_14798__$1;
(statearr_14858_16271[(2)] = inst_14700);

(statearr_14858_16271[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (5))){
var state_14798__$1 = state_14798;
var statearr_14859_16272 = state_14798__$1;
(statearr_14859_16272[(2)] = true);

(statearr_14859_16272[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (14))){
var state_14798__$1 = state_14798;
var statearr_14860_16273 = state_14798__$1;
(statearr_14860_16273[(2)] = false);

(statearr_14860_16273[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (26))){
var inst_14758 = (state_14798[(11)]);
var inst_14765 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_14758);
var state_14798__$1 = state_14798;
var statearr_14861_16274 = state_14798__$1;
(statearr_14861_16274[(2)] = inst_14765);

(statearr_14861_16274[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (16))){
var state_14798__$1 = state_14798;
var statearr_14865_16275 = state_14798__$1;
(statearr_14865_16275[(2)] = true);

(statearr_14865_16275[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (38))){
var inst_14788 = (state_14798[(2)]);
var state_14798__$1 = state_14798;
var statearr_14868_16276 = state_14798__$1;
(statearr_14868_16276[(2)] = inst_14788);

(statearr_14868_16276[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (30))){
var inst_14750 = (state_14798[(13)]);
var inst_14749 = (state_14798[(10)]);
var inst_14758 = (state_14798[(11)]);
var inst_14775 = cljs.core.empty_QMARK_(inst_14749);
var inst_14776 = (inst_14750.cljs$core$IFn$_invoke$arity$1 ? inst_14750.cljs$core$IFn$_invoke$arity$1(inst_14758) : inst_14750.call(null,inst_14758));
var inst_14777 = cljs.core.not(inst_14776);
var inst_14778 = ((inst_14775) && (inst_14777));
var state_14798__$1 = state_14798;
var statearr_14875_16277 = state_14798__$1;
(statearr_14875_16277[(2)] = inst_14778);

(statearr_14875_16277[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (10))){
var inst_14700 = (state_14798[(8)]);
var inst_14721 = (state_14798[(2)]);
var inst_14722 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14721,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_14723 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14721,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_14724 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14721,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_14725 = inst_14700;
var state_14798__$1 = (function (){var statearr_14880 = state_14798;
(statearr_14880[(7)] = inst_14725);

(statearr_14880[(16)] = inst_14724);

(statearr_14880[(17)] = inst_14722);

(statearr_14880[(18)] = inst_14723);

return statearr_14880;
})();
var statearr_14883_16278 = state_14798__$1;
(statearr_14883_16278[(2)] = null);

(statearr_14883_16278[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (18))){
var inst_14740 = (state_14798[(2)]);
var state_14798__$1 = state_14798;
var statearr_14888_16279 = state_14798__$1;
(statearr_14888_16279[(2)] = inst_14740);

(statearr_14888_16279[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (37))){
var state_14798__$1 = state_14798;
var statearr_14891_16280 = state_14798__$1;
(statearr_14891_16280[(2)] = null);

(statearr_14891_16280[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (8))){
var inst_14700 = (state_14798[(8)]);
var inst_14718 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_14700);
var state_14798__$1 = state_14798;
var statearr_14894_16281 = state_14798__$1;
(statearr_14894_16281[(2)] = inst_14718);

(statearr_14894_16281[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__13557__auto__ = null;
var cljs$core$async$mix_$_state_machine__13557__auto____0 = (function (){
var statearr_14901 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14901[(0)] = cljs$core$async$mix_$_state_machine__13557__auto__);

(statearr_14901[(1)] = (1));

return statearr_14901;
});
var cljs$core$async$mix_$_state_machine__13557__auto____1 = (function (state_14798){
while(true){
var ret_value__13558__auto__ = (function (){try{while(true){
var result__13559__auto__ = switch__13556__auto__(state_14798);
if(cljs.core.keyword_identical_QMARK_(result__13559__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13559__auto__;
}
break;
}
}catch (e14902){if((e14902 instanceof Object)){
var ex__13560__auto__ = e14902;
var statearr_14903_16283 = state_14798;
(statearr_14903_16283[(5)] = ex__13560__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_14798);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14902;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13558__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16284 = state_14798;
state_14798 = G__16284;
continue;
} else {
return ret_value__13558__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__13557__auto__ = function(state_14798){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__13557__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__13557__auto____1.call(this,state_14798);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__13557__auto____0;
cljs$core$async$mix_$_state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__13557__auto____1;
return cljs$core$async$mix_$_state_machine__13557__auto__;
})()
})();
var state__13677__auto__ = (function (){var statearr_14904 = (f__13676__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13676__auto__.cljs$core$IFn$_invoke$arity$0() : f__13676__auto__.call(null));
(statearr_14904[(6)] = c__13675__auto___16230);

return statearr_14904;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13677__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4487__auto__ = (((p == null))?null:p);
var m__4488__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4488__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4485__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4485__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4487__auto__ = (((p == null))?null:p);
var m__4488__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4488__auto__.call(null,p,v,ch));
} else {
var m__4485__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4485__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__14909 = arguments.length;
switch (G__14909) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4487__auto__ = (((p == null))?null:p);
var m__4488__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4488__auto__.call(null,p));
} else {
var m__4485__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4485__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4487__auto__ = (((p == null))?null:p);
var m__4488__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4488__auto__.call(null,p,v));
} else {
var m__4485__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4485__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__14918 = arguments.length;
switch (G__14918) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__14915_SHARP_){
if(cljs.core.truth_((p1__14915_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__14915_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__14915_SHARP_.call(null,topic)))){
return p1__14915_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__14915_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async14923 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14923 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta14924){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta14924 = meta14924;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async14923.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14925,meta14924__$1){
var self__ = this;
var _14925__$1 = this;
return (new cljs.core.async.t_cljs$core$async14923(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta14924__$1));
}));

(cljs.core.async.t_cljs$core$async14923.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14925){
var self__ = this;
var _14925__$1 = this;
return self__.meta14924;
}));

(cljs.core.async.t_cljs$core$async14923.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14923.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async14923.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14923.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async14923.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async14923.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async14923.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async14923.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta14924","meta14924",-1115644942,null)], null);
}));

(cljs.core.async.t_cljs$core$async14923.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async14923.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14923");

(cljs.core.async.t_cljs$core$async14923.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async14923");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async14923.
 */
cljs.core.async.__GT_t_cljs$core$async14923 = (function cljs$core$async$__GT_t_cljs$core$async14923(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta14924){
return (new cljs.core.async.t_cljs$core$async14923(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta14924));
});

}

return (new cljs.core.async.t_cljs$core$async14923(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__13675__auto___16287 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13676__auto__ = (function (){var switch__13556__auto__ = (function (state_15009){
var state_val_15010 = (state_15009[(1)]);
if((state_val_15010 === (7))){
var inst_15005 = (state_15009[(2)]);
var state_15009__$1 = state_15009;
var statearr_15011_16288 = state_15009__$1;
(statearr_15011_16288[(2)] = inst_15005);

(statearr_15011_16288[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15010 === (20))){
var state_15009__$1 = state_15009;
var statearr_15012_16289 = state_15009__$1;
(statearr_15012_16289[(2)] = null);

(statearr_15012_16289[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15010 === (1))){
var state_15009__$1 = state_15009;
var statearr_15013_16290 = state_15009__$1;
(statearr_15013_16290[(2)] = null);

(statearr_15013_16290[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15010 === (24))){
var inst_14988 = (state_15009[(7)]);
var inst_14997 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_14988);
var state_15009__$1 = state_15009;
var statearr_15014_16291 = state_15009__$1;
(statearr_15014_16291[(2)] = inst_14997);

(statearr_15014_16291[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15010 === (4))){
var inst_14929 = (state_15009[(8)]);
var inst_14929__$1 = (state_15009[(2)]);
var inst_14933 = (inst_14929__$1 == null);
var state_15009__$1 = (function (){var statearr_15015 = state_15009;
(statearr_15015[(8)] = inst_14929__$1);

return statearr_15015;
})();
if(cljs.core.truth_(inst_14933)){
var statearr_15016_16292 = state_15009__$1;
(statearr_15016_16292[(1)] = (5));

} else {
var statearr_15017_16293 = state_15009__$1;
(statearr_15017_16293[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15010 === (15))){
var inst_14982 = (state_15009[(2)]);
var state_15009__$1 = state_15009;
var statearr_15019_16294 = state_15009__$1;
(statearr_15019_16294[(2)] = inst_14982);

(statearr_15019_16294[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15010 === (21))){
var inst_15002 = (state_15009[(2)]);
var state_15009__$1 = (function (){var statearr_15020 = state_15009;
(statearr_15020[(9)] = inst_15002);

return statearr_15020;
})();
var statearr_15021_16295 = state_15009__$1;
(statearr_15021_16295[(2)] = null);

(statearr_15021_16295[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15010 === (13))){
var inst_14960 = (state_15009[(10)]);
var inst_14964 = cljs.core.chunked_seq_QMARK_(inst_14960);
var state_15009__$1 = state_15009;
if(inst_14964){
var statearr_15022_16296 = state_15009__$1;
(statearr_15022_16296[(1)] = (16));

} else {
var statearr_15023_16297 = state_15009__$1;
(statearr_15023_16297[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15010 === (22))){
var inst_14994 = (state_15009[(2)]);
var state_15009__$1 = state_15009;
if(cljs.core.truth_(inst_14994)){
var statearr_15024_16298 = state_15009__$1;
(statearr_15024_16298[(1)] = (23));

} else {
var statearr_15025_16299 = state_15009__$1;
(statearr_15025_16299[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15010 === (6))){
var inst_14990 = (state_15009[(11)]);
var inst_14988 = (state_15009[(7)]);
var inst_14929 = (state_15009[(8)]);
var inst_14988__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_14929) : topic_fn.call(null,inst_14929));
var inst_14989 = cljs.core.deref(mults);
var inst_14990__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14989,inst_14988__$1);
var state_15009__$1 = (function (){var statearr_15026 = state_15009;
(statearr_15026[(11)] = inst_14990__$1);

(statearr_15026[(7)] = inst_14988__$1);

return statearr_15026;
})();
if(cljs.core.truth_(inst_14990__$1)){
var statearr_15027_16300 = state_15009__$1;
(statearr_15027_16300[(1)] = (19));

} else {
var statearr_15028_16301 = state_15009__$1;
(statearr_15028_16301[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15010 === (25))){
var inst_14999 = (state_15009[(2)]);
var state_15009__$1 = state_15009;
var statearr_15029_16302 = state_15009__$1;
(statearr_15029_16302[(2)] = inst_14999);

(statearr_15029_16302[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15010 === (17))){
var inst_14960 = (state_15009[(10)]);
var inst_14973 = cljs.core.first(inst_14960);
var inst_14974 = cljs.core.async.muxch_STAR_(inst_14973);
var inst_14975 = cljs.core.async.close_BANG_(inst_14974);
var inst_14976 = cljs.core.next(inst_14960);
var inst_14942 = inst_14976;
var inst_14943 = null;
var inst_14944 = (0);
var inst_14945 = (0);
var state_15009__$1 = (function (){var statearr_15030 = state_15009;
(statearr_15030[(12)] = inst_14943);

(statearr_15030[(13)] = inst_14945);

(statearr_15030[(14)] = inst_14944);

(statearr_15030[(15)] = inst_14942);

(statearr_15030[(16)] = inst_14975);

return statearr_15030;
})();
var statearr_15032_16303 = state_15009__$1;
(statearr_15032_16303[(2)] = null);

(statearr_15032_16303[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15010 === (3))){
var inst_15007 = (state_15009[(2)]);
var state_15009__$1 = state_15009;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15009__$1,inst_15007);
} else {
if((state_val_15010 === (12))){
var inst_14984 = (state_15009[(2)]);
var state_15009__$1 = state_15009;
var statearr_15033_16306 = state_15009__$1;
(statearr_15033_16306[(2)] = inst_14984);

(statearr_15033_16306[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15010 === (2))){
var state_15009__$1 = state_15009;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15009__$1,(4),ch);
} else {
if((state_val_15010 === (23))){
var state_15009__$1 = state_15009;
var statearr_15035_16310 = state_15009__$1;
(statearr_15035_16310[(2)] = null);

(statearr_15035_16310[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15010 === (19))){
var inst_14990 = (state_15009[(11)]);
var inst_14929 = (state_15009[(8)]);
var inst_14992 = cljs.core.async.muxch_STAR_(inst_14990);
var state_15009__$1 = state_15009;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15009__$1,(22),inst_14992,inst_14929);
} else {
if((state_val_15010 === (11))){
var inst_14942 = (state_15009[(15)]);
var inst_14960 = (state_15009[(10)]);
var inst_14960__$1 = cljs.core.seq(inst_14942);
var state_15009__$1 = (function (){var statearr_15036 = state_15009;
(statearr_15036[(10)] = inst_14960__$1);

return statearr_15036;
})();
if(inst_14960__$1){
var statearr_15037_16312 = state_15009__$1;
(statearr_15037_16312[(1)] = (13));

} else {
var statearr_15038_16313 = state_15009__$1;
(statearr_15038_16313[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15010 === (9))){
var inst_14986 = (state_15009[(2)]);
var state_15009__$1 = state_15009;
var statearr_15040_16317 = state_15009__$1;
(statearr_15040_16317[(2)] = inst_14986);

(statearr_15040_16317[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15010 === (5))){
var inst_14939 = cljs.core.deref(mults);
var inst_14940 = cljs.core.vals(inst_14939);
var inst_14941 = cljs.core.seq(inst_14940);
var inst_14942 = inst_14941;
var inst_14943 = null;
var inst_14944 = (0);
var inst_14945 = (0);
var state_15009__$1 = (function (){var statearr_15041 = state_15009;
(statearr_15041[(12)] = inst_14943);

(statearr_15041[(13)] = inst_14945);

(statearr_15041[(14)] = inst_14944);

(statearr_15041[(15)] = inst_14942);

return statearr_15041;
})();
var statearr_15042_16322 = state_15009__$1;
(statearr_15042_16322[(2)] = null);

(statearr_15042_16322[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15010 === (14))){
var state_15009__$1 = state_15009;
var statearr_15047_16330 = state_15009__$1;
(statearr_15047_16330[(2)] = null);

(statearr_15047_16330[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15010 === (16))){
var inst_14960 = (state_15009[(10)]);
var inst_14966 = cljs.core.chunk_first(inst_14960);
var inst_14967 = cljs.core.chunk_rest(inst_14960);
var inst_14968 = cljs.core.count(inst_14966);
var inst_14942 = inst_14967;
var inst_14943 = inst_14966;
var inst_14944 = inst_14968;
var inst_14945 = (0);
var state_15009__$1 = (function (){var statearr_15048 = state_15009;
(statearr_15048[(12)] = inst_14943);

(statearr_15048[(13)] = inst_14945);

(statearr_15048[(14)] = inst_14944);

(statearr_15048[(15)] = inst_14942);

return statearr_15048;
})();
var statearr_15050_16345 = state_15009__$1;
(statearr_15050_16345[(2)] = null);

(statearr_15050_16345[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15010 === (10))){
var inst_14943 = (state_15009[(12)]);
var inst_14945 = (state_15009[(13)]);
var inst_14944 = (state_15009[(14)]);
var inst_14942 = (state_15009[(15)]);
var inst_14952 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_14943,inst_14945);
var inst_14954 = cljs.core.async.muxch_STAR_(inst_14952);
var inst_14956 = cljs.core.async.close_BANG_(inst_14954);
var inst_14957 = (inst_14945 + (1));
var tmp15044 = inst_14943;
var tmp15045 = inst_14944;
var tmp15046 = inst_14942;
var inst_14942__$1 = tmp15046;
var inst_14943__$1 = tmp15044;
var inst_14944__$1 = tmp15045;
var inst_14945__$1 = inst_14957;
var state_15009__$1 = (function (){var statearr_15051 = state_15009;
(statearr_15051[(12)] = inst_14943__$1);

(statearr_15051[(13)] = inst_14945__$1);

(statearr_15051[(14)] = inst_14944__$1);

(statearr_15051[(15)] = inst_14942__$1);

(statearr_15051[(17)] = inst_14956);

return statearr_15051;
})();
var statearr_15053_16347 = state_15009__$1;
(statearr_15053_16347[(2)] = null);

(statearr_15053_16347[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15010 === (18))){
var inst_14979 = (state_15009[(2)]);
var state_15009__$1 = state_15009;
var statearr_15054_16352 = state_15009__$1;
(statearr_15054_16352[(2)] = inst_14979);

(statearr_15054_16352[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15010 === (8))){
var inst_14945 = (state_15009[(13)]);
var inst_14944 = (state_15009[(14)]);
var inst_14949 = (inst_14945 < inst_14944);
var inst_14950 = inst_14949;
var state_15009__$1 = state_15009;
if(cljs.core.truth_(inst_14950)){
var statearr_15055_16357 = state_15009__$1;
(statearr_15055_16357[(1)] = (10));

} else {
var statearr_15056_16359 = state_15009__$1;
(statearr_15056_16359[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__13557__auto__ = null;
var cljs$core$async$state_machine__13557__auto____0 = (function (){
var statearr_15057 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15057[(0)] = cljs$core$async$state_machine__13557__auto__);

(statearr_15057[(1)] = (1));

return statearr_15057;
});
var cljs$core$async$state_machine__13557__auto____1 = (function (state_15009){
while(true){
var ret_value__13558__auto__ = (function (){try{while(true){
var result__13559__auto__ = switch__13556__auto__(state_15009);
if(cljs.core.keyword_identical_QMARK_(result__13559__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13559__auto__;
}
break;
}
}catch (e15058){if((e15058 instanceof Object)){
var ex__13560__auto__ = e15058;
var statearr_15059_16364 = state_15009;
(statearr_15059_16364[(5)] = ex__13560__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15009);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15058;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13558__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16366 = state_15009;
state_15009 = G__16366;
continue;
} else {
return ret_value__13558__auto__;
}
break;
}
});
cljs$core$async$state_machine__13557__auto__ = function(state_15009){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13557__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13557__auto____1.call(this,state_15009);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13557__auto____0;
cljs$core$async$state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13557__auto____1;
return cljs$core$async$state_machine__13557__auto__;
})()
})();
var state__13677__auto__ = (function (){var statearr_15061 = (f__13676__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13676__auto__.cljs$core$IFn$_invoke$arity$0() : f__13676__auto__.call(null));
(statearr_15061[(6)] = c__13675__auto___16287);

return statearr_15061;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13677__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__15067 = arguments.length;
switch (G__15067) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__15073 = arguments.length;
switch (G__15073) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__15075 = arguments.length;
switch (G__15075) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__13675__auto___16390 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13676__auto__ = (function (){var switch__13556__auto__ = (function (state_15122){
var state_val_15123 = (state_15122[(1)]);
if((state_val_15123 === (7))){
var state_15122__$1 = state_15122;
var statearr_15124_16391 = state_15122__$1;
(statearr_15124_16391[(2)] = null);

(statearr_15124_16391[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15123 === (1))){
var state_15122__$1 = state_15122;
var statearr_15125_16392 = state_15122__$1;
(statearr_15125_16392[(2)] = null);

(statearr_15125_16392[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15123 === (4))){
var inst_15086 = (state_15122[(7)]);
var inst_15088 = (inst_15086 < cnt);
var state_15122__$1 = state_15122;
if(cljs.core.truth_(inst_15088)){
var statearr_15126_16393 = state_15122__$1;
(statearr_15126_16393[(1)] = (6));

} else {
var statearr_15127_16394 = state_15122__$1;
(statearr_15127_16394[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15123 === (15))){
var inst_15118 = (state_15122[(2)]);
var state_15122__$1 = state_15122;
var statearr_15128_16395 = state_15122__$1;
(statearr_15128_16395[(2)] = inst_15118);

(statearr_15128_16395[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15123 === (13))){
var inst_15111 = cljs.core.async.close_BANG_(out);
var state_15122__$1 = state_15122;
var statearr_15129_16396 = state_15122__$1;
(statearr_15129_16396[(2)] = inst_15111);

(statearr_15129_16396[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15123 === (6))){
var state_15122__$1 = state_15122;
var statearr_15130_16397 = state_15122__$1;
(statearr_15130_16397[(2)] = null);

(statearr_15130_16397[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15123 === (3))){
var inst_15120 = (state_15122[(2)]);
var state_15122__$1 = state_15122;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15122__$1,inst_15120);
} else {
if((state_val_15123 === (12))){
var inst_15108 = (state_15122[(8)]);
var inst_15108__$1 = (state_15122[(2)]);
var inst_15109 = cljs.core.some(cljs.core.nil_QMARK_,inst_15108__$1);
var state_15122__$1 = (function (){var statearr_15135 = state_15122;
(statearr_15135[(8)] = inst_15108__$1);

return statearr_15135;
})();
if(cljs.core.truth_(inst_15109)){
var statearr_15136_16402 = state_15122__$1;
(statearr_15136_16402[(1)] = (13));

} else {
var statearr_15137_16403 = state_15122__$1;
(statearr_15137_16403[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15123 === (2))){
var inst_15082 = cljs.core.reset_BANG_(dctr,cnt);
var inst_15086 = (0);
var state_15122__$1 = (function (){var statearr_15138 = state_15122;
(statearr_15138[(9)] = inst_15082);

(statearr_15138[(7)] = inst_15086);

return statearr_15138;
})();
var statearr_15139_16406 = state_15122__$1;
(statearr_15139_16406[(2)] = null);

(statearr_15139_16406[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15123 === (11))){
var inst_15086 = (state_15122[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_15122,(10),Object,null,(9));
var inst_15095 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_15086) : chs__$1.call(null,inst_15086));
var inst_15096 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_15086) : done.call(null,inst_15086));
var inst_15097 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_15095,inst_15096);
var state_15122__$1 = state_15122;
var statearr_15140_16409 = state_15122__$1;
(statearr_15140_16409[(2)] = inst_15097);


cljs.core.async.impl.ioc_helpers.process_exception(state_15122__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15123 === (9))){
var inst_15086 = (state_15122[(7)]);
var inst_15099 = (state_15122[(2)]);
var inst_15100 = (inst_15086 + (1));
var inst_15086__$1 = inst_15100;
var state_15122__$1 = (function (){var statearr_15141 = state_15122;
(statearr_15141[(10)] = inst_15099);

(statearr_15141[(7)] = inst_15086__$1);

return statearr_15141;
})();
var statearr_15142_16411 = state_15122__$1;
(statearr_15142_16411[(2)] = null);

(statearr_15142_16411[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15123 === (5))){
var inst_15106 = (state_15122[(2)]);
var state_15122__$1 = (function (){var statearr_15143 = state_15122;
(statearr_15143[(11)] = inst_15106);

return statearr_15143;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15122__$1,(12),dchan);
} else {
if((state_val_15123 === (14))){
var inst_15108 = (state_15122[(8)]);
var inst_15113 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_15108);
var state_15122__$1 = state_15122;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15122__$1,(16),out,inst_15113);
} else {
if((state_val_15123 === (16))){
var inst_15115 = (state_15122[(2)]);
var state_15122__$1 = (function (){var statearr_15144 = state_15122;
(statearr_15144[(12)] = inst_15115);

return statearr_15144;
})();
var statearr_15145_16420 = state_15122__$1;
(statearr_15145_16420[(2)] = null);

(statearr_15145_16420[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15123 === (10))){
var inst_15090 = (state_15122[(2)]);
var inst_15091 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_15122__$1 = (function (){var statearr_15146 = state_15122;
(statearr_15146[(13)] = inst_15090);

return statearr_15146;
})();
var statearr_15147_16421 = state_15122__$1;
(statearr_15147_16421[(2)] = inst_15091);


cljs.core.async.impl.ioc_helpers.process_exception(state_15122__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15123 === (8))){
var inst_15104 = (state_15122[(2)]);
var state_15122__$1 = state_15122;
var statearr_15149_16422 = state_15122__$1;
(statearr_15149_16422[(2)] = inst_15104);

(statearr_15149_16422[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__13557__auto__ = null;
var cljs$core$async$state_machine__13557__auto____0 = (function (){
var statearr_15157 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15157[(0)] = cljs$core$async$state_machine__13557__auto__);

(statearr_15157[(1)] = (1));

return statearr_15157;
});
var cljs$core$async$state_machine__13557__auto____1 = (function (state_15122){
while(true){
var ret_value__13558__auto__ = (function (){try{while(true){
var result__13559__auto__ = switch__13556__auto__(state_15122);
if(cljs.core.keyword_identical_QMARK_(result__13559__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13559__auto__;
}
break;
}
}catch (e15158){if((e15158 instanceof Object)){
var ex__13560__auto__ = e15158;
var statearr_15159_16423 = state_15122;
(statearr_15159_16423[(5)] = ex__13560__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15122);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15158;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13558__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16424 = state_15122;
state_15122 = G__16424;
continue;
} else {
return ret_value__13558__auto__;
}
break;
}
});
cljs$core$async$state_machine__13557__auto__ = function(state_15122){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13557__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13557__auto____1.call(this,state_15122);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13557__auto____0;
cljs$core$async$state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13557__auto____1;
return cljs$core$async$state_machine__13557__auto__;
})()
})();
var state__13677__auto__ = (function (){var statearr_15160 = (f__13676__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13676__auto__.cljs$core$IFn$_invoke$arity$0() : f__13676__auto__.call(null));
(statearr_15160[(6)] = c__13675__auto___16390);

return statearr_15160;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13677__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__15164 = arguments.length;
switch (G__15164) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__13675__auto___16433 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13676__auto__ = (function (){var switch__13556__auto__ = (function (state_15200){
var state_val_15201 = (state_15200[(1)]);
if((state_val_15201 === (7))){
var inst_15176 = (state_15200[(7)]);
var inst_15177 = (state_15200[(8)]);
var inst_15176__$1 = (state_15200[(2)]);
var inst_15177__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15176__$1,(0),null);
var inst_15178 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15176__$1,(1),null);
var inst_15179 = (inst_15177__$1 == null);
var state_15200__$1 = (function (){var statearr_15202 = state_15200;
(statearr_15202[(7)] = inst_15176__$1);

(statearr_15202[(9)] = inst_15178);

(statearr_15202[(8)] = inst_15177__$1);

return statearr_15202;
})();
if(cljs.core.truth_(inst_15179)){
var statearr_15203_16435 = state_15200__$1;
(statearr_15203_16435[(1)] = (8));

} else {
var statearr_15204_16437 = state_15200__$1;
(statearr_15204_16437[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15201 === (1))){
var inst_15166 = cljs.core.vec(chs);
var inst_15167 = inst_15166;
var state_15200__$1 = (function (){var statearr_15205 = state_15200;
(statearr_15205[(10)] = inst_15167);

return statearr_15205;
})();
var statearr_15206_16440 = state_15200__$1;
(statearr_15206_16440[(2)] = null);

(statearr_15206_16440[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15201 === (4))){
var inst_15167 = (state_15200[(10)]);
var state_15200__$1 = state_15200;
return cljs.core.async.ioc_alts_BANG_(state_15200__$1,(7),inst_15167);
} else {
if((state_val_15201 === (6))){
var inst_15193 = (state_15200[(2)]);
var state_15200__$1 = state_15200;
var statearr_15207_16442 = state_15200__$1;
(statearr_15207_16442[(2)] = inst_15193);

(statearr_15207_16442[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15201 === (3))){
var inst_15195 = (state_15200[(2)]);
var state_15200__$1 = state_15200;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15200__$1,inst_15195);
} else {
if((state_val_15201 === (2))){
var inst_15167 = (state_15200[(10)]);
var inst_15169 = cljs.core.count(inst_15167);
var inst_15170 = (inst_15169 > (0));
var state_15200__$1 = state_15200;
if(cljs.core.truth_(inst_15170)){
var statearr_15210_16443 = state_15200__$1;
(statearr_15210_16443[(1)] = (4));

} else {
var statearr_15212_16444 = state_15200__$1;
(statearr_15212_16444[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15201 === (11))){
var inst_15167 = (state_15200[(10)]);
var inst_15186 = (state_15200[(2)]);
var tmp15208 = inst_15167;
var inst_15167__$1 = tmp15208;
var state_15200__$1 = (function (){var statearr_15217 = state_15200;
(statearr_15217[(10)] = inst_15167__$1);

(statearr_15217[(11)] = inst_15186);

return statearr_15217;
})();
var statearr_15218_16445 = state_15200__$1;
(statearr_15218_16445[(2)] = null);

(statearr_15218_16445[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15201 === (9))){
var inst_15177 = (state_15200[(8)]);
var state_15200__$1 = state_15200;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15200__$1,(11),out,inst_15177);
} else {
if((state_val_15201 === (5))){
var inst_15191 = cljs.core.async.close_BANG_(out);
var state_15200__$1 = state_15200;
var statearr_15221_16446 = state_15200__$1;
(statearr_15221_16446[(2)] = inst_15191);

(statearr_15221_16446[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15201 === (10))){
var inst_15189 = (state_15200[(2)]);
var state_15200__$1 = state_15200;
var statearr_15226_16447 = state_15200__$1;
(statearr_15226_16447[(2)] = inst_15189);

(statearr_15226_16447[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15201 === (8))){
var inst_15176 = (state_15200[(7)]);
var inst_15167 = (state_15200[(10)]);
var inst_15178 = (state_15200[(9)]);
var inst_15177 = (state_15200[(8)]);
var inst_15181 = (function (){var cs = inst_15167;
var vec__15172 = inst_15176;
var v = inst_15177;
var c = inst_15178;
return (function (p1__15161_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__15161_SHARP_);
});
})();
var inst_15182 = cljs.core.filterv(inst_15181,inst_15167);
var inst_15167__$1 = inst_15182;
var state_15200__$1 = (function (){var statearr_15231 = state_15200;
(statearr_15231[(10)] = inst_15167__$1);

return statearr_15231;
})();
var statearr_15232_16448 = state_15200__$1;
(statearr_15232_16448[(2)] = null);

(statearr_15232_16448[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__13557__auto__ = null;
var cljs$core$async$state_machine__13557__auto____0 = (function (){
var statearr_15233 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15233[(0)] = cljs$core$async$state_machine__13557__auto__);

(statearr_15233[(1)] = (1));

return statearr_15233;
});
var cljs$core$async$state_machine__13557__auto____1 = (function (state_15200){
while(true){
var ret_value__13558__auto__ = (function (){try{while(true){
var result__13559__auto__ = switch__13556__auto__(state_15200);
if(cljs.core.keyword_identical_QMARK_(result__13559__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13559__auto__;
}
break;
}
}catch (e15236){if((e15236 instanceof Object)){
var ex__13560__auto__ = e15236;
var statearr_15237_16449 = state_15200;
(statearr_15237_16449[(5)] = ex__13560__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15200);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15236;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13558__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16450 = state_15200;
state_15200 = G__16450;
continue;
} else {
return ret_value__13558__auto__;
}
break;
}
});
cljs$core$async$state_machine__13557__auto__ = function(state_15200){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13557__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13557__auto____1.call(this,state_15200);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13557__auto____0;
cljs$core$async$state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13557__auto____1;
return cljs$core$async$state_machine__13557__auto__;
})()
})();
var state__13677__auto__ = (function (){var statearr_15238 = (f__13676__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13676__auto__.cljs$core$IFn$_invoke$arity$0() : f__13676__auto__.call(null));
(statearr_15238[(6)] = c__13675__auto___16433);

return statearr_15238;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13677__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__15242 = arguments.length;
switch (G__15242) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__13675__auto___16452 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13676__auto__ = (function (){var switch__13556__auto__ = (function (state_15266){
var state_val_15267 = (state_15266[(1)]);
if((state_val_15267 === (7))){
var inst_15248 = (state_15266[(7)]);
var inst_15248__$1 = (state_15266[(2)]);
var inst_15249 = (inst_15248__$1 == null);
var inst_15250 = cljs.core.not(inst_15249);
var state_15266__$1 = (function (){var statearr_15270 = state_15266;
(statearr_15270[(7)] = inst_15248__$1);

return statearr_15270;
})();
if(inst_15250){
var statearr_15271_16453 = state_15266__$1;
(statearr_15271_16453[(1)] = (8));

} else {
var statearr_15272_16454 = state_15266__$1;
(statearr_15272_16454[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15267 === (1))){
var inst_15243 = (0);
var state_15266__$1 = (function (){var statearr_15273 = state_15266;
(statearr_15273[(8)] = inst_15243);

return statearr_15273;
})();
var statearr_15274_16455 = state_15266__$1;
(statearr_15274_16455[(2)] = null);

(statearr_15274_16455[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15267 === (4))){
var state_15266__$1 = state_15266;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15266__$1,(7),ch);
} else {
if((state_val_15267 === (6))){
var inst_15261 = (state_15266[(2)]);
var state_15266__$1 = state_15266;
var statearr_15275_16456 = state_15266__$1;
(statearr_15275_16456[(2)] = inst_15261);

(statearr_15275_16456[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15267 === (3))){
var inst_15263 = (state_15266[(2)]);
var inst_15264 = cljs.core.async.close_BANG_(out);
var state_15266__$1 = (function (){var statearr_15278 = state_15266;
(statearr_15278[(9)] = inst_15263);

return statearr_15278;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_15266__$1,inst_15264);
} else {
if((state_val_15267 === (2))){
var inst_15243 = (state_15266[(8)]);
var inst_15245 = (inst_15243 < n);
var state_15266__$1 = state_15266;
if(cljs.core.truth_(inst_15245)){
var statearr_15279_16457 = state_15266__$1;
(statearr_15279_16457[(1)] = (4));

} else {
var statearr_15280_16458 = state_15266__$1;
(statearr_15280_16458[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15267 === (11))){
var inst_15243 = (state_15266[(8)]);
var inst_15253 = (state_15266[(2)]);
var inst_15254 = (inst_15243 + (1));
var inst_15243__$1 = inst_15254;
var state_15266__$1 = (function (){var statearr_15281 = state_15266;
(statearr_15281[(10)] = inst_15253);

(statearr_15281[(8)] = inst_15243__$1);

return statearr_15281;
})();
var statearr_15282_16459 = state_15266__$1;
(statearr_15282_16459[(2)] = null);

(statearr_15282_16459[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15267 === (9))){
var state_15266__$1 = state_15266;
var statearr_15283_16460 = state_15266__$1;
(statearr_15283_16460[(2)] = null);

(statearr_15283_16460[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15267 === (5))){
var state_15266__$1 = state_15266;
var statearr_15284_16462 = state_15266__$1;
(statearr_15284_16462[(2)] = null);

(statearr_15284_16462[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15267 === (10))){
var inst_15258 = (state_15266[(2)]);
var state_15266__$1 = state_15266;
var statearr_15285_16464 = state_15266__$1;
(statearr_15285_16464[(2)] = inst_15258);

(statearr_15285_16464[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15267 === (8))){
var inst_15248 = (state_15266[(7)]);
var state_15266__$1 = state_15266;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15266__$1,(11),out,inst_15248);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__13557__auto__ = null;
var cljs$core$async$state_machine__13557__auto____0 = (function (){
var statearr_15286 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_15286[(0)] = cljs$core$async$state_machine__13557__auto__);

(statearr_15286[(1)] = (1));

return statearr_15286;
});
var cljs$core$async$state_machine__13557__auto____1 = (function (state_15266){
while(true){
var ret_value__13558__auto__ = (function (){try{while(true){
var result__13559__auto__ = switch__13556__auto__(state_15266);
if(cljs.core.keyword_identical_QMARK_(result__13559__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13559__auto__;
}
break;
}
}catch (e15287){if((e15287 instanceof Object)){
var ex__13560__auto__ = e15287;
var statearr_15288_16469 = state_15266;
(statearr_15288_16469[(5)] = ex__13560__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15266);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15287;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13558__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16471 = state_15266;
state_15266 = G__16471;
continue;
} else {
return ret_value__13558__auto__;
}
break;
}
});
cljs$core$async$state_machine__13557__auto__ = function(state_15266){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13557__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13557__auto____1.call(this,state_15266);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13557__auto____0;
cljs$core$async$state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13557__auto____1;
return cljs$core$async$state_machine__13557__auto__;
})()
})();
var state__13677__auto__ = (function (){var statearr_15289 = (f__13676__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13676__auto__.cljs$core$IFn$_invoke$arity$0() : f__13676__auto__.call(null));
(statearr_15289[(6)] = c__13675__auto___16452);

return statearr_15289;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13677__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async15291 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15291 = (function (f,ch,meta15292){
this.f = f;
this.ch = ch;
this.meta15292 = meta15292;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async15291.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15293,meta15292__$1){
var self__ = this;
var _15293__$1 = this;
return (new cljs.core.async.t_cljs$core$async15291(self__.f,self__.ch,meta15292__$1));
}));

(cljs.core.async.t_cljs$core$async15291.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15293){
var self__ = this;
var _15293__$1 = this;
return self__.meta15292;
}));

(cljs.core.async.t_cljs$core$async15291.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15291.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async15291.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async15291.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15291.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async15294 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15294 = (function (f,ch,meta15292,_,fn1,meta15295){
this.f = f;
this.ch = ch;
this.meta15292 = meta15292;
this._ = _;
this.fn1 = fn1;
this.meta15295 = meta15295;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async15294.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15296,meta15295__$1){
var self__ = this;
var _15296__$1 = this;
return (new cljs.core.async.t_cljs$core$async15294(self__.f,self__.ch,self__.meta15292,self__._,self__.fn1,meta15295__$1));
}));

(cljs.core.async.t_cljs$core$async15294.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15296){
var self__ = this;
var _15296__$1 = this;
return self__.meta15295;
}));

(cljs.core.async.t_cljs$core$async15294.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15294.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async15294.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async15294.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__15290_SHARP_){
var G__15297 = (((p1__15290_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__15290_SHARP_) : self__.f.call(null,p1__15290_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__15297) : f1.call(null,G__15297));
});
}));

(cljs.core.async.t_cljs$core$async15294.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta15292","meta15292",-1752405234,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async15291","cljs.core.async/t_cljs$core$async15291",1027366511,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta15295","meta15295",993807514,null)], null);
}));

(cljs.core.async.t_cljs$core$async15294.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async15294.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15294");

(cljs.core.async.t_cljs$core$async15294.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async15294");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async15294.
 */
cljs.core.async.__GT_t_cljs$core$async15294 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async15294(f__$1,ch__$1,meta15292__$1,___$2,fn1__$1,meta15295){
return (new cljs.core.async.t_cljs$core$async15294(f__$1,ch__$1,meta15292__$1,___$2,fn1__$1,meta15295));
});

}

return (new cljs.core.async.t_cljs$core$async15294(self__.f,self__.ch,self__.meta15292,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4174__auto__ = ret;
if(cljs.core.truth_(and__4174__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4174__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__15300 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__15300) : self__.f.call(null,G__15300));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async15291.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15291.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async15291.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta15292","meta15292",-1752405234,null)], null);
}));

(cljs.core.async.t_cljs$core$async15291.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async15291.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15291");

(cljs.core.async.t_cljs$core$async15291.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async15291");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async15291.
 */
cljs.core.async.__GT_t_cljs$core$async15291 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async15291(f__$1,ch__$1,meta15292){
return (new cljs.core.async.t_cljs$core$async15291(f__$1,ch__$1,meta15292));
});

}

return (new cljs.core.async.t_cljs$core$async15291(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async15301 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15301 = (function (f,ch,meta15302){
this.f = f;
this.ch = ch;
this.meta15302 = meta15302;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async15301.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15303,meta15302__$1){
var self__ = this;
var _15303__$1 = this;
return (new cljs.core.async.t_cljs$core$async15301(self__.f,self__.ch,meta15302__$1));
}));

(cljs.core.async.t_cljs$core$async15301.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15303){
var self__ = this;
var _15303__$1 = this;
return self__.meta15302;
}));

(cljs.core.async.t_cljs$core$async15301.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15301.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async15301.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15301.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async15301.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15301.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async15301.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta15302","meta15302",-1227009956,null)], null);
}));

(cljs.core.async.t_cljs$core$async15301.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async15301.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15301");

(cljs.core.async.t_cljs$core$async15301.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async15301");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async15301.
 */
cljs.core.async.__GT_t_cljs$core$async15301 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async15301(f__$1,ch__$1,meta15302){
return (new cljs.core.async.t_cljs$core$async15301(f__$1,ch__$1,meta15302));
});

}

return (new cljs.core.async.t_cljs$core$async15301(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async15304 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15304 = (function (p,ch,meta15305){
this.p = p;
this.ch = ch;
this.meta15305 = meta15305;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async15304.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15306,meta15305__$1){
var self__ = this;
var _15306__$1 = this;
return (new cljs.core.async.t_cljs$core$async15304(self__.p,self__.ch,meta15305__$1));
}));

(cljs.core.async.t_cljs$core$async15304.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15306){
var self__ = this;
var _15306__$1 = this;
return self__.meta15305;
}));

(cljs.core.async.t_cljs$core$async15304.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15304.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async15304.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async15304.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15304.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async15304.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15304.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async15304.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta15305","meta15305",-908983306,null)], null);
}));

(cljs.core.async.t_cljs$core$async15304.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async15304.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15304");

(cljs.core.async.t_cljs$core$async15304.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async15304");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async15304.
 */
cljs.core.async.__GT_t_cljs$core$async15304 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async15304(p__$1,ch__$1,meta15305){
return (new cljs.core.async.t_cljs$core$async15304(p__$1,ch__$1,meta15305));
});

}

return (new cljs.core.async.t_cljs$core$async15304(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__15308 = arguments.length;
switch (G__15308) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__13675__auto___16579 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13676__auto__ = (function (){var switch__13556__auto__ = (function (state_15329){
var state_val_15330 = (state_15329[(1)]);
if((state_val_15330 === (7))){
var inst_15325 = (state_15329[(2)]);
var state_15329__$1 = state_15329;
var statearr_15331_16580 = state_15329__$1;
(statearr_15331_16580[(2)] = inst_15325);

(statearr_15331_16580[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15330 === (1))){
var state_15329__$1 = state_15329;
var statearr_15332_16584 = state_15329__$1;
(statearr_15332_16584[(2)] = null);

(statearr_15332_16584[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15330 === (4))){
var inst_15311 = (state_15329[(7)]);
var inst_15311__$1 = (state_15329[(2)]);
var inst_15312 = (inst_15311__$1 == null);
var state_15329__$1 = (function (){var statearr_15333 = state_15329;
(statearr_15333[(7)] = inst_15311__$1);

return statearr_15333;
})();
if(cljs.core.truth_(inst_15312)){
var statearr_15334_16585 = state_15329__$1;
(statearr_15334_16585[(1)] = (5));

} else {
var statearr_15335_16586 = state_15329__$1;
(statearr_15335_16586[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15330 === (6))){
var inst_15311 = (state_15329[(7)]);
var inst_15316 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_15311) : p.call(null,inst_15311));
var state_15329__$1 = state_15329;
if(cljs.core.truth_(inst_15316)){
var statearr_15336_16587 = state_15329__$1;
(statearr_15336_16587[(1)] = (8));

} else {
var statearr_15337_16588 = state_15329__$1;
(statearr_15337_16588[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15330 === (3))){
var inst_15327 = (state_15329[(2)]);
var state_15329__$1 = state_15329;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15329__$1,inst_15327);
} else {
if((state_val_15330 === (2))){
var state_15329__$1 = state_15329;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15329__$1,(4),ch);
} else {
if((state_val_15330 === (11))){
var inst_15319 = (state_15329[(2)]);
var state_15329__$1 = state_15329;
var statearr_15338_16589 = state_15329__$1;
(statearr_15338_16589[(2)] = inst_15319);

(statearr_15338_16589[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15330 === (9))){
var state_15329__$1 = state_15329;
var statearr_15339_16591 = state_15329__$1;
(statearr_15339_16591[(2)] = null);

(statearr_15339_16591[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15330 === (5))){
var inst_15314 = cljs.core.async.close_BANG_(out);
var state_15329__$1 = state_15329;
var statearr_15340_16594 = state_15329__$1;
(statearr_15340_16594[(2)] = inst_15314);

(statearr_15340_16594[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15330 === (10))){
var inst_15322 = (state_15329[(2)]);
var state_15329__$1 = (function (){var statearr_15341 = state_15329;
(statearr_15341[(8)] = inst_15322);

return statearr_15341;
})();
var statearr_15342_16596 = state_15329__$1;
(statearr_15342_16596[(2)] = null);

(statearr_15342_16596[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15330 === (8))){
var inst_15311 = (state_15329[(7)]);
var state_15329__$1 = state_15329;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15329__$1,(11),out,inst_15311);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__13557__auto__ = null;
var cljs$core$async$state_machine__13557__auto____0 = (function (){
var statearr_15343 = [null,null,null,null,null,null,null,null,null];
(statearr_15343[(0)] = cljs$core$async$state_machine__13557__auto__);

(statearr_15343[(1)] = (1));

return statearr_15343;
});
var cljs$core$async$state_machine__13557__auto____1 = (function (state_15329){
while(true){
var ret_value__13558__auto__ = (function (){try{while(true){
var result__13559__auto__ = switch__13556__auto__(state_15329);
if(cljs.core.keyword_identical_QMARK_(result__13559__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13559__auto__;
}
break;
}
}catch (e15344){if((e15344 instanceof Object)){
var ex__13560__auto__ = e15344;
var statearr_15345_16602 = state_15329;
(statearr_15345_16602[(5)] = ex__13560__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15329);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15344;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13558__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16606 = state_15329;
state_15329 = G__16606;
continue;
} else {
return ret_value__13558__auto__;
}
break;
}
});
cljs$core$async$state_machine__13557__auto__ = function(state_15329){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13557__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13557__auto____1.call(this,state_15329);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13557__auto____0;
cljs$core$async$state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13557__auto____1;
return cljs$core$async$state_machine__13557__auto__;
})()
})();
var state__13677__auto__ = (function (){var statearr_15346 = (f__13676__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13676__auto__.cljs$core$IFn$_invoke$arity$0() : f__13676__auto__.call(null));
(statearr_15346[(6)] = c__13675__auto___16579);

return statearr_15346;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13677__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__15352 = arguments.length;
switch (G__15352) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__13675__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13676__auto__ = (function (){var switch__13556__auto__ = (function (state_15414){
var state_val_15415 = (state_15414[(1)]);
if((state_val_15415 === (7))){
var inst_15410 = (state_15414[(2)]);
var state_15414__$1 = state_15414;
var statearr_15420_16614 = state_15414__$1;
(statearr_15420_16614[(2)] = inst_15410);

(statearr_15420_16614[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15415 === (20))){
var inst_15380 = (state_15414[(7)]);
var inst_15391 = (state_15414[(2)]);
var inst_15392 = cljs.core.next(inst_15380);
var inst_15366 = inst_15392;
var inst_15367 = null;
var inst_15368 = (0);
var inst_15369 = (0);
var state_15414__$1 = (function (){var statearr_15421 = state_15414;
(statearr_15421[(8)] = inst_15368);

(statearr_15421[(9)] = inst_15369);

(statearr_15421[(10)] = inst_15366);

(statearr_15421[(11)] = inst_15367);

(statearr_15421[(12)] = inst_15391);

return statearr_15421;
})();
var statearr_15422_16620 = state_15414__$1;
(statearr_15422_16620[(2)] = null);

(statearr_15422_16620[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15415 === (1))){
var state_15414__$1 = state_15414;
var statearr_15423_16622 = state_15414__$1;
(statearr_15423_16622[(2)] = null);

(statearr_15423_16622[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15415 === (4))){
var inst_15355 = (state_15414[(13)]);
var inst_15355__$1 = (state_15414[(2)]);
var inst_15356 = (inst_15355__$1 == null);
var state_15414__$1 = (function (){var statearr_15424 = state_15414;
(statearr_15424[(13)] = inst_15355__$1);

return statearr_15424;
})();
if(cljs.core.truth_(inst_15356)){
var statearr_15425_16630 = state_15414__$1;
(statearr_15425_16630[(1)] = (5));

} else {
var statearr_15426_16631 = state_15414__$1;
(statearr_15426_16631[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15415 === (15))){
var state_15414__$1 = state_15414;
var statearr_15430_16633 = state_15414__$1;
(statearr_15430_16633[(2)] = null);

(statearr_15430_16633[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15415 === (21))){
var state_15414__$1 = state_15414;
var statearr_15431_16635 = state_15414__$1;
(statearr_15431_16635[(2)] = null);

(statearr_15431_16635[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15415 === (13))){
var inst_15368 = (state_15414[(8)]);
var inst_15369 = (state_15414[(9)]);
var inst_15366 = (state_15414[(10)]);
var inst_15367 = (state_15414[(11)]);
var inst_15376 = (state_15414[(2)]);
var inst_15377 = (inst_15369 + (1));
var tmp15427 = inst_15368;
var tmp15428 = inst_15366;
var tmp15429 = inst_15367;
var inst_15366__$1 = tmp15428;
var inst_15367__$1 = tmp15429;
var inst_15368__$1 = tmp15427;
var inst_15369__$1 = inst_15377;
var state_15414__$1 = (function (){var statearr_15432 = state_15414;
(statearr_15432[(8)] = inst_15368__$1);

(statearr_15432[(9)] = inst_15369__$1);

(statearr_15432[(10)] = inst_15366__$1);

(statearr_15432[(11)] = inst_15367__$1);

(statearr_15432[(14)] = inst_15376);

return statearr_15432;
})();
var statearr_15433_16640 = state_15414__$1;
(statearr_15433_16640[(2)] = null);

(statearr_15433_16640[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15415 === (22))){
var state_15414__$1 = state_15414;
var statearr_15434_16641 = state_15414__$1;
(statearr_15434_16641[(2)] = null);

(statearr_15434_16641[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15415 === (6))){
var inst_15355 = (state_15414[(13)]);
var inst_15364 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_15355) : f.call(null,inst_15355));
var inst_15365 = cljs.core.seq(inst_15364);
var inst_15366 = inst_15365;
var inst_15367 = null;
var inst_15368 = (0);
var inst_15369 = (0);
var state_15414__$1 = (function (){var statearr_15435 = state_15414;
(statearr_15435[(8)] = inst_15368);

(statearr_15435[(9)] = inst_15369);

(statearr_15435[(10)] = inst_15366);

(statearr_15435[(11)] = inst_15367);

return statearr_15435;
})();
var statearr_15436_16642 = state_15414__$1;
(statearr_15436_16642[(2)] = null);

(statearr_15436_16642[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15415 === (17))){
var inst_15380 = (state_15414[(7)]);
var inst_15384 = cljs.core.chunk_first(inst_15380);
var inst_15385 = cljs.core.chunk_rest(inst_15380);
var inst_15386 = cljs.core.count(inst_15384);
var inst_15366 = inst_15385;
var inst_15367 = inst_15384;
var inst_15368 = inst_15386;
var inst_15369 = (0);
var state_15414__$1 = (function (){var statearr_15437 = state_15414;
(statearr_15437[(8)] = inst_15368);

(statearr_15437[(9)] = inst_15369);

(statearr_15437[(10)] = inst_15366);

(statearr_15437[(11)] = inst_15367);

return statearr_15437;
})();
var statearr_15438_16643 = state_15414__$1;
(statearr_15438_16643[(2)] = null);

(statearr_15438_16643[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15415 === (3))){
var inst_15412 = (state_15414[(2)]);
var state_15414__$1 = state_15414;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15414__$1,inst_15412);
} else {
if((state_val_15415 === (12))){
var inst_15400 = (state_15414[(2)]);
var state_15414__$1 = state_15414;
var statearr_15439_16644 = state_15414__$1;
(statearr_15439_16644[(2)] = inst_15400);

(statearr_15439_16644[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15415 === (2))){
var state_15414__$1 = state_15414;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15414__$1,(4),in$);
} else {
if((state_val_15415 === (23))){
var inst_15408 = (state_15414[(2)]);
var state_15414__$1 = state_15414;
var statearr_15440_16645 = state_15414__$1;
(statearr_15440_16645[(2)] = inst_15408);

(statearr_15440_16645[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15415 === (19))){
var inst_15395 = (state_15414[(2)]);
var state_15414__$1 = state_15414;
var statearr_15441_16646 = state_15414__$1;
(statearr_15441_16646[(2)] = inst_15395);

(statearr_15441_16646[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15415 === (11))){
var inst_15380 = (state_15414[(7)]);
var inst_15366 = (state_15414[(10)]);
var inst_15380__$1 = cljs.core.seq(inst_15366);
var state_15414__$1 = (function (){var statearr_15442 = state_15414;
(statearr_15442[(7)] = inst_15380__$1);

return statearr_15442;
})();
if(inst_15380__$1){
var statearr_15443_16647 = state_15414__$1;
(statearr_15443_16647[(1)] = (14));

} else {
var statearr_15444_16648 = state_15414__$1;
(statearr_15444_16648[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15415 === (9))){
var inst_15402 = (state_15414[(2)]);
var inst_15403 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_15414__$1 = (function (){var statearr_15445 = state_15414;
(statearr_15445[(15)] = inst_15402);

return statearr_15445;
})();
if(cljs.core.truth_(inst_15403)){
var statearr_15446_16649 = state_15414__$1;
(statearr_15446_16649[(1)] = (21));

} else {
var statearr_15447_16650 = state_15414__$1;
(statearr_15447_16650[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15415 === (5))){
var inst_15358 = cljs.core.async.close_BANG_(out);
var state_15414__$1 = state_15414;
var statearr_15448_16651 = state_15414__$1;
(statearr_15448_16651[(2)] = inst_15358);

(statearr_15448_16651[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15415 === (14))){
var inst_15380 = (state_15414[(7)]);
var inst_15382 = cljs.core.chunked_seq_QMARK_(inst_15380);
var state_15414__$1 = state_15414;
if(inst_15382){
var statearr_15449_16652 = state_15414__$1;
(statearr_15449_16652[(1)] = (17));

} else {
var statearr_15450_16653 = state_15414__$1;
(statearr_15450_16653[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15415 === (16))){
var inst_15398 = (state_15414[(2)]);
var state_15414__$1 = state_15414;
var statearr_15451_16654 = state_15414__$1;
(statearr_15451_16654[(2)] = inst_15398);

(statearr_15451_16654[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15415 === (10))){
var inst_15369 = (state_15414[(9)]);
var inst_15367 = (state_15414[(11)]);
var inst_15374 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_15367,inst_15369);
var state_15414__$1 = state_15414;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15414__$1,(13),out,inst_15374);
} else {
if((state_val_15415 === (18))){
var inst_15380 = (state_15414[(7)]);
var inst_15389 = cljs.core.first(inst_15380);
var state_15414__$1 = state_15414;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15414__$1,(20),out,inst_15389);
} else {
if((state_val_15415 === (8))){
var inst_15368 = (state_15414[(8)]);
var inst_15369 = (state_15414[(9)]);
var inst_15371 = (inst_15369 < inst_15368);
var inst_15372 = inst_15371;
var state_15414__$1 = state_15414;
if(cljs.core.truth_(inst_15372)){
var statearr_15452_16657 = state_15414__$1;
(statearr_15452_16657[(1)] = (10));

} else {
var statearr_15453_16658 = state_15414__$1;
(statearr_15453_16658[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__13557__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__13557__auto____0 = (function (){
var statearr_15454 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15454[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__13557__auto__);

(statearr_15454[(1)] = (1));

return statearr_15454;
});
var cljs$core$async$mapcat_STAR__$_state_machine__13557__auto____1 = (function (state_15414){
while(true){
var ret_value__13558__auto__ = (function (){try{while(true){
var result__13559__auto__ = switch__13556__auto__(state_15414);
if(cljs.core.keyword_identical_QMARK_(result__13559__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13559__auto__;
}
break;
}
}catch (e15455){if((e15455 instanceof Object)){
var ex__13560__auto__ = e15455;
var statearr_15456_16662 = state_15414;
(statearr_15456_16662[(5)] = ex__13560__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15414);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15455;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13558__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16664 = state_15414;
state_15414 = G__16664;
continue;
} else {
return ret_value__13558__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__13557__auto__ = function(state_15414){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__13557__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__13557__auto____1.call(this,state_15414);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__13557__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__13557__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__13557__auto__;
})()
})();
var state__13677__auto__ = (function (){var statearr_15457 = (f__13676__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13676__auto__.cljs$core$IFn$_invoke$arity$0() : f__13676__auto__.call(null));
(statearr_15457[(6)] = c__13675__auto__);

return statearr_15457;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13677__auto__);
}));

return c__13675__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__15459 = arguments.length;
switch (G__15459) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__15461 = arguments.length;
switch (G__15461) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__15463 = arguments.length;
switch (G__15463) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__13675__auto___16674 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13676__auto__ = (function (){var switch__13556__auto__ = (function (state_15487){
var state_val_15488 = (state_15487[(1)]);
if((state_val_15488 === (7))){
var inst_15482 = (state_15487[(2)]);
var state_15487__$1 = state_15487;
var statearr_15489_16676 = state_15487__$1;
(statearr_15489_16676[(2)] = inst_15482);

(statearr_15489_16676[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15488 === (1))){
var inst_15464 = null;
var state_15487__$1 = (function (){var statearr_15490 = state_15487;
(statearr_15490[(7)] = inst_15464);

return statearr_15490;
})();
var statearr_15491_16679 = state_15487__$1;
(statearr_15491_16679[(2)] = null);

(statearr_15491_16679[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15488 === (4))){
var inst_15467 = (state_15487[(8)]);
var inst_15467__$1 = (state_15487[(2)]);
var inst_15468 = (inst_15467__$1 == null);
var inst_15469 = cljs.core.not(inst_15468);
var state_15487__$1 = (function (){var statearr_15492 = state_15487;
(statearr_15492[(8)] = inst_15467__$1);

return statearr_15492;
})();
if(inst_15469){
var statearr_15493_16684 = state_15487__$1;
(statearr_15493_16684[(1)] = (5));

} else {
var statearr_15494_16685 = state_15487__$1;
(statearr_15494_16685[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15488 === (6))){
var state_15487__$1 = state_15487;
var statearr_15495_16690 = state_15487__$1;
(statearr_15495_16690[(2)] = null);

(statearr_15495_16690[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15488 === (3))){
var inst_15484 = (state_15487[(2)]);
var inst_15485 = cljs.core.async.close_BANG_(out);
var state_15487__$1 = (function (){var statearr_15496 = state_15487;
(statearr_15496[(9)] = inst_15484);

return statearr_15496;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_15487__$1,inst_15485);
} else {
if((state_val_15488 === (2))){
var state_15487__$1 = state_15487;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15487__$1,(4),ch);
} else {
if((state_val_15488 === (11))){
var inst_15467 = (state_15487[(8)]);
var inst_15476 = (state_15487[(2)]);
var inst_15464 = inst_15467;
var state_15487__$1 = (function (){var statearr_15497 = state_15487;
(statearr_15497[(10)] = inst_15476);

(statearr_15497[(7)] = inst_15464);

return statearr_15497;
})();
var statearr_15498_16693 = state_15487__$1;
(statearr_15498_16693[(2)] = null);

(statearr_15498_16693[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15488 === (9))){
var inst_15467 = (state_15487[(8)]);
var state_15487__$1 = state_15487;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15487__$1,(11),out,inst_15467);
} else {
if((state_val_15488 === (5))){
var inst_15467 = (state_15487[(8)]);
var inst_15464 = (state_15487[(7)]);
var inst_15471 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15467,inst_15464);
var state_15487__$1 = state_15487;
if(inst_15471){
var statearr_15501_16694 = state_15487__$1;
(statearr_15501_16694[(1)] = (8));

} else {
var statearr_15502_16697 = state_15487__$1;
(statearr_15502_16697[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15488 === (10))){
var inst_15479 = (state_15487[(2)]);
var state_15487__$1 = state_15487;
var statearr_15503_16700 = state_15487__$1;
(statearr_15503_16700[(2)] = inst_15479);

(statearr_15503_16700[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15488 === (8))){
var inst_15464 = (state_15487[(7)]);
var tmp15499 = inst_15464;
var inst_15464__$1 = tmp15499;
var state_15487__$1 = (function (){var statearr_15504 = state_15487;
(statearr_15504[(7)] = inst_15464__$1);

return statearr_15504;
})();
var statearr_15505_16701 = state_15487__$1;
(statearr_15505_16701[(2)] = null);

(statearr_15505_16701[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__13557__auto__ = null;
var cljs$core$async$state_machine__13557__auto____0 = (function (){
var statearr_15506 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_15506[(0)] = cljs$core$async$state_machine__13557__auto__);

(statearr_15506[(1)] = (1));

return statearr_15506;
});
var cljs$core$async$state_machine__13557__auto____1 = (function (state_15487){
while(true){
var ret_value__13558__auto__ = (function (){try{while(true){
var result__13559__auto__ = switch__13556__auto__(state_15487);
if(cljs.core.keyword_identical_QMARK_(result__13559__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13559__auto__;
}
break;
}
}catch (e15507){if((e15507 instanceof Object)){
var ex__13560__auto__ = e15507;
var statearr_15509_16704 = state_15487;
(statearr_15509_16704[(5)] = ex__13560__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15487);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15507;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13558__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16705 = state_15487;
state_15487 = G__16705;
continue;
} else {
return ret_value__13558__auto__;
}
break;
}
});
cljs$core$async$state_machine__13557__auto__ = function(state_15487){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13557__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13557__auto____1.call(this,state_15487);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13557__auto____0;
cljs$core$async$state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13557__auto____1;
return cljs$core$async$state_machine__13557__auto__;
})()
})();
var state__13677__auto__ = (function (){var statearr_15511 = (f__13676__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13676__auto__.cljs$core$IFn$_invoke$arity$0() : f__13676__auto__.call(null));
(statearr_15511[(6)] = c__13675__auto___16674);

return statearr_15511;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13677__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__15516 = arguments.length;
switch (G__15516) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__13675__auto___16709 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13676__auto__ = (function (){var switch__13556__auto__ = (function (state_15561){
var state_val_15562 = (state_15561[(1)]);
if((state_val_15562 === (7))){
var inst_15557 = (state_15561[(2)]);
var state_15561__$1 = state_15561;
var statearr_15565_16710 = state_15561__$1;
(statearr_15565_16710[(2)] = inst_15557);

(statearr_15565_16710[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15562 === (1))){
var inst_15524 = (new Array(n));
var inst_15525 = inst_15524;
var inst_15526 = (0);
var state_15561__$1 = (function (){var statearr_15569 = state_15561;
(statearr_15569[(7)] = inst_15525);

(statearr_15569[(8)] = inst_15526);

return statearr_15569;
})();
var statearr_15570_16712 = state_15561__$1;
(statearr_15570_16712[(2)] = null);

(statearr_15570_16712[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15562 === (4))){
var inst_15529 = (state_15561[(9)]);
var inst_15529__$1 = (state_15561[(2)]);
var inst_15530 = (inst_15529__$1 == null);
var inst_15531 = cljs.core.not(inst_15530);
var state_15561__$1 = (function (){var statearr_15571 = state_15561;
(statearr_15571[(9)] = inst_15529__$1);

return statearr_15571;
})();
if(inst_15531){
var statearr_15572_16713 = state_15561__$1;
(statearr_15572_16713[(1)] = (5));

} else {
var statearr_15573_16714 = state_15561__$1;
(statearr_15573_16714[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15562 === (15))){
var inst_15551 = (state_15561[(2)]);
var state_15561__$1 = state_15561;
var statearr_15574_16715 = state_15561__$1;
(statearr_15574_16715[(2)] = inst_15551);

(statearr_15574_16715[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15562 === (13))){
var state_15561__$1 = state_15561;
var statearr_15575_16716 = state_15561__$1;
(statearr_15575_16716[(2)] = null);

(statearr_15575_16716[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15562 === (6))){
var inst_15526 = (state_15561[(8)]);
var inst_15547 = (inst_15526 > (0));
var state_15561__$1 = state_15561;
if(cljs.core.truth_(inst_15547)){
var statearr_15576_16717 = state_15561__$1;
(statearr_15576_16717[(1)] = (12));

} else {
var statearr_15578_16718 = state_15561__$1;
(statearr_15578_16718[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15562 === (3))){
var inst_15559 = (state_15561[(2)]);
var state_15561__$1 = state_15561;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15561__$1,inst_15559);
} else {
if((state_val_15562 === (12))){
var inst_15525 = (state_15561[(7)]);
var inst_15549 = cljs.core.vec(inst_15525);
var state_15561__$1 = state_15561;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15561__$1,(15),out,inst_15549);
} else {
if((state_val_15562 === (2))){
var state_15561__$1 = state_15561;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15561__$1,(4),ch);
} else {
if((state_val_15562 === (11))){
var inst_15541 = (state_15561[(2)]);
var inst_15542 = (new Array(n));
var inst_15525 = inst_15542;
var inst_15526 = (0);
var state_15561__$1 = (function (){var statearr_15584 = state_15561;
(statearr_15584[(10)] = inst_15541);

(statearr_15584[(7)] = inst_15525);

(statearr_15584[(8)] = inst_15526);

return statearr_15584;
})();
var statearr_15585_16720 = state_15561__$1;
(statearr_15585_16720[(2)] = null);

(statearr_15585_16720[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15562 === (9))){
var inst_15525 = (state_15561[(7)]);
var inst_15539 = cljs.core.vec(inst_15525);
var state_15561__$1 = state_15561;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15561__$1,(11),out,inst_15539);
} else {
if((state_val_15562 === (5))){
var inst_15529 = (state_15561[(9)]);
var inst_15534 = (state_15561[(11)]);
var inst_15525 = (state_15561[(7)]);
var inst_15526 = (state_15561[(8)]);
var inst_15533 = (inst_15525[inst_15526] = inst_15529);
var inst_15534__$1 = (inst_15526 + (1));
var inst_15535 = (inst_15534__$1 < n);
var state_15561__$1 = (function (){var statearr_15587 = state_15561;
(statearr_15587[(11)] = inst_15534__$1);

(statearr_15587[(12)] = inst_15533);

return statearr_15587;
})();
if(cljs.core.truth_(inst_15535)){
var statearr_15592_16723 = state_15561__$1;
(statearr_15592_16723[(1)] = (8));

} else {
var statearr_15593_16724 = state_15561__$1;
(statearr_15593_16724[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15562 === (14))){
var inst_15554 = (state_15561[(2)]);
var inst_15555 = cljs.core.async.close_BANG_(out);
var state_15561__$1 = (function (){var statearr_15598 = state_15561;
(statearr_15598[(13)] = inst_15554);

return statearr_15598;
})();
var statearr_15599_16725 = state_15561__$1;
(statearr_15599_16725[(2)] = inst_15555);

(statearr_15599_16725[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15562 === (10))){
var inst_15545 = (state_15561[(2)]);
var state_15561__$1 = state_15561;
var statearr_15601_16726 = state_15561__$1;
(statearr_15601_16726[(2)] = inst_15545);

(statearr_15601_16726[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15562 === (8))){
var inst_15534 = (state_15561[(11)]);
var inst_15525 = (state_15561[(7)]);
var tmp15597 = inst_15525;
var inst_15525__$1 = tmp15597;
var inst_15526 = inst_15534;
var state_15561__$1 = (function (){var statearr_15605 = state_15561;
(statearr_15605[(7)] = inst_15525__$1);

(statearr_15605[(8)] = inst_15526);

return statearr_15605;
})();
var statearr_15606_16749 = state_15561__$1;
(statearr_15606_16749[(2)] = null);

(statearr_15606_16749[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__13557__auto__ = null;
var cljs$core$async$state_machine__13557__auto____0 = (function (){
var statearr_15607 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15607[(0)] = cljs$core$async$state_machine__13557__auto__);

(statearr_15607[(1)] = (1));

return statearr_15607;
});
var cljs$core$async$state_machine__13557__auto____1 = (function (state_15561){
while(true){
var ret_value__13558__auto__ = (function (){try{while(true){
var result__13559__auto__ = switch__13556__auto__(state_15561);
if(cljs.core.keyword_identical_QMARK_(result__13559__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13559__auto__;
}
break;
}
}catch (e15612){if((e15612 instanceof Object)){
var ex__13560__auto__ = e15612;
var statearr_15616_16779 = state_15561;
(statearr_15616_16779[(5)] = ex__13560__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15561);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15612;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13558__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16800 = state_15561;
state_15561 = G__16800;
continue;
} else {
return ret_value__13558__auto__;
}
break;
}
});
cljs$core$async$state_machine__13557__auto__ = function(state_15561){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13557__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13557__auto____1.call(this,state_15561);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13557__auto____0;
cljs$core$async$state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13557__auto____1;
return cljs$core$async$state_machine__13557__auto__;
})()
})();
var state__13677__auto__ = (function (){var statearr_15618 = (f__13676__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13676__auto__.cljs$core$IFn$_invoke$arity$0() : f__13676__auto__.call(null));
(statearr_15618[(6)] = c__13675__auto___16709);

return statearr_15618;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13677__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__15623 = arguments.length;
switch (G__15623) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__13675__auto___16817 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13676__auto__ = (function (){var switch__13556__auto__ = (function (state_15677){
var state_val_15678 = (state_15677[(1)]);
if((state_val_15678 === (7))){
var inst_15673 = (state_15677[(2)]);
var state_15677__$1 = state_15677;
var statearr_15686_16822 = state_15677__$1;
(statearr_15686_16822[(2)] = inst_15673);

(statearr_15686_16822[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15678 === (1))){
var inst_15624 = [];
var inst_15629 = inst_15624;
var inst_15630 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_15677__$1 = (function (){var statearr_15687 = state_15677;
(statearr_15687[(7)] = inst_15629);

(statearr_15687[(8)] = inst_15630);

return statearr_15687;
})();
var statearr_15688_16824 = state_15677__$1;
(statearr_15688_16824[(2)] = null);

(statearr_15688_16824[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15678 === (4))){
var inst_15633 = (state_15677[(9)]);
var inst_15633__$1 = (state_15677[(2)]);
var inst_15634 = (inst_15633__$1 == null);
var inst_15635 = cljs.core.not(inst_15634);
var state_15677__$1 = (function (){var statearr_15693 = state_15677;
(statearr_15693[(9)] = inst_15633__$1);

return statearr_15693;
})();
if(inst_15635){
var statearr_15694_16828 = state_15677__$1;
(statearr_15694_16828[(1)] = (5));

} else {
var statearr_15695_16832 = state_15677__$1;
(statearr_15695_16832[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15678 === (15))){
var inst_15667 = (state_15677[(2)]);
var state_15677__$1 = state_15677;
var statearr_15696_16833 = state_15677__$1;
(statearr_15696_16833[(2)] = inst_15667);

(statearr_15696_16833[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15678 === (13))){
var state_15677__$1 = state_15677;
var statearr_15697_16834 = state_15677__$1;
(statearr_15697_16834[(2)] = null);

(statearr_15697_16834[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15678 === (6))){
var inst_15629 = (state_15677[(7)]);
var inst_15661 = inst_15629.length;
var inst_15662 = (inst_15661 > (0));
var state_15677__$1 = state_15677;
if(cljs.core.truth_(inst_15662)){
var statearr_15701_16835 = state_15677__$1;
(statearr_15701_16835[(1)] = (12));

} else {
var statearr_15704_16838 = state_15677__$1;
(statearr_15704_16838[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15678 === (3))){
var inst_15675 = (state_15677[(2)]);
var state_15677__$1 = state_15677;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15677__$1,inst_15675);
} else {
if((state_val_15678 === (12))){
var inst_15629 = (state_15677[(7)]);
var inst_15665 = cljs.core.vec(inst_15629);
var state_15677__$1 = state_15677;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15677__$1,(15),out,inst_15665);
} else {
if((state_val_15678 === (2))){
var state_15677__$1 = state_15677;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15677__$1,(4),ch);
} else {
if((state_val_15678 === (11))){
var inst_15637 = (state_15677[(10)]);
var inst_15633 = (state_15677[(9)]);
var inst_15651 = (state_15677[(2)]);
var inst_15652 = [];
var inst_15653 = inst_15652.push(inst_15633);
var inst_15629 = inst_15652;
var inst_15630 = inst_15637;
var state_15677__$1 = (function (){var statearr_15712 = state_15677;
(statearr_15712[(7)] = inst_15629);

(statearr_15712[(8)] = inst_15630);

(statearr_15712[(11)] = inst_15651);

(statearr_15712[(12)] = inst_15653);

return statearr_15712;
})();
var statearr_15716_16849 = state_15677__$1;
(statearr_15716_16849[(2)] = null);

(statearr_15716_16849[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15678 === (9))){
var inst_15629 = (state_15677[(7)]);
var inst_15649 = cljs.core.vec(inst_15629);
var state_15677__$1 = state_15677;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15677__$1,(11),out,inst_15649);
} else {
if((state_val_15678 === (5))){
var inst_15630 = (state_15677[(8)]);
var inst_15637 = (state_15677[(10)]);
var inst_15633 = (state_15677[(9)]);
var inst_15637__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_15633) : f.call(null,inst_15633));
var inst_15641 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15637__$1,inst_15630);
var inst_15643 = cljs.core.keyword_identical_QMARK_(inst_15630,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_15644 = ((inst_15641) || (inst_15643));
var state_15677__$1 = (function (){var statearr_15723 = state_15677;
(statearr_15723[(10)] = inst_15637__$1);

return statearr_15723;
})();
if(cljs.core.truth_(inst_15644)){
var statearr_15724_16855 = state_15677__$1;
(statearr_15724_16855[(1)] = (8));

} else {
var statearr_15729_16856 = state_15677__$1;
(statearr_15729_16856[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15678 === (14))){
var inst_15670 = (state_15677[(2)]);
var inst_15671 = cljs.core.async.close_BANG_(out);
var state_15677__$1 = (function (){var statearr_15736 = state_15677;
(statearr_15736[(13)] = inst_15670);

return statearr_15736;
})();
var statearr_15738_16858 = state_15677__$1;
(statearr_15738_16858[(2)] = inst_15671);

(statearr_15738_16858[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15678 === (10))){
var inst_15656 = (state_15677[(2)]);
var state_15677__$1 = state_15677;
var statearr_15740_16860 = state_15677__$1;
(statearr_15740_16860[(2)] = inst_15656);

(statearr_15740_16860[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15678 === (8))){
var inst_15629 = (state_15677[(7)]);
var inst_15637 = (state_15677[(10)]);
var inst_15633 = (state_15677[(9)]);
var inst_15646 = inst_15629.push(inst_15633);
var tmp15731 = inst_15629;
var inst_15629__$1 = tmp15731;
var inst_15630 = inst_15637;
var state_15677__$1 = (function (){var statearr_15744 = state_15677;
(statearr_15744[(7)] = inst_15629__$1);

(statearr_15744[(14)] = inst_15646);

(statearr_15744[(8)] = inst_15630);

return statearr_15744;
})();
var statearr_15746_16866 = state_15677__$1;
(statearr_15746_16866[(2)] = null);

(statearr_15746_16866[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__13557__auto__ = null;
var cljs$core$async$state_machine__13557__auto____0 = (function (){
var statearr_15748 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15748[(0)] = cljs$core$async$state_machine__13557__auto__);

(statearr_15748[(1)] = (1));

return statearr_15748;
});
var cljs$core$async$state_machine__13557__auto____1 = (function (state_15677){
while(true){
var ret_value__13558__auto__ = (function (){try{while(true){
var result__13559__auto__ = switch__13556__auto__(state_15677);
if(cljs.core.keyword_identical_QMARK_(result__13559__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13559__auto__;
}
break;
}
}catch (e15749){if((e15749 instanceof Object)){
var ex__13560__auto__ = e15749;
var statearr_15751_16870 = state_15677;
(statearr_15751_16870[(5)] = ex__13560__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15677);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15749;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13558__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16872 = state_15677;
state_15677 = G__16872;
continue;
} else {
return ret_value__13558__auto__;
}
break;
}
});
cljs$core$async$state_machine__13557__auto__ = function(state_15677){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13557__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13557__auto____1.call(this,state_15677);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13557__auto____0;
cljs$core$async$state_machine__13557__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13557__auto____1;
return cljs$core$async$state_machine__13557__auto__;
})()
})();
var state__13677__auto__ = (function (){var statearr_15757 = (f__13676__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13676__auto__.cljs$core$IFn$_invoke$arity$0() : f__13676__auto__.call(null));
(statearr_15757[(6)] = c__13675__auto___16817);

return statearr_15757;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13677__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
