goog.provide('cljs_time.coerce');
goog.require('cljs.core');
goog.require('cljs_time.core');
goog.require('cljs_time.format');
goog.require('goog.date.UtcDateTime');

/**
 * @interface
 */
cljs_time.coerce.ICoerce = function(){};

/**
 * Convert `obj` to a goog.date.DateTime instance.
 */
cljs_time.coerce.to_date_time = (function cljs_time$coerce$to_date_time(obj){
if((((!((obj == null)))) && ((!((obj.cljs_time$coerce$ICoerce$to_date_time$arity$1 == null)))))){
return obj.cljs_time$coerce$ICoerce$to_date_time$arity$1(obj);
} else {
var x__4487__auto__ = (((obj == null))?null:obj);
var m__4488__auto__ = (cljs_time.coerce.to_date_time[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$1(obj) : m__4488__auto__.call(null,obj));
} else {
var m__4485__auto__ = (cljs_time.coerce.to_date_time["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$1(obj) : m__4485__auto__.call(null,obj));
} else {
throw cljs.core.missing_protocol("ICoerce.to-date-time",obj);
}
}
}
});

/**
 * Returns a DateTime instance in the UTC time zone corresponding to the given
 *   number of milliseconds after the Unix epoch.
 */
cljs_time.coerce.from_long = (function cljs_time$coerce$from_long(millis){
var G__18305 = millis;
if((G__18305 == null)){
return null;
} else {
return (goog.date.UtcDateTime.fromTimestamp.cljs$core$IFn$_invoke$arity$1 ? goog.date.UtcDateTime.fromTimestamp.cljs$core$IFn$_invoke$arity$1(G__18305) : goog.date.UtcDateTime.fromTimestamp.call(null,G__18305));
}
});
/**
 * Returns DateTime instance from string using formatters in cljs-time.format,
 *   returning first which parses
 */
cljs_time.coerce.from_string = (function cljs_time$coerce$from_string(s){
if(cljs.core.truth_(s)){
return cljs.core.first((function (){var iter__4582__auto__ = (function cljs_time$coerce$from_string_$_iter__18306(s__18307){
return (new cljs.core.LazySeq(null,(function (){
var s__18307__$1 = s__18307;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__18307__$1);
if(temp__5735__auto__){
var s__18307__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__18307__$2)){
var c__4580__auto__ = cljs.core.chunk_first(s__18307__$2);
var size__4581__auto__ = cljs.core.count(c__4580__auto__);
var b__18309 = cljs.core.chunk_buffer(size__4581__auto__);
if((function (){var i__18308 = (0);
while(true){
if((i__18308 < size__4581__auto__)){
var f = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4580__auto__,i__18308);
var d = (function (){try{return cljs_time.format.parse.cljs$core$IFn$_invoke$arity$2(f,s);
}catch (e18310){if((e18310 instanceof Error)){
var _ = e18310;
return null;
} else {
throw e18310;

}
}})();
if(cljs.core.truth_(d)){
cljs.core.chunk_append(b__18309,d);

var G__18329 = (i__18308 + (1));
i__18308 = G__18329;
continue;
} else {
var G__18330 = (i__18308 + (1));
i__18308 = G__18330;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__18309),cljs_time$coerce$from_string_$_iter__18306(cljs.core.chunk_rest(s__18307__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__18309),null);
}
} else {
var f = cljs.core.first(s__18307__$2);
var d = (function (){try{return cljs_time.format.parse.cljs$core$IFn$_invoke$arity$2(f,s);
}catch (e18311){if((e18311 instanceof Error)){
var _ = e18311;
return null;
} else {
throw e18311;

}
}})();
if(cljs.core.truth_(d)){
return cljs.core.cons(d,cljs_time$coerce$from_string_$_iter__18306(cljs.core.rest(s__18307__$2)));
} else {
var G__18331 = cljs.core.rest(s__18307__$2);
s__18307__$1 = G__18331;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4582__auto__(cljs.core.vals(cljs_time.format.formatters));
})());
} else {
return null;
}
});
/**
 * Returns a DateTime instance in the UTC time zone corresponding to the given
 *   js Date object.
 */
cljs_time.coerce.from_date = (function cljs_time$coerce$from_date(date){
var G__18312 = date;
var G__18312__$1 = (((G__18312 == null))?null:G__18312.getTime());
if((G__18312__$1 == null)){
return null;
} else {
return cljs_time.coerce.from_long(G__18312__$1);
}
});
/**
 * Convert `obj` to the number of milliseconds after the Unix epoch.
 */
cljs_time.coerce.to_long = (function cljs_time$coerce$to_long(obj){
var G__18313 = obj;
var G__18313__$1 = (((G__18313 == null))?null:cljs_time.coerce.to_date_time(G__18313));
if((G__18313__$1 == null)){
return null;
} else {
return G__18313__$1.getTime();
}
});
/**
 * Convert `obj` to Unix epoch.
 */
cljs_time.coerce.to_epoch = (function cljs_time$coerce$to_epoch(obj){
var millis = cljs_time.coerce.to_long(obj);
var and__4174__auto__ = millis;
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core.quot(millis,(1000));
} else {
return and__4174__auto__;
}
});
/**
 * Convert `obj` to a JavaScript Date instance.
 */
cljs_time.coerce.to_date = (function cljs_time$coerce$to_date(obj){
var G__18314 = obj;
var G__18314__$1 = (((G__18314 == null))?null:cljs_time.coerce.to_date_time(G__18314));
var G__18314__$2 = (((G__18314__$1 == null))?null:G__18314__$1.getTime());
if((G__18314__$2 == null)){
return null;
} else {
return (new Date(G__18314__$2));
}
});
/**
 * Returns a string representation of obj in UTC time-zone
 *   using "yyyy-MM-dd'T'HH:mm:ss.SSSZZ" date-time representation.
 */
cljs_time.coerce.to_string = (function cljs_time$coerce$to_string(obj){
var G__18315 = obj;
var G__18315__$1 = (((G__18315 == null))?null:cljs_time.coerce.to_date_time(G__18315));
if((G__18315__$1 == null)){
return null;
} else {
return cljs_time.format.unparse(new cljs.core.Keyword(null,"date-time","date-time",177938180).cljs$core$IFn$_invoke$arity$1(cljs_time.format.formatters),G__18315__$1);
}
});
/**
 * Convert `obj` to a goog.date.Date instance
 */
cljs_time.coerce.to_local_date = (function cljs_time$coerce$to_local_date(obj){
if(cljs.core.truth_(obj)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(goog.date.Date,cljs.core.type(obj))){
return obj;
} else {
var temp__5733__auto__ = cljs_time.coerce.to_date_time(obj);
if(cljs.core.truth_(temp__5733__auto__)){
var dt = temp__5733__auto__;
return (new goog.date.Date(dt.getYear(),dt.getMonth(),dt.getDate()));
} else {
return null;
}
}
} else {
return null;
}
});
/**
 * Convert `obj` to a goog.date.DateTime instance
 */
cljs_time.coerce.to_local_date_time = (function cljs_time$coerce$to_local_date_time(obj){
if(cljs.core.truth_(obj)){
var temp__5733__auto__ = cljs_time.coerce.to_date_time(obj);
if(cljs.core.truth_(temp__5733__auto__)){
var dt = temp__5733__auto__;
var G__18316 = (new goog.date.DateTime(dt.getYear(),dt.getMonth(),dt.getDate()));
G__18316.setHours(dt.getHours());

G__18316.setMinutes(dt.getMinutes());

G__18316.setSeconds(dt.getSeconds());

G__18316.setMilliseconds(dt.getMilliseconds());

return G__18316;
} else {
return null;
}
} else {
return null;
}
});
goog.object.set(cljs_time.coerce.ICoerce,"null",true);

var G__18319_18342 = cljs_time.coerce.to_date_time;
var G__18320_18343 = "null";
var G__18321_18344 = (function (_){
return null;
});
goog.object.set(G__18319_18342,G__18320_18343,G__18321_18344);

(Date.prototype.cljs_time$coerce$ICoerce$ = cljs.core.PROTOCOL_SENTINEL);

(Date.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (date){
var date__$1 = this;
return cljs_time.coerce.from_date(date__$1);
}));

(goog.date.Date.prototype.cljs_time$coerce$ICoerce$ = cljs.core.PROTOCOL_SENTINEL);

(goog.date.Date.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (local_date){
var local_date__$1 = this;
if(cljs.core.truth_(local_date__$1)){
return cljs_time.core.to_utc_time_zone(local_date__$1);
} else {
return null;
}
}));

(goog.date.DateTime.prototype.cljs_time$coerce$ICoerce$ = cljs.core.PROTOCOL_SENTINEL);

(goog.date.DateTime.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (local_date_time){
var local_date_time__$1 = this;
if(cljs.core.truth_(local_date_time__$1)){
return cljs_time.core.to_utc_time_zone(local_date_time__$1);
} else {
return null;
}
}));

(goog.date.UtcDateTime.prototype.cljs_time$coerce$ICoerce$ = cljs.core.PROTOCOL_SENTINEL);

(goog.date.UtcDateTime.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (date_time){
var date_time__$1 = this;
return date_time__$1;
}));

goog.object.set(cljs_time.coerce.ICoerce,"number",true);

var G__18323_18347 = cljs_time.coerce.to_date_time;
var G__18324_18348 = "number";
var G__18325_18349 = (function (long$){
return cljs_time.coerce.from_long(long$);
});
goog.object.set(G__18323_18347,G__18324_18348,G__18325_18349);

goog.object.set(cljs_time.coerce.ICoerce,"string",true);

var G__18326_18353 = cljs_time.coerce.to_date_time;
var G__18327_18354 = "string";
var G__18328_18355 = (function (string){
return cljs_time.coerce.from_string(string);
});
goog.object.set(G__18326_18353,G__18327_18354,G__18328_18355);

//# sourceMappingURL=cljs_time.coerce.js.map
